/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.identity.client;

import com.sas.svcs.identity.client.Address;
import com.sas.svcs.identity.client.EmailAddress;
import com.sas.svcs.identity.client.Identity;
import com.sas.svcs.identity.client.PhoneNumber;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class User
extends Identity
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String TYPE_VALUE_ACTIVE = "active";
    public static final String TYPE_VALUE_INACTIVE = "inactive";
    public static final String TYPE_VALUE_LOCKED = "locked";
    private String title;
    private State state;
    private List<PhoneNumber> userPhoneNumbers;
    private List<Address> userAddresses;
    private List<EmailAddress> userEmailAddresses;
    @Deprecated
    private boolean active = true;
    @Deprecated
    private boolean locked = false;
    @Deprecated
    private List<String> phoneNumbers;
    @Deprecated
    private List<String> smsAddresses;
    @Deprecated
    private List<String> emailAddresses;

    public User() {
        this.state = State.ACTIVE;
    }

    public User(String userid, String displayName) {
        super(userid, displayName);
        this.state = State.ACTIVE;
    }

    @Deprecated
    public User(String id, String displayName, List<String> emailAddresses, List<String> phoneNumbers, List<String> smsAddresses, String title, boolean active, boolean locked) {
        super(id, displayName);
        this.setEmailAddresses(emailAddresses);
        this.setPhoneNumbers(phoneNumbers);
        this.setSmsAddresses(smsAddresses);
        this.title = title;
        this.active = active;
        this.locked = locked;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public State getState() {
        return this.state;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setUserPhoneNumbers(List<PhoneNumber> phoneNumberList) {
        this.userPhoneNumbers = new ArrayList<PhoneNumber>();
        for (PhoneNumber phoneNumber : phoneNumberList) {
            this.addUserPhoneNumber(phoneNumber);
        }
    }

    public void addUserPhoneNumber(PhoneNumber phoneNumber) {
        if (this.userPhoneNumbers == null) {
            this.userPhoneNumbers = new ArrayList<PhoneNumber>();
        }
        if (!this.userPhoneNumbers.contains(phoneNumber)) {
            this.userPhoneNumbers.add(phoneNumber);
        }
        this.convertPhoneNumber(phoneNumber);
    }

    private void convertPhoneNumber(PhoneNumber phoneNumber) {
        String number;
        if (this.phoneNumbers == null) {
            this.phoneNumbers = new ArrayList<String>();
        }
        if (!this.phoneNumbers.contains(number = phoneNumber.getValue())) {
            this.phoneNumbers.add(number);
        }
    }

    public List<PhoneNumber> getUserPhoneNumbers() {
        return this.userPhoneNumbers;
    }

    public void addUserAddress(Address address) {
        if (this.userAddresses == null) {
            this.userAddresses = new ArrayList<Address>();
        }
        if (!this.userAddresses.contains(address)) {
            this.userAddresses.add(address);
        }
    }

    public void setUserAddresses(List<Address> addressList) {
        this.userAddresses = new ArrayList<Address>(addressList);
    }

    public List<Address> getUserAddresses() {
        return this.userAddresses;
    }

    public void setUserEmailAddresses(List<EmailAddress> emailList) {
        this.userEmailAddresses = new ArrayList<EmailAddress>();
        for (EmailAddress email : emailList) {
            this.addUserEmailAddress(email);
        }
    }

    public void addUserEmailAddress(EmailAddress email) {
        if (this.userEmailAddresses == null) {
            this.userEmailAddresses = new ArrayList<EmailAddress>();
        }
        if (!this.userEmailAddresses.contains(email)) {
            this.userEmailAddresses.add(email);
        }
        this.convertEmailAddress(email);
    }

    private void convertEmailAddress(EmailAddress email) {
        String address = email.getValue();
        if (email.getType() == EmailAddress.Type.CUSTOM && "SMS".equalsIgnoreCase(email.getTypeLabel())) {
            if (this.smsAddresses == null) {
                this.smsAddresses = new ArrayList<String>();
            }
            if (!this.smsAddresses.contains(address)) {
                this.smsAddresses.add(address);
            }
        } else {
            if (this.emailAddresses == null) {
                this.emailAddresses = new ArrayList<String>();
            }
            if (!this.emailAddresses.contains(address)) {
                this.emailAddresses.add(address);
            }
        }
    }

    public List<EmailAddress> getUserEmailAddresses() {
        return this.userEmailAddresses;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.title, (Object)other.getTitle()).append((Object)this.state, (Object)other.getState()).append(this.userAddresses, other.getUserAddresses()).append(this.userEmailAddresses, other.getUserEmailAddresses()).append(this.userPhoneNumbers, other.getUserPhoneNumbers()).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(49, 33).appendSuper(super.hashCode()).append((Object)this.title).append((Object)this.state).append(this.userAddresses).append(this.userEmailAddresses).append(this.userPhoneNumbers).toHashCode();
    }

    @Deprecated
    public void setEmailAddresses(List<String> emailAddresses) {
        if (emailAddresses == null) {
            return;
        }
        for (String address : emailAddresses) {
            this.addUserEmailAddress(new EmailAddress(address, EmailAddress.Type.OTHER));
        }
    }

    @Deprecated
    public List<String> getEmailAddresses() {
        return this.emailAddresses;
    }

    @Deprecated
    public void setPhoneNumbers(List<String> phoneNumbers) {
        if (phoneNumbers == null) {
            return;
        }
        for (String number : phoneNumbers) {
            this.addUserPhoneNumber(new PhoneNumber(number, PhoneNumber.Type.OTHER));
        }
    }

    @Deprecated
    public List<String> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    @Deprecated
    public void setSmsAddresses(List<String> smsAddresses) {
        if (smsAddresses == null) {
            return;
        }
        for (String address : smsAddresses) {
            this.addUserEmailAddress(new EmailAddress(address, EmailAddress.Type.CUSTOM, "SMS"));
        }
    }

    @Deprecated
    public List<String> getSmsAddresses() {
        return this.smsAddresses;
    }

    public String toString() {
        return this.getId();
    }

    public static enum State {
        ACTIVE("active"),
        INACTIVE("inactive"),
        LOCKED("locked");

        private String value;

        private State(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public static State fromString(String value) {
            if (User.TYPE_VALUE_ACTIVE.equals(value)) {
                return ACTIVE;
            }
            if (User.TYPE_VALUE_INACTIVE.equals(value)) {
                return INACTIVE;
            }
            if (User.TYPE_VALUE_LOCKED.equals(value)) {
                return LOCKED;
            }
            return null;
        }
    }
}

