/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.identity.client;

import com.sas.svcs.identity.client.InternalAccountPolicy;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class InternalAccount
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String ACTIVE_STATE = "active";
    public static final String INACTIVE_STATE = "inactive";
    public static final String EXPIRED_STATE = "expired";
    public static final String RESET_STATE = "reset";
    private String accountId;
    private Date expirationDate;
    private AccountState accountState;
    private String password = null;
    private PasswordState passwordState;
    private Date passwordExpirationDate;
    private List<InternalAccountPolicy> policies;

    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public AccountState getAccountState() {
        return this.accountState;
    }

    public void setAccountState(AccountState accountState) {
        this.accountState = accountState;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Date getPasswordExpirationDate() {
        return this.passwordExpirationDate;
    }

    public void setPasswordExpirationDate(Date passwordExpirationDate) {
        this.passwordExpirationDate = passwordExpirationDate;
    }

    public PasswordState getPasswordState() {
        return this.passwordState;
    }

    public void setPasswordState(PasswordState passwordState) {
        this.passwordState = passwordState;
    }

    public void addPolicy(InternalAccountPolicy policy) {
        if (this.policies == null) {
            this.policies = new ArrayList<InternalAccountPolicy>();
        }
        this.policies.add(policy);
    }

    public void setPolicies(List<InternalAccountPolicy> policyList) {
        this.policies = new ArrayList<InternalAccountPolicy>(policyList);
    }

    public List<InternalAccountPolicy> getPolicies() {
        return this.policies;
    }

    public int hashCode() {
        return new HashCodeBuilder(13, 35).append((Object)this.accountId).append((Object)this.expirationDate).append((Object)this.accountState).append((Object)this.password).append((Object)this.passwordExpirationDate).append((Object)this.passwordState).append(this.policies).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InternalAccount other = (InternalAccount)obj;
        return new EqualsBuilder().append((Object)this.accountId, (Object)other.getAccountId()).append((Object)this.expirationDate, (Object)other.getExpirationDate()).append((Object)this.accountState, (Object)other.getAccountState()).append((Object)this.password, (Object)other.getPassword()).append((Object)this.passwordExpirationDate, (Object)other.getPasswordExpirationDate()).append((Object)this.passwordState, (Object)other.getPasswordState()).append(this.policies, other.getPolicies()).isEquals();
    }

    public static enum PasswordState {
        ACTIVE("active"),
        EXPIRED("expired"),
        RESET("reset");

        private String state;

        private PasswordState(String state) {
            this.state = state;
        }

        public String state() {
            return this.state;
        }

        public static PasswordState fromString(String state) {
            if (InternalAccount.ACTIVE_STATE.equals(state)) {
                return ACTIVE;
            }
            if (InternalAccount.EXPIRED_STATE.equals(state)) {
                return EXPIRED;
            }
            if (InternalAccount.RESET_STATE.equals(state)) {
                return RESET;
            }
            throw new IllegalArgumentException("Invalid password account state");
        }
    }

    public static enum AccountState {
        ACTIVE("active"),
        INACTIVE("inactive"),
        EXPIRED("expired");

        private String state;

        private AccountState(String state) {
            this.state = state;
        }

        public String state() {
            return this.state;
        }

        public static AccountState fromString(String state) {
            if (InternalAccount.ACTIVE_STATE.equals(state)) {
                return ACTIVE;
            }
            if (InternalAccount.INACTIVE_STATE.equals(state)) {
                return INACTIVE;
            }
            if (InternalAccount.EXPIRED_STATE.equals(state)) {
                return EXPIRED;
            }
            if (state == null) {
                return ACTIVE;
            }
            throw new IllegalArgumentException("Invalid account state: " + state);
        }
    }
}

