/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.identity.client;

import com.sas.svcs.identity.client.Group;
import com.sas.svcs.identity.client.Identity;
import com.sas.svcs.identity.client.User;

public enum IdentityType {
    USER("user"),
    GROUP("group");

    private String value;

    private IdentityType(String value) {
        this.value = value;
    }

    public String value() {
        return this.value;
    }

    public static IdentityType fromValue(String value) {
        if ("user".equalsIgnoreCase(value)) {
            return USER;
        }
        if ("group".equalsIgnoreCase(value)) {
            return GROUP;
        }
        throw new IllegalArgumentException("Invalid identity type: " + value);
    }

    public static IdentityType fromIdentity(Identity identity) {
        if (identity instanceof User) {
            return USER;
        }
        if (identity instanceof Group) {
            return GROUP;
        }
        throw new IllegalArgumentException("Invalid identity type: " + identity.getClass().getName());
    }
}

