/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.identity.client;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class IdentityProperty
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String TYPE_VALUE_STRING = "string";
    public static final String TYPE_VALUE_INTEGER = "integer";
    public static final String TYPE_VALUE_BOOLEAN = "boolean";
    public static final String TYPE_VALUE_DECIMAL = "decimal";
    public static final String TYPE_VALUE_DATETIME = "dateTime";
    private Type type;
    private String name;
    private String category;
    private List<String> values;

    public IdentityProperty() {
    }

    public IdentityProperty(String name, Type type, String value) {
        this(name, type, value, null);
    }

    public IdentityProperty(String name, Type type, String value, String category) {
        this(name, type, Arrays.asList(value), category);
    }

    public IdentityProperty(String name, Type type, List<String> values) {
        this(name, type, values, null);
    }

    public IdentityProperty(String name, Type type, List<String> values, String category) {
        this.name = name;
        this.type = type;
        this.values = values;
        this.category = category;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IdentityProperty other = (IdentityProperty)obj;
        return new EqualsBuilder().append((Object)this.name, (Object)other.getName()).append((Object)this.category, (Object)other.getCategory()).append((Object)this.type, (Object)other.getType()).append(this.values, other.getValues()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(41, 39).append((Object)this.name).append((Object)this.category).append((Object)this.type).append(this.values).toHashCode();
    }

    public String toString() {
        return this.name + ": " + this.values;
    }

    public static enum Type {
        STRING("string"),
        INTEGER("integer"),
        BOOLEAN("boolean"),
        DECIMAL("decimal"),
        DATETIME("dateTime");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }

        public static Type fromString(String value) {
            if (IdentityProperty.TYPE_VALUE_STRING.equals(value)) {
                return STRING;
            }
            if (IdentityProperty.TYPE_VALUE_INTEGER.equals(value)) {
                return INTEGER;
            }
            if (IdentityProperty.TYPE_VALUE_BOOLEAN.equals(value)) {
                return BOOLEAN;
            }
            if (IdentityProperty.TYPE_VALUE_DECIMAL.equals(value)) {
                return DECIMAL;
            }
            if (IdentityProperty.TYPE_VALUE_DATETIME.equals(value)) {
                return DATETIME;
            }
            return STRING;
        }
    }
}

