/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.identity.client;

import com.sas.commons.expr.Expression;
import com.sas.commons.expr.parser.ExprParser;
import com.sas.svcs.identity.client.InvalidRequestException;
import java.util.Set;
import org.springframework.util.Assert;

public class IdentityExpressionFactory {
    public static Expression createAllExpression() {
        return IdentityExpressionFactory.parseExpression("match(id,\".*\")");
    }

    public static Expression createIdExpression(Set<String> ids) {
        return IdentityExpressionFactory.createInExpression("id", ids);
    }

    public static Expression createDisplayNameExpression(Set<String> names) {
        return IdentityExpressionFactory.createInExpression("name", names);
    }

    public static Expression createDisplayNameExpression(String displayName, ExpressionOperator operator) {
        StringBuilder sb = new StringBuilder();
        sb.append(operator.value());
        sb.append("(name,");
        sb.append("\"").append(displayName).append("\")");
        return IdentityExpressionFactory.parseExpression(sb.toString());
    }

    private static Expression createInExpression(String attributeName, Set<String> values) {
        Assert.notNull(values);
        StringBuilder sb = new StringBuilder();
        sb.append("in(").append(attributeName).append(",");
        int counter = 0;
        for (String value : values) {
            if (counter > 0) {
                sb.append(",");
            }
            sb.append("\"").append(value).append("\"");
            ++counter;
        }
        sb.append(")");
        return IdentityExpressionFactory.parseExpression(sb.toString());
    }

    private static Expression parseExpression(String query) {
        try {
            ExprParser parser = ExprParser.from((String)query);
            return parser.parse();
        }
        catch (Exception e) {
            throw new InvalidRequestException(e.getMessage(), 1200, e);
        }
    }

    public static enum ExpressionOperator {
        EQUALS("eq"),
        NOT_EQUALS("ne"),
        CONTAINS("contains"),
        STARTS_WITH("startsWith"),
        ENDS_WITH("endsWith"),
        LESS_THAN("lt"),
        GREATER_THAN("gt"),
        LESS_THAN_OR_EQUAL("le"),
        GREATER_THAN_OR_EQUAL("ge");

        private String value;

        private ExpressionOperator(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

