/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFAdminManager;
import com.platform.LSFJobFlow.api.JFException;
import com.platform.LSFJobFlow.api.JFJIDInfo;
import com.platform.LSFJobFlow.api.JFUTFConverter;
import java.util.HashMap;
import java.util.StringTokenizer;

public class JFUser {
    private static String m_lsfUserDomain = null;
    private static final String m_sDomainSepSubst = "__BS__";
    private static final String m_sLocalDomainSubst = "DT_BS_";
    static final String m_sUniEscSubst = "UE_BS_";
    private static String m_serverType = null;
    private static String m_serverName = null;
    public static final String WIN32_SERVER_TYPE = "WIN32";
    public static final String SYSTEM_USER = "Sys";
    public static final String GUEST = "guest";
    private String m_name = null;
    private String m_domain = null;
    private String m_origName = null;
    private String m_origDomain = null;

    public JFUser() {
    }

    public JFUser(String string) {
        StringTokenizer stringTokenizer;
        String string2 = JFUser.deFormatString(string);
        if (string2 == null) {
            string2 = "";
        }
        if ((stringTokenizer = new StringTokenizer(string2, "\\")).countTokens() <= 1) {
            this.m_name = string2;
            this.m_domain = null;
        } else {
            this.m_domain = stringTokenizer.nextToken();
            this.m_name = stringTokenizer.nextToken();
        }
        if (this.m_domain != null && this.m_domain.equalsIgnoreCase(m_serverName)) {
            this.m_domain = ".";
        }
        this.m_origName = this.m_name;
        this.m_origDomain = this.m_domain;
        if (m_serverType != null && m_serverType.equals(WIN32_SERVER_TYPE) && !this.m_name.equals(SYSTEM_USER)) {
            this.m_name = this.m_name.toLowerCase();
            if (this.m_domain != null) {
                this.m_domain = this.m_domain.toUpperCase();
            }
        }
    }

    public boolean isGuest() {
        return this.m_name.equalsIgnoreCase(GUEST);
    }

    public static synchronized void updateServerInfo() {
        try {
            JFJIDInfo jFJIDInfo;
            JFAdminManager jFAdminManager = new JFAdminManager();
            HashMap hashMap = jFAdminManager.getServerInfo();
            m_lsfUserDomain = (String)hashMap.get("LSF_USER_DOMAIN");
            m_serverType = (String)hashMap.get("SERVER_TYPE");
            if (m_lsfUserDomain != null) {
                m_lsfUserDomain = m_lsfUserDomain.toUpperCase();
            }
            if ((jFJIDInfo = jFAdminManager.getJIDInfo()) == null) {
                throw new JFException("");
            }
            m_serverName = jFJIDInfo.getServerName();
            if (m_serverName != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(m_serverName, ".");
                if (stringTokenizer.hasMoreTokens()) {
                    m_serverName = stringTokenizer.nextToken();
                }
                m_serverName = m_serverName.toUpperCase();
            }
        }
        catch (Exception exception) {
            m_lsfUserDomain = null;
            m_serverType = null;
            m_serverName = null;
        }
    }

    public String toJSUserName() {
        if (this.m_name == null) {
            return null;
        }
        if (this.m_domain == null || this.m_domain.equals("")) {
            return this.m_name;
        }
        if (this.m_domain.equals(m_lsfUserDomain)) {
            return this.m_name;
        }
        return this.m_domain + "\\" + this.m_name;
    }

    String toJSUserNamePreservingCase() {
        if (this.m_name == null) {
            return null;
        }
        if (this.m_domain == null || this.m_domain.equals("")) {
            return this.m_origName;
        }
        if (this.m_domain.equals(m_lsfUserDomain)) {
            return this.m_origName;
        }
        return this.m_origDomain + "\\" + this.m_origName;
    }

    public String toOSUserName() {
        if (this.m_name == null) {
            return null;
        }
        if (this.m_domain == null || this.m_domain.equals("")) {
            return this.m_name;
        }
        return this.m_domain + "\\" + this.m_name;
    }

    public boolean equals(JFUser jFUser) {
        if (this.m_name == null) {
            return false;
        }
        if (!this.m_name.equals(jFUser.m_name)) {
            return false;
        }
        if (this.m_domain != null) {
            return this.m_domain.equals(jFUser.m_domain);
        }
        return jFUser.m_domain == null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JFUser jFUser = (JFUser)object;
        return this.equals(jFUser);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.m_domain == null ? 0 : this.m_domain.hashCode());
        n = 31 * n + (this.m_name == null ? 0 : this.m_name.hashCode());
        return n;
    }

    public String getName() {
        return this.m_name;
    }

    public String getDomain() {
        return this.m_domain;
    }

    public static String getServerType() {
        return m_serverType;
    }

    public static String formatString(String string) {
        if (string == null) {
            return null;
        }
        String string2 = JFUser.replaceString(string, ".\\", m_sLocalDomainSubst);
        string2 = JFUTFConverter.toUnicodeEscape(string2);
        string2 = JFUser.replaceString(string2, "\\u", m_sUniEscSubst);
        return JFUser.replaceString(string2, "\\", m_sDomainSepSubst);
    }

    public static String deFormatString(String string) {
        if (string == null) {
            return null;
        }
        String string2 = JFUser.replaceString(string, m_sUniEscSubst, "\\u");
        string2 = JFUTFConverter.fromUnicodeEscape(string2);
        string2 = JFUser.replaceString(string2, m_sLocalDomainSubst, ".\\");
        return JFUser.replaceString(string2, m_sDomainSepSubst, "\\");
    }

    public static boolean isEquivalentByFormat(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2) || string.equals(JFUser.formatString(string2));
    }

    static String replaceString(String string, String string2, String string3) {
        if (string == null) {
            return null;
        }
        if (string2 == null || string2.length() <= 0 || string3 == null) {
            return string;
        }
        int n = string2.length();
        int n2 = string3.length();
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        for (String string4 = string; string4 != null; string4 = string4.substring(n3 + n)) {
            n3 = string4.indexOf(string2);
            if (n3 < 0) {
                stringBuffer.append(string4);
                break;
            }
            stringBuffer.append(string4.substring(0, n3));
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    static {
        JFUser.updateServerInfo();
    }
}

