/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFInvalidTemplateException;
import com.platform.LSFJobFlow.api.JFResource;
import com.platform.LSFJobFlow.api.JFTemplateParameterDefList;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JFTemplateDef {
    public static final int LSF_EXEC_TYPE = 0;
    public static final int ORACLE_EXEC_TYPE = 1;
    public static final int ZOS_EXEC_TYPE = 2;
    public static final int SCRIPT_EXEC_TYPE = 3;
    public static final int OTHER_EXEC_TYPE = 4;
    private String m_name;
    private String m_version;
    private String m_icon;
    private int m_execType;
    private String m_execTypeStr;
    private String m_execAction;
    private boolean m_hasArray;
    private String m_help;
    private String m_fileName;
    private JFTemplateParameterDefList m_execParams;
    private JFTemplateParameterDefList m_subParams;

    public JFTemplateDef(String string) throws JFInvalidTemplateException {
        Document document;
        if (string == null) {
            throw new NullPointerException(JFResource.getString("TEMPLATE_INVALID_FILE"));
        }
        this.m_fileName = string;
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            document = documentBuilder.parse(new InputSource(new FileReader(string)));
        }
        catch (SAXException sAXException) {
            throw new JFInvalidTemplateException(JFResource.getString("TEMPLATE_PARSE_ERROR") + sAXException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new JFInvalidTemplateException(JFResource.getString("TEMPLATE_PARSE_ERROR") + parserConfigurationException.getMessage());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(JFResource.getString("TEMPLATE_INVALID_FILE"));
        }
        this.init(document);
    }

    public String getVersion() {
        return this.m_version;
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public String getName() {
        return this.m_name;
    }

    public String getIcon() {
        return this.m_icon;
    }

    public int getExecutionType() {
        return this.m_execType;
    }

    public String getExecutionTypeString() {
        return this.m_execTypeStr;
    }

    public String getExecutionAction() {
        return this.m_execAction;
    }

    public boolean isSupportArray() {
        return this.m_hasArray;
    }

    public JFTemplateParameterDefList getExecutionParams() {
        return this.m_execParams;
    }

    public JFTemplateParameterDefList getSubmissionParams() {
        return this.m_subParams;
    }

    public String getHelp() {
        return this.m_help;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("[Template]: ");
        stringBuffer.append(this.m_name);
        stringBuffer.append("\nExecution parameters:\n");
        stringBuffer.append(this.m_execParams.toString());
        stringBuffer.append("\nSubmission parameters:\n");
        stringBuffer.append(this.m_subParams.toString());
        return stringBuffer.toString();
    }

    public static boolean isValidTemplateName(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isLetterOrDigit(c) || Character.isSpaceChar(c) || c == '_') continue;
            return false;
        }
        return true;
    }

    private void init(Document document) throws JFInvalidTemplateException {
        if (document == null) {
            throw new NullPointerException("Parameter <templateDoc> is null!");
        }
        Element element = document.getDocumentElement();
        if (element == null) {
            throw new JFInvalidTemplateException(JFResource.getString("TEMPLATE_EMPTY_CONTENT"));
        }
        if (!element.getTagName().equals("JobTemplate")) {
            throw new JFInvalidTemplateException(JFResource.getString("TEMPLATE_INVALID_ROOT"));
        }
        if (!element.hasAttribute("Name")) {
            throw new JFInvalidTemplateException(JFResource.getString("TEMPLATE_NO_NAME"));
        }
        this.m_name = element.getAttribute("Name").trim();
        if (!JFTemplateDef.isValidTemplateName(this.m_name)) {
            String string = JFResource.getString("TEMPLATE_INVALID_NAME");
            MessageFormat messageFormat = new MessageFormat(string);
            Object[] objectArray = new Object[]{this.m_name};
            string = messageFormat.format(objectArray);
            throw new JFInvalidTemplateException(string);
        }
        this.m_version = element.getAttribute("Version");
        this.m_icon = element.getAttribute("Icon");
        this.m_help = "";
        NodeList nodeList = element.getChildNodes();
        Node node = null;
        String string = null;
        Element element2 = null;
        for (int i = 0; nodeList != null && i < nodeList.getLength(); ++i) {
            node = nodeList.item(i);
            string = node.getNodeName();
            if (node.getNodeType() != 1) continue;
            element2 = (Element)node;
            if (string.equals("Execution")) {
                this.m_execTypeStr = element2.getAttribute("Type");
                if (this.m_execTypeStr == null || this.m_execTypeStr.length() <= 0) {
                    throw new JFInvalidTemplateException(JFResource.getString("TEMPLATE_NO_EXEC_TYPE"));
                }
                if (this.m_execTypeStr.equals("lsf")) {
                    this.m_execType = 0;
                } else if (this.m_execTypeStr.equals("script")) {
                    this.m_execType = 3;
                } else if (this.m_execTypeStr.equals("oracle")) {
                    this.m_execType = 1;
                } else if (this.m_execTypeStr.equals("zos")) {
                    this.m_execType = 2;
                } else {
                    throw new JFInvalidTemplateException(JFResource.getString("TEMPLATE_INVALID_EXEC_TYPE"));
                }
                this.m_execAction = element2.getAttribute("Action");
                this.m_hasArray = !"false".equalsIgnoreCase(element2.getAttribute("HasArray"));
                this.m_execParams = new JFTemplateParameterDefList(element2.getElementsByTagName("Param"), true);
                continue;
            }
            if (string.equals("Submission")) {
                this.m_subParams = new JFTemplateParameterDefList(element2.getElementsByTagName("Param"), false);
                continue;
            }
            if (!string.equals("Help")) continue;
            Node node2 = node.getFirstChild();
            this.m_help = node2.getNodeValue().trim();
        }
        if (this.m_execParams == null) {
            throw new JFInvalidTemplateException(JFResource.getString("TEMPLATE_NO_EXEC"));
        }
        if (this.m_execParams.getParameterNumber() == 0) {
            throw new JFInvalidTemplateException(JFResource.getString("TEMPLATE_NO_EXECPARAM"));
        }
        if (this.m_subParams == null) {
            throw new JFInvalidTemplateException(JFResource.getString("TEMPLATE_NO_SUB"));
        }
        if (this.m_subParams.getParameterNumber() == 0) {
            throw new JFInvalidTemplateException(JFResource.getString("TEMPLATE_NO_SUBPARAM"));
        }
    }

    private String paramType2String(int n) {
        switch (n) {
            case 0: {
                return "STRING";
            }
            case 1: {
                return "INTEGER";
            }
            case 2: {
                return "FLOAT";
            }
            case 3: {
                return "FILE";
            }
            case 4: {
                return "FOLDER";
            }
            case 5: {
                return "FILE_TRANSFER";
            }
        }
        return "";
    }

    public static void main(String[] stringArray) {
        try {
            JFTemplateDef jFTemplateDef = new JFTemplateDef(stringArray[0]);
            System.out.println(jFTemplateDef.getExecutionParams().getParameterNum());
            System.out.println(jFTemplateDef.getExecutionParams().getParameter("MailDestination").getName());
            System.out.println(jFTemplateDef.getExecutionParams().getParameter("MailDestination").getCaption());
            System.out.println(jFTemplateDef.getExecutionParams().getParameter("MailDestination").getType());
            jFTemplateDef.getExecutionParams().getParameter("MailDestination").validate("123.23");
            System.out.println(jFTemplateDef.getSubmissionParams().getParameterNum());
            System.out.println(jFTemplateDef.getSubmissionParams().getParameter("Query_strands").getName());
            System.out.println(jFTemplateDef.getSubmissionParams().getParameter("Query_strands").getCaption());
            System.out.println(jFTemplateDef.getSubmissionParams().getParameter("Query_strands").getType());
            System.out.println(jFTemplateDef.getSubmissionParams().getParameter("Query_strands").getChoices()[1].getCaption());
            System.out.println(jFTemplateDef.getSubmissionParams().getParameter("Query_strands").getChoices()[1].getValue());
            System.out.println(jFTemplateDef);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

