/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JFHistoryRecord {
    private static final int TIME_LEN = 35;
    private static final int USER_LEN = 14;
    private JFTime m_time;
    private String m_user;
    private String m_key;
    private String m_action;
    private List m_actionData;

    JFHistoryRecord(Element element) {
        if (element == null) {
            return;
        }
        if (!"historyRec".equals(element.getTagName())) {
            return;
        }
        this.m_actionData = new ArrayList();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            Element element2 = (Element)nodeList.item(i);
            String string = element2.getTagName();
            if ("time".equals(string)) {
                this.m_time = new JFTime(element2);
                continue;
            }
            if ("user".equals(string)) {
                this.m_user = element2.getFirstChild().getNodeValue();
                continue;
            }
            if ("key".equals(string)) {
                this.m_key = element2.getFirstChild().getNodeValue();
                continue;
            }
            if ("action".equals(string)) {
                this.m_action = element2.getFirstChild().getNodeValue();
                continue;
            }
            if (!"actionData".equals(string)) continue;
            this.m_actionData.add(this.replaceTimeStr(element2.getFirstChild().getNodeValue()));
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_time != null) {
            stringBuffer.append(this.alignString(this.m_time.getTimeString(), 35));
        }
        if (this.m_user != null) {
            stringBuffer.append(this.alignString(this.m_user, 14));
        }
        if (this.m_action != null) {
            stringBuffer.append(this.m_action);
        }
        stringBuffer.append(" ");
        if (this.m_key != null) {
            stringBuffer.append(this.m_key);
        }
        int n = this.m_actionData.size();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("\n");
            stringBuffer.append(this.alignString(" ", 49));
            stringBuffer.append(this.m_actionData.get(i));
        }
        return stringBuffer.toString();
    }

    public String getUser() {
        return this.m_user;
    }

    public String getKey() {
        return this.m_key;
    }

    public String getAction() {
        return this.m_action;
    }

    public String getTime() {
        if (this.m_time != null) {
            return this.m_time.getTimeString();
        }
        return null;
    }

    public String[] getActionData() {
        String[] stringArray = new String[this.m_actionData.size()];
        ((ArrayList)this.m_actionData).toArray(stringArray);
        return stringArray;
    }

    private String replaceTimeStr(String string) {
        if (string == null) {
            return string;
        }
        int n = string.indexOf("StartTime=");
        if (n < 0) {
            n = string.indexOf("FinishTime=");
        }
        if (n < 0) {
            return string;
        }
        n = string.indexOf(61);
        String string2 = string.substring(n + 1);
        if (string2 == null || string2.length() <= 0) {
            return string;
        }
        JFTime jFTime = new JFTime(string2);
        return string.substring(0, n + 1) + jFTime.getTimeString();
    }

    private String alignString(String string, int n) {
        if (string.length() > n) {
            return "*" + string.substring(string.length() - n + 2) + " ";
        }
        char[] cArray = new char[n];
        Arrays.fill(cArray, ' ');
        return (string + new String(cArray)).substring(0, n - 1) + " ";
    }
}

