/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFConfigManager;
import com.platform.LSFJobFlow.api.JFException;
import com.platform.LSFJobFlow.api.JFHistory;
import com.platform.LSFJobFlow.api.JFMethodInvoker;
import com.platform.LSFJobFlow.api.JFResource;
import com.platform.LSFJobFlow.api.JFServiceProxy;
import com.platform.LSFJobFlow.api.JFVersion;

public class JFHistoryManager {
    private JFServiceProxy historyInvoker = new JFServiceProxy("JFHistory");
    private static final int SUCCESS = 0;
    private static final int QUERY_FROM_CLAUSE_EMPTY = 12003;
    private static final int QUERY_ILLEGAL_CATEGORY = 12004;
    private static final int QUERY_ILLEGAL_DATE_FORMAT = 12010;
    private static final int CANNOT_OPEN_LOG_FILE = 12102;
    private static final int CANNOT_SCAN_HISTORY_DIR = 12103;
    private static final int CANNOT_OBTAIN_HISTORY_DIR = 12104;
    private static final int PERMISSION_DENIED = 7;

    public JFHistory getHistoryObject(String string) throws JFException, Exception {
        JFConfigManager.checkServerVersionCompatible(new JFVersion("5.5"), JFResource.getString("Get_History_Object"));
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.historyInvoker, "JF_GetHistory");
        jFMethodInvoker.inParams.addParam("query", string);
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        this.generateError(n);
        JFHistory jFHistory = new JFHistory(jFMethodInvoker.outParams.findParam("history"));
        return jFHistory;
    }

    public String getHistory(String string) throws JFException, Exception {
        JFVersion jFVersion = JFConfigManager.getServerVersion(true);
        if (jFVersion != null && jFVersion.compareTo("5.5") < 0) {
            JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.historyInvoker, "JF_GetHistory");
            jFMethodInvoker.inParams.addParam("query", string);
            jFMethodInvoker.invoke();
            int n = jFMethodInvoker.outParams.getParamInt("return");
            this.generateError(n);
            return jFMethodInvoker.outParams.getParamString("response");
        }
        JFHistory jFHistory = this.getHistoryObject(string);
        return jFHistory.toString();
    }

    private void generateError(int n) throws JFException {
        switch (n) {
            case 0: {
                return;
            }
            case 12003: {
                throw new JFException(JFResource.getString("QUERY_FROM_CLAUSE_EMPTY"));
            }
            case 12004: {
                throw new JFException(JFResource.getString("QUERY_ILLEGAL_CATEGORY"));
            }
            case 12010: {
                throw new JFException(JFResource.getString("QUERY_ILLEGAL_DATE_FORMAT"));
            }
            case 12102: {
                throw new JFException(JFResource.getString("CANNOT_OPEN_LOG_FILE"));
            }
            case 12103: {
                throw new JFException(JFResource.getString("CANNOT_SCAN_HISTORY_DIR"));
            }
            case 12104: {
                throw new JFException(JFResource.getString("CANNOT_OBTAIN_HISTORY_DIR"));
            }
            case 7: {
                throw new JFException(JFResource.getString("PERMISSION_DENIED"));
            }
        }
        throw new JFException(JFResource.getString("HISTORY_SERVICE_ERROR"));
    }
}

