/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFCharReader;
import com.platform.LSFJobFlow.api.JFEvent;
import com.platform.LSFJobFlow.api.JFEventFactory;
import com.platform.LSFJobFlow.api.JFException;
import com.platform.LSFJobFlow.api.JFFlowArrayEvent;
import com.platform.LSFJobFlow.api.JFFlowArrayExceptionEvent;
import com.platform.LSFJobFlow.api.JFFlowEvent;
import com.platform.LSFJobFlow.api.JFFlowExceptionEvent;
import com.platform.LSFJobFlow.api.JFJob;
import com.platform.LSFJobFlow.api.JFJobArrayEvent;
import com.platform.LSFJobFlow.api.JFJobArrayExceptionEvent;
import com.platform.LSFJobFlow.api.JFJobEvent;
import com.platform.LSFJobFlow.api.JFJobExceptionEvent;
import com.platform.LSFJobFlow.api.JFResource;
import com.platform.LSFJobFlow.api.JFSAXParser;
import com.platform.LSFJobFlow.api.JFXMLSource;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;

public class JFHandler
implements Cloneable {
    public static final int KILL = 0;
    public static final int RERUN = 1;
    public static final int ALARM = 2;
    public static final int NUMBER_RERUN_LIMIT = 50;
    public static final int NUMBER_RERUN_DEFAULT = 30;
    private JFEvent m_event;
    private JFJob m_objAlarm;
    private int m_action;
    private int m_delay = 1;
    private int m_numberRerun = 30;

    public JFHandler() {
    }

    public static JFHandler initFromDefinition(String string) throws JFException {
        if (string == null) {
            throw new NullPointerException(JFResource.getString("EVENT_DEFN_NULL"));
        }
        String string2 = "<Exceptions> ";
        String string3 = "\n  </Exceptions>";
        String string4 = string2 + string + string3;
        JFCharReader jFCharReader = null;
        List<JFHandler> list = null;
        try {
            jFCharReader = new JFCharReader(string4.toCharArray());
            JFSAXParser jFSAXParser = new JFSAXParser(jFCharReader);
            XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
            XmlPullParser xmlPullParser = xmlPullParserFactory.newPullParser();
            xmlPullParser.setInput((Reader)jFCharReader);
            list = jFSAXParser.getHandlers(xmlPullParser);
            if (list.size() != 1) {
                throw new JFException(JFResource.getString("DEFN_FILE_DEFN_DOC"));
            }
            JFHandler jFHandler = list.get(0);
            return jFHandler;
        }
        catch (Exception exception) {
            throw new JFException(JFResource.getString("DEFN_FILE_DEFN_DOC") + ": " + exception.getMessage());
        }
        finally {
            if (jFCharReader != null) {
                try {
                    jFCharReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public JFHandler(JFEvent jFEvent, int n) throws JFException {
        if (!JFHandler.getValidHandlerAction(jFEvent, n)) {
            throw new JFException(JFResource.getString("HANDLER_ACTION_INVALID"));
        }
        this.m_event = jFEvent;
        this.m_action = n;
    }

    public JFHandler(JFEvent jFEvent, int n, int n2) throws JFException {
        if (!JFHandler.getValidHandlerAction(jFEvent, n)) {
            throw new JFException(JFResource.getString("HANDLER_ACTION_INVALID"));
        }
        if (n2 < 1) {
            throw new IllegalArgumentException(JFResource.getString("HANDLER_DELAY_NEG"));
        }
        this.m_event = jFEvent;
        this.m_action = n;
        this.m_delay = n2;
    }

    public JFHandler(JFEvent jFEvent, int n, int n2, int n3) throws JFException {
        if (!JFHandler.getValidHandlerAction(jFEvent, n)) {
            throw new JFException(JFResource.getString("HANDLER_ACTION_INVALID"));
        }
        if (n2 < 1) {
            throw new IllegalArgumentException(JFResource.getString("HANDLER_DELAY_NEG"));
        }
        if (n3 < 1 || n3 >= 50) {
            throw new IllegalArgumentException(JFResource.getString("HANDLER_NUMBER_RERUN_INVALID"));
        }
        this.m_event = jFEvent;
        this.m_action = n;
        this.m_delay = n2;
        this.m_numberRerun = n3;
    }

    public void setAlarmJob(JFJob jFJob) throws JFException {
        if (this.m_action != 2) {
            throw new JFException(JFResource.getString("HANDLER_INCOMPATIBLE_TYPE"));
        }
        if (jFJob == null) {
            throw new JFException(JFResource.getString("HANDLER_ALARM_NULL"));
        }
        this.m_objAlarm = jFJob;
    }

    public JFJob getAlarmJob() {
        return this.m_objAlarm;
    }

    public JFEvent getEvent() {
        return this.m_event;
    }

    public void setEvent(JFEvent jFEvent) {
        this.m_event = jFEvent;
    }

    public int getAction() {
        return this.m_action;
    }

    public void setAction(int n) throws JFException {
        if (!JFHandler.getValidHandlerAction(n)) {
            throw new JFException(JFResource.getString("HANDLER_ACTION_INVALID"));
        }
        this.m_action = n;
    }

    public int getDelay() {
        if (this.m_action == 1 && this.m_delay < 1) {
            this.m_delay = 1;
        }
        return this.m_delay;
    }

    public void setDelay(int n) {
        if (n < 1) {
            throw new IllegalArgumentException(JFResource.getString("HANDLER_DELAY_NEG"));
        }
        this.m_delay = n;
    }

    public int getNumberRerun() {
        if (this.m_action == 1 && (this.m_numberRerun < 1 || this.m_numberRerun > 50)) {
            this.m_numberRerun = 30;
        }
        return this.m_numberRerun;
    }

    public void setNumberRerun(int n) {
        if (n < 1 || n >= 50) {
            throw new IllegalArgumentException(JFResource.getString("HANDLER_NUMBER_RERUN_INVALID"));
        }
        this.m_numberRerun = n;
    }

    public Object clone() {
        try {
            Object object;
            JFEvent jFEvent = null;
            if (this.m_event != null) {
                try {
                    object = JFEventFactory.getEventFactory();
                    jFEvent = ((JFEventFactory)object).createEvent(this.m_event.getEventGeneratorType(), this.m_event.generateDefinition());
                }
                catch (Exception exception) {
                    jFEvent = null;
                }
            }
            object = new JFHandler(jFEvent, this.m_action, this.m_delay, this.m_numberRerun);
            if (this.getAction() == 2) {
                ((JFHandler)object).setAlarmJob((JFJob)this.getAlarmJob().clone());
            }
            return object;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static boolean getValidHandlerAction(int n) {
        return n == 2 || n == 0 || n == 1;
    }

    public static boolean getValidHandlerAction(JFEvent jFEvent, int n) {
        return JFHandler.getValidAction(jFEvent) == n || n == 2;
    }

    public static int getValidAction(JFEvent jFEvent) {
        if (!(jFEvent instanceof JFJobEvent || jFEvent instanceof JFJobExceptionEvent || jFEvent instanceof JFFlowEvent || jFEvent instanceof JFFlowExceptionEvent || jFEvent instanceof JFJobArrayEvent || jFEvent instanceof JFJobArrayExceptionEvent || jFEvent instanceof JFFlowArrayEvent || jFEvent instanceof JFFlowArrayExceptionEvent)) {
            return -1;
        }
        if (jFEvent instanceof JFJobEvent && ((JFJobEvent)jFEvent).getEventType() == 2 || jFEvent instanceof JFJobExceptionEvent && ((JFJobExceptionEvent)jFEvent).getEventType() == 3 || jFEvent instanceof JFFlowEvent && (((JFFlowEvent)jFEvent).getEventType() == 10 || ((JFFlowEvent)jFEvent).getEventType() == 13 || ((JFFlowEvent)jFEvent).getEventType() == 12 || ((JFFlowEvent)jFEvent).getEventType() == 11) || jFEvent instanceof JFFlowExceptionEvent && ((JFFlowExceptionEvent)jFEvent).getEventType() == 3 || jFEvent instanceof JFJobArrayEvent && (((JFJobArrayEvent)jFEvent).getEventType() == 10 || ((JFJobArrayEvent)jFEvent).getEventType() == 13 || ((JFJobArrayEvent)jFEvent).getEventType() == 12 || ((JFJobArrayEvent)jFEvent).getEventType() == 11) || jFEvent instanceof JFJobArrayExceptionEvent && ((JFJobArrayExceptionEvent)jFEvent).getEventType() == 3 || jFEvent instanceof JFFlowArrayEvent && (((JFFlowArrayEvent)jFEvent).getEventType() == 10 || ((JFFlowArrayEvent)jFEvent).getEventType() == 13 || ((JFFlowArrayEvent)jFEvent).getEventType() == 12 || ((JFFlowArrayEvent)jFEvent).getEventType() == 11) || jFEvent instanceof JFFlowArrayExceptionEvent && ((JFFlowArrayExceptionEvent)jFEvent).getEventType() == 3) {
            return 0;
        }
        return 1;
    }

    public boolean equals(JFHandler jFHandler) {
        boolean bl;
        boolean bl2 = bl = jFHandler.m_action == jFHandler.m_action && jFHandler.m_event.equals(this.m_event) && jFHandler.m_delay == this.m_delay && jFHandler.m_numberRerun == this.m_numberRerun;
        if (jFHandler.m_objAlarm == null || this.m_objAlarm == null) {
            if (jFHandler.m_objAlarm != null || this.m_objAlarm != null) {
                return false;
            }
        } else {
            return bl && jFHandler.m_objAlarm.equals(this.m_objAlarm);
        }
        return bl;
    }

    public void setEventObject(Object object) {
        this.m_event.setEventObject(object);
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        switch (this.m_action) {
            case 2: {
                string = "alarm";
                break;
            }
            case 1: {
                string = "rerun";
                break;
            }
            case 0: {
                string = "kill";
                break;
            }
        }
        stringBuffer.append("<Exception Type=\"" + string + "\" Delay=\"" + this.m_delay + "\" NumberRerun=\"" + this.m_numberRerun + "\">");
        stringBuffer.append("<Event GeneratorType=\"" + this.m_event.getEventGeneratorType() + "\">");
        stringBuffer.append(JFXMLSource.convertToXMLAttrString(this.m_event.generateDefinition()) + "</Event>");
        if (this.m_action == 2) {
            stringBuffer.append(this.m_objAlarm.toXML(""));
        }
        stringBuffer.append("</Exception>");
        return stringBuffer.toString();
    }
}

