/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFConfigManager;
import com.platform.LSFJobFlow.api.JFDateTimeParser;
import com.platform.LSFJobFlow.api.JFDebug;
import com.platform.LSFJobFlow.api.JFEvent;
import com.platform.LSFJobFlow.api.JFEventInstance;
import com.platform.LSFJobFlow.api.JFException;
import com.platform.LSFJobFlow.api.JFFileEvent;
import com.platform.LSFJobFlow.api.JFFileEventInstance;
import com.platform.LSFJobFlow.api.JFFilter;
import com.platform.LSFJobFlow.api.JFFlow;
import com.platform.LSFJobFlow.api.JFFlowArrayEvent;
import com.platform.LSFJobFlow.api.JFFlowArrayExceptionEvent;
import com.platform.LSFJobFlow.api.JFFlowArrayInstance;
import com.platform.LSFJobFlow.api.JFFlowEvent;
import com.platform.LSFJobFlow.api.JFFlowExceptionEvent;
import com.platform.LSFJobFlow.api.JFJob;
import com.platform.LSFJobFlow.api.JFJobArrayEvent;
import com.platform.LSFJobFlow.api.JFJobArrayExceptionEvent;
import com.platform.LSFJobFlow.api.JFJobArrayInstance;
import com.platform.LSFJobFlow.api.JFJobEvent;
import com.platform.LSFJobFlow.api.JFJobExceptionEvent;
import com.platform.LSFJobFlow.api.JFJobInstance;
import com.platform.LSFJobFlow.api.JFLinkEvent;
import com.platform.LSFJobFlow.api.JFLinkEventInstance;
import com.platform.LSFJobFlow.api.JFLoginManager;
import com.platform.LSFJobFlow.api.JFResource;
import com.platform.LSFJobFlow.api.JFStatusListener;
import com.platform.LSFJobFlow.api.JFTime;
import com.platform.LSFJobFlow.api.JFUpdateMsg;
import com.platform.LSFJobFlow.api.JFUser;
import com.platform.LSFJobFlow.api.JFVariableEvent;
import com.platform.LSFJobFlow.api.JFVersion;
import com.platform.LSFJobFlow.api.JFXMLSource;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JFFlowInstance
extends JFStatusListener {
    public static final int FLOW_WAITING = 0;
    public static final int FLOW_RUNNING = 1;
    public static final int FLOW_DONE = 2;
    public static final int FLOW_EXIT = 3;
    public static final int FLOW_KILLED = 4;
    public static final int FLOW_SUSPENDED = 5;
    public static final int FLOW_WAITSUSPENDED = 6;
    public static final String JOBARRAY_TYPE = "jobarray";
    public static final String FLOW_TYPE = "flow";
    public static final String FLOWARRAY_TYPE = "flowarray";
    public static final String LSF_TYPE = "lsf";
    public static final String MANUAL_TYPE = "manual";
    public static final String LINK_TYPE = "link";
    public static final String ALARM_TYPE = "alarm";
    public static final String JOBARRAY_ELEMENT_TYPE = "jobarrayelement";
    public static final String SUBFLOW_TYPE = "subflow";
    private JFFlow flowDefinition = null;
    private LinkedList events = null;
    private long id;
    private String name = null;
    private int state;
    private int statusCode;
    JFTime startTime = null;
    JFTime finishTime = null;
    private String currentlyUsedVer = null;
    private String owner = null;
    private JFUser triggerUser = null;
    private LinkedList subFlowInstances = null;
    private LinkedList jobInstances = null;
    private LinkedList jobArrayInstances = null;
    private LinkedList flowArrayInstances = null;
    private Properties localVariables = null;
    private Properties inputVariables = null;
    private static final String m_szTopic = "js_flowinstanceints";
    private JFFilter m_filter = null;
    private static Object mutex = new Object();
    private Vector m_szChangedList = null;
    private Map m_linkEventInstances = null;
    private boolean m_isFromOwnFlowDefinition;
    private String m_inputData = null;
    private String m_outputData = null;
    private boolean m_isDraft;
    private List<JFLinkEventInstance> jfLinkEventInstances = new ArrayList<JFLinkEventInstance>();
    private Map<String, JFJobInstance> jfLinkJobs = new HashMap<String, JFJobInstance>();

    public boolean isFromOwnFlowDefinition() {
        return this.m_isFromOwnFlowDefinition;
    }

    JFFlowInstance() {
        this.events = new LinkedList();
        this.subFlowInstances = new LinkedList();
        this.jobInstances = new LinkedList();
        this.jobArrayInstances = new LinkedList();
        this.flowArrayInstances = new LinkedList();
        this.localVariables = new Properties();
        this.inputVariables = new Properties();
        this.m_szChangedList = new Vector();
        this.m_linkEventInstances = new Hashtable();
    }

    @Override
    public void registerWithJMS() {
    }

    @Override
    public void unregisterWithJMS() {
    }

    public String getCurrentlyUsedVersion() {
        return this.currentlyUsedVer;
    }

    public JFFlow getFlowDefinition() {
        return this.flowDefinition;
    }

    public String getOwner() {
        return this.owner;
    }

    public JFUser getTriggerUser() {
        return this.triggerUser;
    }

    public String getSubmitter() {
        return this.triggerUser.toJSUserName();
    }

    public long getInstanceId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Properties getLocalVariables() {
        return this.localVariables;
    }

    public Properties getInputVariables() {
        return this.inputVariables;
    }

    public int getState() {
        return this.state;
    }

    public static String getStateStr(int n) {
        switch (n) {
            case 0: {
                return JFResource.getString("FLOW_STATE_WAITING");
            }
            case 1: {
                return JFResource.getString("FLOW_STATE_RUNNING");
            }
            case 2: {
                return JFResource.getString("FLOW_STATE_DONE");
            }
            case 3: {
                return JFResource.getString("FLOW_STATE_EXIT");
            }
            case 4: {
                return JFResource.getString("FLOW_STATE_KILLED");
            }
            case 5: 
            case 6: {
                return JFResource.getString("FLOW_STATE_SUSPENDED");
            }
        }
        return JFResource.getString("FLOW_STATE_UNKNOWN");
    }

    public int getStatus() {
        return this.statusCode;
    }

    public Date getStartTime() {
        if (this.startTime != null) {
            return this.startTime.getTime();
        }
        return null;
    }

    public Date getFinishTime() {
        if (this.finishTime != null) {
            return this.finishTime.getTime();
        }
        return null;
    }

    public String getStartTimeOnServer() {
        if (this.startTime != null) {
            return this.startTime.getTimeStringOnServer();
        }
        return null;
    }

    public String getFinishTimeOnServer() {
        if (this.finishTime != null) {
            return this.finishTime.getTimeStringOnServer();
        }
        return null;
    }

    public String getStartTimeString() {
        if (this.startTime != null) {
            return this.startTime.getTimeString();
        }
        return null;
    }

    public String getFinishTimeString() {
        if (this.finishTime != null) {
            return this.finishTime.getTimeString();
        }
        return null;
    }

    public JFEventInstance[] getEventInstances() {
        if (this.events == null) {
            return new JFEventInstance[0];
        }
        JFEventInstance[] jFEventInstanceArray = new JFEventInstance[this.events.size()];
        this.events.toArray(jFEventInstanceArray);
        return jFEventInstanceArray;
    }

    private JFFlowArrayInstance getFlowArrayInstanceByName(String string) {
        String string2;
        if (string == null) {
            return null;
        }
        JFDebug.println("getFlowArrayInstanceByName: strName: <" + string + ">");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        String string3 = string2 = stringArray[0] + ":" + stringArray[1] + ":" + stringArray[2];
        JFFlowInstance jFFlowInstance = this;
        JFFlowArrayInstance jFFlowArrayInstance = null;
        block1: for (int i = 3; i < stringArray.length; ++i) {
            string3 = string3 + ":" + stringArray[i];
            JFFlowArrayInstance[] jFFlowArrayInstanceArray = jFFlowInstance.getFlowArrayInstances();
            for (int j = 0; j < jFFlowArrayInstanceArray.length; ++j) {
                JFDebug.println("getFlowArrayInstanceByName: fa.getName: <" + jFFlowArrayInstanceArray[j].getName() + "> name: <" + string3 + ">");
                if (!string3.equals(jFFlowArrayInstanceArray[j].getName())) continue;
                jFFlowArrayInstance = jFFlowArrayInstanceArray[j];
                break;
            }
            if (jFFlowArrayInstance != null) continue;
            JFFlowInstance[] jFFlowInstanceArray = jFFlowInstance.getSubFlowInstances();
            for (int j = 0; j < jFFlowInstanceArray.length; ++j) {
                if (!string3.equals(jFFlowInstanceArray[j].getName())) continue;
                jFFlowInstance = jFFlowInstanceArray[j];
                continue block1;
            }
        }
        return jFFlowArrayInstance;
    }

    private JFFlowInstance getFlowInstanceByName(String string) {
        String string2;
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        String string3 = string2 = stringArray[0] + ":" + stringArray[1] + ":" + stringArray[2];
        JFFlowInstance jFFlowInstance = this;
        block1: for (int i = 3; i < stringArray.length; ++i) {
            int n2;
            JFDebug.println("getFlowInstanceByName: parsedName[" + i + "]: <" + stringArray[i] + ">");
            if (stringArray[i].indexOf("(") != -1) {
                int n3 = stringArray[i].indexOf("(");
                n2 = stringArray[i].indexOf(")");
                JFDebug.println("getFlowInstanceByName:pos1 <" + n3 + "> pos2: <" + n2 + ">");
                String string4 = stringArray[i].substring(0, n3);
                String string5 = stringArray[i].substring(n3 + 1, n2);
                JFDebug.println("getFlowInstanceByName: tmpName1: <" + string4 + "> tmpName2 <" + string5 + ">");
                string3 = string3 + ":" + string4;
                JFFlowArrayInstance[] jFFlowArrayInstanceArray = jFFlowInstance.getFlowArrayInstances();
                boolean bl = false;
                for (int j = 0; j < jFFlowArrayInstanceArray.length; ++j) {
                    if (!string3.equals(jFFlowArrayInstanceArray[j].getName())) continue;
                    jFFlowInstance = jFFlowArrayInstanceArray[j].getFlowInstance(string3 = string3 + "(" + string5 + ")");
                    if (jFFlowInstance == null) break;
                    bl = true;
                    break;
                }
                if (bl) continue;
                return null;
            }
            string3 = string3 + ":" + stringArray[i];
            JFFlowInstance[] jFFlowInstanceArray = jFFlowInstance.getSubFlowInstances();
            for (n2 = 0; n2 < jFFlowInstanceArray.length; ++n2) {
                if (!string3.equals(jFFlowInstanceArray[n2].getName())) continue;
                jFFlowInstance = jFFlowInstanceArray[n2];
                continue block1;
            }
        }
        return jFFlowInstance;
    }

    public JFJobInstance[] getJobInstances() {
        if (this.jobInstances == null) {
            return new JFJobInstance[0];
        }
        JFJobInstance[] jFJobInstanceArray = new JFJobInstance[this.jobInstances.size()];
        this.jobInstances.toArray(jFJobInstanceArray);
        return jFJobInstanceArray;
    }

    private JFJobInstance getJobInstanceByName(String string) {
        if (this.jobInstances == null) {
            return null;
        }
        for (JFJobInstance jFJobInstance : this.jobInstances) {
            if (!jFJobInstance.getName().equals(string)) continue;
            return jFJobInstance;
        }
        return null;
    }

    public JFFlowInstance[] getSubFlowInstances() {
        if (this.subFlowInstances == null) {
            return new JFFlowInstance[0];
        }
        JFFlowInstance[] jFFlowInstanceArray = new JFFlowInstance[this.subFlowInstances.size()];
        this.subFlowInstances.toArray(jFFlowInstanceArray);
        return jFFlowInstanceArray;
    }

    private JFFlowInstance getSubFlowInstanceByName(String string) {
        if (this.subFlowInstances == null) {
            return null;
        }
        for (JFFlowInstance jFFlowInstance : this.subFlowInstances) {
            if (!jFFlowInstance.getName().equals(string)) continue;
            return jFFlowInstance;
        }
        return null;
    }

    public JFJobArrayInstance[] getJobArrayInstances() {
        if (this.jobArrayInstances == null) {
            return new JFJobArrayInstance[0];
        }
        JFJobArrayInstance[] jFJobArrayInstanceArray = new JFJobArrayInstance[this.jobArrayInstances.size()];
        this.jobArrayInstances.toArray(jFJobArrayInstanceArray);
        return jFJobArrayInstanceArray;
    }

    private JFJobArrayInstance getJobArrayInstanceByName(String string) {
        if (this.jobInstances == null) {
            return null;
        }
        for (JFJobArrayInstance jFJobArrayInstance : this.jobArrayInstances) {
            if (!jFJobArrayInstance.getName().equals(string)) continue;
            return jFJobArrayInstance;
        }
        return null;
    }

    public JFFlowArrayInstance[] getFlowArrayInstances() {
        if (this.flowArrayInstances == null) {
            return new JFFlowArrayInstance[0];
        }
        JFFlowArrayInstance[] jFFlowArrayInstanceArray = new JFFlowArrayInstance[this.flowArrayInstances.size()];
        this.flowArrayInstances.toArray(jFFlowArrayInstanceArray);
        return jFFlowArrayInstanceArray;
    }

    void fromXML(Node node) throws JFException {
        this.fromXML(node, null);
    }

    void fromXML(Node node, JFFlow jFFlow) throws JFException {
        Hashtable<String, JFJobInstance> hashtable = new Hashtable<String, JFJobInstance>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        boolean bl = false;
        JFVersion jFVersion = JFConfigManager.getServerVersion();
        if (jFVersion != null && jFVersion.compareTo("5.5") < 0) {
            bl = true;
        }
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            Object object;
            int n;
            Object object2;
            Object object3;
            Node node2 = node.getChildNodes().item(i);
            if (node2.getNodeName().equals("flowDefinition")) {
                object3 = node2.getFirstChild();
                JFXMLSource jFXMLSource = new JFXMLSource((Node)object3);
                this.flowDefinition = jFXMLSource.createFlow();
                for (int j = 0; j < object3.getChildNodes().getLength(); ++j) {
                    object2 = object3.getChildNodes().item(j);
                    if (!object2.getNodeName().equals("JobFlowDef")) continue;
                    for (n = 0; n < object2.getChildNodes().getLength(); ++n) {
                        object = object2.getChildNodes().item(n);
                        if (!object.getNodeName().equals("flowVersion")) continue;
                        for (int k = 0; k < object.getChildNodes().getLength(); ++k) {
                            Node node3 = object.getChildNodes().item(k);
                            if (!node3.getNodeName().equals("version")) continue;
                            this.currentlyUsedVer = node3.getFirstChild().getNodeValue();
                        }
                    }
                }
            }
            if (node2.getNodeName().equals("id")) {
                this.id = Long.parseLong(node2.getFirstChild().getNodeValue());
            }
            if (node2.getNodeName().equals("name")) {
                this.name = node2.getFirstChild().getNodeValue();
            }
            if (node2.getNodeName().equals("owner")) {
                this.owner = node2.getFirstChild().getNodeValue();
            }
            if (node2.getNodeName().equals("triggerUser")) {
                this.triggerUser = new JFUser(node2.getFirstChild().getNodeValue());
            }
            if (node2.getNodeName().equals("state")) {
                this.state = Integer.parseInt(node2.getFirstChild().getNodeValue());
            }
            if (node2.getNodeName().equals("statusCode")) {
                this.statusCode = Integer.parseInt(node2.getFirstChild().getNodeValue());
            }
            if (node2.getNodeName().equals("startTime")) {
                if (bl) {
                    try {
                        this.startTime = new JFTime(JFDateTimeParser.oldParse(node2.getFirstChild().getNodeValue()));
                    }
                    catch (ParseException parseException) {
                        JFDebug.println("JFFlowInstance::fromXML: wrong format of startTime " + parseException.getMessage());
                    }
                } else {
                    this.startTime = new JFTime(node2.getFirstChild());
                }
            }
            if (node2.getNodeName().equals("finishTime")) {
                if (bl) {
                    try {
                        this.finishTime = new JFTime(JFDateTimeParser.oldParse(node2.getFirstChild().getNodeValue()));
                    }
                    catch (ParseException parseException) {
                        JFDebug.println("JFFlowInstance::fromXML: wrong format of finishTime time " + parseException.getMessage());
                    }
                } else {
                    this.finishTime = new JFTime(node2.getFirstChild());
                }
            }
            if (node2.getNodeName().equals("isFromOwnFlowDefinition")) {
                object3 = node2.getFirstChild().getNodeValue();
                boolean bl2 = this.m_isFromOwnFlowDefinition = object3 != null && ((String)object3).equalsIgnoreCase("true");
            }
            if (node2.getNodeName().equals("isDraft")) {
                object3 = node2.getFirstChild().getNodeValue();
                boolean bl3 = this.m_isDraft = object3 != null && ((String)object3).equalsIgnoreCase("true");
            }
            if (node2.getNodeName().equals("jobArrayInstances")) {
                object3 = node2.getChildNodes();
                for (int j = 0; j < object3.getLength(); ++j) {
                    JFJobArrayInstance jFJobArrayInstance = new JFJobArrayInstance();
                    jFJobArrayInstance.fromXML(object3.item(j), this.getFlowDefinition());
                    object2 = jFJobArrayInstance.getJobInstance().getEventInstances();
                    for (n = 0; object2 != null && n < ((JFEventInstance[])object2).length; ++n) {
                        object = object2[n];
                        if (!(object instanceof JFLinkEventInstance)) continue;
                        arrayList.add(object);
                    }
                    this.jobArrayInstances.add(jFJobArrayInstance);
                }
            }
            if (node2.getNodeName().equals("jobInstances")) {
                object3 = node2.getChildNodes();
                for (int j = 0; j < object3.getLength(); ++j) {
                    JFJobInstance jFJobInstance = new JFJobInstance();
                    jFJobInstance.fromXML(object3.item(j), this.getFlowDefinition(), false);
                    object2 = jFJobInstance.getJobDefinition();
                    if (object2 != null && !((JFJob)object2).getExecutionType().equals(LINK_TYPE)) {
                        this.jobInstances.add(jFJobInstance);
                    } else {
                        hashtable.put(((JFJob)object2).getName(), jFJobInstance);
                    }
                    JFEventInstance[] jFEventInstanceArray = jFJobInstance.getEventInstances();
                    for (int k = 0; jFEventInstanceArray != null && k < jFEventInstanceArray.length; ++k) {
                        JFEventInstance jFEventInstance = jFEventInstanceArray[k];
                        if (!(jFEventInstance instanceof JFLinkEventInstance)) continue;
                        arrayList.add(jFEventInstance);
                    }
                }
            }
            if (node2.getNodeName().equals("subFlowInstances")) {
                object3 = node2.getChildNodes();
                for (int j = 0; j < object3.getLength(); ++j) {
                    JFFlowInstance jFFlowInstance = new JFFlowInstance();
                    jFFlowInstance.fromXML(object3.item(j), this.flowDefinition);
                    jFFlowInstance.flowDefinition.setAttributes(this.flowDefinition.getFlow(jFFlowInstance.flowDefinition.getName()).getAttributes());
                    jFFlowInstance.flowDefinition.m_handlerList = this.flowDefinition.getFlow((String)jFFlowInstance.flowDefinition.getName()).m_handlerList;
                    this.subFlowInstances.add(jFFlowInstance);
                    object2 = jFFlowInstance.getEventInstances();
                    for (int k = 0; object2 != null && k < ((Object)object2).length; ++k) {
                        Object object4 = object2[k];
                        if (!(object4 instanceof JFLinkEventInstance)) continue;
                        arrayList.add(object4);
                    }
                }
            }
            if (node2.getNodeName().equals("flowArrayInstances")) {
                object3 = node2.getChildNodes();
                for (int j = 0; j < object3.getLength(); ++j) {
                    JFFlowArrayInstance jFFlowArrayInstance = new JFFlowArrayInstance();
                    jFFlowArrayInstance.fromXML(object3.item(j), this.flowDefinition);
                    jFFlowArrayInstance.m_flowDefinition.setAttributes(this.flowDefinition.getFlowArray(jFFlowArrayInstance.m_flowDefinition.getName()).getFlowDefinition().getAttributes());
                    jFFlowArrayInstance.m_flowDefinition.m_handlerList = this.flowDefinition.getFlowArray((String)jFFlowArrayInstance.m_flowDefinition.getName()).getFlowDefinition().m_handlerList;
                    this.flowArrayInstances.add(jFFlowArrayInstance);
                    object2 = jFFlowArrayInstance.getEventInstances();
                    for (int k = 0; object2 != null && k < ((Object)object2).length; ++k) {
                        Object object5 = object2[k];
                        if (!(object5 instanceof JFLinkEventInstance)) continue;
                        arrayList.add(object5);
                    }
                }
            }
            if (node2.getNodeName().equals("variables")) {
                object3 = node2.getChildNodes();
                for (int j = 0; j < object3.getLength(); ++j) {
                    Element element = (Element)object3.item(j);
                    if (element == null || !"item".equals(element.getNodeName())) continue;
                    object2 = JFXMLSource.decodeXML(element.getAttribute("varName"));
                    String string = JFXMLSource.decodeXML(element.getAttribute("varValue"));
                    if (object2 == null || string == null) continue;
                    this.localVariables.put(object2, string);
                }
            }
            if (node2.getNodeName().equals("localVars")) {
                object3 = node2.getChildNodes();
                for (int j = 0; j < object3.getLength(); ++j) {
                    Element element = (Element)object3.item(j);
                    if (element == null || !"item".equals(element.getNodeName())) continue;
                    object2 = JFXMLSource.decodeXML(element.getAttribute("varName"));
                    String string = JFXMLSource.decodeXML(element.getAttribute("varValue"));
                    if (object2 == null || string == null) continue;
                    this.localVariables.put(object2, string);
                }
            }
            if (node2.getNodeName().equals("inputVars")) {
                object3 = node2.getChildNodes();
                for (int j = 0; j < object3.getLength(); ++j) {
                    Element element = (Element)object3.item(j);
                    if (element == null || !"item".equals(element.getNodeName())) continue;
                    object2 = JFXMLSource.decodeXML(element.getAttribute("varName"));
                    String string = JFXMLSource.decodeXML(element.getAttribute("varValue"));
                    if (object2 == null || string == null) continue;
                    this.inputVariables.put(object2, string);
                }
            }
            if (node2.getNodeName().equals("events")) {
                this.eventsFromXML_(node2, jFFlow);
            }
            if (node2.getNodeName().equals("inputData") && (object3 = node2.getFirstChild()) != null) {
                this.setInputData(object3.getNodeValue());
            }
            if (!node2.getNodeName().equals("outputData") || (object3 = node2.getFirstChild()) == null) continue;
            this.setOutputData(object3.getNodeValue());
        }
        if (jFFlow != null) {
            this.initializeEventInstances(jFFlow);
        }
        this.setupLinks(arrayList, hashtable);
        this.flowDefinition.setTriggeredEvents(this.getEventInstances());
        if (this.owner == null) {
            this.owner = JFFlowInstance.getUserByFlowName(this.flowDefinition.getName());
        }
    }

    static String getUserByFlowName(String string) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        int n = string.indexOf(58);
        string2 = n != -1 ? string.substring(0, n) : JFLoginManager.getUserName();
        return string2;
    }

    private void eventsFromXML_(Node node, JFFlow jFFlow) throws JFException {
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            JFFlow jFFlow2;
            JFEvent jFEvent;
            JFEventInstance jFEventInstance = new JFEventInstance();
            jFEventInstance.fromXML(node.getChildNodes().item(i));
            JFEvent jFEvent2 = jFEventInstance.getEventDefinition();
            String string = jFEvent2.getEventGeneratorType();
            if (string.equals(LSF_TYPE) || string.equals(MANUAL_TYPE) || string.equals("otherbatch") || string.equals("local")) {
                jFEvent = (JFJobEvent)jFEvent2;
                jFEvent.m_jobRef = this.flowDefinition.getJob(jFEvent.m_jobName);
                if (jFEvent.m_jobRef == null && jFFlow != null) {
                    jFEvent.m_jobRef = jFFlow.getJob(jFEvent.m_jobName);
                }
            } else if (string.equals("variable")) {
                jFEvent = (JFVariableEvent)jFEvent2;
                ((JFVariableEvent)jFEvent).m_jobRef = this.flowDefinition.getJob(((JFVariableEvent)jFEvent).m_jobName);
                if (((JFVariableEvent)jFEvent).m_jobRef == null && jFFlow != null) {
                    ((JFVariableEvent)jFEvent).m_jobRef = jFFlow.getJob(((JFVariableEvent)jFEvent).m_jobName);
                }
            } else if (string.equals(LINK_TYPE)) {
                jFEvent = (JFLinkEvent)jFEvent2;
                jFEventInstance = new JFLinkEventInstance();
                jFEventInstance.fromXML(node.getChildNodes().item(i));
                ((JFLinkEvent)jFEventInstance.eventDefinition).m_linkJobRef = this.flowDefinition.getJob(((JFLinkEvent)jFEvent).m_linkJobName);
                if (((JFLinkEvent)jFEventInstance.eventDefinition).m_linkJobRef == null && jFFlow != null) {
                    ((JFLinkEvent)jFEventInstance.eventDefinition).m_linkJobRef = jFFlow.getJob(((JFLinkEvent)jFEvent).m_linkJobName);
                }
            } else if (string.equals(FLOW_TYPE)) {
                jFEvent = (JFFlowEvent)jFEvent2;
                ((JFFlowEvent)jFEvent).m_flowRef = this.flowDefinition.getFlow(((JFFlowEvent)jFEvent).m_flowName);
                if (((JFFlowEvent)jFEvent).m_flowRef == null) {
                    ((JFFlowEvent)jFEvent).m_flowRef = jFFlow != null ? jFFlow.getFlow(((JFFlowEvent)jFEvent).m_flowName) : (jFFlow2 = new JFFlow(((JFFlowEvent)jFEvent).m_flowName));
                }
            } else if (string.equals(JOBARRAY_TYPE)) {
                jFEvent = (JFJobArrayEvent)jFEvent2;
                ((JFJobArrayEvent)jFEvent).m_jobArrRef = this.flowDefinition.getJobArray(((JFJobArrayEvent)jFEvent).m_jobArrName);
                if (((JFJobArrayEvent)jFEvent).m_jobArrRef == null && jFFlow != null) {
                    ((JFJobArrayEvent)jFEvent).m_jobArrRef = jFFlow.getJobArray(((JFJobArrayEvent)jFEvent).m_jobArrName);
                }
            } else if (string.equals("job_except")) {
                jFEvent = (JFJobExceptionEvent)jFEvent2;
                ((JFJobExceptionEvent)jFEvent).m_jobRef = this.flowDefinition.getJob(((JFJobExceptionEvent)jFEvent).m_jobName);
                if (((JFJobExceptionEvent)jFEvent).m_jobRef == null && jFFlow != null) {
                    ((JFJobExceptionEvent)jFEvent).m_jobRef = jFFlow.getJob(((JFJobExceptionEvent)jFEvent).m_jobName);
                }
            } else if (string.equals("jobarray_except")) {
                jFEvent = (JFJobArrayExceptionEvent)jFEvent2;
                ((JFJobArrayExceptionEvent)jFEvent).m_jobArrRef = this.flowDefinition.getJobArray(((JFJobArrayExceptionEvent)jFEvent).m_jobArrName);
                if (((JFJobArrayExceptionEvent)jFEvent).m_jobArrRef == null && jFFlow != null) {
                    ((JFJobArrayExceptionEvent)jFEvent).m_jobArrRef = jFFlow.getJobArray(((JFJobArrayExceptionEvent)jFEvent).m_jobArrName);
                }
            } else if (string.equals("flow_except")) {
                jFEvent = (JFFlowExceptionEvent)jFEvent2;
                ((JFFlowExceptionEvent)jFEvent).m_flowRef = this.flowDefinition.getFlow(((JFFlowExceptionEvent)jFEvent).m_flowName);
                if (((JFFlowExceptionEvent)jFEvent).m_flowRef == null) {
                    ((JFFlowExceptionEvent)jFEvent).m_flowRef = jFFlow != null ? jFFlow.getFlow(((JFFlowExceptionEvent)jFEvent).m_flowName) : (jFFlow2 = new JFFlow(((JFFlowExceptionEvent)jFEvent).m_flowName));
                }
            } else if (string.equals(FLOWARRAY_TYPE)) {
                jFEvent = (JFFlowArrayEvent)jFEvent2;
                ((JFFlowArrayEvent)jFEvent).m_flowArrRef = this.flowDefinition.getFlowArray(((JFFlowArrayEvent)jFEvent).m_flowArrName);
                if (((JFFlowArrayEvent)jFEvent).m_flowArrRef == null && jFFlow != null) {
                    ((JFFlowArrayEvent)jFEvent).m_flowArrRef = jFFlow.getFlowArray(((JFFlowArrayEvent)jFEvent).m_flowArrName);
                }
            } else if (string.equals("flowarray_except")) {
                jFEvent = (JFFlowArrayExceptionEvent)jFEvent2;
                ((JFFlowArrayExceptionEvent)jFEvent).m_flowArrRef = this.flowDefinition.getFlowArray(((JFFlowArrayExceptionEvent)jFEvent).m_flowArrName);
                if (((JFFlowArrayExceptionEvent)jFEvent).m_flowArrRef == null && jFFlow != null) {
                    ((JFFlowArrayExceptionEvent)jFEvent).m_flowArrRef = jFFlow.getFlowArray(((JFFlowArrayExceptionEvent)jFEvent).m_flowArrName);
                }
            } else if (string.equals("FileAgent_v1.0")) {
                jFEvent = (JFFileEvent)jFEvent2;
                jFEventInstance = new JFFileEventInstance();
                jFEventInstance.fromXML(node.getChildNodes().item(i));
            }
            this.events.add(jFEventInstance);
        }
    }

    void initializeEventInstances(JFFlow jFFlow) {
        Iterator iterator = jFFlow.getEvents(this.getName());
        if (iterator != null) {
            while (iterator.hasNext()) {
                JFEventInstance jFEventInstance;
                JFEvent jFEvent = (JFEvent)iterator.next();
                Iterator iterator2 = this.events.iterator();
                if (iterator2 == null) continue;
                boolean bl = false;
                while (iterator2.hasNext()) {
                    jFEventInstance = (JFEventInstance)iterator2.next();
                    if (!jFEventInstance.getEventDefinition().equalsWithPosition(jFEvent)) continue;
                    if (jFEventInstance instanceof JFLinkEventInstance) {
                        jFEventInstance.eventDefinition = jFEvent;
                    }
                    bl = true;
                    break;
                }
                if (bl) continue;
                jFEventInstance = null;
                jFEventInstance = !jFEvent.getEventGeneratorType().equals(LINK_TYPE) ? new JFEventInstance() : new JFLinkEventInstance();
                if (!jFEvent.isProxy()) {
                    int n;
                    JFEvent jFEvent2;
                    String string = jFEvent.getEventGeneratorType();
                    if (string.equals(LSF_TYPE) || string.equals(MANUAL_TYPE) || string.equals("otherbatch") || string.equals("local")) {
                        jFEvent2 = (JFJobEvent)jFEvent;
                        n = jFEvent2.m_jobName.lastIndexOf(":");
                        if (n != -1) {
                            jFEvent2.m_jobName = jFEvent2.m_jobName.substring(n + 1, jFEvent2.m_jobName.length());
                        }
                    } else if (string.equals(LINK_TYPE)) {
                        jFEvent2 = (JFLinkEvent)jFEvent;
                        n = ((JFLinkEvent)jFEvent2).m_linkJobName.lastIndexOf(":");
                        if (n != -1) {
                            ((JFLinkEvent)jFEvent2).m_linkJobName = ((JFLinkEvent)jFEvent2).m_linkJobName.substring(n + 1, ((JFLinkEvent)jFEvent2).m_linkJobName.length());
                        }
                        if (((JFLinkEvent)jFEvent2).m_linkJobRef != null) {
                            ((JFLinkEvent)jFEvent2).m_linkJobRef.setName(((JFLinkEvent)jFEvent2).m_linkJobName);
                        }
                    } else if (string.equals(FLOW_TYPE)) {
                        jFEvent2 = (JFFlowEvent)jFEvent;
                        n = ((JFFlowEvent)jFEvent2).m_flowName.lastIndexOf(":");
                        if (n != -1) {
                            ((JFFlowEvent)jFEvent2).m_flowName = ((JFFlowEvent)jFEvent2).m_flowName.substring(n + 1, ((JFFlowEvent)jFEvent2).m_flowName.length());
                        }
                    } else if (string.equals(JOBARRAY_TYPE)) {
                        jFEvent2 = (JFJobArrayEvent)jFEvent;
                        n = ((JFJobArrayEvent)jFEvent2).m_jobArrName.lastIndexOf(":");
                        if (n != -1) {
                            ((JFJobArrayEvent)jFEvent2).m_jobArrName = ((JFJobArrayEvent)jFEvent2).m_jobArrName.substring(n + 1, ((JFJobArrayEvent)jFEvent2).m_jobArrName.length());
                        }
                    } else if (string.equals("job_except")) {
                        jFEvent2 = (JFJobExceptionEvent)jFEvent;
                        n = ((JFJobExceptionEvent)jFEvent2).m_jobName.lastIndexOf(":");
                        if (n != -1) {
                            ((JFJobExceptionEvent)jFEvent2).m_jobName = ((JFJobExceptionEvent)jFEvent2).m_jobName.substring(n + 1, ((JFJobExceptionEvent)jFEvent2).m_jobName.length());
                        }
                    } else if (string.equals("jobarray_except")) {
                        jFEvent2 = (JFJobArrayExceptionEvent)jFEvent;
                        n = ((JFJobArrayExceptionEvent)jFEvent2).m_jobArrName.lastIndexOf(":");
                        if (n != -1) {
                            ((JFJobArrayExceptionEvent)jFEvent2).m_jobArrName = ((JFJobArrayExceptionEvent)jFEvent2).m_jobArrName.substring(n + 1, ((JFJobArrayExceptionEvent)jFEvent2).m_jobArrName.length());
                        }
                    } else if (string.equals("flow_except")) {
                        jFEvent2 = (JFFlowExceptionEvent)jFEvent;
                        n = ((JFFlowExceptionEvent)jFEvent2).m_flowName.lastIndexOf(":");
                        if (n != -1) {
                            ((JFFlowExceptionEvent)jFEvent2).m_flowName = ((JFFlowExceptionEvent)jFEvent2).m_flowName.substring(n + 1, ((JFFlowExceptionEvent)jFEvent2).m_flowName.length());
                        }
                    }
                }
                jFEventInstance.eventDefinition = jFEvent;
                this.events.add(jFEventInstance);
            }
        }
    }

    void setupLinks(List list, Map map) {
        for (int i = 0; i < list.size(); ++i) {
            JFJobInstance jFJobInstance;
            JFLinkEventInstance jFLinkEventInstance = (JFLinkEventInstance)list.get(i);
            if (!jFLinkEventInstance.getEventDefinition().getEventGeneratorType().equals(LINK_TYPE)) continue;
            JFLinkEvent jFLinkEvent = (JFLinkEvent)jFLinkEventInstance.getEventDefinition();
            JFJob jFJob = this.flowDefinition.getJob(jFLinkEvent.m_linkJobName);
            if (jFJob == null || !jFJob.getExecutionType().equals(LINK_TYPE) || (jFJobInstance = (JFJobInstance)map.get(jFJob.getName())) == null) continue;
            jFLinkEventInstance.m_events = jFJobInstance.events;
            jFLinkEventInstance.setInstanceObj(jFJobInstance);
            this.m_linkEventInstances.put(jFJob.getName(), jFLinkEventInstance.m_events);
        }
    }

    private boolean isFinished() {
        return this.state == 2 || this.state == 3 || this.state == 4;
    }

    @Override
    public void refresh() throws Exception {
        this.setChanged();
        this.notifyObservers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStatusUpdate(JFUpdateMsg jFUpdateMsg) {
        String string = "JFFlowInstance::onStatusUpdate";
        JFDebug.println(string + ": Entered ...");
        Object object = mutex;
        synchronized (object) {
            int n = Integer.parseInt(jFUpdateMsg.getAttributeValue("Id"));
            if (this.getInstanceId() != (long)n) {
                JFDebug.println("JFFlowInstance::onStatusUpdate: Msg not for this instance");
                JFDebug.println("");
                return;
            }
            if (jFUpdateMsg.getOperation().equals("StateChange")) {
                if (!this.doStateChange(jFUpdateMsg)) {
                    return;
                }
                this.setChanged();
                this.notifyObservers();
            } else if (jFUpdateMsg.getOperation().equals("StatusChange")) {
                this.doStatusChange(jFUpdateMsg);
            } else if (jFUpdateMsg.getOperation().equals("EventTrigger")) {
                this.doEventTrigger(jFUpdateMsg);
            } else if (jFUpdateMsg.getOperation().equals("AddScopeVar")) {
                String string2 = jFUpdateMsg.getAttributeValue("VarName");
                String string3 = jFUpdateMsg.getAttributeValue("VarValue");
                JFDebug.println(string + ": Operation: AddScopeVar" + "Name: <" + string2 + "> Value: <" + string3 + ">");
                this.localVariables.setProperty(string2, string3);
            }
        }
        JFDebug.println(string + ": Finished ...");
    }

    @Override
    public void setFilter(JFFilter jFFilter) {
        this.m_filter = jFFilter;
    }

    @Override
    public void removeFilter() {
        this.setFilter(null);
    }

    public String[] getChangedItems() {
        if (this.m_szChangedList == null) {
            return null;
        }
        String[] stringArray = new String[this.m_szChangedList.size()];
        this.m_szChangedList.toArray(stringArray);
        return stringArray;
    }

    public void finalize() {
    }

    private boolean doStatusChange(JFUpdateMsg jFUpdateMsg) {
        String string = "JFFlowInstance::doStatusChange";
        JFDebug.println(string + ": Entered ...");
        String string2 = jFUpdateMsg.getAttributeValue("Name");
        String string3 = jFUpdateMsg.getAttributeValue("UserName");
        String string4 = jFUpdateMsg.getAttributeValue("FlowDefName");
        int n = Integer.parseInt(jFUpdateMsg.getAttributeValue("Id"));
        int n2 = Integer.parseInt(jFUpdateMsg.getAttributeValue("State"));
        JFDebug.println(string + ": Current Instance: <" + this.getName() + "> Name: <" + string2 + ">" + "Operation: <" + jFUpdateMsg.getType() + "> State: <" + n2 + ">");
        int n3 = string2.lastIndexOf("(");
        String string5 = string2.substring(0, n3);
        JFFlowArrayInstance jFFlowArrayInstance = this.getFlowArrayInstanceByName(string5);
        if (jFFlowArrayInstance == null) {
            JFDebug.println("JFFlowInstance::onStatusUpdate: Flow Instance: <" + string2 + "> not found");
            JFDebug.println(string + ": Finished ...");
            JFDebug.println("");
            return false;
        }
        String string6 = null;
        Date date = null;
        Date date2 = null;
        string6 = jFUpdateMsg.getAttributeValue("ExitCode");
        String string7 = jFUpdateMsg.getAttributeValue("StartTime");
        date = new JFTime(string7).getTime();
        String string8 = jFUpdateMsg.getAttributeValue("FinishTime");
        date2 = new JFTime(string8).getTime();
        jFFlowArrayInstance.updateElement(string2, n2, date, date2, string6);
        JFDebug.println(string + ": Finished ...");
        return true;
    }

    private boolean doStateChange(JFUpdateMsg jFUpdateMsg) {
        String string = "JFFlowInstance::doStateChange";
        JFDebug.println(string + ": Entered ...");
        String string2 = jFUpdateMsg.getAttributeValue("Name");
        String string3 = jFUpdateMsg.getAttributeValue("UserName");
        String string4 = jFUpdateMsg.getAttributeValue("FlowDefName");
        String string5 = jFUpdateMsg.getAttributeValue("ObjectName");
        int n = Integer.parseInt(jFUpdateMsg.getAttributeValue("Id"));
        int n2 = Integer.parseInt(jFUpdateMsg.getAttributeValue("State"));
        JFDebug.println(string + ": Current Instance: <" + this.getName() + "> Name: <" + string2 + ">" + "Operation: <" + jFUpdateMsg.getType() + "> State: <" + n2 + "> Object Name: <" + string5 + ">");
        this.m_szChangedList.clear();
        this.m_szChangedList.add(string5);
        if (this.getInstanceId() != (long)n) {
            JFDebug.println("JFFlowInstance::onStatusUpdate: Msg not for this instance");
            JFDebug.println(string + ": Finished ...");
            JFDebug.println("");
            return false;
        }
        if (jFUpdateMsg.getType().equals(FLOWARRAY_TYPE)) {
            JFFlowArrayInstance jFFlowArrayInstance = this.getFlowArrayInstanceByName(string2);
            if (jFFlowArrayInstance == null) {
                JFDebug.println("JFFlowInstance::onStatusUpdate: Flow Instance: <" + string2 + "> not found");
                JFDebug.println(string + ": Finished ...");
                JFDebug.println("");
                return false;
            }
            jFFlowArrayInstance.setState(n2);
            JFDebug.println(string + ": flow array State <" + jFFlowArrayInstance.getState() + ">");
            if (jFFlowArrayInstance.isFinished()) {
                int n3 = Integer.parseInt(jFUpdateMsg.getAttributeValue("ExitCode"));
                String string6 = jFUpdateMsg.getAttributeValue("FinishTime");
                jFFlowArrayInstance.setExitCode(n3);
                jFFlowArrayInstance.setFinishTime(new JFTime(string6));
            }
            if (jFFlowArrayInstance.getState() == 1) {
                String string7;
                String string8 = jFUpdateMsg.getAttributeValue("StartTime");
                JFDebug.println(string + ": Flow Array start Time <" + string8 + ">");
                jFFlowArrayInstance.setStartTime(new JFTime(string8));
                int n4 = -1;
                int n5 = -1;
                try {
                    string7 = jFUpdateMsg.getAttributeValue("FirstIndex");
                    n4 = Integer.parseInt(string7);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    string7 = jFUpdateMsg.getAttributeValue("LastIndex");
                    n5 = Integer.parseInt(string7);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                JFDebug.println(string + ": firstIndex <" + n4 + "> Last Index: <" + n5 + ">");
                jFFlowArrayInstance.createElements(n4, n5);
            }
        } else {
            JFFlowInstance jFFlowInstance = this.getFlowInstanceByName(string2);
            if (jFFlowInstance == null) {
                JFDebug.println("JFFlowInstance::onStatusUpdate: Flow Instance: <" + string2 + "> not found");
                JFDebug.println(string + ": Finished ...");
                JFDebug.println("");
                return false;
            }
            if (jFUpdateMsg.getType().equals(SUBFLOW_TYPE)) {
                jFFlowInstance.state = n2;
                JFDebug.println(string + ": Subflow State <" + jFFlowInstance.getState() + ">");
                if (jFFlowInstance.isFinished()) {
                    int n6 = Integer.parseInt(jFUpdateMsg.getAttributeValue("ExitCode"));
                    String string9 = jFUpdateMsg.getAttributeValue("FinishTime");
                    jFFlowInstance.statusCode = n6;
                    jFFlowInstance.finishTime = new JFTime(string9);
                }
                if (jFFlowInstance.getState() == 1) {
                    String string10 = jFUpdateMsg.getAttributeValue("StartTime");
                    JFDebug.println(string + ": Subflow start Time <" + string10 + ">");
                    jFFlowInstance.startTime = new JFTime(string10);
                }
            } else if (jFUpdateMsg.getType().equals(LSF_TYPE)) {
                JFJobInstance jFJobInstance = jFFlowInstance.getJobInstanceByName(string5);
                this.updateJobInstance(jFUpdateMsg, jFJobInstance);
            } else if (jFUpdateMsg.getType().equals(JOBARRAY_TYPE)) {
                JFJobArrayInstance jFJobArrayInstance = jFFlowInstance.getJobArrayInstanceByName(string5);
                if (null == jFJobArrayInstance) {
                    return false;
                }
                JFJobInstance jFJobInstance = jFJobArrayInstance.getJobInstance();
                this.updateJobInstance(jFUpdateMsg, jFJobInstance);
            } else if (jFUpdateMsg.getType().equals(JOBARRAY_ELEMENT_TYPE)) {
                int n7 = Integer.parseInt(jFUpdateMsg.getAttributeValue("Index"));
                JFJobArrayInstance jFJobArrayInstance = jFFlowInstance.getJobArrayInstanceByName(string5);
                if (null == jFJobArrayInstance) {
                    return false;
                }
                if (0 == n7) {
                    jFJobArrayInstance.resetAllElements();
                } else if (-1 == n7) {
                    jFJobArrayInstance.resetExitedElements();
                } else {
                    jFJobArrayInstance.setIndexState(n7, n2);
                }
            } else if (jFUpdateMsg.getType().equals(MANUAL_TYPE)) {
                JFJobInstance jFJobInstance = jFFlowInstance.getJobInstanceByName(string5);
                this.updateJobInstance(jFUpdateMsg, jFJobInstance);
            } else if (jFUpdateMsg.getType().equals(ALARM_TYPE)) {
                JFJobInstance jFJobInstance = jFFlowInstance.getJobInstanceByName(string5);
                this.updateJobInstance(jFUpdateMsg, jFJobInstance);
            }
        }
        JFDebug.println(string + ": Finished ...");
        return true;
    }

    private void doEventTrigger(JFUpdateMsg jFUpdateMsg) {
        String string = "JFFlowInstance::doEventTrigger";
        JFDebug.println(string + ": Entered ...");
        String string2 = jFUpdateMsg.getAttributeValue("Name");
        String string3 = jFUpdateMsg.getAttributeValue("UserName");
        String string4 = jFUpdateMsg.getAttributeValue("FlowDefName");
        String string5 = jFUpdateMsg.getAttributeValue("Destination");
        String string6 = jFUpdateMsg.getAttributeValue("Event");
        String string7 = jFUpdateMsg.getAttributeValue("SourceType");
        String string8 = jFUpdateMsg.getAttributeValue("DestinationType");
        int n = Integer.parseInt(jFUpdateMsg.getAttributeValue("Id"));
        JFDebug.println(string + ": Current Instance: <" + this.getName() + "> Name: <" + string2 + "> Source Type: <" + string7 + "> Dest Type: <" + string8 + "> Destination: <" + string5 + ">");
        if (this.getInstanceId() != (long)n) {
            JFDebug.println("JFFlowInstance::onStatusUpdate: Msg not for this instance");
            JFDebug.println("");
            return;
        }
        JFEventInstance jFEventInstance = new JFEventInstance();
        jFEventInstance.fromString(string6);
        JFFlowInstance jFFlowInstance = this.getFlowInstanceByName(string2);
        if (jFFlowInstance == null) {
            JFDebug.println("JFFlowInstance::onStatusUpdate: Flow Instance: <" + string2 + "> not found");
            JFDebug.println(string + ": Finished ...");
            JFDebug.println("");
            return;
        }
        JFDebug.println(string + ": flow Name: <" + jFFlowInstance.getName() + ">");
        if (!(string8.equals("Time") || string8.equals("File") || string8.equals("Proxy"))) {
            if (string8.equals(LSF_TYPE)) {
                JFJobInstance jFJobInstance = jFFlowInstance.getJobInstanceByName(string5);
                if (null == jFJobInstance) {
                    return;
                }
                JFDebug.println(string + ": job Name: <" + jFJobInstance.getName() + ">");
                JFEventInstance[] jFEventInstanceArray = jFJobInstance.getEventInstances();
                this.updateEventInstance(jFEventInstance, jFEventInstanceArray);
            } else if (string8.equals(JOBARRAY_TYPE)) {
                JFJobArrayInstance jFJobArrayInstance = jFFlowInstance.getJobArrayInstanceByName(string5);
                if (null == jFJobArrayInstance) {
                    return;
                }
                JFDebug.println(string + ": job array Name: <" + jFJobArrayInstance.getName() + ">");
                JFJobInstance jFJobInstance = jFJobArrayInstance.getJobInstance();
                if (null == jFJobInstance) {
                    return;
                }
                JFEventInstance[] jFEventInstanceArray = jFJobInstance.getEventInstances();
                this.updateEventInstance(jFEventInstance, jFEventInstanceArray);
            } else if (string8.equals(SUBFLOW_TYPE)) {
                JFFlowInstance jFFlowInstance2 = this.getFlowInstanceByName(string5);
                if (null == jFFlowInstance2) {
                    return;
                }
                JFEventInstance[] jFEventInstanceArray = jFFlowInstance2.getEventInstances();
                this.updateEventInstance(jFEventInstance, jFEventInstanceArray);
            } else if (string8.equals(MANUAL_TYPE) || string8.equals(ALARM_TYPE)) {
                JFJobInstance jFJobInstance = jFFlowInstance.getJobInstanceByName(string5);
                if (null == jFJobInstance) {
                    return;
                }
                JFEventInstance[] jFEventInstanceArray = jFJobInstance.getEventInstances();
                this.updateEventInstance(jFEventInstance, jFEventInstanceArray);
            } else if (string8.equals(LINK_TYPE)) {
                if (null == this.m_linkEventInstances) {
                    return;
                }
                JFDebug.println(string + "Map Size: <" + jFFlowInstance.m_linkEventInstances.size() + ">");
                String string9 = null;
                int n2 = string5.lastIndexOf(":");
                if (n2 != -1) {
                    string9 = string5.substring(n2 + 1, string5.length());
                }
                if (jFFlowInstance.m_linkEventInstances.containsKey(string9)) {
                    List list = (List)jFFlowInstance.m_linkEventInstances.get(string9);
                    JFEventInstance[] jFEventInstanceArray = new JFEventInstance[list.size()];
                    list.toArray(jFEventInstanceArray);
                    this.updateEventInstance(jFEventInstance, jFEventInstanceArray);
                }
            } else if (string8.equals(FLOWARRAY_TYPE)) {
                JFFlowArrayInstance jFFlowArrayInstance = this.getFlowArrayInstanceByName(string5);
                if (null == jFFlowArrayInstance) {
                    return;
                }
                JFEventInstance[] jFEventInstanceArray = jFFlowArrayInstance.getEventInstances();
                this.updateEventInstance(jFEventInstance, jFEventInstanceArray);
            }
        }
    }

    private void updateJobInstance(JFUpdateMsg jFUpdateMsg, JFJobInstance jFJobInstance) {
        int n;
        Object object;
        String string = "JFFlowInstance::updateJobInstance";
        JFDebug.println(string + ": Entered ...");
        if (null == jFJobInstance) {
            return;
        }
        JFDebug.println(string + ": b Job Name: <" + jFJobInstance.getName() + "> State: <" + jFJobInstance.getState() + ">");
        JFDebug.println(string + ": Job ref: <" + jFJobInstance + ">");
        int n2 = Integer.parseInt(jFUpdateMsg.getAttributeValue("State"));
        jFJobInstance.setState(n2);
        JFDebug.println(string + ": a Job Name: <" + jFJobInstance.getName() + "> State: <" + jFJobInstance.getState() + ">");
        if (n2 == 3) {
            jFJobInstance.setStartTime(null);
            jFJobInstance.setFinishTime(null);
            jFJobInstance.setInstanceId(0L);
        } else if (n2 == 5) {
            object = jFUpdateMsg.getAttributeValue("StartTime");
            n = Integer.parseInt(jFUpdateMsg.getAttributeValue("JobId"));
            jFJobInstance.setStartTime(new JFTime((String)object));
            jFJobInstance.setInstanceId(n);
        } else if (jFJobInstance.isFinished()) {
            object = jFUpdateMsg.getAttributeValue("FinishTime");
            n = Integer.parseInt(jFUpdateMsg.getAttributeValue("ExitCode"));
            double d = Double.parseDouble(jFUpdateMsg.getAttributeValue("CPUUsage"));
            jFJobInstance.setFinishTime(new JFTime((String)object));
            jFJobInstance.setStatus(n);
            jFJobInstance.setCPUUsage(d);
        }
        if (n2 == 7 || n2 == 9 || n2 == 5 || n2 == 3 || n2 == 8) {
            object = new Boolean(jFUpdateMsg.getAttributeValue("isStartingPoint"));
            Boolean bl = new Boolean(jFUpdateMsg.getAttributeValue("isInAllElements"));
            jFJobInstance.setStartingPointToRerunFlow((Boolean)object);
            jFJobInstance.setStartingPointInAllFlowArrayElements(bl);
        }
        JFDebug.println(string + ": Finished ...");
    }

    private void updateEventInstance(JFEventInstance jFEventInstance, JFEventInstance[] jFEventInstanceArray) {
        String string = "JFFlowInstance::updateEventInstance";
        JFDebug.println(string + ": Entered ...");
        if (null == jFEventInstance || null == jFEventInstanceArray) {
            JFDebug.println(string + ": Finished ..., NULL");
            return;
        }
        JFDebug.println(string + ": anEventInstance.toString: <" + jFEventInstance.toString() + ">");
        JFDebug.println(string + ": anEventInstance.gendef: <" + jFEventInstance.getEventDefinition().generateDefinition() + ">");
        for (int i = 0; i < jFEventInstanceArray.length; ++i) {
            JFDebug.println(string + ": eventList[" + i + "]: toString: <" + jFEventInstanceArray[i].toString() + ">");
            JFDebug.println(string + ": eventList.gendef: <" + jFEventInstanceArray[i].getEventDefinition().generateDefinition() + ">");
            if (!jFEventInstanceArray[i].getEventDefinition().equals(jFEventInstance.getEventDefinition())) continue;
            JFDebug.println("Found the Event");
            jFEventInstanceArray[i].setTime(jFEventInstance.getTimeObj());
            String string2 = jFEventInstance.getEventDefinition().getAttribute("Source");
            if (string2 != null && string2.length() > 0) {
                jFEventInstanceArray[i].getEventDefinition().setAttribute("Source", string2);
            }
            jFEventInstanceArray[i].setTime(jFEventInstance.getTimeObj());
            if (jFEventInstance.getTriggerFile() != null && !jFEventInstance.getTriggerFile().equals("")) {
                jFEventInstanceArray[i].setTriggerFile(jFEventInstance.getTriggerFile());
            }
            if (jFEventInstance.getRuntimeInfo() != null && !jFEventInstance.getRuntimeInfo().equals("")) {
                jFEventInstanceArray[i].setRuntimeInfo(jFEventInstance.getRuntimeInfo());
            }
            jFEventInstanceArray[i].setCompletedManually(jFEventInstance.isCompletedManually());
        }
        JFDebug.println(string + ": Finished ...");
    }

    void setFromOwnFlowDefinition(boolean bl) {
        this.m_isFromOwnFlowDefinition = bl;
    }

    void setDraft(boolean bl) {
        this.m_isDraft = bl;
    }

    public boolean isDraft() {
        return this.m_isDraft;
    }

    Map<String, List<JFEventInstance>> getLinkEvents() {
        return this.m_linkEventInstances;
    }

    void setFlowDefintion(JFFlow jFFlow) {
        this.flowDefinition = jFFlow;
        this.currentlyUsedVer = jFFlow.getFlowVersion().getVersion();
    }

    void setOwner(String string) {
        this.owner = string;
    }

    void setTriggerUser(JFUser jFUser) {
        this.triggerUser = jFUser;
    }

    void setInstanceId(long l) {
        this.id = l;
    }

    void setName(String string) {
        this.name = string;
    }

    void setLocalVariables(Properties properties) {
        this.localVariables = properties;
    }

    void setInputVariables(Properties properties) {
        this.inputVariables = properties;
    }

    void setState(int n) {
        this.state = n;
    }

    void setStatus(int n) {
        this.statusCode = n;
    }

    void setStartTime(JFTime jFTime) {
        this.startTime = jFTime;
    }

    void setFinishTime(JFTime jFTime) {
        this.finishTime = jFTime;
    }

    void addJFEventInstance(JFEventInstance jFEventInstance) {
        this.events.add(jFEventInstance);
    }

    void addJFFlowArrayInstance(JFFlowArrayInstance jFFlowArrayInstance) {
        this.flowArrayInstances.add(jFFlowArrayInstance);
    }

    void addJFJobInstance(JFJobInstance jFJobInstance) {
        if (this.jobInstances == null) {
            this.jobInstances = new LinkedList();
        }
        this.jobInstances.add(jFJobInstance);
    }

    void addSubFlowInstance(JFFlowInstance jFFlowInstance) {
        if (jFFlowInstance != null) {
            this.subFlowInstances.add(jFFlowInstance);
        }
    }

    void addJFJobArrayInstance(JFJobArrayInstance jFJobArrayInstance) {
        this.jobArrayInstances.add(jFJobArrayInstance);
    }

    void addJFLinkEventInstance(JFLinkEventInstance jFLinkEventInstance) {
        this.jfLinkEventInstances.add(jFLinkEventInstance);
    }

    List<JFLinkEventInstance> getJFLinkEventInstances() {
        return this.jfLinkEventInstances;
    }

    void putLinkJob(String string, JFJobInstance jFJobInstance) {
        this.jfLinkJobs.put(string, jFJobInstance);
    }

    Map<String, JFJobInstance> getLinkJobs() {
        return this.jfLinkJobs;
    }

    public String getInputData() {
        return this.m_inputData;
    }

    public void setInputData(String string) {
        this.m_inputData = string;
    }

    public String getOutputData() {
        return this.m_outputData;
    }

    public void setOutputData(String string) {
        this.m_outputData = string;
    }
}

