/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFCommon;
import com.platform.LSFJobFlow.api.JFConfigManager;
import com.platform.LSFJobFlow.api.JFDaemonExceptionData;
import com.platform.LSFJobFlow.api.JFEncryptionINF;
import com.platform.LSFJobFlow.api.JFEncryptor;
import com.platform.LSFJobFlow.api.JFEvent;
import com.platform.LSFJobFlow.api.JFException;
import com.platform.LSFJobFlow.api.JFFilter;
import com.platform.LSFJobFlow.api.JFFlow;
import com.platform.LSFJobFlow.api.JFFlowVersion;
import com.platform.LSFJobFlow.api.JFLoginManager;
import com.platform.LSFJobFlow.api.JFMethodInvoker;
import com.platform.LSFJobFlow.api.JFProxyDependant;
import com.platform.LSFJobFlow.api.JFProxyLocation;
import com.platform.LSFJobFlow.api.JFPseudoFlow;
import com.platform.LSFJobFlow.api.JFResource;
import com.platform.LSFJobFlow.api.JFServiceProxy;
import com.platform.LSFJobFlow.api.JFTime;
import com.platform.LSFJobFlow.api.JFUTFConverter;
import com.platform.LSFJobFlow.api.JFUser;
import com.platform.LSFJobFlow.api.JFVersion;
import com.platform.LSFJobFlow.api.JFXMLSource;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Node;

public class JFFlowDefinitionManager {
    private JFServiceProxy schedulerInvoker = new JFServiceProxy("JFScheduler");
    private JFEncryptionINF m_encryption = null;
    private static final byte[] KEY = new byte[]{112, 8, 8, 113, 16, 8, -110, 18, 32, -105, 6, 32, -103, 3, 35, -1};
    private static final int IMGR_ERR_NO_ERROR = 0;
    private static final int IMGR_ERR_FILTER_SYNTAX = 8001;
    private static final int IMGR_ERR_UNKNOWN_STATE = 8002;
    private static final int IMGR_ERR_POLICY_FAILED = 8003;
    private static final int IMGR_ERR_NOT_FOUND = 8004;
    private static final int IMGR_ERR_INVALID_OPERATION = 8005;
    private static final int IMGR_ERR_OUT_OF_MEMORY = 8006;
    private static final int IMGR_ERR_NOT_IMPLEMENTED = 8007;
    private static final int ENGINE_ERR_PERMISSION_DENIED = 2013;
    private static final int IMGR_ERR_FLOW_STILL_ACTIVE = 2014;
    private static final int IMGR_ERR_FLOW_NOT_FOUND = 2015;
    private static final int IMGR_ERR_FLOW_NOT_EXIT = 2016;
    private static final int IMGR_ERR_REQUEST_UNSUPPORTED = 2017;
    private static final int IMGR_ERR_DUPLICATE_FLOW = 2018;
    private static final int IMGR_ERR_FLOW_RERUN_DELAY = 2029;
    private static final int COMMON_ERR_PERMISSION_DENIED = 7;
    private static final int SNAPSHOT_INPROCESS_NOTIFICATION = 22;
    private static final int INVALID_USER_NAME = 37;
    private static final int JOBARRAY_RERUN_EMPTYELEMENTLIST = 2073;
    private static final int JOBARRAY_RERUN_INVALIDELEMENTINDEX = 2075;
    private static final int SCHED_ERR_NO_ERROR = 0;
    private static final int SCHED_ERR_FLOW_NOT_FOUND = 1;
    private static final int SCHED_ERR_DUPLICATE_FLOW = 2;
    private static final int SCHED_ERR_INVALID_FILTER = 3;
    private static final int SCHED_ERR_FLOW_PARSE = 4;
    private static final int SCHED_ERR_PERSIST = 5;
    private static final int SCHED_ERR_EXCEPTION = 6;
    private static final int SCHED_ERR_PERMISSION_DENIED = 7;
    private static final int SCHED_ERR_DUPLICATE_JOBNAME = 8;
    private static final int SCHED_ERR_SUB_JOBNAME_INVALID = 9;
    private static final int SCHED_ERR_NOT_SAS_FLOW = 10;
    private static final int SCHED_ERR_GUEST_ACCESS_DENIED = 11;
    private static final int SCHED_ERR_INVALID_TRIGGER_EVENTS = 12;
    private static final int SCHED_ERR_FAIL_TO_LOCATE_TARGET_FLOW = 13;
    private static final int SCHED_ERR_TARGET_FLOW_NOT_PUBLISHED = 14;
    private static final int SCHED_ERR_MAX_DYNAMIC_FLOWS_DEPTH_REACHED = 15;
    private static final int SCHED_ERR_FLOW_IS_NOT_DYNAMIC_FLOW = 16;
    private static final int SCHED_ERR_LIMIT_GROUP_ADMIN = 17;
    private static final int SCHED_ERR_JOB_PERMISSION_DENIED = 18;
    private static final int SCHED_ERR_FLOW_OWNER_IS_VAR = 19;
    private static final int SCHED_ERR_JOBARRAY_ELEMENT_DEPENDENCY = 20;
    private static final int SCHED_ERR_FLOW_VERSION_NOT_FOUND = 21;
    private static final int SCHED_ERR_FLOW_INVALID_VERSION_NUMBER = 4003;
    private static final int SCHED_ERR_FLOW_INVALID_VERSION_FORMAT = 23;
    private static final int SCHED_ERR_FLOW_MINOR_VERSION_MAX_VAL = 25;
    private static final int SCHED_ERR_PROXY_EXISTS = 4002;
    private static final int COMP_DEP_WORK_ITEM_NOT_FOUND = 2034;
    private static final int COMP_DEP_EVENT_ALREADY_OCCURRED = 2035;
    private static final int COMP_DEP_EVENT_NOT_FOUND = 2036;
    private static final int COMP_DEP_FLOW_ONHOLD = 2037;

    private String iMgrErrorToString(int n) {
        switch (n) {
            case 0: {
                return JFResource.getString("IMGR_ERR_NO_ERROR");
            }
            case 8001: {
                return JFResource.getString("IMGR_ERR_FILTER_SYNTAX");
            }
            case 8002: {
                return JFResource.getString("IMGR_ERR_UNKNOWN_STATE");
            }
            case 8003: {
                return JFResource.getString("IMGR_ERR_POLICY_FAILED");
            }
            case 8004: {
                return JFResource.getString("IMGR_ERR_NOT_FOUND");
            }
            case 8005: {
                return JFResource.getString("IMGR_ERR_INVALID_OPERATION");
            }
            case 8006: {
                return JFResource.getString("IMGR_ERR_OUT_OF_MEMORY");
            }
            case 8007: {
                return JFResource.getString("IMGR_ERR_NOT_IMPLEMENTED");
            }
            case 7: 
            case 2013: {
                return JFResource.getString("IMGR_ERR_COMMON_PERMISSION_DENIED");
            }
            case 2014: {
                return JFResource.getString("IMGR_ERR_FLOW_STILL_ACTIVE");
            }
            case 2015: {
                return JFResource.getString("IMGR_ERR_FLOW_NOT_FOUND");
            }
            case 2016: {
                return JFResource.getString("IMGR_ERR_FLOW_NOT_EXIT");
            }
            case 2017: {
                return JFResource.getString("IMGR_ERR_REQUEST_UNSUPPORTED");
            }
            case 2018: {
                return JFResource.getString("IMGR_ERR_DUPLICATE_FLOW");
            }
            case 2029: {
                return JFResource.getString("IMGR_ERR_FLOW_RERUN_DELAY");
            }
            case 22: {
                return JFResource.getString("SNAPSHOT_INPROCESS_NOTIFICATION");
            }
            case 37: {
                return JFResource.getString("INVALID_USER_NAME");
            }
            case 2073: {
                return JFResource.getString("JOBARRAY_RERUN_EMPTYELEMENTLIST");
            }
            case 2075: {
                return JFResource.getString("JOBARRAY_RERUN_INVALIDELEMENTINDEX");
            }
        }
        return JFResource.getString("IMGR_ERR_UNKNOWN");
    }

    public JFPseudoFlow[] getPseudoFlows(JFFilter jFFilter) throws JFException, IOException {
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.schedulerInvoker, "JF_GetPseudoFlowDef");
        if (jFFilter != null) {
            String string = null;
            if (jFFilter.getUser() != null) {
                string = "user=" + jFFilter.getUser();
            }
            if (string != null) {
                jFMethodInvoker.inParams.addParam("filter", string);
            }
        }
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (0 != n) {
            if (8004 == n) {
                return new JFPseudoFlow[0];
            }
            throw new JFException(this.iMgrErrorToString(n));
        }
        return jFMethodInvoker.outParams.getParamPseudoFlowDefArray("pseudoFlowDef");
    }

    private String schedulerErrorToString(int n) {
        switch (n) {
            case 0: {
                return JFResource.getString("SCHED_ERR_NO_ERROR");
            }
            case 1: {
                return JFResource.getString("SCHED_ERR_FLOW_NOT_FOUND");
            }
            case 21: {
                return JFResource.getString("SCHED_ERR_FLOW_VERSION_NOT_FOUND");
            }
            case 2: {
                return JFResource.getString("SCHED_ERR_DUPLICATE_FLOW");
            }
            case 3: {
                return JFResource.getString("SCHED_ERR_INVALID_FILTER");
            }
            case 4: {
                return JFResource.getString("SCHED_ERR_FLOW_PARSE");
            }
            case 5: {
                return JFResource.getString("SCHED_ERR_PERSIST");
            }
            case 6: {
                return JFResource.getString("SCHED_ERR_EXCEPTION");
            }
            case 7: 
            case 18: {
                return JFResource.getString("SCHED_ERR_PERMISSION_DENIED");
            }
            case 8: {
                return JFResource.getString("SCHED_ERR_DUPLICATE_JOBNAME");
            }
            case 9: {
                return JFResource.getString("SCHED_ERR_SUB_JOBNAME_INVALID");
            }
            case 13: {
                return JFResource.getString("SCHED_ERR_FAIL_TO_LOCATE_TARGET_FLOW");
            }
            case 14: {
                return JFResource.getString("SCHED_ERR_TARGET_FLOW_NOT_PUBLISHED");
            }
            case 15: {
                return JFResource.getString("SCHED_ERR_MAX_DYNAMIC_FLOWS_DEPTH_REACHED");
            }
            case 22: {
                return JFResource.getString("SNAPSHOT_INPROCESS_NOTIFICATION");
            }
            case 4002: {
                return JFResource.getString("SCHED_ERR_PROXY_EXISTS");
            }
            case 2034: {
                return JFResource.getString("COMP_DEP_WORK_ITEM_NOT_FOUND");
            }
            case 2035: {
                return JFResource.getString("COMP_DEP_EVENT_ALREADY_OCCURRED");
            }
            case 2036: {
                return JFResource.getString("COMP_DEP_EVENT_NOT_FOUND");
            }
            case 2037: {
                return JFResource.getString("COMP_DEP_FLOW_ONHOLD");
            }
            case 11: {
                return JFResource.getString("SCHED_ERROR_GUEST_ACCOUNT_DENIED");
            }
            case 12: {
                return JFResource.getString("SCHED_ERR_INVALID_TRIGGER_EVENTS");
            }
            case 16: {
                return JFResource.getString("SCHED_ERR_FLOW_IS_NOT_DYNAMIC_FLOW");
            }
            case 17: {
                return JFResource.getString("SCHED_ERR_LIMIT_GROUP_ADMIN");
            }
            case 19: {
                return JFResource.getString("SCHED_ERR_FLOW_OWNER_IS_VAR");
            }
            case 20: {
                return JFResource.getString("SCHED_ERR_JOBARRAY_ELEMENT_DEPENDENCY");
            }
            case 4003: {
                return JFResource.getString("SCHED_ERR_FLOW_INVALID_VERSION_NUMBER");
            }
            case 23: {
                return JFResource.getString("SCHED_ERR_FLOW_INVALID_VERSION_FORMAT");
            }
            case 25: {
                return JFResource.getString("SCHED_ERR_FLOW_MINOR_VERSION_MAX_VAL");
            }
        }
        return "";
    }

    private void addFlowCredential(JFFlow jFFlow, String string) throws JFException {
        if (string == null || string.equals("")) {
            return;
        }
        String string2 = string + "," + JFUTFConverter.toUnicodeEscape(jFFlow.getName());
        try {
            if (this.m_encryption == null) {
                this.m_encryption = JFEncryptor.getEncryptor(KEY);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        string2 = this.m_encryption.marshallChannel(string2.getBytes());
        jFFlow.setAttribute("APP_AUTH", string2);
    }

    public void submitFlow(JFFlow jFFlow, String string, boolean bl, String string2) throws JFException, IOException {
        JFUser jFUser = new JFUser(JFLoginManager.getUserName());
        if (jFUser.isGuest()) {
            throw new JFException(JFResource.getString("SCHED_COMMIT_FLOW") + JFResource.getString("SCHED_ERR_GUEST_ACCOUNT_DENIED"));
        }
        if (string != null && string.length() > 0) {
            JFConfigManager.checkServerVersionCompatible(new JFVersion("8.0"), JFResource.getString("Submit_with_comments"));
        }
        String string3 = jFFlow.getName();
        String string4 = jFUser.toJSUserName();
        String string5 = jFFlow.getAttribute("Owner");
        if (string5 != null && string5.length() > 0) {
            JFConfigManager.checkServerVersionInvalid(new JFVersion("9.12"), JFResource.getString("Flow_owner"));
            JFConfigManager.checkServerVersionCompatible(new JFVersion("9.107"), JFResource.getString("Flow_owner"));
        }
        if (string5 == null || string5.equals("")) {
            if (!string3.startsWith(string4 + ":")) {
                string3 = string4 + ":" + string3;
                jFFlow.setName(string3);
            }
        } else if (!string3.startsWith(string5 + ":")) {
            if (string3.startsWith(string4 + ":")) {
                string3 = string5 + string3.substring(string4.length());
                jFFlow.setName(string3);
            } else {
                string3 = string5 + ":" + string3;
                jFFlow.setName(string3);
            }
        }
        jFFlow.validate();
        this.checkFlowBackwardCompat(jFFlow);
        this.setTimeZoneInfo(jFFlow);
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.schedulerInvoker, "JF_SubmitFlow");
        this.addFlowCredential(jFFlow, string2);
        jFMethodInvoker.inParams.addParam("xmlFlowDef", jFFlow);
        jFMethodInvoker.inParams.addParam("ready", bl);
        jFMethodInvoker.inParams.addParam("comments", string);
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n == 10 && string2 == null) {
            throw new JFException(JFResource.getString("SCHED_COMMIT_FLOW") + JFResource.getString("ERR_REQUIRE_FULL_LICENSE"));
        }
        if (n != 0) {
            JFDaemonExceptionData[] jFDaemonExceptionDataArray = null;
            try {
                jFDaemonExceptionDataArray = jFMethodInvoker.outParams.getParamExceptions("errormessages");
            }
            catch (Exception exception) {
                throw new JFException(JFResource.getString("SCHED_COMMIT_FLOW") + this.schedulerErrorToString(n));
            }
            throw new JFException(JFResource.getString("SCHED_COMMIT_FLOW") + this.schedulerErrorToString(n), jFDaemonExceptionDataArray);
        }
    }

    public void submitFlow(JFFlow jFFlow, String string, boolean bl) throws JFException, IOException {
        this.submitFlow(jFFlow, string, bl, null);
    }

    public void submitFlow(JFFlow jFFlow, boolean bl, String string) throws JFException, IOException {
        this.submitFlow(jFFlow, "", bl, string);
    }

    public void submitFlow(JFFlow jFFlow, boolean bl) throws JFException, IOException {
        this.submitFlow(jFFlow, "", bl, null);
    }

    public String submitDuplicateFlow(JFFlow jFFlow, String string, boolean bl, String string2) throws JFException, IOException {
        JFUser jFUser = new JFUser(JFLoginManager.getUserName());
        if (jFUser.isGuest()) {
            throw new JFException(JFResource.getString("SCHED_COMMIT_FLOW") + JFResource.getString("SCHED_ERR_GUEST_ACCOUNT_DENIED"));
        }
        String string3 = jFFlow.getName();
        String string4 = jFUser.toJSUserName();
        String string5 = jFFlow.getAttribute("Owner");
        if (string5 != null && string5.length() > 0) {
            JFConfigManager.checkServerVersionInvalid(new JFVersion("9.12"), JFResource.getString("Flow_owner"));
            JFConfigManager.checkServerVersionCompatible(new JFVersion("9.107"), JFResource.getString("Flow_owner"));
        }
        if (string5 == null || string5.equals("")) {
            if (!string3.startsWith(string4 + ":")) {
                string3 = string4 + ":" + string3;
                jFFlow.setName(string3);
            }
        } else if (!string3.startsWith(string5 + ":")) {
            if (string3.startsWith(string4 + ":")) {
                string3 = string5 + string3.substring(string4.length());
                jFFlow.setName(string3);
            } else {
                string3 = string5 + ":" + string3;
                jFFlow.setName(string3);
            }
        }
        jFFlow.validate();
        this.checkFlowBackwardCompat(jFFlow);
        this.setTimeZoneInfo(jFFlow);
        JFConfigManager.checkServerVersionCompatible(new JFVersion("5.5"), JFResource.getString("Duplicated_flow"));
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.schedulerInvoker, "JF_SubmitDuplicateFlow");
        this.addFlowCredential(jFFlow, string2);
        jFMethodInvoker.inParams.addParam("xmlFlowDef", jFFlow);
        jFMethodInvoker.inParams.addParam("ready", bl);
        jFMethodInvoker.inParams.addParam("comments", string);
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n == 10 && string2 == null) {
            throw new JFException(JFResource.getString("SCHED_COMMIT_FLOW") + JFResource.getString("ERR_REQUIRE_FULL_LICENSE"));
        }
        if (n != 0) {
            JFDaemonExceptionData[] jFDaemonExceptionDataArray = null;
            try {
                jFDaemonExceptionDataArray = jFMethodInvoker.outParams.getParamExceptions("errormessages");
            }
            catch (Exception exception) {
                throw new JFException(JFResource.getString("SCHED_COMMIT_FLOW") + this.schedulerErrorToString(n));
            }
            throw new JFException(JFResource.getString("SCHED_COMMIT_FLOW") + this.schedulerErrorToString(n), jFDaemonExceptionDataArray);
        }
        String string6 = jFMethodInvoker.outParams.getParamString("duplicateName");
        return string6;
    }

    public String submitDuplicateFlow(JFFlow jFFlow, String string, boolean bl) throws JFException, IOException {
        return this.submitDuplicateFlow(jFFlow, string, bl, null);
    }

    public String submitDuplicateFlow(JFFlow jFFlow, boolean bl) throws JFException, IOException {
        return this.submitDuplicateFlow(jFFlow, "", bl, null);
    }

    public String submitDuplicateFlow(JFFlow jFFlow, boolean bl, String string) throws JFException, IOException {
        return this.submitDuplicateFlow(jFFlow, "", bl, string);
    }

    public String submitAndUpdateFlow(JFFlow jFFlow, String string, String string2, boolean bl, String string3) throws JFException, IOException {
        JFDaemonExceptionData[] jFDaemonExceptionDataArray;
        JFUser jFUser = new JFUser(JFLoginManager.getUserName());
        if (jFUser.isGuest()) {
            throw new JFException(JFResource.getString("SCHED_COMMIT_FLOW") + JFResource.getString("SCHED_ERR_GUEST_ACCOUNT_DENIED"));
        }
        String string4 = jFFlow.getName();
        String string5 = jFUser.toJSUserName();
        String string6 = jFFlow.getAttribute("Owner");
        if (string2 != "") {
            JFConfigManager.checkServerVersionCompatible(new JFVersion("9.15"), JFResource.getString("User_Defined_Version"));
        }
        if (string6 != null && string6.length() > 0) {
            JFConfigManager.checkServerVersionInvalid(new JFVersion("9.12"), JFResource.getString("Flow_owner"));
            JFConfigManager.checkServerVersionCompatible(new JFVersion("9.107"), JFResource.getString("Flow_owner"));
        }
        if (string6 == null || string6.equals("")) {
            if (!string4.startsWith(string5 + ":")) {
                string4 = string5 + ":" + string4;
                jFFlow.setName(string4);
            }
        } else if (!string4.startsWith(string6 + ":")) {
            if (string4.startsWith(string5 + ":")) {
                string4 = string6 + string4.substring(string5.length());
                jFFlow.setName(string4);
            } else {
                string4 = string6 + ":" + string4;
                jFFlow.setName(string4);
            }
        }
        jFFlow.validate();
        this.checkFlowBackwardCompat(jFFlow);
        this.setTimeZoneInfo(jFFlow);
        JFConfigManager.checkServerVersionCompatible(new JFVersion("8.0"), JFResource.getString("Update_Flow"));
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.schedulerInvoker, "JF_SubmitAndUpdateFlow");
        this.addFlowCredential(jFFlow, string3);
        jFMethodInvoker.inParams.addParam("xmlFlowDef", jFFlow);
        jFMethodInvoker.inParams.addParam("ready", bl);
        jFMethodInvoker.inParams.addParam("comments", string);
        jFMethodInvoker.inParams.addParam("userDefinedVersion", string2);
        if (string2 != "") {
            String string7 = "^([0]+)?$";
            jFDaemonExceptionDataArray = Pattern.compile(string7);
            Matcher matcher = jFDaemonExceptionDataArray.matcher(string2);
            String string8 = "^([0]+\\.[0]+)?$";
            Pattern pattern = Pattern.compile(string8);
            Matcher matcher2 = pattern.matcher(string2);
            if (matcher2.find() || matcher.find()) {
                throw new JFException(JFResource.getString("SCHED_COMMIT_FLOW") + JFResource.getString("SCHED_ERR_FLOW_INVALID_VERSION_FORMAT_ZERO"));
            }
            String string9 = "^(\\d+\\.\\d+)?$";
            Pattern pattern2 = Pattern.compile(string9);
            Matcher matcher3 = pattern2.matcher(string2);
            if (!matcher3.find()) {
                throw new JFException(JFResource.getString("SCHED_COMMIT_FLOW") + JFResource.getString("SCHED_ERR_FLOW_INVALID_VERSION_FORMAT"));
            }
        }
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n == 10 && string3 == null) {
            throw new JFException(JFResource.getString("SCHED_COMMIT_FLOW") + JFResource.getString("ERR_REQUIRE_FULL_LICENSE"));
        }
        if (n != 0) {
            jFDaemonExceptionDataArray = null;
            try {
                jFDaemonExceptionDataArray = jFMethodInvoker.outParams.getParamExceptions("errormessages");
            }
            catch (Exception exception) {
                throw new JFException(JFResource.getString("SCHED_COMMIT_FLOW") + this.schedulerErrorToString(n));
            }
            throw new JFException(JFResource.getString("SCHED_COMMIT_FLOW") + this.schedulerErrorToString(n), jFDaemonExceptionDataArray);
        }
        jFDaemonExceptionDataArray = jFMethodInvoker.outParams.getParamString("version");
        return jFDaemonExceptionDataArray;
    }

    public String submitAndUpdateFlow(JFFlow jFFlow, String string, boolean bl) throws JFException, IOException {
        return this.submitAndUpdateFlow(jFFlow, string, "", bl, null);
    }

    public String submitAndUpdateFlow(JFFlow jFFlow, String string, String string2, boolean bl) throws JFException, IOException {
        return this.submitAndUpdateFlow(jFFlow, string, string2, bl, null);
    }

    public String submitAndUpdateFlow(JFFlow jFFlow, boolean bl) throws JFException, IOException {
        return this.submitAndUpdateFlow(jFFlow, "", "", bl, null);
    }

    public String submitAndUpdateFlow(JFFlow jFFlow, boolean bl, String string) throws JFException, IOException {
        return this.submitAndUpdateFlow(jFFlow, "", "", bl, string);
    }

    public long submitAndRunFlow(JFFlow jFFlow) throws JFException, IOException {
        return this.submitAndRunFlow(jFFlow, "");
    }

    public long submitAndRunFlow(JFFlow jFFlow, String string) throws JFException, IOException {
        return this.submitAndRunFlow(jFFlow, string, null);
    }

    public long submitAndRunFlow(JFFlow jFFlow, String string, String string2) throws JFException, IOException {
        JFUser jFUser = new JFUser(JFLoginManager.getUserName());
        if (jFUser.isGuest()) {
            throw new JFException(JFResource.getString("SCHED_SUBMIT_FLOW") + JFResource.getString("SCHED_ERR_GUEST_ACCOUNT_DENIED"));
        }
        String string3 = jFFlow.getName();
        String string4 = jFUser.toJSUserName();
        String string5 = jFFlow.getAttribute("Owner");
        if (string5 != null && string5.length() > 0) {
            JFConfigManager.checkServerVersionInvalid(new JFVersion("9.12"), JFResource.getString("Flow_owner"));
            JFConfigManager.checkServerVersionCompatible(new JFVersion("9.107"), JFResource.getString("Flow_owner"));
        }
        if (string5 == null || string5.equals("")) {
            if (!string3.startsWith(string4 + ":")) {
                string3 = string4 + ":" + string3;
                jFFlow.setName(string3);
            }
        } else if (!string3.startsWith(string5 + ":")) {
            if (string3.startsWith(string4 + ":")) {
                string3 = string5 + string3.substring(string4.length());
                jFFlow.setName(string3);
            } else {
                string3 = string5 + ":" + string3;
                jFFlow.setName(string3);
            }
        }
        jFFlow.validate();
        this.checkFlowBackwardCompat(jFFlow);
        this.setTimeZoneInfo(jFFlow);
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.schedulerInvoker, "JF_SubmitAndRunFlow");
        this.addFlowCredential(jFFlow, string2);
        jFMethodInvoker.inParams.addParam("xmlFlowDef", jFFlow);
        if (string != null) {
            if (JFCommon.containNonASCIIChar(string)) {
                Object[] objectArray = new Object[]{JFResource.getString("Run_flow_now_with_var")};
                String string6 = JFResource.getString("Localized_input_not_supported");
                MessageFormat messageFormat = new MessageFormat(string6);
                throw new JFException(messageFormat.format(objectArray));
            }
            jFMethodInvoker.inParams.addParam("variableList", string);
        } else {
            jFMethodInvoker.inParams.addParam("variableList", "");
        }
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n == 10 && string2 == null) {
            throw new JFException(JFResource.getString("SCHED_SUBMIT_FLOW") + JFResource.getString("ERR_REQUIRE_FULL_LICENSE"));
        }
        if (n != 0) {
            JFDaemonExceptionData[] jFDaemonExceptionDataArray = null;
            try {
                jFDaemonExceptionDataArray = jFMethodInvoker.outParams.getParamExceptions("errormessages");
            }
            catch (Exception exception) {
                throw new JFException(JFResource.getString("SCHED_SUBMIT_FLOW") + this.schedulerErrorToString(n));
            }
            throw new JFException(JFResource.getString("SCHED_SUBMIT_FLOW") + this.schedulerErrorToString(n), jFDaemonExceptionDataArray);
        }
        long l = jFMethodInvoker.outParams.getParamLong("instanceId");
        return l;
    }

    public JFFlowVersion[] getFlowVersionHistory(String string) throws JFException, IOException {
        JFConfigManager.checkServerVersionCompatible(new JFVersion("8.0"), JFResource.getString("Get_Flow_Ver_History"));
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.schedulerInvoker, "JF_GetFlowVersionHistory");
        jFMethodInvoker.inParams.addParam("flowName", this.getFullFlowName(string));
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (0 != n) {
            return new JFFlowVersion[0];
        }
        return jFMethodInvoker.outParams.getParamFlowVersionArray("flowVersionHistory");
    }

    public void setDefaultVersionForFlow(String string, String string2) throws JFException, IOException {
        JFConfigManager.checkServerVersionCompatible(new JFVersion("8.0"), JFResource.getString("Set_Default_Ver"));
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.schedulerInvoker, "JF_SetDefaultVersionForFlow");
        jFMethodInvoker.inParams.addParam("flowName", this.getFullFlowName(string));
        jFMethodInvoker.inParams.addParam("newVersion", string2);
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n != 0) {
            JFDaemonExceptionData[] jFDaemonExceptionDataArray = null;
            try {
                jFDaemonExceptionDataArray = jFMethodInvoker.outParams.getParamExceptions("errormessages");
            }
            catch (Exception exception) {
                throw new JFException(JFResource.getString("SCHED_SET_VERSION", new Object[]{string}) + ": " + this.schedulerErrorToString(n));
            }
            throw new JFException(JFResource.getString("SCHED_SET_VERSION", new Object[]{string}) + ": " + this.schedulerErrorToString(n), jFDaemonExceptionDataArray);
        }
    }

    public void setUpdateType(String string, String string2, String string3, boolean bl) throws JFException, IOException {
        JFConfigManager.checkServerVersionCompatible(new JFVersion("8.0"), JFResource.getString("Set_Update_Type"));
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.schedulerInvoker, "JF_SetUpdateTypeForItem");
        if (string == null || string3 == null) {
            throw new JFException(JFResource.getString("NULL_PARAM"));
        }
        if (!string3.equals("Automatic") && !string3.equals("Manual")) {
            throw new JFException(JFResource.getString("INVALID_UPDATE_TYPE"));
        }
        jFMethodInvoker.inParams.addParam("itemName", string);
        jFMethodInvoker.inParams.addParam("targetFlowDefName", string2);
        jFMethodInvoker.inParams.addParam("newUpdateType", string3);
        jFMethodInvoker.inParams.addParam("updateNow", bl);
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n != 0) {
            JFDaemonExceptionData[] jFDaemonExceptionDataArray = null;
            try {
                jFDaemonExceptionDataArray = jFMethodInvoker.outParams.getParamExceptions("errormessages");
            }
            catch (Exception exception) {
                throw new JFException(JFResource.getString("SCHED_SET_UPDATE_TYPE", new Object[]{string}) + ": " + this.schedulerErrorToString(n));
            }
            throw new JFException(JFResource.getString("SCHED_SET_UPDATE_TYPE", new Object[]{string}) + ": " + this.schedulerErrorToString(n), jFDaemonExceptionDataArray);
        }
    }

    public void removeFlow(String string) throws JFException, IOException {
        this.removeFlow(string, false);
    }

    public void removeFlow(String string, boolean bl) throws JFException, IOException {
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.schedulerInvoker, "JF_RemoveFlow");
        jFMethodInvoker.inParams.addParam("flowName", this.getFullFlowName(string));
        jFMethodInvoker.inParams.addParam("force", bl ? "true" : "false");
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n != 0) {
            JFDaemonExceptionData[] jFDaemonExceptionDataArray = null;
            try {
                jFDaemonExceptionDataArray = jFMethodInvoker.outParams.getParamExceptions("errormessages");
            }
            catch (Exception exception) {
                throw new JFException(JFResource.getString("SCHED_REMOVE_FLOW", new Object[]{string}) + ": " + this.schedulerErrorToString(n));
            }
            throw new JFException(JFResource.getString("SCHED_REMOVE_FLOW", new Object[]{string}) + ": " + this.schedulerErrorToString(n), jFDaemonExceptionDataArray);
        }
    }

    public void releaseFlow(String string) throws JFException, IOException {
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.schedulerInvoker, "JF_ReleaseFlow");
        jFMethodInvoker.inParams.addParam("flowName", this.getFullFlowName(string));
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n != 0) {
            throw new JFException(JFResource.getString("SCHED_RELEASE_FLOW", new Object[]{string}) + ": " + this.schedulerErrorToString(n));
        }
    }

    public void holdFlow(String string) throws JFException, IOException {
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.schedulerInvoker, "JF_HoldFlow");
        jFMethodInvoker.inParams.addParam("flowName", this.getFullFlowName(string));
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n != 0) {
            throw new JFException(JFResource.getString("SCHED_HOLD_FLOW", new Object[]{string}) + ": " + this.schedulerErrorToString(n));
        }
    }

    public void publishFlow(String string) throws JFException, IOException {
        JFConfigManager.checkServerVersionCompatible(new JFVersion("8.0"), JFResource.getString("Publish_Flow"));
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.schedulerInvoker, "JF_PublishFlow");
        jFMethodInvoker.inParams.addParam("flowName", this.getFullFlowName(string));
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n != 0) {
            throw new JFException(JFResource.getString("SCHED_PUBLISH_FLOW", new Object[]{string}) + ": " + this.schedulerErrorToString(n));
        }
    }

    public void unpublishFlow(String string) throws JFException, IOException {
        JFConfigManager.checkServerVersionCompatible(new JFVersion("8.0"), JFResource.getString("Unpublish_Flow"));
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.schedulerInvoker, "JF_UnpublishFlow");
        jFMethodInvoker.inParams.addParam("flowName", this.getFullFlowName(string));
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n != 0) {
            throw new JFException(JFResource.getString("SCHED_UNPUBLISH_FLOW", new Object[]{string}) + ": " + this.schedulerErrorToString(n));
        }
    }

    public long triggerFlow(String string) throws JFException, IOException {
        return this.triggerFlow(string, "", "");
    }

    public long triggerFlow(String string, String string2) throws JFException, IOException {
        return this.triggerFlow(string, string2, "");
    }

    public long triggerFlow(String string, String string2, String string3) throws JFException, IOException {
        if (string3 != null && string3.length() > 0) {
            JFConfigManager.checkServerVersionCompatible(new JFVersion("9.13"), JFResource.getString("Trigger_with_version"));
        }
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.schedulerInvoker, "JF_TriggerFlow");
        jFMethodInvoker.inParams.addParam("flowName", this.getFullFlowName(string));
        if (string2 != null) {
            if (JFCommon.containNonASCIIChar(string2)) {
                Object[] objectArray = new Object[]{JFResource.getString("Trig_flow_with_var")};
                String string4 = JFResource.getString("Localized_input_not_supported");
                MessageFormat messageFormat = new MessageFormat(string4);
                throw new JFException(messageFormat.format(objectArray));
            }
            jFMethodInvoker.inParams.addParam("variableList", string2);
        } else {
            jFMethodInvoker.inParams.addParam("variableList", "");
        }
        if (string3 != null) {
            jFMethodInvoker.inParams.addParam("version", string3);
        } else {
            jFMethodInvoker.inParams.addParam("version", "");
        }
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n != 0) {
            JFDaemonExceptionData[] jFDaemonExceptionDataArray = null;
            try {
                jFDaemonExceptionDataArray = jFMethodInvoker.outParams.getParamExceptions("errormessages");
            }
            catch (Exception exception) {
                throw new JFException(JFResource.getString("SCHED_TRIGGER_FLOW", new Object[]{string}) + ": " + this.schedulerErrorToString(n));
            }
            throw new JFException(JFResource.getString("SCHED_TRIGGER_FLOW", new Object[]{string}) + this.schedulerErrorToString(n), jFDaemonExceptionDataArray);
        }
        long l = jFMethodInvoker.outParams.getParamLong("instanceId");
        return l;
    }

    public JFFlow getFlow(String string) throws JFException, IOException {
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.schedulerInvoker, "JF_QueryFlow");
        jFMethodInvoker.inParams.addParam("flowName", this.getFullFlowName(string));
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n != 0) {
            throw new JFException(JFResource.getString("SCHED_QUERY_FLOW") + this.schedulerErrorToString(n));
        }
        Node node = jFMethodInvoker.outParams.getParamNode("flow");
        JFXMLSource jFXMLSource = new JFXMLSource(node);
        JFFlow jFFlow = jFXMLSource.createFlow();
        return jFFlow;
    }

    public JFFlow getFlowByVersion(String string, JFFlowVersion jFFlowVersion) throws IOException, JFException {
        JFConfigManager.checkServerVersionCompatible(new JFVersion("9.105"), JFResource.getString("Get_Flow_By_Version"));
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.schedulerInvoker, "JF_QueryFlowByVersion");
        jFMethodInvoker.inParams.addParam("flowName", this.getFullFlowName(string));
        jFMethodInvoker.inParams.addParam("flowVersion", jFFlowVersion.getVersion());
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n != 0) {
            throw new JFException(JFResource.getString("SCHED_QUERY_FLOW") + this.schedulerErrorToString(n));
        }
        Node node = jFMethodInvoker.outParams.getParamNode("flow");
        JFXMLSource jFXMLSource = new JFXMLSource(node);
        JFFlow jFFlow = jFXMLSource.createFlow();
        return jFFlow;
    }

    public JFProxyDependant[] getProxyDependants(String string) throws JFException, IOException {
        JFConfigManager.checkServerVersionCompatible(new JFVersion("5.5"), JFResource.getString("Navigate_flows"));
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.schedulerInvoker, "JF_GetProxyDependants");
        jFMethodInvoker.inParams.addParam("proxySource", string);
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (0 != n) {
            throw new JFException(this.iMgrErrorToString(n));
        }
        JFProxyDependant[] jFProxyDependantArray = jFMethodInvoker.outParams.getParamProxyDependantsArray("proxyDependants");
        return jFProxyDependantArray;
    }

    public JFProxyLocation[] getProxyLocations() throws JFException, IOException {
        JFConfigManager.checkServerVersionCompatible(new JFVersion("5.5"), JFResource.getString("Global_view"));
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.schedulerInvoker, "JF_GetProxyLocations");
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (0 != n) {
            throw new JFException(this.iMgrErrorToString(n));
        }
        JFProxyLocation[] jFProxyLocationArray = jFMethodInvoker.outParams.getParamProxyLocationsArray("proxyLocations");
        return jFProxyLocationArray;
    }

    public void completeDependency(JFEvent jFEvent, String string) throws JFException, IOException {
        JFConfigManager.checkServerVersionCompatible(new JFVersion("5.5"), JFResource.getString("Complete_dependency"));
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.schedulerInvoker, "JF_SchedCompleteDependency");
        if (jFEvent.isProxy()) {
            jFEvent.setAttribute("Destination", string);
            jFEvent.setAttribute("PositionX", "1");
            jFEvent.setAttribute("PositionY", "1");
        }
        jFMethodInvoker.inParams.addParam("flowName", string);
        jFMethodInvoker.inParams.addParam("dependency", jFEvent);
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (0 != n) {
            throw new JFException(JFResource.getString("COMP_DEP_FAIL") + this.schedulerErrorToString(n));
        }
    }

    private String getFullFlowName(String string) {
        if (string == null || string.indexOf(58) != -1) {
            return string;
        }
        String string2 = JFLoginManager.getUserName();
        if (string2 == null) {
            return string;
        }
        return string2 + ":" + string;
    }

    private void setTimeZoneInfo(JFFlow jFFlow) throws JFException, IOException {
        if (jFFlow == null) {
            return;
        }
        int n = JFConfigManager.getTimeZoneFlag();
        if (n == 0 || n == 2) {
            JFConfigManager.checkServerVersionCompatible(new JFVersion("5.5"), JFResource.getString("Full_time_zone"));
        }
        if (n == 0) {
            Date date = new Date();
            TimeZone timeZone = TimeZone.getDefault();
            String string = JFTime.getClientTimeZone();
            String string2 = Integer.toString(timeZone.getOffset(date.getTime()) / 1000);
            jFFlow.setTimeZoneInfo(string, string2);
        } else if (n == 2) {
            jFFlow.setTimeZoneInfo("GMT", "0");
        } else {
            jFFlow.setTimeZoneInfo(null, null);
        }
    }

    void checkFlowBackwardCompat(JFFlow jFFlow) throws JFException, IOException {
        String string;
        int n;
        int n2;
        if (jFFlow.hasAlarmHandler()) {
            JFConfigManager.checkServerVersionCompatible(new JFVersion("5.5"), JFResource.getString("Alarm_as_build_in_exception"));
        }
        if (jFFlow.hasExclusiveSet()) {
            JFConfigManager.checkServerVersionCompatible(new JFVersion("5.5"), JFResource.getString("Exclusive_flow"));
        }
        if (jFFlow.hasProxyEventTimeDuration()) {
            JFConfigManager.checkServerVersionCompatible(new JFVersion("5.5"), JFResource.getString("Latch_event"));
        }
        if (jFFlow.hasWorkingDir()) {
            JFConfigManager.checkServerVersionCompatible(new JFVersion("6.1"), JFResource.getString("Working_dir"));
        }
        if (jFFlow.hasJobEnvVars()) {
            JFConfigManager.checkServerVersionCompatible(new JFVersion("6.1"), JFResource.getString("Job_env_vars"));
        }
        if (jFFlow.hasZOSJob()) {
            JFConfigManager.checkServerVersionCompatible(new JFVersion("6.1"), JFResource.getString("zOS"));
        }
        if (jFFlow.hasScriptJob()) {
            JFConfigManager.checkServerVersionCompatible(new JFVersion("6.2"), JFResource.getString("Job_submission_script"));
        }
        if (jFFlow.hasFlowEnvVars()) {
            JFConfigManager.checkServerVersionCompatible(new JFVersion("6.2"), JFResource.getString("Flow_env_vars"));
        }
        if (jFFlow.hasTimeEventNumOccurrences()) {
            JFConfigManager.checkServerVersionCompatible(new JFVersion("7.1"), JFResource.getString("Time_event_num_occurrences"));
        }
        if (jFFlow.hasMultipleTimeZones()) {
            JFConfigManager.checkServerVersionCompatible(new JFVersion("7.1"), JFResource.getString("Multple_time_zone"));
        }
        if (jFFlow.hasVariableEvaluator()) {
            JFConfigManager.checkServerVersionInvalid(new JFVersion("7.1"), JFResource.getString("Variable_evaluator"));
            JFConfigManager.checkServerVersionCompatible(new JFVersion("7.01"), JFResource.getString("Variable_evaluator"));
        }
        if (jFFlow.hasLocalJob()) {
            JFConfigManager.checkServerVersionInvalid(new JFVersion("7.1"), JFResource.getString("Local_job"));
            JFConfigManager.checkServerVersionCompatible(new JFVersion("7.01"), JFResource.getString("Local_job"));
        }
        if (jFFlow.hasFlowArray()) {
            JFConfigManager.checkServerVersionInvalid(new JFVersion("7.1"), JFResource.getString("Flow_array"));
            JFConfigManager.checkServerVersionCompatible(new JFVersion("7.01"), JFResource.getString("Flow_array"));
        }
        if (jFFlow.hasDynamicFlow() || jFFlow.hasDynamicFlowArray()) {
            JFConfigManager.checkServerVersionCompatible(new JFVersion("8.0"), JFResource.getString("Dynamic_Subflow"));
        }
        if (jFFlow.hasFlowWorkingDir()) {
            JFConfigManager.checkServerVersionCompatible(new JFVersion("8.0"), JFResource.getString("Flow_working_dir"));
        }
        if (jFFlow.hasOtherOptions()) {
            JFConfigManager.checkServerVersionCompatible(new JFVersion("8.2"), JFResource.getString("Job_Other_Options"));
        }
        if (jFFlow.hasPreSubmitOption()) {
            JFConfigManager.checkServerVersionCompatible(new JFVersion("8.2"), JFResource.getString("Job_Pre_Submit_Option"));
        }
        if (jFFlow.hasExtUsrVar()) {
            JFConfigManager.checkServerVersionCompatible(new JFVersion("8.3"), JFResource.getString("Extended_user_variable_support"));
        }
        if (jFFlow.hasSequentialFlowArray()) {
            JFConfigManager.checkServerVersionCompatible(new JFVersion("8.3"), JFResource.getString("Sequential_flow_array"));
        }
        if ((n2 = jFFlow.hasSubmittedOrFailDepType()) != 0) {
            switch (n2) {
                case 1: {
                    JFConfigManager.checkServerVersionCompatible(new JFVersion("8.3"), JFResource.getString("Is_Submitted_Event"));
                    break;
                }
                case 2: {
                    JFConfigManager.checkServerVersionCompatible(new JFVersion("8.3"), JFResource.getString("Fails_Event"));
                    break;
                }
                case 3: {
                    JFConfigManager.checkServerVersionCompatible(new JFVersion("8.3"), JFResource.getString("Ends_with_Any_Exit_Code_Event"), JFResource.getString("Manual_Jobs"));
                    break;
                }
                case 4: {
                    JFConfigManager.checkServerVersionCompatible(new JFVersion("8.3"), JFResource.getString("Ends_with_Exit_Code_Event"), JFResource.getString("Manual_Jobs"));
                    break;
                }
                case 5: {
                    JFConfigManager.checkServerVersionCompatible(new JFVersion("8.3"), JFResource.getString("Complete_Successfully_with_Exit_Code_Event"), JFResource.getString("Subflows"));
                    break;
                }
            }
        }
        if ((n2 = jFFlow.hasJobArrayElementDependencyType()) != 0) {
            JFConfigManager.checkServerVersionCompatible(new JFVersion("9.13"), JFResource.getString("Job_array_element_to_element_dependency"));
        }
        if ((n = jFFlow.hasNonZeroExitCodesOrExitCodeRule()) != 0) {
            switch (n) {
                case 1: {
                    JFConfigManager.checkServerVersionCompatible(new JFVersion("8.3"), JFResource.getString("Setting_Non_Zero_Success_Exit_Code"));
                    break;
                }
                case 2: {
                    JFConfigManager.checkServerVersionCompatible(new JFVersion("8.3"), JFResource.getString("Determine_Flow_Exit_Code_from_the_Last_Done_or_Failed_Item"));
                    break;
                }
            }
        }
        if (jFFlow.hasMultiExitCodeJobDep()) {
            JFConfigManager.checkServerVersionCompatible(new JFVersion("8.3"), JFResource.getString("Job_Dep_Multi_Exit_Code"));
        }
        if (jFFlow.hasLocalJobDisabledSuspension()) {
            JFConfigManager.checkServerVersionCompatible(new JFVersion("8.5"), JFResource.getString("Local_Job_Disabled_Suspend"));
        }
        if (jFFlow.hasLocalJobOutputFile()) {
            JFConfigManager.checkServerVersionCompatible(new JFVersion("9.12"), JFResource.getString("Local_Job_Output_File"));
        }
        if (jFFlow.hasGlobalStdoutStderr()) {
            JFConfigManager.checkServerVersionCompatible(new JFVersion("9.12"), JFResource.getString("Global_Output_File"));
        }
        if ((string = jFFlow.getAttribute("EndBehaviour")) != null && string.equals("FlowStopKill")) {
            JFConfigManager.checkServerVersionCompatible(new JFVersion("9.13"), JFResource.getString("Stop_flow_and_kill_running_itmes"));
        }
        if (jFFlow.hasExitConditionIgnoreWaitingActivities()) {
            JFConfigManager.checkServerVersionCompatible(new JFVersion("9.13"), JFResource.getString("Ignore_work_items_not_run"));
        }
    }
}

