/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFAdminManager;
import com.platform.LSFJobFlow.api.JFDebug;
import com.platform.LSFJobFlow.api.JFEncryption128;
import com.platform.LSFJobFlow.api.JFException;
import com.platform.LSFJobFlow.api.JFIncompatibleException;
import com.platform.LSFJobFlow.api.JFIncompatibleIOException;
import com.platform.LSFJobFlow.api.JFResource;
import com.platform.LSFJobFlow.api.JFVersion;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Properties;

public class JFConfigManager {
    private static Properties m_properties = new Properties();
    public static final int CLIENT_TIME = 0;
    public static final int SERVER_TIME = 1;
    public static final int UTC_TIME = 2;
    public static final int CUSTOM_TIME = 3;
    public static final String CLIENT_TIMEZONE_STR = "Client";
    public static final String SERVER_TIMEZONE_STR = "Server";
    public static final String UTC_TIMEZONE_STR = "UTC";
    static final String CLIENT_INTERNAL_VERSION = "10.201";
    private static JFVersion m_oldServerVersion = null;
    private static JFVersion m_serverVersion = null;
    private static JFVersion m_clientVersion = new JFVersion("10.201");
    private static Object mutex = new Object();
    private static boolean m_wasKey64 = false;

    private JFConfigManager() {
    }

    public static void init(Properties properties) {
        m_properties = properties;
        JFConfigManager.addWorkDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void init() throws JFException {
        Object object;
        String string = System.getProperty("JS_ENVDIR");
        if (string == null) {
            string = System.getProperty("file.separator") + "etc";
        }
        String string2 = string + System.getProperty("file.separator") + "js.conf";
        try {
            object = new FileInputStream(string2);
            String string3 = null;
            String string4 = null;
            String string5 = null;
            while ((string3 = JFConfigManager.getNextLine((FileInputStream)object)) != null) {
                if (string3.length() == 0) continue;
                int n = string3.indexOf(61);
                int n2 = string3.length();
                if (n <= 0 || n >= n2 - 1) continue;
                string4 = string3.substring(0, n);
                string5 = string3.substring(n + 1);
                string5 = string5.replace('\'', ' ').replace('\"', ' ').trim();
                string4 = string4.trim();
                Object object2 = mutex;
                synchronized (object2) {
                    m_properties.setProperty(string4, string5);
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new JFException(JFResource.getString("CFGMGR_NO_CONFFILE") + ": " + string2);
        }
        catch (IOException iOException) {
            throw new JFException(JFResource.getString("CFGMGR_ERROR_READ_CONFFILE") + ": " + string2);
        }
        object = JFConfigManager.getConfig("LSF_ENVDIR");
        if (object != null) {
            System.setProperty("LSF_ENVDIR", (String)object);
        }
        JFConfigManager.addWorkDir();
    }

    private static void addWorkDir() {
        String string = JFConfigManager.getConfig("JS_WORK_DIR");
        if (string != null && !string.equals("")) {
            return;
        }
        String string2 = JFConfigManager.getConfig("JS_HOME");
        if (string2 != null && !string2.equals("")) {
            JFConfigManager.addConfig("JS_WORK_DIR", string2 + File.separator + "work");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void needRefresh() {
        JFDebug.println("JFConfigManager.needRefresh() called");
        Object object = mutex;
        synchronized (object) {
            m_serverVersion = null;
        }
        JFEncryption128.setKey64(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveServerVersion() {
        Object object = mutex;
        synchronized (object) {
            m_oldServerVersion = m_serverVersion;
            m_wasKey64 = JFEncryption128.isKey64();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restoreServerVersion() {
        JFDebug.println("JFConfigManager.restoreServerVersion() called");
        Object object = mutex;
        synchronized (object) {
            if (m_oldServerVersion != null) {
                m_serverVersion = m_oldServerVersion;
            }
        }
        JFEncryption128.setKey64(m_wasKey64);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getConfig(String string) {
        Object object = mutex;
        synchronized (object) {
            return m_properties.getProperty(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getConfig(String string, String string2) {
        Object object = mutex;
        synchronized (object) {
            return m_properties.getProperty(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addConfig(String string, String string2) {
        Object object = mutex;
        synchronized (object) {
            m_properties.setProperty(string, string2);
        }
    }

    public static boolean isExternalLogin() {
        String string = JFConfigManager.getConfig("JS_LOGIN_REQUIRED");
        return string != null && string.equalsIgnoreCase("TRUE");
    }

    public static boolean isDefaultEmptyValueEnabled() {
        String string = JFConfigManager.getConfig("JS_DEFAULT_USER_VARIABLE_VALUE_IS_EMPTY");
        return string != null && string.equalsIgnoreCase("TRUE");
    }

    public static int getTimeZoneFlag() {
        String string = JFConfigManager.getConfig("JS_TIME_ZONE");
        if ("server".equals(string)) {
            return 1;
        }
        if (UTC_TIMEZONE_STR.equals(string)) {
            return 2;
        }
        JFVersion jFVersion = JFConfigManager.getServerVersion();
        if (jFVersion != null && jFVersion.compareTo("5.5") < 0) {
            return 1;
        }
        return 0;
    }

    public static int getEauthTimeOut() {
        int n;
        String string = JFConfigManager.getConfig("JS_EAUTH_TIMEOUT", "300");
        try {
            n = Integer.parseInt(string);
            if (n < 10 || n > 3600) {
                n = 300;
            }
        }
        catch (NumberFormatException numberFormatException) {
            n = 300;
        }
        return n;
    }

    private static String getNextLine(FileInputStream fileInputStream) throws IOException {
        char c;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = -1;
        boolean bl = false;
        while ((n = fileInputStream.read()) != n2) {
            if (n == 13) {
                n = fileInputStream.read();
                if (n == 10) break;
                stringBuffer.append(' ');
            }
            if (n == 10) break;
            if (n == 34) {
                bl = !bl;
            }
            if (n == 35 && !bl) {
                while ((n = fileInputStream.read()) != n2 && n != 10) {
                }
                break;
            }
            if (n == 92) {
                c = (char)n;
                n = fileInputStream.read();
                if (n == n2) break;
                if (n == 13) {
                    n = fileInputStream.read();
                    if (n != 10) {
                        stringBuffer.append(' ');
                    }
                } else if (n != 10 && !Character.isWhitespace((char)n)) {
                    stringBuffer.append(c);
                }
            }
            if (Character.isWhitespace((char)n)) {
                n = 32;
            }
            stringBuffer.append((char)n);
        }
        for (c = stringBuffer.length() - 1; c >= '\u0000' && stringBuffer.charAt(c) == ' '; --c) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        if (n != n2 || stringBuffer.length() > 0) {
            return stringBuffer.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setServerVersion(String string) {
        Object object = mutex;
        synchronized (object) {
            m_serverVersion = new JFVersion(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setServerVersion(JFVersion jFVersion) {
        Object object = mutex;
        synchronized (object) {
            m_serverVersion = jFVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setServerVersion(String string, boolean bl) {
        Object object = mutex;
        synchronized (object) {
            if (m_serverVersion == null) {
                m_serverVersion = new JFVersion(string);
                return;
            }
            if (bl) {
                m_serverVersion = new JFVersion(string);
                JFDebug.println("JFConfigManager::setServerVersion(" + string + ", " + bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setServerVersion(JFVersion jFVersion, boolean bl) {
        Object object = mutex;
        synchronized (object) {
            if (m_serverVersion == null) {
                m_serverVersion = jFVersion;
                return;
            }
            if (bl) {
                m_serverVersion = jFVersion;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JFVersion getServerVersion() {
        Object object = mutex;
        synchronized (object) {
            return m_serverVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JFVersion getServerVersion(boolean bl) throws JFException, IOException {
        Object object = mutex;
        synchronized (object) {
            if (!bl || m_serverVersion != null) {
                return m_serverVersion;
            }
        }
        try {
            JFDebug.println("JFConfigManager::getServerVersion() call server to get the version number.");
            new JFAdminManager().isRootAdmin();
        }
        catch (JFIncompatibleIOException jFIncompatibleIOException) {
            JFDebug.println("catch version error from server " + jFIncompatibleIOException + "Ignore it.");
        }
        object = mutex;
        synchronized (object) {
            return m_serverVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setClientVersion(String string) {
        Object object = mutex;
        synchronized (object) {
            m_clientVersion = new JFVersion(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setClientVersion(JFVersion jFVersion) {
        Object object = mutex;
        synchronized (object) {
            m_clientVersion = jFVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JFVersion getClientVersion() {
        Object object = mutex;
        synchronized (object) {
            return m_clientVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JFVersion getEffectiveClientVersion() {
        JFVersion jFVersion = new JFVersion("5.50");
        Object object = mutex;
        synchronized (object) {
            if (m_serverVersion != null && m_serverVersion.equals(jFVersion)) {
                JFDebug.println("JFConfigManager::getEffectiveClientVersion() returns 5.50");
                return jFVersion;
            }
            return m_clientVersion;
        }
    }

    public static void checkServerVersionCompatible(JFVersion jFVersion, String string) throws JFIncompatibleException, JFException, IOException {
        JFConfigManager.checkServerVersionCompatible(jFVersion, string, null);
    }

    public static void checkServerVersionCompatible(JFVersion jFVersion, String string, String string2) throws JFIncompatibleException, JFException, IOException {
        JFVersion jFVersion2 = JFConfigManager.getServerVersion(true);
        JFDebug.println("checkServerVersionCompatible(). the server version" + jFVersion2.getVersion());
        JFDebug.println("checkServerVersionCompatible(). the checking version" + jFVersion.getVersion());
        if (jFVersion2 == null || jFVersion2.compareTo(jFVersion) < 0) {
            if (string2 == null) {
                Object[] objectArray = new Object[]{"\"" + string + "\""};
                String string3 = JFResource.getString("OUTDATED_SERVER_DETECTED");
                MessageFormat messageFormat = new MessageFormat(string3);
                throw new JFIncompatibleException(messageFormat.format(objectArray));
            }
            Object[] objectArray = new Object[]{"\"" + string + "\"", "\"" + string2 + "\""};
            String string4 = JFResource.getString("OUTDATED_SERVER_DETECTED_FOR");
            MessageFormat messageFormat = new MessageFormat(string4);
            throw new JFIncompatibleException(messageFormat.format(objectArray));
        }
    }

    public static boolean checkServerVersionCompatible(JFVersion jFVersion) {
        try {
            JFConfigManager.checkServerVersionCompatible(jFVersion, "");
        }
        catch (JFIncompatibleException jFIncompatibleException) {
            return false;
        }
        catch (JFException jFException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public static void checkServerVersionInvalid(JFVersion jFVersion, String string) throws JFIncompatibleException, JFException, IOException {
        JFVersion jFVersion2 = JFConfigManager.getServerVersion(true);
        JFDebug.println("checkServerVersionInvalid(). the server version" + jFVersion2.getVersion());
        JFDebug.println("checkServerVersionInvalid(). the checking version" + jFVersion.getVersion());
        if (jFVersion2 == null || jFVersion2.compareTo(jFVersion) == 0) {
            Object[] objectArray = new Object[]{string};
            String string2 = JFResource.getString("UNSUPPORTED_SERVER_DETECTED");
            MessageFormat messageFormat = new MessageFormat(string2);
            throw new JFIncompatibleException(messageFormat.format(objectArray));
        }
    }
}

