/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.nld;

import com.sas.graphics.util.nld.NLD;
import com.sas.graphics.util.nld.NLDLink;
import com.sas.graphics.util.nld.NLDModel;
import com.sas.graphics.util.nld.NLDNode;
import com.sas.graphics.util.nld.NLDViewer;
import java.awt.Font;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class XML2NLD {
    private NLDModel nld = null;
    private Document doc = null;
    private NLDViewer viewer = null;
    private boolean createNodesFromLinks;
    private Stack deletedNodes = new Stack();
    private Hashtable nodeStyles = new Hashtable();
    Hashtable IDlookup = new Hashtable();
    Hashtable linkIDlookup = null;

    XML2NLD() {
    }

    void setNLDModel(NLDModel nld) {
        this.nld = nld;
    }

    NLDModel getNLDModel() {
        return this.nld;
    }

    void setDoc(Document doc) {
        this.doc = doc;
    }

    Document getDocument() {
        return this.doc;
    }

    void setNLDViewer(NLDViewer aViewer) {
        this.viewer = aViewer;
    }

    NLDViewer getNLDViewer() {
        return this.viewer;
    }

    void load() {
        block15: {
            Element element;
            int i;
            Node node;
            NodeList Elems;
            if (this.doc == null) {
                System.out.println("XML2DWG.load : Error. doc=null.");
                return;
            }
            if (this.nld == null) {
                System.out.println("XML2DWG.load : Error. nld=null.");
                return;
            }
            if (this.nld.dupCheck && this.linkIDlookup == null) {
                this.linkIDlookup = new Hashtable();
            }
            if ((Elems = this.doc.getElementsByTagName("Action")).getLength() > 0 && (node = Elems.item(0).getFirstChild()) != null) {
                this.nld.action = node.getNodeValue().trim();
                this.nld.userAction = true;
            }
            if ((Elems = this.doc.getElementsByTagName("NodeStyle")) != null) {
                int num = Elems.getLength();
                for (i = 0; i < num; ++i) {
                    element = (Element)Elems.item(i);
                    this.loadNodeStyle(element);
                }
            }
            if ((Elems = this.doc.getElementsByTagName("Node")) != null) {
                int num = Elems.getLength();
                if (this.nld.dupCheck) {
                    for (i = 0; i < num; ++i) {
                        element = (Element)Elems.item(i);
                        this.loadDupNode(element);
                    }
                } else {
                    for (i = 0; i < num; ++i) {
                        element = (Element)Elems.item(i);
                        NLDNode n = this.loadNode(element);
                        this.addNode(n);
                    }
                }
            }
            this.createNodesFromLinks = this.nld.nodes.size() == 0;
            Elems = this.doc.getElementsByTagName("Link");
            if (Elems == null) break block15;
            int num = Elems.getLength();
            if (this.nld.dupCheck) {
                for (i = 0; i < num; ++i) {
                    element = (Element)Elems.item(i);
                    this.loadDupNLDLink(element);
                }
            } else {
                for (i = 0; i < num; ++i) {
                    element = (Element)Elems.item(i);
                    NLDLink a = this.loadNLDLink(element);
                    a.directed = this.nld.directed;
                    if (a.from == -1 || a.to == -1) continue;
                    this.addNLDLink(a);
                }
            }
        }
    }

    void readNodePositions() {
        NodeList Elems = this.doc.getElementsByTagName("Node");
        if (Elems != null) {
            int num = Elems.getLength();
            for (int i = 0; i < num; ++i) {
                Element element = (Element)Elems.item(i);
                this.readNodeX_Y(element);
            }
        }
    }

    private boolean readNodeX_Y(Element elem) {
        Node node;
        Node node2;
        String id = null;
        NodeList Elems = elem.getElementsByTagName("ID");
        if (Elems.getLength() > 0 && (node2 = Elems.item(0).getFirstChild()) != null) {
            id = node2.getNodeValue().trim();
        }
        if (id == null) {
            return false;
        }
        Object obj = this.IDlookup.get(id);
        NLDNode n = null;
        if (obj == null) {
            return false;
        }
        int index = (Integer)obj;
        n = (NLDNode)this.nld.nodes.elementAt(index);
        if (n == null) {
            return false;
        }
        Elems = elem.getElementsByTagName("X");
        if (Elems.getLength() == 0) {
            Elems = elem.getElementsByTagName("xloc");
        }
        if (Elems.getLength() > 0 && (node = Elems.item(0).getFirstChild()) != null) {
            String xStr = node.getNodeValue().trim();
            try {
                double xpos = Double.valueOf(xStr);
                n.setOrgXPosition(xpos);
            }
            catch (NumberFormatException xpos) {
                // empty catch block
            }
        }
        if ((Elems = elem.getElementsByTagName("Y")).getLength() == 0) {
            Elems = elem.getElementsByTagName("yloc");
        }
        if (Elems.getLength() > 0 && (node = Elems.item(0).getFirstChild()) != null) {
            String yStr = node.getNodeValue().trim();
            try {
                double ypos = Double.valueOf(yStr);
                n.setOrgYPosition(ypos);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return true;
    }

    private void loadNodeStyle(Element elem) {
        Node node;
        NodeList Elems;
        String ID = elem.getAttribute("ID");
        if ((ID == null || ID.equals("")) && (Elems = elem.getElementsByTagName("ID")).getLength() > 0 && (node = Elems.item(0).getFirstChild()) != null) {
            ID = node.getNodeValue().trim();
        }
        if (ID == null || ID.equals("")) {
            return;
        }
        ID = ID.trim();
        Hashtable<String, String> bag = new Hashtable<String, String>();
        this.nodeStyles.put(ID, bag);
        String elemTag = "";
        String value = "";
        for (node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            Node valNode = node.getFirstChild();
            if (valNode != null) {
                value = valNode.getNodeValue();
            }
            bag.put(elemTag, value);
        }
    }

    private void loadDupNode(Element elem) {
        Node node;
        NodeList Elems = elem.getElementsByTagName("ID");
        String id = null;
        if (Elems.getLength() > 0 && (node = Elems.item(0).getFirstChild()) != null) {
            id = node.getNodeValue().trim();
        }
        if (id == null) {
            return;
        }
        Object obj = this.IDlookup.get(id);
        NLDNode n = null;
        if (obj == null) {
            n = new NLDNode(0.0, 0.0);
            n.type = this.nld.shape;
            n.id = id;
            n.localTextColor = null;
            if (this.nld.deletedNodes.isEmpty()) {
                this.nld.nodes.addElement(n);
                n.index = this.nld.nodes.getIndexOf(n);
            } else {
                n.index = ((NLDNode)this.deletedNodes.pop()).index;
                this.nld.nodes.setElementAt(n, n.index);
            }
            this.IDlookup.put(n.id, new Integer(n.index));
        } else {
            int index = (Integer)obj;
            n = (NLDNode)this.nld.nodes.elementAt(index);
        }
        this.readNode(elem, n);
    }

    private NLDNode loadNode(Element elem) {
        Node node;
        NLDNode n = new NLDNode(0.0, 0.0);
        n.type = this.nld.shape;
        n.localTextColor = null;
        NodeList Elems = elem.getElementsByTagName("ID");
        if (Elems.getLength() > 0 && (node = Elems.item(0).getFirstChild()) != null) {
            n.id = node.getNodeValue().trim();
        }
        this.readNode(elem, n);
        return n;
    }

    private void readNode(Element elem, NLDNode n) {
        boolean del;
        int num;
        String sStr;
        String colStr;
        Node node = null;
        NodeList Elems = elem.getElementsByTagName("color");
        if (Elems.getLength() < 1) {
            Elems = elem.getElementsByTagName("Color");
        }
        if (Elems.getLength() > 0 && (node = Elems.item(0).getFirstChild()) != null) {
            colStr = node.getNodeValue().trim();
            n.color = NLD.decodeColor(colStr);
        }
        if ((Elems = elem.getElementsByTagName("textColor")).getLength() > 0 && (node = Elems.item(0).getFirstChild()) != null) {
            colStr = node.getNodeValue().trim();
            n.localTextColor = NLD.decodeColor(colStr);
        }
        if ((Elems = elem.getElementsByTagName("value")).getLength() > 0 && (node = Elems.item(0).getFirstChild()) != null) {
            String valueStr = node.getNodeValue().trim();
            try {
                n.value = Double.valueOf(valueStr);
            }
            catch (NumberFormatException ne) {
                n.value = 0.0;
            }
        }
        if ((Elems = elem.getElementsByTagName("colval")).getLength() > 0 && (node = Elems.item(0).getFirstChild()) != null) {
            String colvalStr = node.getNodeValue().trim();
            try {
                n.colval = Double.valueOf(colvalStr);
            }
            catch (NumberFormatException ne) {
                n.colval = 0.0;
            }
        }
        if ((Elems = elem.getElementsByTagName("shape")).getLength() > 0 && (node = Elems.item(0).getFirstChild()) != null) {
            String shapeStr = node.getNodeValue().trim();
            n.type = shapeStr.equalsIgnoreCase("circle") ? 1 : (shapeStr.equalsIgnoreCase("triangle") ? 2 : (shapeStr.equalsIgnoreCase("diamond") ? 3 : (shapeStr.equalsIgnoreCase("image") ? 5 : (shapeStr.equalsIgnoreCase("none") ? 4 : (shapeStr.equalsIgnoreCase("square") ? 0 : NLDViewer.DEFAULT_SHAPE_TYPE)))));
        }
        if ((Elems = elem.getElementsByTagName("image")).getLength() > 0 && (node = Elems.item(0).getFirstChild()) != null) {
            n.imgstr = node.getNodeValue();
        }
        if ((Elems = elem.getElementsByTagName("level")).getLength() > 0 && (node = Elems.item(0).getFirstChild()) != null) {
            String levelStr = node.getNodeValue().trim();
            try {
                n.level = Double.valueOf(levelStr).intValue();
                if (n.level > 5) {
                    n.level = 5;
                }
            }
            catch (NumberFormatException ne) {
                n.level = 1;
            }
        }
        if ((Elems = elem.getElementsByTagName("X")).getLength() == 0) {
            Elems = elem.getElementsByTagName("xloc");
        }
        if (Elems.getLength() > 0 && (node = Elems.item(0).getFirstChild()) != null) {
            String xStr = node.getNodeValue().trim();
            try {
                double xpos = Double.valueOf(xStr);
                n.setXPosition(xpos);
            }
            catch (NumberFormatException xpos) {
                // empty catch block
            }
        }
        if ((Elems = elem.getElementsByTagName("Y")).getLength() == 0) {
            Elems = elem.getElementsByTagName("yloc");
        }
        if (Elems.getLength() > 0 && (node = Elems.item(0).getFirstChild()) != null) {
            String yStr = node.getNodeValue().trim();
            try {
                double ypos = Double.valueOf(yStr);
                n.setYPosition(ypos);
            }
            catch (NumberFormatException ypos) {
                // empty catch block
            }
        }
        if ((Elems = elem.getElementsByTagName("size")).getLength() > 0 && (node = Elems.item(0).getFirstChild()) != null) {
            sStr = node.getNodeValue().trim();
            try {
                double size;
                n.size = size = Double.valueOf(sStr).doubleValue();
            }
            catch (NumberFormatException ne) {
                n.size = -1.0;
            }
        }
        if ((Elems = elem.getElementsByTagName("height")).getLength() > 0 && (node = Elems.item(0).getFirstChild()) != null) {
            sStr = node.getNodeValue().trim();
            try {
                double height;
                n.userHeight = height = Double.valueOf(sStr).doubleValue();
            }
            catch (NumberFormatException ne) {
                n.userHeight = -1.0;
            }
        }
        if ((Elems = elem.getElementsByTagName("fontName")).getLength() > 0 && (node = Elems.item(0).getFirstChild()) != null) {
            String name = node.getNodeValue().trim();
            Font font = n.font == null ? this.viewer.getFont() : n.font;
            n.font = new Font(name, font.getStyle(), font.getSize());
        }
        if ((Elems = elem.getElementsByTagName("fontStyle")).getLength() > 0 && (node = Elems.item(0).getFirstChild()) != null) {
            Font font = n.font == null ? this.viewer.getFont() : n.font;
            String fontStyle = node.getNodeValue().trim();
            if (fontStyle.startsWith("B") || fontStyle.startsWith("b")) {
                n.font = new Font(font.getName(), 1, font.getSize());
            } else if (fontStyle.startsWith("I") || fontStyle.startsWith("i")) {
                n.font = new Font(font.getName(), 2, font.getSize());
            } else if (fontStyle.startsWith("P") || fontStyle.startsWith("p")) {
                n.font = new Font(font.getName(), 0, font.getSize());
            }
        }
        if ((Elems = elem.getElementsByTagName("fontSize")).getLength() > 0 && (node = Elems.item(0).getFirstChild()) != null) {
            try {
                int size = new Double(node.getNodeValue()).intValue();
                if (size > 0) {
                    Font font = n.font == null ? this.viewer.getFont() : n.font;
                    n.font = new Font(font.getName(), font.getStyle(), size);
                }
            }
            catch (NumberFormatException size) {
                // empty catch block
            }
        }
        if ((Elems = elem.getElementsByTagName("style")).getLength() > 0 && (node = Elems.item(0).getFirstChild()) != null) {
            Hashtable bag;
            String style = node.getNodeValue();
            if (style != null) {
                if (NLDViewer.diamondNLS == null) {
                    this.viewer.setShapeStrings();
                }
                if (style.equalsIgnoreCase(NLDViewer.diamondEng) || style.equalsIgnoreCase(NLDViewer.diamondNLS)) {
                    n.type = 3;
                } else if (style.equalsIgnoreCase(NLDViewer.circleEng) || style.equalsIgnoreCase(NLDViewer.circleNLS)) {
                    n.type = 1;
                } else if (style.equalsIgnoreCase(NLDViewer.noneEng) || style.equalsIgnoreCase(NLDViewer.noneNLS)) {
                    n.type = 4;
                } else if (style.equalsIgnoreCase(NLDViewer.triangleEng) || style.equalsIgnoreCase(NLDViewer.triangleNLS)) {
                    n.type = 2;
                } else if (style.equalsIgnoreCase(NLDViewer.squareEng) || style.equalsIgnoreCase(NLDViewer.squareNLS)) {
                    n.type = 0;
                }
            }
            if ((bag = (Hashtable)this.nodeStyles.get(style)) != null) {
                Enumeration e = bag.keys();
                while (e.hasMoreElements()) {
                    String prop = (String)e.nextElement();
                    String val = (String)bag.get(prop);
                    if (prop.equalsIgnoreCase("color")) {
                        n.color = NLD.decodeColor(val);
                        continue;
                    }
                    if (prop.equalsIgnoreCase("labelBackColor")) {
                        n.color = NLD.decodeColor(val);
                        continue;
                    }
                    if (prop.equalsIgnoreCase("labelTextColor")) {
                        n.localTextColor = NLD.decodeColor(val);
                        continue;
                    }
                    if (prop.equalsIgnoreCase("nodeBorderColor")) {
                        n.borderColor = NLD.decodeColor(val);
                        continue;
                    }
                    if (prop.equalsIgnoreCase("fontName")) {
                        Font font = n.font == null ? this.viewer.getFont() : n.font;
                        n.font = new Font(val, font.getStyle(), font.getSize());
                        continue;
                    }
                    if (prop.equalsIgnoreCase("fontStyle")) {
                        Font font;
                        Font font2 = font = n.font == null ? this.viewer.getFont() : n.font;
                        if (val.startsWith("B") || val.startsWith("b")) {
                            n.font = new Font(font.getName(), 1, font.getSize());
                            continue;
                        }
                        if (val.startsWith("I") || val.startsWith("i")) {
                            n.font = new Font(font.getName(), 2, font.getSize());
                            continue;
                        }
                        if (!val.startsWith("P") && !val.startsWith("p")) continue;
                        n.font = new Font(font.getName(), 0, font.getSize());
                        continue;
                    }
                    if (!prop.equalsIgnoreCase("fontSize")) continue;
                    try {
                        int ssize = new Double(val).intValue();
                        if (ssize <= 0) continue;
                        Font font = n.font == null ? this.viewer.getFont() : n.font;
                        n.font = new Font(font.getName(), font.getStyle(), ssize);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
        }
        if ((Elems = elem.getElementsByTagName("label")).getLength() == 0) {
            Elems = elem.getElementsByTagName("Label");
        }
        if (Elems.getLength() > 0) {
            int num2 = Elems.getLength();
            if (num2 == 1) {
                node = Elems.item(0).getFirstChild();
                if (node != null) {
                    n.label = node.getNodeValue();
                }
            } else {
                Vector<String> labels = new Vector<String>();
                for (int i = 0; i < num2; ++i) {
                    node = Elems.item(i).getFirstChild();
                    if (node == null) continue;
                    labels.addElement(node.getNodeValue());
                }
                n.mlabel = labels;
            }
            if (node != null) {
                n.analyseLabel();
            }
        }
        if ((Elems = elem.getElementsByTagName("vars")).getLength() > 0 && (num = Elems.getLength()) > 0) {
            Vector<String> vars = new Vector<String>();
            for (int i = 0; i < num; ++i) {
                node = Elems.item(i).getFirstChild();
                if (node == null) continue;
                vars.addElement(node.getNodeValue());
            }
            n.splitVars = vars;
        }
        if ((Elems = elem.getElementsByTagName("xml")).getLength() > 0 && (num = Elems.getLength()) > 0) {
            Vector<String> xml = new Vector<String>();
            for (int i = 0; i < num; ++i) {
                node = Elems.item(i).getFirstChild();
                if (node == null) continue;
                xml.addElement(node.getNodeValue());
            }
            n.varXMLs = xml;
        }
        if ((Elems = elem.getElementsByTagName("url")).getLength() > 0 && (node = Elems.item(0).getFirstChild()) != null) {
            n.urlStr = node.getNodeValue();
        }
        if ((Elems = elem.getElementsByTagName("action")).getLength() > 0 && (node = Elems.item(0).getFirstChild()) != null) {
            n.action = node.getNodeValue();
        }
        if ((Elems = elem.getElementsByTagName("icon")).getLength() > 0 && (node = Elems.item(0).getFirstChild()) != null) {
            n.iconstr = node.getNodeValue();
        }
        if ((Elems = elem.getElementsByTagName("tip")).getLength() > 0) {
            num = Elems.getLength();
            if (num == 1) {
                node = Elems.item(0).getFirstChild();
                if (node != null) {
                    n.info = node.getNodeValue();
                }
            } else {
                Vector<String> minfo = new Vector<String>();
                for (int i = 0; i < num; ++i) {
                    node = Elems.item(i).getFirstChild();
                    if (node == null) continue;
                    minfo.addElement(node.getNodeValue());
                }
                n.minfo = minfo;
            }
            if (node != null) {
                n.analyseInfo();
            }
        }
        if ((Elems = elem.getElementsByTagName("jsp")).getLength() > 0 && (node = Elems.item(0).getFirstChild()) != null) {
            n.jspStr = node.getNodeValue();
        }
        if ((Elems = elem.getElementsByTagName("collapse")).getLength() > 0 && (node = Elems.item(0).getFirstChild()) != null) {
            n.hideSubtree = n.orgHideSubtree = new Boolean(node.getNodeValue()).booleanValue();
        }
        if ((Elems = elem.getElementsByTagName("delete")).getLength() > 0 && (node = Elems.item(0).getFirstChild()) != null && (del = new Boolean(node.getNodeValue()).booleanValue())) {
            this.removeNode(n);
        }
        if ((Elems = elem.getElementsByTagName("visible")).getLength() > 0 && (node = Elems.item(0).getFirstChild()) != null) {
            boolean visible = new Boolean(node.getNodeValue());
            n.hide = !visible;
        }
    }

    private int find(String id) {
        Object obj = this.IDlookup.get(id);
        if (obj == null) {
            return -1;
        }
        if (!(obj instanceof Integer)) {
            return -1;
        }
        return (Integer)obj;
    }

    private void loadDupNLDLink(Element elem) {
        NLDNode n;
        Node node;
        int fIndex = -1;
        int tIndex = -1;
        String fID = null;
        String tID = null;
        NodeList Elems = elem.getElementsByTagName("fromNode");
        if (Elems.getLength() > 0 && (node = Elems.item(0).getFirstChild()) != null) {
            fID = node.getNodeValue().trim();
            fIndex = this.find(fID);
            if (this.createNodesFromLinks && fIndex == -1) {
                n = new NLDNode(0.0, 0.0);
                n.type = this.nld.shape;
                n.localTextColor = null;
                n.id = fID;
                this.addNode(n);
                fIndex = n.index;
            }
        }
        if ((Elems = elem.getElementsByTagName("toNode")).getLength() > 0 && (node = Elems.item(0).getFirstChild()) != null) {
            tID = node.getNodeValue().trim();
            tIndex = this.find(tID);
            if (this.createNodesFromLinks && tIndex == -1) {
                n = new NLDNode(0.0, 0.0);
                n.type = this.nld.shape;
                n.localTextColor = null;
                n.id = tID;
                this.addNode(n);
                tIndex = n.index;
            }
        }
        if (fIndex == -1 || tIndex == -1) {
            if (fIndex == -1) {
                System.out.println("WARNING: No node with ID = " + fID + " is defined.");
            } else {
                System.out.println("WARNING: No node with ID " + tID + " is defined.");
            }
            System.out.println("Therefore, link between " + fID + " and " + tID + " ignored.");
        }
        String id = fIndex + "," + tIndex;
        Object obj = this.linkIDlookup.get(id);
        NLDLink a = null;
        if (obj == null) {
            a = new NLDLink(fIndex, tIndex);
            this.nld.links.addObservation(a);
            a.index = this.nld.links.indexOf(a);
            a.color = null;
            a.directed = this.nld.directed;
            this.linkIDlookup.put(id, new Integer(a.index));
        } else {
            int index = (Integer)obj;
            a = (NLDLink)this.nld.links.elementAt(index);
        }
        this.readLink(elem, a);
    }

    private NLDLink loadNLDLink(Element elem) {
        NLDNode n;
        Node node;
        int fIndex = -1;
        int tIndex = -1;
        String fID = null;
        String tID = null;
        NodeList Elems = elem.getElementsByTagName("fromNode");
        if (Elems.getLength() > 0 && (node = Elems.item(0).getFirstChild()) != null) {
            fID = node.getNodeValue().trim();
            fIndex = this.find(fID);
            if (this.createNodesFromLinks && fIndex == -1) {
                n = new NLDNode(0.0, 0.0);
                n.type = this.nld.shape;
                n.localTextColor = null;
                n.id = fID;
                this.addNode(n);
                fIndex = n.index;
            }
        }
        if ((Elems = elem.getElementsByTagName("toNode")).getLength() > 0 && (node = Elems.item(0).getFirstChild()) != null) {
            tID = node.getNodeValue().trim();
            tIndex = this.find(tID);
            if (this.createNodesFromLinks && tIndex == -1) {
                n = new NLDNode(0.0, 0.0);
                n.type = this.nld.shape;
                n.localTextColor = null;
                n.id = tID;
                this.addNode(n);
                tIndex = n.index;
            }
        }
        NLDLink a = new NLDLink(fIndex, tIndex);
        a.color = null;
        if (fIndex == -1 || tIndex == -1) {
            if (fIndex == -1) {
                System.out.println("WARNING: No node with ID = " + fID + " is defined.");
            } else {
                System.out.println("WARNING: No node with ID " + tID + " is defined.");
            }
            System.out.println("Therefore, link between " + fID + " and " + tID + " ignored.");
            a.hide = true;
            return a;
        }
        this.readLink(elem, a);
        return a;
    }

    private void readLink(Element elem, NLDLink a) {
        int i;
        Node node = null;
        NodeList Elems = elem.getElementsByTagName("color");
        if (Elems.getLength() > 0 && (node = Elems.item(0).getFirstChild()) != null) {
            String colStr = node.getNodeValue();
            a.color = NLD.decodeColor(colStr);
        }
        if ((Elems = elem.getElementsByTagName("width")).getLength() > 0 && (node = Elems.item(0).getFirstChild()) != null) {
            String widthStr = node.getNodeValue();
            a.width = new Double(widthStr).floatValue();
        }
        if ((Elems = elem.getElementsByTagName("value")).getLength() > 0 && (node = Elems.item(0).getFirstChild()) != null) {
            String valueStr = node.getNodeValue().trim();
            try {
                a.value = Double.valueOf(valueStr);
            }
            catch (NumberFormatException ne) {
                a.value = 0.0;
            }
        }
        if ((Elems = elem.getElementsByTagName("colval")).getLength() > 0 && (node = Elems.item(0).getFirstChild()) != null) {
            String colvalStr = node.getNodeValue().trim();
            try {
                a.colval = Double.valueOf(colvalStr);
            }
            catch (NumberFormatException ne) {
                a.colval = 0.0;
            }
        }
        if ((Elems = elem.getElementsByTagName("label")).getLength() == 0) {
            Elems = elem.getElementsByTagName("Label");
        }
        if (Elems.getLength() > 0) {
            int num = Elems.getLength();
            if (num == 1) {
                node = Elems.item(0).getFirstChild();
                if (node != null) {
                    a.label = node.getNodeValue();
                }
            } else {
                Vector<String> labels = new Vector<String>();
                for (i = 0; i < num; ++i) {
                    node = Elems.item(i).getFirstChild();
                    if (node == null) continue;
                    labels.addElement(node.getNodeValue());
                }
                a.mlabel = labels;
            }
            if (node != null) {
                a.analyseLabel();
            }
        }
        if ((Elems = elem.getElementsByTagName("tip")).getLength() > 0) {
            int num = Elems.getLength();
            if (num == 1) {
                node = Elems.item(0).getFirstChild();
                if (node != null) {
                    a.info = node.getNodeValue();
                }
            } else {
                Vector<String> minfo = new Vector<String>();
                for (i = 0; i < num; ++i) {
                    node = Elems.item(i).getFirstChild();
                    if (node == null) continue;
                    minfo.addElement(node.getNodeValue());
                }
                a.minfo = minfo;
            }
            if (node != null) {
                a.analyseInfo();
            }
        }
        if ((Elems = elem.getElementsByTagName("stipple")).getLength() > 0 && (node = Elems.item(0).getFirstChild()) != null) {
            String stipple = node.getNodeValue();
            try {
                a.stipple = Integer.decode(stipple);
            }
            catch (NumberFormatException e) {
                a.stipple = 0;
            }
        }
        if ((Elems = elem.getElementsByTagName("stippleFactor")).getLength() > 0 && (node = Elems.item(0).getFirstChild()) != null) {
            String stippleFactor = node.getNodeValue();
            try {
                a.factor = new Double(stippleFactor).intValue();
            }
            catch (NumberFormatException e) {
                a.factor = 1;
            }
        }
    }

    void addNode(NLDNode node) {
        this.nld.nodes.addElement(node);
        node.index = this.nld.nodes.getIndexOf(node);
        if (node.id != null) {
            this.IDlookup.put(node.id, new Integer(node.index));
        }
    }

    void removeNode(NLDNode node) {
        Enumeration e = this.linkIDlookup.keys();
        String id = new String(node.id);
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.indexOf(id) == -1) continue;
            NLDLink link = (NLDLink)this.linkIDlookup.get(key);
            if (link.from != node.index && link.to != node.index) continue;
            this.nld.links.remove(link);
            this.linkIDlookup.remove(key);
        }
        this.IDlookup.remove(node.id);
        node.id = null;
        node.hide = true;
        this.deletedNodes.push(node);
    }

    void addNLDLink(NLDLink link) {
        this.nld.links.addObservation(link);
        link.index = this.nld.links.indexOf(link);
    }
}

