/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.nld;

import com.sas.graphics.util.nld.Ring;
import java.util.ArrayList;

public class RingList
extends ArrayList {
    public boolean consumeRing(int pos, double a1, double a2, double r1, double r2) {
        Ring pRing = (Ring)this.get(pos);
        double amax = pRing.getAMax();
        double amin = pRing.getAMin();
        double rmax = pRing.getRMax();
        double rmin = pRing.getRMin();
        if (a1 < amin || a2 > amax || r1 < rmin || r2 > rmax) {
            return false;
        }
        Ring pNewRing = new Ring();
        if (amin < a1) {
            pNewRing = new Ring(amin, a1, rmin, rmax);
            this.addToList(pos, pNewRing);
        }
        if (amax > a2) {
            pNewRing = new Ring(a2, amax, rmin, rmax);
            this.addToList(pos, pNewRing);
        }
        pNewRing = pRing;
        pNewRing.setAMin(a1);
        pNewRing.setAMax(a2);
        pNewRing.setRMin(r2);
        pNewRing.setRMax(rmax);
        this.addToList(pos, pNewRing);
        this.remove(pos);
        return true;
    }

    private int addToList(int startPos, Ring pRing) {
        boolean found = false;
        int pos = 0;
        int pos1 = startPos;
        ++pos1;
        while (pos1 < this.size() && !found) {
            pos = pos1;
            Ring pOldRing = (Ring)this.get(pos1);
            ++pos1;
            found = pRing.getRMin() < pOldRing.getRMin() || pRing.getRMin() - pOldRing.getRMin() < 2.2204460492503132E16 && pRing.calcMaxInteriorCircle() > pOldRing.calcMaxInteriorCircle();
        }
        if (found) {
            this.add(pos - 1, pRing);
            --pos;
        } else {
            this.add(pRing);
            pos = this.size() - 1;
        }
        return pos;
    }
}

