/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.nld;

import com.sas.graphics.util.nld.Compass;
import com.sas.graphics.util.nld.Group;
import com.sas.graphics.util.nld.NLDLink;
import com.sas.graphics.util.nld.NLDModel;
import com.sas.graphics.util.nld.NLDNode;
import com.sas.graphics.util.nld.NLDRect;
import com.sas.graphics.util.nld.NLDViewer;
import com.sas.graphics.util.nld.Ring;
import com.sas.graphics.util.nld.RingList;
import com.sas.graphics.util.nld.SortContext;
import com.sas.graphics.util.nld.VectorLinkModel;
import com.sas.graphics.util.nld.VectorNodeModel;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;

public class NLDHierarchyLayout {
    public static final double DOUBLE_ZERO = 1.0E-8;
    public static final double RADIUS = 300.0;
    public static final double DBL_EPSILON = 2.2204460492503132E16;
    private VectorNodeModel nodes = null;
    private VectorLinkModel links = null;
    private Hashtable linkTable = null;
    private Vector groups = null;
    private Long[] hashValues = null;
    private long linkCount = -1L;
    private long nodeCount = -1L;
    private long hashConst = -1L;
    private double[] minMaxLinkValues = null;
    private Node[] m_nodes = null;
    private Link[] m_links = null;
    private Node[] m_tree_roots = null;
    private int nGroups = -1;
    protected NLDViewer viewer = null;
    private int componentSpacing = 10;
    private NLDRect globalBounds = null;
    private boolean[] m_pUsedLinks = null;
    private double m_radiusInterval = 100.0;
    private int visNodeCount = 0;
    private int visLinkCount = 0;
    private double oldxm;
    private double oldym;
    private double oldxd;
    private double oldyd;
    private double newxm;
    private double newym;
    private double newxd;
    private double newyd;

    public NLDHierarchyLayout(NLDModel model) {
        int i;
        for (i = 0; i < model.links.size(); ++i) {
            NLDLink l = (NLDLink)model.links.elementAt(i);
            if (l.from == -1) {
                l.from = l.getFromIndex();
            }
            if (l.to == -1) {
                l.to = l.getToIndex();
            }
            if (l.from >= model.nodes.size() || l.to >= model.nodes.size()) continue;
            NLDNode nodeF = (NLDNode)model.nodes.elementAt(l.from);
            NLDNode nodeT = (NLDNode)model.nodes.elementAt(l.to);
            if (nodeF == null || nodeT == null || !nodeF.isVisible() || !nodeT.isVisible()) continue;
            ++this.visLinkCount;
        }
        for (i = 0; i < model.nodes.size(); ++i) {
            NLDNode n = (NLDNode)model.nodes.elementAt(i);
            if (!n.isVisible()) continue;
            ++this.visNodeCount;
        }
        this.nodes = model.nodes;
        this.links = model.links;
        this.linkTable = null;
        this.hashValues = null;
        this.linkCount = this.links.size();
        this.nodeCount = this.nodes.size();
        this.hashConst = this.linkCount > this.nodeCount ? this.linkCount : this.nodeCount;
        this.groups = new Vector();
        this.nGroups = -1;
        this.viewer = model.viewer;
        this.componentSpacing = 10;
        this.globalBounds = new NLDRect(0, 0, this.viewer.getWidth(), this.viewer.getHeight());
        this.m_pUsedLinks = null;
        this.m_radiusInterval = 100.0;
    }

    public void setComponentSpacing(int spacing) {
        this.componentSpacing = spacing;
    }

    public int getComponentSpacing() {
        return this.componentSpacing;
    }

    private int getLinkIdx(int i, int j, Hashtable linkTable) {
        NLDNode nI = (NLDNode)this.nodes.elementAt(i);
        NLDNode nJ = (NLDNode)this.nodes.elementAt(j);
        if (!nI.isVisible() || !nJ.isVisible()) {
            return -1;
        }
        long hashKey = (long)i * this.hashConst + (long)j;
        if (linkTable == null) {
            return -1;
        }
        Integer linkIndex = (Integer)linkTable.get(new Long(hashKey));
        if (null != linkIndex) {
            int retVal = linkIndex;
            if (this.links.isCulled(retVal)) {
                return -1;
            }
            return retVal;
        }
        return -1;
    }

    private void buildLinks(Hashtable linkTable, int i, int j, boolean useValue, boolean someNegValues) {
        int linkIdT;
        Node ni = this.m_nodes[i];
        Node nj = this.m_nodes[j];
        double value = 0.0;
        int linkIdx = -1;
        int linkIdF = this.getLinkIdx(j, i, linkTable);
        if (linkIdF >= 0) {
            if (useValue) {
                NLDLink l = (NLDLink)this.links.elementAt(linkIdF);
                double lValue = l.value;
                if (someNegValues) {
                    lValue += Math.abs(this.minMaxLinkValues[0]);
                }
                if (lValue <= 0.0) {
                    lValue = 1.0E-8;
                }
                value += lValue;
            } else {
                value += 1.0;
            }
            linkIdx = linkIdF;
        }
        if ((linkIdT = this.getLinkIdx(i, j, linkTable)) >= 0) {
            if (useValue) {
                NLDLink l = (NLDLink)this.links.elementAt(linkIdT);
                double lValue = l.value;
                if (someNegValues) {
                    lValue += Math.abs(this.minMaxLinkValues[0]);
                }
                if (lValue <= 0.0) {
                    lValue = 1.0E-8;
                }
                value += lValue;
            } else {
                value += 1.0;
            }
            linkIdx = linkIdT;
        }
        if (linkIdx >= 0) {
            Link lnk = new Link(linkIdx);
            value = useValue ? (someNegValues ? (value /= this.minMaxLinkValues[1] - this.minMaxLinkValues[0]) : (value /= this.minMaxLinkValues[1])) : (value /= 2.0);
            lnk.setValue(value);
            this.m_links[linkIdx] = lnk;
            ni.addLink(lnk);
            nj.addLink(lnk);
        }
    }

    private boolean buildGraph() {
        if (this.visNodeCount <= 0) {
            return false;
        }
        this.m_nodes = new Node[(int)this.nodeCount];
        int i = 0;
        while ((long)i < this.nodeCount) {
            Node n;
            this.m_nodes[i] = n = new Node(i);
            ++i;
        }
        if (this.visLinkCount <= 0) {
            return false;
        }
        this.m_links = new Link[(int)this.linkCount];
        this.linkTable = new Hashtable((int)this.linkCount);
        this.hashValues = new Long[(int)this.linkCount];
        this.minMaxLinkValues = new double[2];
        this.minMaxLinkValues[0] = Double.POSITIVE_INFINITY;
        this.minMaxLinkValues[1] = Double.NEGATIVE_INFINITY;
        i = 0;
        while ((long)i < this.linkCount) {
            NLDLink l = (NLDLink)this.links.elementAt(i);
            if (l.isVisible() && l.to >= 0 && l.from >= 0 && (long)l.to < this.nodeCount && (long)l.from < this.nodeCount && l.to != l.from) {
                NLDNode nodeF = (NLDNode)this.nodes.elementAt(l.from);
                NLDNode nodeT = (NLDNode)this.nodes.elementAt(l.to);
                if (nodeF.isVisible() && nodeT.isVisible()) {
                    long hashValue = (long)l.from * this.hashConst + (long)l.to;
                    this.hashValues[i] = new Long(hashValue);
                    this.linkTable.put(this.hashValues[i], new Integer(i));
                    this.minMaxLinkValues[0] = Math.min(this.minMaxLinkValues[0], l.value);
                    this.minMaxLinkValues[1] = Math.max(this.minMaxLinkValues[1], l.value);
                }
            }
            ++i;
        }
        boolean useValue = true;
        boolean someNegValues = false;
        if (this.minMaxLinkValues[1] == this.minMaxLinkValues[0] && this.minMaxLinkValues[1] == 0.0) {
            useValue = false;
        }
        if (this.minMaxLinkValues[0] < 0.0) {
            someNegValues = true;
        }
        int i2 = 0;
        while ((long)i2 < this.nodeCount) {
            NLDNode nI = (NLDNode)this.nodes.elementAt(i2);
            if (nI.isVisible()) {
                int j = i2 + 1;
                while ((long)j < this.nodeCount) {
                    NLDNode nJ = (NLDNode)this.nodes.elementAt(j);
                    if (nJ.isVisible()) {
                        this.buildLinks(this.linkTable, i2, j, useValue, someNegValues);
                    }
                    ++j;
                }
            }
            ++i2;
        }
        return true;
    }

    private void findAComponent(Node pNode, Group theGroup) {
        if (pNode.isVisited()) {
            return;
        }
        pNode.setVisited(true);
        theGroup.addNode(pNode);
        for (int i = 0; i < pNode.getNumLinks(); ++i) {
            int linkIdx = pNode.getLink(i).getIndex();
            NLDLink l = (NLDLink)this.links.elementAt(linkIdx);
            NLDNode nodeF = (NLDNode)this.nodes.elementAt(l.from);
            NLDNode nodeT = (NLDNode)this.nodes.elementAt(l.to);
            if (!nodeF.isVisible() || !nodeT.isVisible()) continue;
            int nodeIdx = l.from;
            if (nodeIdx == pNode.getIndex()) {
                nodeIdx = l.to;
            }
            if (nodeIdx == -1 || this.m_nodes[nodeIdx].isVisited()) continue;
            this.findAComponent(this.m_nodes[nodeIdx], theGroup);
        }
    }

    private boolean sortGroups(Vector groups) {
        int nGroups = groups.size();
        try {
            SortContext.mergesort(groups, 0, nGroups);
        }
        catch (Exception e) {
            System.out.println("Exception while sorting groups!!!!");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean findComponents() {
        int i;
        int numNodes = this.m_nodes.length;
        for (i = 0; i < numNodes; ++i) {
            this.m_nodes[i].setVisited(false);
        }
        int id = 0;
        for (i = 0; i < numNodes; ++i) {
            NLDNode n = (NLDNode)this.nodes.elementAt(this.m_nodes[i].getIndex());
            if (!n.isVisible() || this.m_nodes[i].isVisited()) continue;
            Group oneGroup = new Group(id);
            this.findAComponent(this.m_nodes[i], oneGroup);
            this.groups.addElement(oneGroup);
            ++id;
        }
        this.nGroups = this.groups.size();
        if (this.nGroups <= 0) {
            return false;
        }
        if (!this.sortGroups(this.groups)) {
            return false;
        }
        if (this.m_pUsedLinks == null) {
            this.m_pUsedLinks = new boolean[(int)this.linkCount];
        }
        i = 0;
        while ((long)i < this.linkCount) {
            this.m_pUsedLinks[i] = false;
            ++i;
        }
        this.m_tree_roots = new Node[this.nGroups];
        return true;
    }

    private void setRadiusInterval(double interval) {
        this.m_radiusInterval = interval;
    }

    private double getRadiusInterval() {
        return this.m_radiusInterval;
    }

    private void scaleCmps() {
        int height;
        NLDRect bounds = new NLDRect(((Group)this.groups.elementAt(0)).getBound());
        for (int i = 1; i < this.nGroups; ++i) {
            bounds.unionRect(((Group)this.groups.elementAt(i)).getBound());
        }
        int width = bounds.width();
        if (width > (height = bounds.height())) {
            bounds.top -= (width - height) / 2;
            bounds.bottom += (width - height) / 2;
        } else if (width < height) {
            bounds.left -= (height - width) / 2;
            bounds.right += (height - width) / 2;
        }
        bounds.inflateRect(this.componentSpacing / 2, this.componentSpacing / 2);
        int minViewDim = this.globalBounds.width() > this.globalBounds.height() ? this.globalBounds.height() : this.globalBounds.width();
        int maxDataRange = bounds.width() > bounds.height() ? bounds.height() : bounds.width();
        double xRatio = (double)minViewDim / (double)maxDataRange;
        double yRatio = (double)minViewDim / (double)maxDataRange;
        for (int i = 0; i < this.nGroups; ++i) {
            NLDRect groupBound = ((Group)this.groups.elementAt(i)).getBound();
            groupBound.left -= bounds.left;
            groupBound.right -= bounds.left;
            groupBound.top -= bounds.top;
            groupBound.bottom -= bounds.top;
            groupBound.left = (int)(xRatio * (double)groupBound.left);
            groupBound.right = (int)(xRatio * (double)groupBound.right);
            groupBound.top = (int)(yRatio * (double)groupBound.top);
            groupBound.bottom = (int)(yRatio * (double)groupBound.bottom);
            groupBound.left += this.globalBounds.left;
            groupBound.right += this.globalBounds.left;
            groupBound.top += this.globalBounds.top;
            groupBound.bottom += this.globalBounds.top;
        }
    }

    private boolean layoutCmps() {
        RingList ringList = new RingList();
        int viewCenterX = this.viewer.getWidth() / 2;
        int viewCenterY = this.viewer.getHeight() / 2;
        int dx = 0;
        int dy = 0;
        double radius = 100.0;
        Group laregestGroup = (Group)this.groups.elementAt(this.groups.size() - 1);
        int maxNodes = laregestGroup.getSize();
        if (maxNodes <= 0) {
            return false;
        }
        Compass compass = new Compass(maxNodes, 300.0);
        double cos45 = Math.cos(0.7853981633974483);
        Ring pRing = null;
        boolean isOk = true;
        for (int i = this.nGroups - 1; i >= 0; --i) {
            Group oneGroup = (Group)this.groups.elementAt(i);
            int nNodes = oneGroup.getSize();
            radius = compass.calcRadius(nNodes);
            if (i != this.nGroups - 1) {
                for (int k = 0; k < ringList.size(); ++k) {
                    int pos0 = k;
                    pRing = (Ring)ringList.get(k);
                    if (!(pRing.calcMaxInteriorCircle() >= radius)) continue;
                    double a = (pRing.getAMax() + pRing.getAMin()) / 2.0;
                    double r = pRing.getRMin() + radius + (double)this.componentSpacing;
                    dx = (int)(r * Math.cos(a - 0.7853981633974483));
                    dy = (int)(r * Math.sin(a - 0.7853981633974483));
                    double halfAngleSpan = Math.asin(radius / r);
                    isOk = ringList.consumeRing(pos0, a - halfAngleSpan, a + halfAngleSpan, pRing.getRMin(), r + radius);
                    break;
                }
            } else {
                pRing = new Ring(0.0, Math.PI * 2, radius, Double.MAX_VALUE);
                pRing.calcMaxInteriorCircle();
                ringList.add(0, pRing);
            }
            if (!isOk) continue;
            NLDRect groupBound = new NLDRect((int)((double)(dx += viewCenterX) - radius), (int)((double)(dy += viewCenterY) - radius), (int)((double)dx + radius), (int)((double)dy + radius));
            oneGroup.setBounds(groupBound);
            dx += (int)(radius * cos45) + this.componentSpacing;
            dy += (int)(radius * cos45) + this.componentSpacing;
        }
        ringList.clear();
        this.scaleCmps();
        return true;
    }

    public boolean init() {
        this.buildGraph();
        if (!this.findComponents()) {
            return false;
        }
        this.setRadiusInterval(100.0);
        return true;
    }

    boolean isLinkInTree(int linkIndex) {
        return this.m_pUsedLinks[linkIndex];
    }

    private int countLeaves(Node pNode) {
        pNode.setVisited(true);
        if (pNode.getValue() == 0) {
            return 0;
        }
        int numLeaves = 0;
        for (int i = 0; i < pNode.getNumLinks(); ++i) {
            Node pChild;
            int linkIdx = pNode.getLink(i).getIndex();
            if (!this.isLinkInTree(linkIdx)) continue;
            Link lnk = this.m_links[linkIdx];
            int linkOrd = lnk.getIndex();
            NLDLink l = (NLDLink)this.links.elementAt(linkOrd);
            if (l.from == -1) {
                l.from = l.getFromIndex();
            }
            if (l.to == -1) {
                l.to = l.getToIndex();
            }
            int nodeIdx = l.from;
            if (pNode.getIndex() == l.from) {
                nodeIdx = l.to;
            }
            if ((pChild = this.m_nodes[nodeIdx]).isVisited()) continue;
            if (pChild.getValue() == 0) {
                ++numLeaves;
                continue;
            }
            numLeaves += this.countLeaves(pChild);
        }
        pNode.setValue(numLeaves);
        return numLeaves;
    }

    public void groupDebugPrint(Group group) {
        Vector memberNodes = group.getMemberNodes();
        int nNodes = memberNodes.size();
        for (int i = 0; i < nNodes; ++i) {
            Node n = (Node)memberNodes.elementAt(i);
            System.out.print("Node: " + ((NLDNode)this.nodes.elementAt(n.getIndex())).getID());
            System.out.println(" nLinks: " + n.getNumLinks());
        }
    }

    private Node buildCmpTree(Group group) {
        int i;
        int nodeIdx;
        int linkIdx;
        int groupIdx = group.getIdx();
        if (null != this.m_tree_roots[groupIdx]) {
            return this.m_tree_roots[groupIdx];
        }
        if (!group.sortNodes()) {
            return null;
        }
        Node pRoot = group.getNode(0);
        int nNodes = group.getSize();
        int[] pDegrees = new int[nNodes];
        Node pNode = null;
        Node pNextNode = null;
        int k = 0;
        int j = 0;
        j = 0;
        k = 0;
        while (j < nNodes) {
            pNode = group.getNode(j);
            pDegrees[k] = pNode.getNumLinks();
            pNode.setVisited(false);
            pNode.setValue(0);
            ++j;
            ++k;
        }
        ArrayList<Node> nodeQueue = new ArrayList<Node>();
        nodeQueue.clear();
        k = 0;
        int count = 0;
        int radius = 0;
        Vector<Node> nodesAtLevel = new Vector<Node>();
        int stage = 0;
        while (true) {
            if (nodeQueue.size() > 0) {
                while (nodeQueue.size() != 0) {
                    pNode = (Node)nodeQueue.get(0);
                    int step = pNode.getValue();
                    if (radius < step) {
                        radius = step;
                        pRoot = pNode;
                        count = 0;
                        nodesAtLevel.clear();
                        nodesAtLevel.addElement(pNode);
                    } else if (radius == step) {
                        ++count;
                        nodesAtLevel.addElement(pNode);
                    }
                    ++step;
                    for (j = 0; j < pNode.getNumLinks(); ++j) {
                        linkIdx = pNode.getLink(j).getIndex();
                        Link lnk = this.m_links[linkIdx];
                        int linkOrd = lnk.getIndex();
                        NLDLink l = (NLDLink)this.links.elementAt(linkOrd);
                        if (l.from == -1) {
                            l.from = l.getFromIndex();
                        }
                        if (l.to == -1) {
                            l.to = l.getToIndex();
                        }
                        nodeIdx = l.from;
                        if (pNode.getIndex() == l.from) {
                            nodeIdx = l.to;
                        }
                        if ((pNextNode = this.m_nodes[nodeIdx]).isVisited()) continue;
                        pNextNode.setVisited(true);
                        pNextNode.setValue(step);
                        nodeQueue.add(pNextNode);
                    }
                    nodeQueue.remove(0);
                }
            }
            if (nodeQueue.size() == 0) {
                while (k < nNodes && pDegrees[k] <= stage) {
                    pNode = group.getNode(k);
                    if (!pNode.isVisited()) {
                        pNode.setVisited(true);
                        pNode.setValue(0);
                        nodeQueue.add(pNode);
                    }
                    ++k;
                }
            }
            if (nodeQueue.size() == 0 && k >= nNodes) break;
            ++stage;
        }
        this.m_tree_roots[groupIdx] = pRoot;
        for (int i2 = 0; i2 < group.getSize(); ++i2) {
            pNode = group.getNode(i2);
            pNode.setVisited(false);
            if (pNode.getValue() <= 0) continue;
            pNode.setValue(-1);
        }
        ArrayList<Node> bfsQueue = new ArrayList<Node>();
        bfsQueue.clear();
        bfsQueue.add(pRoot);
        pRoot.setVisited(true);
        Node pChild = null;
        boolean found = false;
        while (bfsQueue.size() > 0) {
            int pos = 0;
            pNode = (Node)bfsQueue.get(pos);
            bfsQueue.remove(pos);
            found = false;
            for (int i3 = 0; i3 < pNode.getNumLinks(); ++i3) {
                linkIdx = pNode.getLink(i3).getIndex();
                if (this.m_pUsedLinks[linkIdx]) continue;
                Link lnk = this.m_links[linkIdx];
                int linkOrd = lnk.getIndex();
                NLDLink l = (NLDLink)this.links.elementAt(linkOrd);
                if (l.from == -1) {
                    l.from = l.getFromIndex();
                }
                if (l.to == -1) {
                    l.to = l.getToIndex();
                }
                nodeIdx = l.from;
                if (pNode.getIndex() == l.from) {
                    nodeIdx = l.to;
                }
                if ((pChild = this.m_nodes[nodeIdx]).isVisited()) continue;
                this.m_pUsedLinks[linkIdx] = true;
                pChild.setVisited(true);
                bfsQueue.add(pChild);
                found = true;
            }
            pNode.setValue(found ? -1 : 0);
        }
        for (i = 0; i < group.getSize(); ++i) {
            pNode = group.getNode(i);
            pNode.setVisited(false);
        }
        this.countLeaves(pRoot);
        for (i = 0; i < group.getSize(); ++i) {
            pNode = group.getNode(i);
            if (pNode.getValue() == 0) {
                pNode.setValue(1);
            }
            pNode.setVisited(false);
        }
        return pRoot;
    }

    private boolean setXYPos(int nodeIdx, double x, double y) {
        NLDNode n = (NLDNode)this.nodes.elementAt(nodeIdx);
        n.orgXpos = x;
        n.orgYpos = y;
        return true;
    }

    private boolean arrangeSubtree(Node pRoot, double angleMin, double angleMax, double radius, int centerX, int centerY) {
        pRoot.setVisited(true);
        double angle = angleMin + 0.5 * (angleMax - angleMin);
        int nodeIdx = pRoot.getIndex();
        double x = radius * Math.cos(angle) + (double)centerX;
        double y = radius * Math.sin(angle) + (double)centerY;
        if (!this.setXYPos(nodeIdx, x, y)) {
            return false;
        }
        if (this.links == null || this.nodes == null) {
            return false;
        }
        int totalNumLeaves = 0;
        int numLinks = pRoot.getNumLinks();
        if (!pRoot.sortLinks()) {
            return false;
        }
        int[] children = new int[numLinks];
        int numChildren = 0;
        Node pChild = null;
        for (int i = 0; i < numLinks; ++i) {
            int linkIdx = pRoot.getLink(i).getIndex();
            if (!this.isLinkInTree(linkIdx)) continue;
            Link lnk = this.m_links[linkIdx];
            int linkOrd = lnk.getIndex();
            NLDLink l = (NLDLink)this.links.elementAt(linkOrd);
            if (l.from == -1) {
                l.from = l.getFromIndex();
            }
            if (l.to == -1) {
                l.to = l.getToIndex();
            }
            int childIdx = l.from;
            if (pRoot.getIndex() == l.from) {
                childIdx = l.to;
            }
            if ((pChild = this.m_nodes[childIdx]).isVisited()) continue;
            totalNumLeaves += pChild.getValue();
            children[numChildren] = childIdx;
            ++numChildren;
        }
        double radiusInterval = this.getRadiusInterval();
        double angle1 = angleMin;
        double angle2 = angleMin;
        double angleRange = angleMax - angleMin;
        boolean atMin = true;
        for (int i = 0; i < numChildren; ++i) {
            pChild = this.m_nodes[children[i]];
            if (pChild.isVisited()) continue;
            pChild.setVisited(true);
            double span = angleRange * (double)pChild.getValue() / (double)totalNumLeaves;
            if (atMin) {
                angle2 = angleMin + span;
                angle1 = angleMin;
                this.arrangeSubtree(pChild, angle1, angle2, radius + radiusInterval, centerX, centerY);
                angleMin = angle2;
            } else {
                angle1 = angleMax - span;
                angle2 = angleMax;
                this.arrangeSubtree(pChild, angle1, angle2, radius + radiusInterval, centerX, centerY);
                angleMax = angle1;
            }
            atMin = !atMin;
        }
        return true;
    }

    private boolean doNodeLayout(Group group) {
        NLDRect bounds = group.getBound();
        Node pRoot = this.buildCmpTree(group);
        if (pRoot == null) {
            return false;
        }
        double cx = (bounds.left + bounds.right) / 2;
        double cy = (bounds.top + bounds.bottom) / 2;
        double radius = Math.min(bounds.width(), bounds.height()) / 2;
        double dR = radius / 2.0;
        dR = radius / 2.4;
        dR = radius / 7.0;
        this.setRadiusInterval(dR);
        boolean ret = false;
        ret = this.arrangeSubtree(pRoot, 0.0, Math.PI * 2, 0.0, (int)cx, (int)cy);
        return ret;
    }

    private boolean scaleToFit(Group group) {
        double y;
        double x;
        NLDNode n;
        int nodeIdx;
        int i;
        double cos45 = Math.sqrt(2.0) / 2.0;
        long halfSpacing = this.getComponentSpacing() / 2;
        double xmin = Double.MAX_VALUE;
        double xmax = -1.7976931348623157E308;
        double ymin = Double.MAX_VALUE;
        double ymax = -1.7976931348623157E308;
        double x45min = Double.MAX_VALUE;
        double x45max = -1.7976931348623157E308;
        double y45min = Double.MAX_VALUE;
        double y45max = -1.7976931348623157E308;
        int nNodes = group.getSize();
        if (nNodes <= 0) {
            return false;
        }
        for (i = 0; i < nNodes; ++i) {
            nodeIdx = group.getNode(i).getIndex();
            n = (NLDNode)this.nodes.elementAt(nodeIdx);
            if (xmin > n.orgXpos) {
                xmin = n.orgXpos;
            }
            if (xmax < n.orgXpos) {
                xmax = n.orgXpos;
            }
            if (ymin > n.orgYpos) {
                ymin = n.orgYpos;
            }
            if (!(ymax < n.orgYpos)) continue;
            ymax = n.orgYpos;
        }
        double cx = (xmin + xmax) / 2.0;
        double cy = (ymin + ymax) / 2.0;
        for (i = 0; i < nNodes; ++i) {
            nodeIdx = group.getNode(i).getIndex();
            n = (NLDNode)this.nodes.elementAt(nodeIdx);
            x = n.orgXpos;
            y = n.orgYpos;
            double x45 = cos45 * ((x -= cx) - (y -= cy)) + cx;
            double y45 = cos45 * (x + y) + cy;
            if (x45min > x45) {
                x45min = x45;
            }
            if (x45max < x45) {
                x45max = x45;
            }
            if (y45min > y45) {
                y45min = y45;
            }
            if (!(y45max < y45)) continue;
            y45max = y45;
        }
        xmin = Math.min(xmin, x45min);
        xmax = Math.max(xmax, x45max);
        ymin = Math.min(ymin, y45min);
        ymax = Math.max(ymax, y45max);
        NLDRect bounds = group.getBound();
        double xRatio = (double)bounds.width() / ((xmax += (double)halfSpacing) - (xmin -= (double)halfSpacing));
        double yRatio = (double)bounds.height() / ((ymax += (double)halfSpacing) - (ymin -= (double)halfSpacing));
        for (int i2 = 0; i2 < nNodes; ++i2) {
            nodeIdx = group.getNode(i2).getIndex();
            NLDNode n2 = (NLDNode)this.nodes.elementAt(nodeIdx);
            x = n2.orgXpos;
            y = n2.orgYpos;
            x = (x - xmin) * xRatio + (double)bounds.left;
            y = (y - ymin) * yRatio + (double)bounds.top;
            n2.orgXpos = x;
            n2.orgYpos = y;
        }
        return true;
    }

    private boolean calculateCentroid() {
        double oldxmin = Double.POSITIVE_INFINITY;
        double oldxmax = Double.NEGATIVE_INFINITY;
        double oldymin = Double.POSITIVE_INFINITY;
        double oldymax = Double.NEGATIVE_INFINITY;
        int i = 0;
        while ((long)i < this.nodeCount) {
            NLDNode n = (NLDNode)this.nodes.elementAt(i);
            if (n.isVisible()) {
                double x = n.orgXpos;
                double y = n.orgYpos;
                if (i == 0) {
                    oldxmin = oldxmax = x;
                    oldymin = oldymax = y;
                } else {
                    oldxmin = Math.min(x, oldxmin);
                    oldxmax = Math.max(x, oldxmax);
                    oldymin = Math.min(y, oldymin);
                    oldymax = Math.max(y, oldymax);
                }
            }
            ++i;
        }
        this.oldxm = (oldxmin + oldxmax) / 2.0;
        this.oldym = (oldymin + oldymax) / 2.0;
        this.oldxd = oldxmax - oldxmin;
        this.oldyd = oldymax - oldymin;
        double fac = 0.0;
        fac = this.visNodeCount == 1 ? 0.01 : 0.6 + 0.1 * Math.min(2.0, Math.sqrt(this.visNodeCount));
        double newxmin = -fac;
        double newxmax = fac;
        double newymin = -fac;
        double newymax = fac;
        this.newxm = (newxmin + newxmax) / 2.0;
        this.newym = (newymin + newymax) / 2.0;
        this.newxd = newxmax - newxmin;
        this.newyd = newymax - newymin;
        return true;
    }

    private void applyTransf() {
        double yexp;
        double xexp;
        double xshift = this.newxm - this.oldxm;
        double yshift = this.newym - this.oldym;
        if (this.visNodeCount == 1) {
            xexp = this.newxd / (this.oldxd + 1.0);
            yexp = this.newyd / (this.oldyd + 1.0);
        } else {
            xexp = this.newxd / this.oldxd;
            yexp = this.newyd / this.oldyd;
        }
        double expand = Math.min(xexp, yexp);
        int i = 0;
        while ((long)i < this.nodeCount) {
            NLDNode n = (NLDNode)this.nodes.elementAt(i);
            if (n.isVisible()) {
                double x = n.orgXpos + xshift;
                double y = n.orgYpos + yshift;
                x = this.newxm + (x - this.newxm) * expand;
                y = this.newym + (y - this.newym) * expand;
                n.xpos = x;
                n.ypos = y;
            }
            ++i;
        }
    }

    public boolean apply() {
        if (!this.layoutCmps()) {
            return false;
        }
        for (int i = 0; i < this.nGroups; ++i) {
            if (this.doNodeLayout((Group)this.groups.elementAt(i)) && this.scaleToFit((Group)this.groups.elementAt(i))) continue;
        }
        this.calculateCentroid();
        this.applyTransf();
        return true;
    }

    public void shrinkModelToUnitSpace() {
        double boxHeight;
        double orgXmin = Double.POSITIVE_INFINITY;
        double orgYmin = Double.POSITIVE_INFINITY;
        double orgXmax = Double.NEGATIVE_INFINITY;
        double orgYmax = Double.NEGATIVE_INFINITY;
        orgXmin = Double.POSITIVE_INFINITY;
        orgYmin = Double.POSITIVE_INFINITY;
        orgXmax = Double.NEGATIVE_INFINITY;
        orgYmax = Double.NEGATIVE_INFINITY;
        int i = 0;
        while ((long)i < this.nodeCount) {
            NLDNode currNode = (NLDNode)this.nodes.elementAt(i);
            if (currNode.isVisible()) {
                orgXmin = Math.min(orgXmin, currNode.orgXpos);
                orgYmin = Math.min(orgYmin, currNode.orgYpos);
                orgXmax = Math.max(orgXmax, currNode.orgXpos);
                orgYmax = Math.max(orgYmax, currNode.orgYpos);
            }
            ++i;
        }
        double boxWidth = orgXmax - orgXmin;
        if (boxWidth == 0.0) {
            boxWidth = 1.0E-8;
        }
        if ((boxHeight = orgYmax - orgYmin) == 0.0) {
            boxHeight = 1.0E-8;
        }
        double widthR = 0.0;
        double heightR = 0.0;
        if (boxWidth >= boxHeight) {
            widthR = 2.0;
            heightR = boxHeight / boxWidth;
        } else {
            heightR = 2.0;
            widthR = boxWidth / boxHeight;
        }
        int i2 = 0;
        while ((long)i2 < this.nodeCount) {
            NLDNode currNode = (NLDNode)this.nodes.elementAt(i2);
            if (currNode.isVisible()) {
                currNode.orgXpos = widthR / boxWidth * (currNode.orgXpos - orgXmin);
                currNode.orgYpos = heightR / boxHeight * (currNode.orgYpos - orgYmin);
            }
            ++i2;
        }
    }

    class Node {
        protected int m_index = -1;
        protected boolean m_visited = false;
        protected Vector m_linksVec = new Vector();
        protected int m_value;

        public Node(int index) {
            this.m_index = index;
            this.m_visited = false;
        }

        private boolean sortLinks() {
            int nLinks = this.m_linksVec.size();
            if (nLinks == 0) {
                return false;
            }
            if (nLinks == 1) {
                return true;
            }
            try {
                SortContext.mergesort(this.m_linksVec, 0, nLinks);
            }
            catch (Exception e) {
                System.out.println("Exception while sorting nodes!!!!");
                e.printStackTrace();
                return false;
            }
            return true;
        }

        public int getIndex() {
            return this.m_index;
        }

        private boolean isVisited() {
            return this.m_visited;
        }

        private void setVisited(boolean visited) {
            this.m_visited = visited;
        }

        int getNumLinks() {
            return this.m_linksVec != null ? this.m_linksVec.size() : -1;
        }

        private void addLink(Link lnk) {
            int nLinks = this.m_linksVec.size();
            for (int i = 0; i < nLinks; ++i) {
                Link l = (Link)this.m_linksVec.elementAt(i);
                if (l.getIndex() != lnk.getIndex()) continue;
                return;
            }
            this.m_linksVec.addElement(lnk);
        }

        private Link getLink(int i) {
            return (Link)this.m_linksVec.elementAt(i);
        }

        private void setValue(int value) {
            this.m_value = value;
        }

        private int getValue() {
            return this.m_value;
        }
    }

    class Link {
        private int m_index = -1;
        private double m_value = 0.0;

        public Link(int index) {
            this.m_index = index;
            this.m_value = 0.0;
        }

        public int getIndex() {
            return this.m_index;
        }

        private void setValue(double value) {
            this.m_value = value;
        }

        public double getValue() {
            return this.m_value;
        }
    }
}

