/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.nld;

import com.sas.graphics.util.nld.MyGridBagConstraints;
import com.sas.graphics.util.nld.NLDLink;
import com.sas.graphics.util.nld.NLDModel;
import com.sas.graphics.util.nld.NLDNode;
import com.sas.graphics.util.nld.NLDViewer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class NLDFilterDlg
extends JDialog {
    private static final int NONE = 0;
    private static final int EQUALS = 1;
    private static final int STARTSWITH = 2;
    private static final int CONTAINS = 3;
    private static final int LESSTHAN = 4;
    private static final int LESSTHANOREQ = 5;
    private static final int GREATERTHAN = 6;
    private static final int GREATERTHANOREQ = 7;
    private boolean showCenterSelected = false;
    public NLDModel model = null;
    public NLDViewer viewer = null;
    boolean fComponentsAdjusted = false;
    JLabel label1 = new JLabel();
    JList attrList = new JList();
    JList cmpList = new JList();
    JTextField target = new JTextField(20);
    JCheckBox ignoreCase = new JCheckBox();
    JCheckBox extend = new JCheckBox();
    JCheckBox bring2Center = new JCheckBox();
    JButton OK = new JButton();
    JButton Cancel = new JButton();
    JButton Apply = new JButton();

    public NLDFilterDlg(Frame parent, NLDViewer v, boolean modal, boolean flag) {
        this(parent, v, flag);
        this.setModal(modal);
    }

    public NLDFilterDlg(Frame parent, NLDViewer v, boolean flag) {
        super(parent);
        this.showCenterSelected = flag;
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        this.setBackground(Color.lightGray);
        int width = 500;
        int height = 250;
        Dimension dim = v.getRBSize("FilterDialog.size", width, height);
        if (dim != null) {
            width = dim.width;
            height = dim.height;
        }
        this.setSize(width, height);
        this.setVisible(false);
        this.label1.setText(v.GRS("Filter.selectNodes.txt", "Select nodes where:"));
        c.add((Component)this.label1, new MyGridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.label1.setBounds(5, 5, 126, 23);
        Vector<String> attrListData = new Vector<String>();
        attrListData.add(v.GRS("Filter.label.txt", "label"));
        if (v.isNTipPresent()) {
            attrListData.add(v.GRS("Filter.tip.txt", "tip"));
        }
        this.attrList.setListData(attrListData);
        JScrollPane attrListScrollPane = new JScrollPane(this.attrList);
        c.add((Component)attrListScrollPane, new MyGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.attrList.setBackground(Color.white);
        this.attrList.setBounds(5, 38, 124, 64);
        Vector<String> cmpListData = new Vector<String>();
        cmpListData.add(v.GRS("Filter.equals.txt", "equals"));
        cmpListData.add(v.GRS("Filter.startsWith.txt", "starts with"));
        cmpListData.add(v.GRS("Filter.contains.txt", "contains"));
        cmpListData.add(v.GRS("Filter.lessThan.txt", "less than"));
        cmpListData.add(v.GRS("Filter.lessThanorEq.txt", "less than or equal to"));
        cmpListData.add(v.GRS("Filter.greaterThan.txt", "greater than"));
        cmpListData.add(v.GRS("Filter.greaterThanOrEq.txt", "greater than or equal to"));
        this.cmpList.setListData(cmpListData);
        JScrollPane cmpListScrollPane = new JScrollPane(this.cmpList);
        c.add((Component)cmpListScrollPane, new MyGridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.cmpList.setBackground(Color.white);
        this.cmpList.setBounds(139, 38, 163, 126);
        c.add((Component)this.target, new MyGridBagConstraints(2, 1, 1, 1, 2.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.target.setBounds(312, 38, 182, 23);
        this.ignoreCase.setSelected(true);
        this.ignoreCase.setText(v.GRS("Filter.ignoreCase.txt", "ignore case"));
        this.ignoreCase.setBounds(19, 179, 95, 23);
        c.add((Component)this.ignoreCase, new MyGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        if (this.showCenterSelected) {
            this.bring2Center.setSelected(true);
            this.bring2Center.setText(v.GRS("Filter.centerSel.txt", "center selected node"));
            this.bring2Center.setBounds(120, 179, 160, 23);
            c.add((Component)this.bring2Center, new MyGridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.extend.setText(v.GRS("Filter.extendCurrent.txt", "extend current selection"));
        c.add((Component)this.extend, new MyGridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 10, 0), 0, 0));
        this.extend.setBounds(307, 179, 160, 23);
        this.OK.setText(v.GRS("Filter.OK.txt", "OK"));
        c.add((Component)this.OK, new MyGridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 20, 5));
        this.OK.setBackground(Color.lightGray);
        this.OK.setBounds(41, 217, 51, 28);
        this.Cancel.setText(v.GRS("Filter.Cancel.txt", "Cancel"));
        c.add((Component)this.Cancel, new MyGridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 5, 5));
        this.Cancel.setBackground(Color.lightGray);
        this.Cancel.setBounds(191, 217, 58, 28);
        this.Apply.setText(v.GRS("Filter.Apply.txt", "Apply"));
        c.add((Component)this.Apply, new MyGridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 10, 5));
        this.Apply.setBackground(Color.lightGray);
        this.Apply.setBounds(376, 217, 53, 28);
        this.setTitle(v.GRS("Filter.FilterDialog.txt", "Filter Dialog"));
        this.attrList.setSelectedIndex(0);
        this.cmpList.setSelectedIndex(1);
        this.viewer = v;
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        SymAction lSymAction = new SymAction();
        this.OK.addActionListener(lSymAction);
        this.Apply.addActionListener(lSymAction);
        this.Cancel.addActionListener(lSymAction);
    }

    @Override
    public void addNotify() {
        Dimension d = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        Insets ins = this.getInsets();
        this.setSize(ins.left + ins.right + d.width, ins.top + ins.bottom + d.height);
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Point p = components[i].getLocation();
            p.translate(ins.left, ins.top);
            components[i].setLocation(p);
        }
        this.fComponentsAdjusted = true;
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            Rectangle bounds = this.getParent().getBounds();
            Rectangle abounds = this.getBounds();
            this.setLocation(bounds.x + (bounds.width - abounds.width) / 2, bounds.y + (bounds.height - abounds.height) / 2);
        }
        super.setVisible(b);
    }

    @Override
    public void show() {
        super.show();
        String str = this.target.getText();
        if (str != null) {
            this.target.setCaretPosition(0);
        }
    }

    void FilterDlg_WindowClosing(WindowEvent event) {
        this.dispose();
    }

    void OK_ActionPerformed(ActionEvent event) {
        this.setVisible(false);
        this.viewer.repaint();
        this.applyFilter();
        this.dispose();
    }

    void Apply_ActionPerformed(ActionEvent event) {
        this.applyFilter();
    }

    void Cancel_ActionPerformed(ActionEvent event) {
        this.dispose();
    }

    void applyFilter() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.viewer.setCursor(Cursor.getPredefinedCursor(3));
        NLDNode n = null;
        int sindex = -1;
        String value = null;
        boolean ext = this.extend.isSelected();
        boolean ignore = this.ignoreCase.isSelected();
        boolean match = false;
        String targ = this.target.getText();
        boolean selected = false;
        boolean labels = ((String)this.attrList.getSelectedValue()).equalsIgnoreCase(this.viewer.GRS("Filter.label.txt", "label"));
        boolean tips = ((String)this.attrList.getSelectedValue()).equalsIgnoreCase(this.viewer.GRS("Filter.tip.txt", "tip"));
        boolean center = this.bring2Center != null ? this.bring2Center.isSelected() : false;
        int filterType = 0;
        if (((String)this.cmpList.getSelectedValue()).equalsIgnoreCase(this.viewer.GRS("Filter.equals.txt", "equals"))) {
            filterType = 1;
        } else if (((String)this.cmpList.getSelectedValue()).equalsIgnoreCase(this.viewer.GRS("Filter.startsWith.txt", "starts with"))) {
            filterType = 2;
        } else if (((String)this.cmpList.getSelectedValue()).equalsIgnoreCase(this.viewer.GRS("Filter.contains.txt", "contains"))) {
            filterType = 3;
        } else if (((String)this.cmpList.getSelectedValue()).equalsIgnoreCase(this.viewer.GRS("Filter.lessThan.txt", "less than"))) {
            filterType = 4;
        } else if (((String)this.cmpList.getSelectedValue()).equalsIgnoreCase(this.viewer.GRS("Filter.lessThanOrEq.txt", "less than or equal to"))) {
            filterType = 5;
        } else if (((String)this.cmpList.getSelectedValue()).equalsIgnoreCase(this.viewer.GRS("Filter.greaterThan.txt", "greater than"))) {
            filterType = 6;
        } else if (((String)this.cmpList.getSelectedValue()).equalsIgnoreCase(this.viewer.GRS("Filter.greaterThanOrEq.txt", "greater than or equal to"))) {
            filterType = 7;
        }
        if (ignore) {
            targ = targ.toUpperCase();
        }
        Vector<Integer> selNodes = new Vector<Integer>();
        for (int i = 0; i < this.model.nodes.size(); ++i) {
            n = (NLDNode)this.model.nodes.elementAt(i);
            if (labels) {
                value = n.label;
            } else if (tips) {
                value = n.info;
            }
            if (value == null) continue;
            if (ignore) {
                value = value.toUpperCase();
            }
            switch (filterType) {
                case 1: {
                    match = value.equals(targ);
                    break;
                }
                case 2: {
                    match = value.startsWith(targ);
                    break;
                }
                case 3: {
                    match = value.indexOf(targ) >= 0;
                    break;
                }
                case 4: {
                    match = value.compareTo(targ) < 0;
                    break;
                }
                case 5: {
                    match = value.compareTo(targ) <= 0;
                    break;
                }
                case 6: {
                    match = value.compareTo(targ) > 0;
                    break;
                }
                case 7: {
                    match = value.compareTo(targ) >= 0;
                    break;
                }
            }
            if (ext) {
                if (n.selected || match) {
                    selNodes.add(new Integer(i));
                    this.model.nodes.setSelected(i, true);
                } else {
                    this.model.nodes.setSelected(i, false);
                }
            } else if (match) {
                selNodes.add(new Integer(i));
                this.model.nodes.setSelected(i, true);
            } else {
                this.model.nodes.setSelected(i, false);
            }
            boolean visible = this.viewer.isNodeDescendentOfRoot(i);
            if (selected || !match || !visible) continue;
            sindex = i;
            selected = true;
        }
        this.model.updateLinks();
        Vector<Integer> selLinks = new Vector<Integer>();
        for (int i = 0; i < this.model.links.size(); ++i) {
            NLDLink l = (NLDLink)this.model.links.elementAt(i);
            if (!l.isVisible() || !l.isSelected()) continue;
            selLinks.add(new Integer(i));
        }
        int[] selLinkIdx = null;
        int nSelLinks = selLinks.size();
        if (nSelLinks > 0) {
            selLinkIdx = new int[nSelLinks];
            for (int i = 0; i < nSelLinks; ++i) {
                selLinkIdx[i] = ((Number)selLinks.elementAt(i)).intValue();
            }
        }
        int[] selIdx = null;
        int nSelNodes = selNodes.size();
        if (nSelNodes > 0) {
            selIdx = new int[nSelNodes];
            for (int i = 0; i < nSelNodes; ++i) {
                selIdx[i] = ((Number)selNodes.elementAt(i)).intValue();
            }
        }
        if (nSelLinks > 0 || nSelNodes > 0) {
            this.viewer.buildSelected(selIdx, nSelNodes, selLinkIdx, nSelLinks);
        }
        if (selected) {
            this.viewer.setDeselectAll(false);
            if (center) {
                n = (NLDNode)this.model.nodes.elementAt(sindex);
                this.viewer.centerNode(n, false);
                this.viewer.rebuild(true);
            } else {
                this.viewer.repaint();
            }
        } else {
            this.viewer.repaint();
        }
        this.setCursor(Cursor.getDefaultCursor());
        this.viewer.setCursor(Cursor.getDefaultCursor());
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == NLDFilterDlg.this.OK) {
                NLDFilterDlg.this.OK_ActionPerformed(event);
            } else if (object == NLDFilterDlg.this.Apply) {
                NLDFilterDlg.this.Apply_ActionPerformed(event);
            } else if (object == NLDFilterDlg.this.Cancel) {
                NLDFilterDlg.this.Cancel_ActionPerformed(event);
            }
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == NLDFilterDlg.this) {
                NLDFilterDlg.this.FilterDlg_WindowClosing(event);
            }
        }
    }
}

