/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.nld;

import com.sas.graphics.util.nld.NLDHierarchyLayout;
import com.sas.graphics.util.nld.NLDRect;
import com.sas.graphics.util.nld.SortContext;
import java.util.Vector;

public class Group {
    private int groupIdx = -1;
    private Vector memberNodes = null;
    private NLDRect bound = null;
    private NLDHierarchyLayout.Node fakeRoot = null;

    public Group(int idx) {
        this.groupIdx = idx;
        this.memberNodes = new Vector();
        this.bound = new NLDRect();
        this.fakeRoot = null;
    }

    public void setFakeRoot(NLDHierarchyLayout.Node n) {
        this.fakeRoot = n;
    }

    public NLDHierarchyLayout.Node getFakeRoot() {
        return this.fakeRoot;
    }

    public boolean sortNodes() {
        int nNodes = this.memberNodes.size();
        if (nNodes == 0) {
            return false;
        }
        if (nNodes == 1) {
            return true;
        }
        try {
            SortContext.mergesort(this.memberNodes, 0, nNodes);
        }
        catch (Exception e) {
            System.out.println("Exception while sorting nodes!!!!");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public int getIdx() {
        return this.groupIdx;
    }

    public int getSize() {
        return this.memberNodes != null ? this.memberNodes.size() : -1;
    }

    public void addNode(NLDHierarchyLayout.Node pNode) {
        this.memberNodes.addElement(pNode);
    }

    public Vector getMemberNodes() {
        return this.memberNodes;
    }

    public NLDHierarchyLayout.Node getNode(int idx) {
        if (idx < 0 || idx >= this.memberNodes.size()) {
            return null;
        }
        return (NLDHierarchyLayout.Node)this.memberNodes.elementAt(idx);
    }

    public void setBounds(NLDRect rect) {
        this.bound = rect;
    }

    public NLDRect getBound() {
        return this.bound;
    }
}

