/*
 * Decompiled with CFR 0.152.
 */
package MITI.stitching.memory.generic;

import MITI.lineage.links.Link;
import MITI.lineage.links.Links;
import MITI.sdk.MIRCondition;
import MITI.sdk.MIRDimensionAttribute;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRFilter;
import MITI.sdk.MIRLevelAttribute;
import MITI.sdk.MIRObject;
import MITI.sdk.mix.MIRObjectCache;
import MITI.server.services.common.mir.ObjectIdentifier;
import MITI.stitching.generic.GenericStitchingObject;
import MITI.stitching.memory.MirStitchableObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GenericStitchableObject
extends MirStitchableObject<GenericStitchableObject>
implements GenericStitchingObject {
    public GenericStitchableObject(MIRObject mIRObject) {
        super(mIRObject);
    }

    public List<GenericStitchableObject> getChildren(MIRObjectCache mIRObjectCache, Links links, short s) {
        ArrayList<GenericStitchableObject> arrayList = new ArrayList<GenericStitchableObject>();
        ObjectIdentifier objectIdentifier = mIRObjectCache.getObjectIdentifier(this.object);
        for (Link link : links.getLinksFromSourceObject(objectIdentifier, Collections.singleton(7))) {
            arrayList.add(new GenericStitchableObject(mIRObjectCache.getMirObject(link.getDestinationId())));
        }
        return arrayList;
    }

    @Override
    public boolean isDefault() {
        if (this.object instanceof MIRLevelAttribute) {
            return ((MIRLevelAttribute)this.object).getDefaultOfLevel() != null;
        }
        return false;
    }

    @Override
    public boolean isReferenced() {
        if (this.object instanceof MIRDimensionAttribute) {
            return ((MIRDimensionAttribute)this.object).getLevelAttributeCount() > 0;
        }
        if (this.object instanceof MIRCondition) {
            return this.object.getParent() instanceof MIRFilter;
        }
        return false;
    }

    @Override
    public int getLength() {
        MIRFeature mIRFeature;
        if (this.object instanceof MIRFeature && (mIRFeature = (MIRFeature)this.object).getType() != null) {
            return mIRFeature.getType().getLength();
        }
        return 0;
    }
}

