/*
 * Decompiled with CFR 0.152.
 */
package MITI.stitching.memory;

import MITI.MIRException;
import MITI.lineage.links.Links;
import MITI.lineage.links.ModelLineageBuilder;
import MITI.messages.MIRStitchingUtil.STCHU;
import MITI.sdk.MIRConnection;
import MITI.sdk.MIRContent;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRStoreConnection;
import MITI.sdk.MIRStoreContent;
import MITI.sdk.MIRStoreModel;
import MITI.sdk.mix.MIRObjectCache;
import MITI.server.services.common.AuthenticationException;
import MITI.server.services.common.AuthorizationException;
import MITI.server.services.common.mir.ObjectIdentifier;
import MITI.server.services.common.mir.StitchingRule;
import MITI.stitching.Stitching;
import MITI.stitching.StitchingContext;
import MITI.stitching.StitchingObjectCache;
import MITI.stitching.base.StitchingException;
import MITI.stitching.base.StitchingOptions;
import MITI.stitching.memory.StitchingUtil;
import MITI.stitching.memory.generic.GenericMemoryStitcher;
import MITI.stitching.memory.generic.GenericStitchableObject;
import MITI.stitching.memory.microstrategy.MicrostrategyMemoryStitcher;
import MITI.stitching.memory.microstrategy.MicrostrategyStitchableObject;
import MITI.stitching.memory.nativeId.NativeIdMemoryStitcher;
import MITI.stitching.memory.nativeId.NativeIdStitchableObject;
import MITI.stitching.memory.tableau.TableauMemoryStitcher;
import MITI.stitching.memory.tableau.TableauStitchableObject;
import java.util.TreeMap;

public class Stitcher {
    private TreeMap<ObjectIdentifier, Links> modelLinks = new TreeMap();
    private StitchingObjectCache<GenericStitchableObject> genericModels = new StitchingObjectCache();
    private StitchingObjectCache<NativeIdStitchableObject> nativeIdModels = new StitchingObjectCache();
    private StitchingObjectCache<MicrostrategyStitchableObject> mstrModels = new StitchingObjectCache();
    private MIRObjectCache cache;

    public Stitcher(MIRObjectCache mIRObjectCache) {
        this.cache = mIRObjectCache;
    }

    public Stitching matchModels(MIRContent mIRContent, MIRConnection mIRConnection, MIRStoreContent mIRStoreContent) throws MIRException {
        String string = mIRConnection.getName();
        MIRStoreConnection mIRStoreConnection = StitchingUtil.findStoreConnection(mIRContent.getModel(), string);
        if (mIRStoreConnection == null) {
            throw new StitchingException(STCHU.ERR_STITCHING_CONNECTION_RULE_MISTMATCH.getMessage(string, mIRContent.getName()));
        }
        StitchingContext stitchingContext = new StitchingContext(mIRStoreContent.getPath(), mIRContent.getPath(), mIRConnection.getName());
        short s = mIRConnection.getMatchingRule();
        StitchingRule stitchingRule = StitchingRule.deserialize(mIRConnection.getRules());
        try {
            return this.matchModels(mIRContent, mIRStoreConnection, (MIRStoreModel)mIRStoreContent.getModel(), stitchingRule, s, stitchingContext);
        }
        catch (AuthenticationException | AuthorizationException exception) {
            return null;
        }
    }

    public void unload(MIRContent mIRContent) {
        MIRModel mIRModel = mIRContent.getModel();
        if (mIRModel != null) {
            ObjectIdentifier objectIdentifier = this.cache.getObjectIdentifier(mIRModel);
            this.modelLinks.remove(objectIdentifier);
            this.genericModels.removeModel(objectIdentifier);
            this.nativeIdModels.removeModel(objectIdentifier);
            this.mstrModels.removeModel(objectIdentifier);
        }
    }

    private Stitching matchModels(MIRContent mIRContent, MIRStoreConnection mIRStoreConnection, MIRStoreModel mIRStoreModel, StitchingRule stitchingRule, short s, StitchingContext stitchingContext) throws AuthenticationException, AuthorizationException, MIRException {
        StitchingOptions.MatchCase matchCase = StitchingOptions.MatchCase.DEFAULT;
        if (s == 0) {
            if (mIRContent.getElementType() == 278 || mIRContent.getElementType() == 283 || mIRContent.getElementType() == 343) {
                if (mIRStoreConnection.getStoreType() == 2) {
                    s = (short)2;
                    matchCase = StitchingOptions.MatchCase.SENSITIVE;
                } else {
                    s = (short)14;
                }
            } else if (mIRStoreConnection.getConnectionElementCount() + mIRStoreConnection.getConnectionClassifierCount() > 0) {
                s = mIRStoreConnection.getStoreType() == 4 ? (short)7 : (short)6;
            } else if (mIRStoreConnection.getStoreType() == 0) {
                s = 1;
            } else if (mIRStoreConnection.getStoreType() == 2) {
                s = (short)2;
            } else if (mIRStoreConnection.getStoreType() == 1) {
                s = (short)3;
            } else if (mIRStoreConnection.getStoreType() == 3) {
                s = (short)5;
            } else if (mIRStoreConnection.getStoreType() == 4) {
                s = (short)7;
            } else if (mIRStoreConnection.getStoreType() == 5) {
                s = (short)13;
            } else {
                throw new StitchingException(STCHU.ERR_UNSUPPORTED_STITCHING.getMessage(new Object[0]));
            }
        }
        ObjectIdentifier objectIdentifier = this.cache.getObjectIdentifier(mIRStoreModel);
        Links links = new Links();
        Links links2 = this.modelLinks.get(objectIdentifier);
        if (links2 == null) {
            links2 = ModelLineageBuilder.buildLinks(mIRStoreModel, this.cache);
            this.modelLinks.put(objectIdentifier, links2);
        }
        links.addLinks(links2);
        StitchingOptions.MatchCase matchCase2 = StitchingOptions.MatchCase.getByType(mIRStoreModel.getSystemCase());
        StitchingOptions stitchingOptions = new StitchingOptions(stitchingRule, s, matchCase2 != StitchingOptions.MatchCase.DEFAULT ? matchCase2 : matchCase, false);
        if (stitchingOptions.getMatchingRule() == 7) {
            MicrostrategyMemoryStitcher microstrategyMemoryStitcher = new MicrostrategyMemoryStitcher(stitchingOptions);
            MicrostrategyStitchableObject microstrategyStitchableObject = new MicrostrategyStitchableObject(mIRStoreConnection);
            MicrostrategyStitchableObject microstrategyStitchableObject2 = this.mstrModels.getModel(new MicrostrategyStitchableObject(mIRStoreModel));
            return microstrategyMemoryStitcher.stitch(stitchingContext, microstrategyStitchableObject, microstrategyStitchableObject2);
        }
        if (stitchingOptions.getMatchingRule() == 13) {
            Links links3 = ModelLineageBuilder.buildLinks(mIRStoreConnection.getModel(), this.cache);
            links.addLinks(links3);
            TableauMemoryStitcher tableauMemoryStitcher = new TableauMemoryStitcher(this.cache, links, stitchingOptions);
            TableauStitchableObject tableauStitchableObject = new TableauStitchableObject(mIRStoreConnection);
            TableauStitchableObject tableauStitchableObject2 = new TableauStitchableObject(mIRStoreModel);
            return tableauMemoryStitcher.stitch(stitchingContext, tableauStitchableObject, tableauStitchableObject2);
        }
        if (stitchingOptions.getMatchingRule() == 6) {
            Links links4 = ModelLineageBuilder.buildLinks(mIRStoreConnection.getModel(), this.cache);
            links.addLinks(links4);
            NativeIdMemoryStitcher nativeIdMemoryStitcher = new NativeIdMemoryStitcher(this.cache, links, stitchingOptions);
            NativeIdStitchableObject nativeIdStitchableObject = new NativeIdStitchableObject(mIRStoreConnection);
            NativeIdStitchableObject nativeIdStitchableObject2 = this.nativeIdModels.getModel(new NativeIdStitchableObject(mIRStoreModel));
            return nativeIdMemoryStitcher.stitch(stitchingContext, nativeIdStitchableObject, nativeIdStitchableObject2);
        }
        Links links5 = ModelLineageBuilder.buildLinks(mIRStoreConnection.getModel(), this.cache);
        links.addLinks(links5);
        GenericMemoryStitcher genericMemoryStitcher = new GenericMemoryStitcher(this.cache, links, stitchingOptions);
        GenericStitchableObject genericStitchableObject = new GenericStitchableObject(mIRStoreConnection);
        GenericStitchableObject genericStitchableObject2 = this.genericModels.getModel(new GenericStitchableObject(mIRStoreModel));
        return genericMemoryStitcher.stitch(stitchingContext, genericStitchableObject, genericStitchableObject2);
    }
}

