/*
 * Decompiled with CFR 0.152.
 */
package MITI.stitching.memory;

import MITI.lineage.links.LineageNodeFlags;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRObject;
import MITI.server.services.common.mir.ObjectIdentifier;
import MITI.stitching.StitchingObject;

public class MirStitchableObject<T extends StitchingObject<T>>
extends StitchingObject<T> {
    protected MIRObject object;
    private int flags;
    private boolean objectNameStitchable = true;

    protected MirStitchableObject(MIRObject mIRObject) {
        this.object = mIRObject;
        this.flags = LineageNodeFlags.computeFlags(mIRObject);
    }

    @Override
    public ObjectIdentifier getObjectId() {
        return new ObjectIdentifier(this.object.getModelId(), this.object.getObjectId());
    }

    @Override
    public String getName() {
        String string = "";
        if (this.object instanceof MIRModelObject) {
            string = ((MIRModelObject)this.object).getPhysicalName();
        }
        if (string.isEmpty()) {
            return this.object.getName();
        }
        return string;
    }

    @Override
    public int getPosition() {
        if (this.object instanceof MIRFeature) {
            return ((MIRFeature)this.object).getPosition();
        }
        return -1;
    }

    @Override
    public int getType() {
        if (this.isFeature()) {
            return 77;
        }
        if (this.object.isInstanceOf((short)75) || this.object.isInstanceOf((short)124)) {
            return 75;
        }
        if (this.isSchema()) {
            return 141;
        }
        if (this.isNamespace()) {
            return 198;
        }
        return this.object.getElementType();
    }

    @Override
    public boolean isNamespace() {
        return this.object.isInstanceOf((short)207) || this.object.isInstanceOf((short)9) || this.object.isInstanceOf((short)321);
    }

    @Override
    public boolean isSchema() {
        return this.object.isInstanceOf((short)141) && !this.isNamespace();
    }

    @Override
    public boolean isClassifier() {
        return this.object.isInstanceOf((short)75);
    }

    @Override
    public boolean isHierarchy() {
        return this.object.isInstanceOf((short)90);
    }

    @Override
    public boolean isFeature() {
        return this.object.isInstanceOf((short)77) || this.object.isInstanceOf((short)123);
    }

    public boolean isDefault() {
        return false;
    }

    public boolean isSynonym() {
        return this.object.isInstanceOf((short)49);
    }

    public boolean isReferenced() {
        return false;
    }

    @Override
    public String getPath() {
        return this.object.getPath();
    }

    protected int getFlags() {
        return this.flags;
    }

    public MIRObject getObject() {
        return this.object;
    }

    public boolean isObjectNameStitchable() {
        return this.objectNameStitchable;
    }

    public void setObjectNameStitchable(boolean bl) {
        this.objectNameStitchable = bl;
    }

    @Override
    protected boolean hasFlag(int n) {
        return (this.flags & n) == n;
    }
}

