/*
 * Decompiled with CFR 0.152.
 */
package MITI.stitching.base;

import MITI.server.services.common.mir.StitchingRule;
import MITI.stitching.StitchingObject;
import java.util.Map;

public class StitchingOptions {
    private StitchingRule stitchingRule;
    private short matchingRule;
    private MatchCase matchCase;
    private boolean hierarchical;

    public StitchingOptions(StitchingRule stitchingRule, short s, MatchCase matchCase, boolean bl) {
        this.stitchingRule = stitchingRule;
        this.matchingRule = s;
        this.matchCase = matchCase;
        this.hierarchical = bl;
    }

    public StitchingRule getStitchingRule() {
        return this.stitchingRule;
    }

    public short getMatchingRule() {
        return this.matchingRule;
    }

    public MatchCase getMatchCase() {
        return this.matchCase;
    }

    public boolean isHierarchical() {
        return this.hierarchical;
    }

    public boolean match(StitchingObject<?> stitchingObject, StitchingObject<?> stitchingObject2) {
        MatchCase matchCase = this.getMatchType(stitchingObject, stitchingObject2);
        if (stitchingObject.isFeature() && (this.matchingRule == 2 && !stitchingObject.isByName() || stitchingObject.isByPosition())) {
            return stitchingObject.getPosition() != -1 && stitchingObject.getPosition() == stitchingObject2.getPosition();
        }
        if (stitchingObject.isSchema()) {
            for (Map.Entry<String, String> entry : this.stitchingRule.getMappedSchemas().entrySet()) {
                if (!this.matchName(stitchingObject.getName(), entry.getKey(), matchCase)) continue;
                return this.matchName(stitchingObject2.getName(), entry.getValue(), matchCase);
            }
        }
        return this.matchName(stitchingObject.getName(), stitchingObject2.getName(), matchCase);
    }

    private MatchCase getMatchType(StitchingObject<?> stitchingObject, StitchingObject<?> stitchingObject2) {
        if (this.matchCase == MatchCase.DEFAULT) {
            if (this.matchingRule == 3 || this.matchingRule == 14) {
                return MatchCase.SENSITIVE;
            }
            if (stitchingObject.isCaseSensitive()) {
                return MatchCase.SENSITIVE;
            }
            if (stitchingObject2.isCaseSensitive()) {
                return MatchCase.DEFAULT;
            }
            return MatchCase.INSENSITIVE;
        }
        if (this.matchCase == MatchCase.INSENSITIVE && stitchingObject2.isCaseSensitive()) {
            return MatchCase.SENSITIVE;
        }
        return this.matchCase;
    }

    private boolean matchName(String string, String string2, MatchCase matchCase) {
        if (matchCase == MatchCase.SENSITIVE) {
            return string.equals(string2);
        }
        if (matchCase == MatchCase.INSENSITIVE) {
            return string.equalsIgnoreCase(string2);
        }
        return false;
    }

    public static enum MatchCase {
        DEFAULT,
        SENSITIVE,
        INSENSITIVE;


        public static MatchCase getByType(byte by) {
            switch (by) {
                case 2: {
                    return INSENSITIVE;
                }
                case 1: {
                    return SENSITIVE;
                }
            }
            return DEFAULT;
        }
    }
}

