/*
 * Decompiled with CFR 0.152.
 */
package MITI.stitching;

import MITI.server.services.common.mir.ObjectIdentifier;
import java.util.Collection;

public abstract class StitchingObject<T extends StitchingObject<T>>
implements Comparable<StitchingObject<T>> {
    private Collection<T> children = null;
    private Collection<T> references = null;
    private String path = null;

    public abstract ObjectIdentifier getObjectId();

    public abstract String getName();

    public abstract int getPosition();

    public abstract int getType();

    public abstract boolean isNamespace();

    public abstract boolean isSchema();

    public abstract boolean isClassifier();

    public abstract boolean isHierarchy();

    public abstract boolean isFeature();

    protected abstract boolean hasFlag(int var1);

    public boolean isAmbiguous() {
        return this.hasFlag(1);
    }

    public boolean isByName() {
        return this.hasFlag(8192);
    }

    public boolean isByPosition() {
        return this.hasFlag(512);
    }

    public boolean isCaseSensitive() {
        return this.hasFlag(4096);
    }

    public boolean isCondition() {
        return this.hasFlag(128);
    }

    public boolean isHierarchical() {
        return this.hasFlag(32768);
    }

    public boolean isPartitioned() {
        return this.hasFlag(16384);
    }

    public boolean isStar() {
        return this.hasFlag(256);
    }

    public boolean isTemporary() {
        return this.hasFlag(1024);
    }

    public Collection<T> getChildren() {
        return this.children;
    }

    public void setChildren(Collection<T> collection) {
        this.children = collection;
    }

    public Collection<T> getReferences() {
        return this.references;
    }

    public void setReferences(Collection<T> collection) {
        this.references = collection;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        this.path = string;
    }

    @Override
    public int compareTo(StitchingObject<T> stitchingObject) {
        return this.getObjectId().compareTo(stitchingObject.getObjectId());
    }
}

