/*
 * Decompiled with CFR 0.152.
 */
package MITI.lineage.links;

import MITI.bridges.bridgelib.MIRBridgeLib;
import MITI.lineage.links.AbstractLineageAugmenter;
import MITI.lineage.links.LineageObjectCollector;
import MITI.lineage.links.LineageUtil;
import MITI.lineage.links.Link;
import MITI.lineage.links.Links;
import MITI.lineage.links.PassThroughDetector;
import MITI.lineage.links.UpdatableViewDetector;
import MITI.sdk.MIRActivityStep;
import MITI.sdk.MIRBusinessRule;
import MITI.sdk.MIRClass;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRClassifierMap;
import MITI.sdk.MIRConceptualDomain;
import MITI.sdk.MIRConcreteType;
import MITI.sdk.MIRCondition;
import MITI.sdk.MIRConnection;
import MITI.sdk.MIRConnectionElement;
import MITI.sdk.MIRConnectionNamespace;
import MITI.sdk.MIRConnectionPackage;
import MITI.sdk.MIRContent;
import MITI.sdk.MIRDataPackage;
import MITI.sdk.MIRDerivedType;
import MITI.sdk.MIRDesignPackage;
import MITI.sdk.MIRDiModel;
import MITI.sdk.MIRDirectoryStructureModel;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRElementMap;
import MITI.sdk.MIREmbeddedCallTransformation;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRFeatureMap;
import MITI.sdk.MIRFilter;
import MITI.sdk.MIRFolder;
import MITI.sdk.MIRHierarchy;
import MITI.sdk.MIRHierarchyLevelAssociation;
import MITI.sdk.MIRJoin;
import MITI.sdk.MIRJoinCondition;
import MITI.sdk.MIRJoinRelationship;
import MITI.sdk.MIRJoinRole;
import MITI.sdk.MIRLevel;
import MITI.sdk.MIRLevelAttribute;
import MITI.sdk.MIRMeasure;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRObject;
import MITI.sdk.MIROperation;
import MITI.sdk.MIRPackage;
import MITI.sdk.MIRQueryJoin;
import MITI.sdk.MIRReportField;
import MITI.sdk.MIRReportItem;
import MITI.sdk.MIRSQLViewAttribute;
import MITI.sdk.MIRSQLViewEntity;
import MITI.sdk.MIRSqlQuery;
import MITI.sdk.MIRStepElement;
import MITI.sdk.MIRStepReference;
import MITI.sdk.MIRStoreConnection;
import MITI.sdk.MIRStoreContent;
import MITI.sdk.MIRStoreModel;
import MITI.sdk.MIRSummaryMap;
import MITI.sdk.MIRSynonym;
import MITI.sdk.MIRTerm;
import MITI.sdk.MIRTermRelationship;
import MITI.sdk.MIRTransformation;
import MITI.sdk.MIRType;
import MITI.sdk.MIR_Object;
import MITI.sdk.mix.MIRObjectCache;
import MITI.server.services.common.mir.ObjectIdentifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class ModelLineageBuilder
extends AbstractLineageAugmenter {
    private MIRObjectCache cache;
    private TreeSet<Link> list = new TreeSet();
    private TreeMap<ObjectIdentifier, ObjectIdentifier> parentIds = new TreeMap();
    private PassThroughDetector passThroughDetector = new PassThroughDetector(0, 0);

    public static Links buildLinks(MIRModel mIRModel, MIRObjectCache mIRObjectCache) {
        return ModelLineageBuilder.buildLinks(mIRModel, mIRObjectCache, null);
    }

    public static Links buildLinks(MIRModel mIRModel, MIRObjectCache mIRObjectCache, Set<MIRObject> set) {
        Links links = new Links();
        ModelLineageBuilder modelLineageBuilder = new ModelLineageBuilder(mIRObjectCache);
        if (set == null) {
            set = LineageObjectCollector.process(mIRModel);
        }
        for (Link link : modelLineageBuilder.buildLineageGraphLinks(set, UpdatableViewDetector.list(mIRModel))) {
            links.addLink(link);
        }
        return links;
    }

    public static final Collection<Link> getLinks(MIRModel mIRModel, MIRObjectCache mIRObjectCache) {
        return ModelLineageBuilder.getLinks(mIRModel, mIRObjectCache, null);
    }

    public static final Collection<Link> getLinks(MIRModel mIRModel, MIRObjectCache mIRObjectCache, Set<MIRObject> set) {
        ModelLineageBuilder modelLineageBuilder = new ModelLineageBuilder(mIRObjectCache);
        if (set == null) {
            set = LineageObjectCollector.process(mIRModel);
        }
        return modelLineageBuilder.buildLineageGraphLinks(set, UpdatableViewDetector.list(mIRModel));
    }

    private ModelLineageBuilder(MIRObjectCache mIRObjectCache) {
        this.cache = mIRObjectCache;
    }

    private boolean isTableauDataSource(MIRObject mIRObject) {
        MIRModel mIRModel;
        if (mIRObject != null && (mIRModel = mIRObject.getRootModel()) instanceof MIRStoreModel) {
            return ((MIRStoreModel)mIRModel).getStoreType() == 5;
        }
        return false;
    }

    private final ObjectIdentifier getObjectIdentifier(MIRObject mIRObject) {
        return this.cache.getObjectIdentifier(mIRObject);
    }

    private Collection<Link> buildLineageGraphLinks(Set<MIRObject> set, Set<MIRSQLViewEntity> set2) {
        ArrayList<MIRQueryJoin> arrayList = new ArrayList<MIRQueryJoin>();
        ArrayList<MIRFilter> arrayList2 = new ArrayList<MIRFilter>();
        for (MIRObject mIRObject : set) {
            if (mIRObject.isInstanceOf((short)77)) {
                if (mIRObject.isInstanceOf((short)337)) continue;
                this.getFeatureLineageNode((MIRFeature)mIRObject);
                if (!mIRObject.isInstanceOf((short)334) || ((MIRQueryJoin)mIRObject).getTopOfSqlQuery() == null) continue;
                arrayList.add((MIRQueryJoin)mIRObject);
                continue;
            }
            if (mIRObject.isInstanceOf((short)123)) {
                this.createReportFieldLineageNode((MIRReportField)mIRObject);
                continue;
            }
            if (mIRObject.isInstanceOf((short)75)) {
                if (mIRObject.isInstanceOf((short)89)) {
                    arrayList2.add((MIRFilter)mIRObject);
                }
                this.getClassifierLineageNode((MIRClassifier)mIRObject);
                continue;
            }
            if (mIRObject.isInstanceOf((short)90)) {
                this.getHierarchyLineageNode((MIRHierarchy)mIRObject);
                continue;
            }
            if (mIRObject.isInstanceOf((short)317)) {
                this.createConnectionElementLineageNode((MIRConnectionElement)mIRObject);
                continue;
            }
            if (mIRObject.isInstanceOf((short)203)) {
                this.getTermLineageNode((MIRTerm)mIRObject);
                continue;
            }
            if (mIRObject.isInstanceOf((short)205)) {
                this.getConceptualDomainLineageNode((MIRConceptualDomain)mIRObject);
                continue;
            }
            if (mIRObject.isInstanceOf((short)5)) {
                this.getTypeLineageNode((MIRDerivedType)mIRObject);
                continue;
            }
            if (mIRObject.isInstanceOf((short)321)) {
                this.getConnectionNamespaceLineageNode((MIRConnectionNamespace)mIRObject);
                continue;
            }
            if (mIRObject.isInstanceOf((short)215)) {
                this.getPackageLineageNode((MIRConnectionPackage)mIRObject);
                continue;
            }
            if (mIRObject.isInstanceOf((short)297)) {
                this.getStepLineageNode((MIRActivityStep)mIRObject);
                continue;
            }
            if (mIRObject.isInstanceOf((short)79)) {
                this.getTransformationLineageNode((MIRTransformation)mIRObject);
                continue;
            }
            if (mIRObject.isInstanceOf((short)159)) {
                this.getContentLineageNode((MIRContent)mIRObject);
                continue;
            }
            if (mIRObject.isInstanceOf((short)78)) {
                this.createFeatureMap((MIRFeatureMap)mIRObject, set2);
                continue;
            }
            if (mIRObject.isInstanceOf((short)76)) {
                this.createClassifierMap((MIRClassifierMap)mIRObject);
                continue;
            }
            if (mIRObject.isInstanceOf((short)197)) {
                this.createElementMap((MIRElementMap)mIRObject);
                continue;
            }
            if (mIRObject.isInstanceOf((short)262)) {
                this.createSummaryMap((MIRSummaryMap)mIRObject);
                continue;
            }
            if (mIRObject.isInstanceOf((short)306)) {
                this.createStepReference((MIRStepReference)mIRObject);
                continue;
            }
            if (mIRObject.isInstanceOf((short)213)) {
                this.createConnection((MIRConnection)mIRObject);
                continue;
            }
            if (!mIRObject.isInstanceOf((short)216)) continue;
            this.getPackageLineageNode((MIRStoreConnection)mIRObject);
        }
        for (MIRQueryJoin mIRQueryJoin : arrayList) {
            this.processQueryJoin(mIRQueryJoin);
        }
        for (MIRFilter mIRFilter : arrayList2) {
            MIRFeature mIRFeature;
            if (mIRFilter.getFeatureCount() != 1 || !((mIRFeature = mIRFilter.getFeatures().first()) instanceof MIRCondition)) continue;
            TreeSet<MIRReportField> treeSet = new TreeSet<MIRReportField>();
            for (MIRReportItem mIRReportItem : ((MIRCondition)mIRFeature).getReportItems()) {
                this.collectReportFields(mIRReportItem, treeSet);
            }
            for (MIRReportField mIRReportField : treeSet) {
                ObjectIdentifier objectIdentifier = this.getObjectIdentifier(mIRReportField);
                this.addLink(this.getObjectIdentifier(mIRFilter), objectIdentifier, objectIdentifier, 2);
            }
        }
        super.buildLineageGraphLinks(set);
        return this.list;
    }

    private final boolean isProcessed(ObjectIdentifier objectIdentifier) {
        return this.parentIds.containsKey(objectIdentifier);
    }

    private final MIRDataPackage getParentDataPackage(MIRClassifier mIRClassifier) {
        ObjectIdentifier objectIdentifier = this.getClassifierLineageNode(mIRClassifier);
        ObjectIdentifier objectIdentifier2 = this.parentIds.get(objectIdentifier);
        MIRObject mIRObject = this.cache.getMirObject(objectIdentifier2);
        if (mIRObject instanceof MIRDataPackage) {
            return (MIRDataPackage)mIRObject;
        }
        if (mIRObject instanceof MIRClassifier) {
            return this.getParentDataPackage((MIRClassifier)mIRObject);
        }
        return null;
    }

    private void collectReportFields(MIRReportItem mIRReportItem, Set<MIRReportField> set) {
        if (mIRReportItem instanceof MIRReportField) {
            set.add((MIRReportField)mIRReportItem);
            return;
        }
        for (MIRReportItem mIRReportItem2 : mIRReportItem.getChildReportItems()) {
            this.collectReportFields(mIRReportItem2, set);
        }
    }

    private void processQueryJoin(MIRQueryJoin mIRQueryJoin) {
    }

    private ObjectIdentifier getFeatureLineageNode(MIRFeature mIRFeature) {
        MIRObject mIRObject;
        Comparable<MIR_Object> comparable;
        ObjectIdentifier objectIdentifier = this.getObjectIdentifier(mIRFeature);
        if (this.isProcessed(objectIdentifier)) {
            return objectIdentifier;
        }
        if (mIRFeature instanceof MIRLevelAttribute && (comparable = (mIRObject = (MIRLevelAttribute)mIRFeature).getDimensionAttribute()) != null) {
            ObjectIdentifier objectIdentifier2 = this.getObjectIdentifier((MIRObject)comparable);
            this.addLink(objectIdentifier, objectIdentifier2, objectIdentifier2, 20);
        }
        mIRObject = null;
        if (LineageUtil.isHierarchicalFeature(mIRFeature) && this.isHierarchicalPart(mIRFeature.getClassifier())) {
            mIRObject = this.getHierarchicalParent(mIRFeature.getClassifier(), true);
        }
        if (mIRObject == null) {
            mIRObject = mIRFeature.getClassifier();
        }
        comparable = null;
        if (mIRObject instanceof MIRFeature) {
            comparable = this.getFeatureLineageNode((MIRFeature)mIRObject);
        } else if (mIRObject instanceof MIRClassifier) {
            comparable = this.getClassifierLineageNode((MIRClassifier)mIRObject);
        }
        this.addLink((ObjectIdentifier)comparable, objectIdentifier, objectIdentifier, 7);
        this.processSynonymLineageNodes(mIRFeature);
        for (MIRBusinessRule mIRBusinessRule : mIRFeature.getAssociatedBusinessRules()) {
            ObjectIdentifier objectIdentifier3 = this.getBusinessRuleLineageNode(mIRBusinessRule);
            this.addLink(objectIdentifier3, objectIdentifier, objectIdentifier3, 8);
        }
        return objectIdentifier;
    }

    private void createReportFieldLineageNode(MIRReportField mIRReportField) {
        ObjectIdentifier objectIdentifier = this.getObjectIdentifier(mIRReportField);
        if (this.isProcessed(objectIdentifier)) {
            return;
        }
        MIRObject mIRObject = LineageUtil.getReportItemParent(mIRReportField);
        ObjectIdentifier objectIdentifier2 = this.getReportItemLineageNode(mIRObject);
        this.addLink(objectIdentifier2, objectIdentifier, objectIdentifier, 7);
        MIRFeature mIRFeature = mIRReportField.getFeature();
        this.addLink(this.getObjectIdentifier(mIRFeature), objectIdentifier, objectIdentifier, 0);
    }

    private ObjectIdentifier getReportItemLineageNode(MIRObject mIRObject) {
        if (mIRObject.isInstanceOf((short)218)) {
            return this.getObjectIdentifier(mIRObject);
        }
        ObjectIdentifier objectIdentifier = this.getObjectIdentifier(mIRObject);
        if (this.isProcessed(objectIdentifier)) {
            return objectIdentifier;
        }
        MIRObject mIRObject2 = LineageUtil.getReportItemParent(mIRObject);
        ObjectIdentifier objectIdentifier2 = this.getReportItemLineageNode(mIRObject2);
        this.addLink(objectIdentifier2, objectIdentifier, objectIdentifier, 7);
        return objectIdentifier;
    }

    private ObjectIdentifier getClassifierLineageNode(MIRClassifier mIRClassifier) {
        Object object;
        Object object2;
        ObjectIdentifier objectIdentifier = this.getObjectIdentifier(mIRClassifier);
        if (this.isProcessed(objectIdentifier)) {
            return objectIdentifier;
        }
        MIRObject mIRObject = null;
        if (mIRClassifier instanceof MIRFilter) {
            object2 = new ArrayList<MIRReportItem>();
            for (MIRFeature object3 : mIRClassifier.getFeatures()) {
                if (!(object3 instanceof MIRCondition)) continue;
                object2.addAll(((MIRCondition)object3).getReportItems());
            }
            if (object2.size() == 1) {
                mIRObject = (MIRObject)object2.get(0);
            }
        } else if (mIRClassifier instanceof MIRLevel) {
            return objectIdentifier;
        }
        if (mIRObject == null) {
            mIRObject = mIRClassifier.getConnectionDataPackage();
        }
        if (mIRObject == null) {
            mIRObject = mIRClassifier.getDataPackage();
        }
        if (mIRObject == null && this.isHierarchicalPart(mIRClassifier)) {
            mIRObject = this.getHierarchicalParent(mIRClassifier);
        }
        if (mIRObject == null) {
            mIRObject = mIRClassifier.getParent();
        }
        if (mIRObject instanceof MIRElement && mIRObject.getName().equals("Fake Root") && ((MIRElement)mIRObject).getNativeType().equals("Fake Root")) {
            mIRObject = mIRObject.getParent();
        }
        object2 = null;
        if (mIRObject.isInstanceOf((short)141)) {
            object2 = this.getPackageLineageNode((MIRPackage)mIRObject);
        } else if (mIRObject.isInstanceOf((short)9)) {
            object2 = this.isTableauDataSource(mIRObject) ? this.getPackageLineageNode((MIRDesignPackage)mIRObject) : this.getObjectIdentifier(mIRClassifier.getRootModel());
        } else if (mIRObject.isInstanceOf((short)216)) {
            object2 = this.getPackageLineageNode((MIRStoreConnection)mIRObject);
        } else if (mIRObject.isInstanceOf((short)79)) {
            object2 = this.getTransformationLineageNode((MIRTransformation)mIRObject);
        } else if (mIRObject.isInstanceOf((short)218)) {
            object2 = this.getObjectIdentifier(mIRObject);
        } else if (mIRObject.isInstanceOf((short)119)) {
            object2 = this.getObjectIdentifier(mIRObject.getRootModel());
        } else if (mIRObject.isInstanceOf((short)75)) {
            object2 = this.getClassifierLineageNode((MIRClassifier)mIRObject);
        } else if (mIRObject.isInstanceOf((short)124)) {
            object2 = this.getReportItemLineageNode(mIRObject);
        } else if (mIRObject.isInstanceOf((short)23)) {
            object2 = this.getOperationLineageNode((MIROperation)mIRObject);
        } else {
            throw new IllegalStateException("Unexpected object: " + mIRObject);
        }
        if (!(mIRClassifier instanceof MIRLevel)) {
            this.addLink((ObjectIdentifier)object2, objectIdentifier, objectIdentifier, 7);
        }
        this.processSynonymLineageNodes(mIRClassifier);
        for (MIRJoinRelationship mIRJoinRelationship : mIRClassifier.getLeftOfJoinRelationships()) {
            ObjectIdentifier objectIdentifier2 = this.getObjectIdentifier(mIRJoinRelationship);
            this.addLink(objectIdentifier, this.getObjectIdentifier(mIRJoinRelationship.getRightClassifier()), objectIdentifier2, 11);
            for (MIRJoinCondition mIRJoinCondition : mIRJoinRelationship.getJoinConditions()) {
                this.addLink(this.getObjectIdentifier(mIRJoinCondition.getLeftFeature()), this.getObjectIdentifier(mIRJoinCondition.getRightFeature()), objectIdentifier2, 11);
            }
        }
        for (MIRJoinRole mIRJoinRole : mIRClassifier.getAssociatedJoinRoles()) {
            if (!mIRJoinRole.getLeft()) continue;
            MIRJoin mIRJoin = mIRJoinRole.getJoin();
            object = this.getObjectIdentifier(mIRJoin);
            MIRJoinRole mIRJoinRole2 = MIRBridgeLib.getRightJoinRole(mIRJoin);
            if (mIRJoinRole2 == null) continue;
            this.addLink(objectIdentifier, this.getObjectIdentifier(mIRJoinRole2.getClassifier()), (ObjectIdentifier)object, 11);
        }
        if (mIRClassifier.hasLineageOption(1024) && !(mIRObject instanceof MIRStoreConnection) && !(mIRObject instanceof MIRConnectionPackage)) {
            TreeSet treeSet = new TreeSet();
            for (MIRFeature mIRFeature : mIRClassifier.getFeatures()) {
                if (!mIRFeature.hasLineageOption(256)) continue;
                treeSet.add(mIRFeature);
            }
            Iterator iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                MIRFeature mIRFeature = (MIRFeature)iterator.next();
                object = this.getObjectIdentifier(mIRFeature);
                for (MIRFeature mIRFeature2 : mIRClassifier.getFeatures()) {
                    if (treeSet.contains(mIRFeature2)) continue;
                    ObjectIdentifier objectIdentifier3 = this.getObjectIdentifier(mIRFeature2);
                    this.addLink((ObjectIdentifier)object, objectIdentifier3, (ObjectIdentifier)object, 5);
                    this.addLink(objectIdentifier3, (ObjectIdentifier)object, (ObjectIdentifier)object, 6);
                }
            }
        }
        return objectIdentifier;
    }

    private boolean isHierarchicalPart(MIRClassifier mIRClassifier) {
        if (mIRClassifier.getConnectionDataPackage() == null && mIRClassifier.getDataPackage() == null && mIRClassifier instanceof MIRClass) {
            MIRObject mIRObject = mIRClassifier;
            while (mIRObject != null) {
                if ((mIRObject = this.getHierarchicalParent(mIRObject)) instanceof MIRStoreModel) {
                    return LineageUtil.isHierarchialModel((MIRStoreModel)mIRObject);
                }
                if (!(mIRObject instanceof MIRStoreConnection)) continue;
                return ((MIRStoreConnection)mIRObject).getStoreType() == 2;
            }
        }
        return false;
    }

    private MIRObject getHierarchicalParent(MIRObject mIRObject) {
        if (mIRObject != null) {
            if (mIRObject instanceof MIRClassifier) {
                MIRClassifier mIRClassifier = (MIRClassifier)mIRObject;
                if (mIRClassifier.getConnectionDataPackage() != null) {
                    return mIRClassifier.getConnectionDataPackage();
                }
                if (mIRClassifier.getDataPackage() != null) {
                    return mIRClassifier.getDataPackage();
                }
                return this.getHierarchicalParent(mIRClassifier, false);
            }
            return mIRObject.getParent();
        }
        return null;
    }

    private MIRObject getHierarchicalParent(MIRClassifier mIRClassifier, boolean bl) {
        MIRClass mIRClass;
        MIRType mIRType;
        if (mIRClassifier instanceof MIRClass && (mIRType = (mIRClass = (MIRClass)mIRClassifier).getClassType()) != null) {
            if (mIRType.getArrayTypeOfDerivedTypeCount() == 1) {
                mIRType = mIRType.getArrayTypeOfDerivedType(null);
            }
            if (mIRType.getFeatureCount() == 1) {
                MIRFeature mIRFeature = mIRType.getFeature(null);
                return bl ? mIRFeature : mIRFeature.getParent();
            }
        }
        return null;
    }

    private ObjectIdentifier getOperationLineageNode(MIROperation mIROperation) {
        MIRObject mIRObject = mIROperation.getDataPackage();
        if (mIRObject == null) {
            mIRObject = mIROperation.getParent();
        }
        ObjectIdentifier objectIdentifier = null;
        if (mIRObject.isInstanceOf((short)141)) {
            objectIdentifier = this.getPackageLineageNode((MIRPackage)mIRObject);
        } else if (mIRObject.isInstanceOf((short)9)) {
            objectIdentifier = this.getObjectIdentifier(mIROperation.getRootModel());
        } else if (mIRObject.isInstanceOf((short)216)) {
            objectIdentifier = this.getPackageLineageNode((MIRStoreConnection)mIRObject);
        } else if (mIRObject.isInstanceOf((short)75)) {
            objectIdentifier = this.getClassifierLineageNode((MIRClassifier)mIRObject);
        } else {
            throw new IllegalStateException("Unexpected object: " + mIRObject);
        }
        return objectIdentifier;
    }

    private ObjectIdentifier getHierarchyLineageNode(MIRHierarchy mIRHierarchy) {
        ObjectIdentifier objectIdentifier = this.getObjectIdentifier(mIRHierarchy);
        if (this.isProcessed(objectIdentifier)) {
            return objectIdentifier;
        }
        for (MIRHierarchyLevelAssociation mIRHierarchyLevelAssociation : mIRHierarchy.getHierarchyLevelAssociations()) {
            MIRLevel mIRLevel = mIRHierarchyLevelAssociation.getLevel();
            ObjectIdentifier objectIdentifier2 = this.getLevelLineageNode(mIRLevel);
            this.addLink(objectIdentifier, objectIdentifier2, objectIdentifier2, 7);
            for (MIRSynonym mIRSynonym : mIRLevel.getSynonyms()) {
                ObjectIdentifier objectIdentifier3 = this.getObjectIdentifier(mIRSynonym);
                this.addLink(objectIdentifier, objectIdentifier3, objectIdentifier3, 7);
            }
        }
        ObjectIdentifier objectIdentifier4 = this.getClassifierLineageNode(mIRHierarchy.getDimension());
        this.addLink(objectIdentifier4, objectIdentifier, objectIdentifier, 7);
        this.processSynonymLineageNodes(mIRHierarchy);
        return objectIdentifier;
    }

    private ObjectIdentifier getLevelLineageNode(MIRLevel mIRLevel) {
        ObjectIdentifier objectIdentifier = this.getObjectIdentifier(mIRLevel);
        if (!this.isProcessed(objectIdentifier)) {
            Comparable<MIR_Object> comparable;
            for (MIRFeature mIRModelObject : mIRLevel.getFeatures()) {
                comparable = (MIRLevelAttribute)mIRModelObject;
                ObjectIdentifier objectIdentifier2 = this.getFeatureLineageNode((MIRFeature)comparable);
                if (comparable.getDefaultOfLevel() == null) continue;
                this.addLink(objectIdentifier, objectIdentifier2, objectIdentifier2, 22);
            }
            for (MIRSynonym mIRSynonym : mIRLevel.getSynonyms()) {
                comparable = this.getObjectIdentifier(mIRSynonym);
                this.addLink((ObjectIdentifier)comparable, objectIdentifier, (ObjectIdentifier)comparable, 21);
            }
        }
        return objectIdentifier;
    }

    private ObjectIdentifier createConnectionElementLineageNode(MIRConnectionElement mIRConnectionElement) {
        ObjectIdentifier objectIdentifier = this.getObjectIdentifier(mIRConnectionElement);
        boolean bl = true;
        for (Comparable<MIR_Object> comparable : mIRConnectionElement.getDefinedElements()) {
            if (comparable.isInstanceOf((short)243)) continue;
            this.addLink(objectIdentifier, this.getObjectIdentifier((MIRObject)comparable), objectIdentifier, 1);
        }
        if (bl) {
            Comparable<MIR_Object> comparable;
            MIRStoreConnection mIRStoreConnection = mIRConnectionElement.getStoreConnection();
            comparable = this.getPackageLineageNode(mIRStoreConnection);
            this.addLink((ObjectIdentifier)comparable, objectIdentifier, objectIdentifier, 7);
        }
        return objectIdentifier;
    }

    private void processSynonymLineageNodes(MIRModelObject mIRModelObject) {
        ObjectIdentifier objectIdentifier = this.getObjectIdentifier(mIRModelObject);
        for (MIRSynonym mIRSynonym : mIRModelObject.getSynonyms()) {
            ObjectIdentifier objectIdentifier2 = this.getObjectIdentifier(mIRSynonym);
            if (this.isProcessed(objectIdentifier2)) {
                return;
            }
            ObjectIdentifier objectIdentifier3 = null;
            MIRObject mIRObject = mIRSynonym.getDataPackage();
            if (mIRObject == null) {
                mIRObject = mIRSynonym.getParent();
                while (!(mIRObject instanceof MIRClassifier) && !(mIRObject instanceof MIRFeature)) {
                    mIRObject = mIRObject.getParent();
                }
                if (mIRObject instanceof MIRClassifier) {
                    MIRClassifier mIRClassifier = (MIRClassifier)mIRObject;
                    mIRObject = mIRClassifier.getConnectionDataPackage() != null ? mIRClassifier.getConnectionDataPackage() : (mIRClassifier.getDataPackage() != null ? mIRClassifier.getDataPackage() : mIRClassifier.getParent());
                    objectIdentifier3 = this.getPackageLineageNode((MIRPackage)mIRObject);
                } else if (mIRObject instanceof MIRFeature) {
                    objectIdentifier3 = this.getClassifierLineageNode((MIRClassifier)mIRObject.getParent());
                }
            } else {
                objectIdentifier3 = this.getPackageLineageNode((MIRPackage)mIRObject);
            }
            if (objectIdentifier3 == null) continue;
            this.addLink(objectIdentifier3, objectIdentifier2, objectIdentifier2, 7);
            this.addLink(objectIdentifier2, objectIdentifier, objectIdentifier2, 21);
            this.processSynonymLineageNodes(mIRSynonym);
        }
    }

    private ObjectIdentifier getTermLineageNode(MIRTerm mIRTerm) {
        ObjectIdentifier objectIdentifier = this.getObjectIdentifier(mIRTerm);
        if (this.isProcessed(objectIdentifier)) {
            return objectIdentifier;
        }
        for (MIRTermRelationship mIRTermRelationship : mIRTerm.getDestinationOfTermRelationships()) {
            MIRTerm mIRTerm2 = mIRTermRelationship.getSourceTerm();
            if (mIRTerm2 == null || mIRTermRelationship.getType() != 1) continue;
            this.addLink(objectIdentifier, this.getObjectIdentifier(mIRTerm2), objectIdentifier, 1);
        }
        ObjectIdentifier objectIdentifier2 = this.getObjectIdentifier(mIRTerm.getRootModel());
        this.addLink(objectIdentifier2, objectIdentifier, objectIdentifier, 7);
        this.processSynonymLineageNodes(mIRTerm);
        return objectIdentifier;
    }

    private ObjectIdentifier getConceptualDomainLineageNode(MIRConceptualDomain mIRConceptualDomain) {
        Comparable<ObjectIdentifier> comparable;
        ObjectIdentifier objectIdentifier = this.getObjectIdentifier(mIRConceptualDomain);
        if (this.isProcessed(objectIdentifier)) {
            return objectIdentifier;
        }
        SortedSet<MIRTerm> sortedSet = mIRConceptualDomain.getRepresentedTerms();
        for (MIRTerm object2 : sortedSet) {
            comparable = this.getTermLineageNode(object2);
            this.addLink(objectIdentifier, (ObjectIdentifier)comparable, objectIdentifier, 1);
        }
        SortedSet<MIRConceptualDomain> sortedSet2 = mIRConceptualDomain.getSubtypeConceptualDomains();
        Iterator iterator = sortedSet2.iterator();
        while (iterator.hasNext()) {
            comparable = (MIRConceptualDomain)iterator.next();
            this.addLink(objectIdentifier, this.getConceptualDomainLineageNode((MIRConceptualDomain)comparable), objectIdentifier, 1);
        }
        ObjectIdentifier objectIdentifier2 = this.getObjectIdentifier(mIRConceptualDomain.getRootModel());
        this.addLink(objectIdentifier2, objectIdentifier, objectIdentifier, 7);
        return objectIdentifier;
    }

    private ObjectIdentifier getTypeLineageNode(MIRDerivedType mIRDerivedType) {
        if (!mIRDerivedType.getUserDefined()) {
            return null;
        }
        ObjectIdentifier objectIdentifier = this.getObjectIdentifier(mIRDerivedType);
        MIRConcreteType mIRConcreteType = mIRDerivedType.getDerivedFromConcreteType();
        if (mIRConcreteType.isInstanceOf((short)5) && mIRConcreteType.getUserDefined()) {
            this.addLink(this.getObjectIdentifier(mIRConcreteType), objectIdentifier, objectIdentifier, 8);
        }
        for (MIRFeature mIRModelObject : mIRDerivedType.getFeatures()) {
            this.addLink(objectIdentifier, this.getObjectIdentifier(mIRModelObject), objectIdentifier, 8);
        }
        for (MIRDerivedType mIRDerivedType2 : mIRDerivedType.getDerivedTypes()) {
            if (mIRDerivedType2.getUserDefined()) continue;
            for (MIRFeature mIRFeature : mIRDerivedType2.getFeatures()) {
                this.addLink(objectIdentifier, this.getObjectIdentifier(mIRFeature), objectIdentifier, 8);
            }
        }
        for (MIRBusinessRule mIRBusinessRule : mIRDerivedType.getAssociatedBusinessRules()) {
            ObjectIdentifier objectIdentifier2 = this.getBusinessRuleLineageNode(mIRBusinessRule);
            this.addLink(objectIdentifier2, objectIdentifier, objectIdentifier2, 8);
        }
        ObjectIdentifier objectIdentifier3 = this.getObjectIdentifier(mIRDerivedType.getRootModel());
        this.addLink(objectIdentifier3, objectIdentifier, objectIdentifier, 7);
        return objectIdentifier;
    }

    private ObjectIdentifier getBusinessRuleLineageNode(MIRBusinessRule mIRBusinessRule) {
        ObjectIdentifier objectIdentifier = this.getObjectIdentifier(mIRBusinessRule);
        if (this.isProcessed(objectIdentifier)) {
            return objectIdentifier;
        }
        ObjectIdentifier objectIdentifier2 = this.getObjectIdentifier(mIRBusinessRule.getRootModel());
        this.addLink(objectIdentifier2, objectIdentifier, objectIdentifier, 7);
        return objectIdentifier;
    }

    private ObjectIdentifier getConnectionNamespaceLineageNode(MIRConnectionNamespace mIRConnectionNamespace) {
        ObjectIdentifier objectIdentifier = this.getObjectIdentifier(mIRConnectionNamespace);
        if (this.isProcessed(objectIdentifier)) {
            return objectIdentifier;
        }
        ObjectIdentifier objectIdentifier2 = null;
        MIRObject mIRObject = mIRConnectionNamespace.getParent();
        if (mIRObject.isInstanceOf((short)321)) {
            objectIdentifier2 = this.getConnectionNamespaceLineageNode((MIRConnectionNamespace)mIRObject);
        } else if (mIRObject.isInstanceOf((short)216)) {
            objectIdentifier2 = this.getPackageLineageNode((MIRStoreConnection)mIRObject);
        }
        this.addLink(objectIdentifier2, objectIdentifier, objectIdentifier, 7);
        return objectIdentifier;
    }

    private ObjectIdentifier getStepLineageNode(MIRActivityStep mIRActivityStep) {
        ObjectIdentifier objectIdentifier = this.getObjectIdentifier(mIRActivityStep);
        if (this.isProcessed(objectIdentifier)) {
            return objectIdentifier;
        }
        ObjectIdentifier objectIdentifier2 = null;
        MIRObject mIRObject = mIRActivityStep.getParent();
        if (mIRObject.isInstanceOf((short)218)) {
            objectIdentifier2 = this.getObjectIdentifier(mIRObject);
        } else if (mIRObject.isInstanceOf((short)315)) {
            objectIdentifier2 = this.getStepLineageNode((MIRActivityStep)mIRObject);
        } else {
            throw new IllegalArgumentException();
        }
        this.addLink(objectIdentifier2, objectIdentifier, objectIdentifier, 7);
        return objectIdentifier;
    }

    private ObjectIdentifier getFolderLineageNode(MIRFolder mIRFolder) {
        ObjectIdentifier objectIdentifier = this.getObjectIdentifier(mIRFolder);
        if (this.isProcessed(objectIdentifier)) {
            return objectIdentifier;
        }
        ObjectIdentifier objectIdentifier2 = null;
        MIRObject mIRObject = mIRFolder.getParent();
        if (mIRObject instanceof MIRElement && mIRObject.getName().equals("Fake Root") && ((MIRElement)mIRObject).getNativeType().equals("Fake Root")) {
            mIRObject = mIRObject.getParent();
        }
        objectIdentifier2 = mIRObject.getElementType() == 157 ? this.getFolderLineageNode((MIRFolder)mIRObject) : this.getObjectIdentifier(mIRFolder.getRootModel());
        this.addLink(objectIdentifier2, objectIdentifier, objectIdentifier, 7);
        if (mIRObject instanceof MIRFolder) {
            this.addLink(objectIdentifier2, objectIdentifier, objectIdentifier, 14);
        }
        return objectIdentifier;
    }

    private ObjectIdentifier getContentLineageNode(MIRContent mIRContent) {
        ObjectIdentifier objectIdentifier = this.getObjectIdentifier(mIRContent);
        if (this.isProcessed(objectIdentifier)) {
            return objectIdentifier;
        }
        MIRModel mIRModel = mIRContent.getRootModel();
        boolean bl = false;
        if (mIRModel.isInstanceOf((short)286)) {
            byte by = ((MIRDirectoryStructureModel)mIRModel).getType();
            bl = by == 3 || by == 2 || by == 5;
        }
        ObjectIdentifier objectIdentifier2 = null;
        MIRObject mIRObject = mIRContent.getParent();
        if (mIRObject instanceof MIRElement && mIRObject.getName().equals("Fake Root") && ((MIRElement)mIRObject).getNativeType().equals("Fake Root")) {
            mIRObject = mIRObject.getParent();
        }
        objectIdentifier2 = bl && mIRObject.getElementType() == 157 ? this.getFolderLineageNode((MIRFolder)mIRObject) : this.getObjectIdentifier(mIRContent.getRootModel());
        this.addLink(objectIdentifier2, objectIdentifier, objectIdentifier, 7);
        return objectIdentifier;
    }

    private ObjectIdentifier getPackageLineageNode(MIRModelObject mIRModelObject) {
        ObjectIdentifier objectIdentifier = this.getObjectIdentifier(mIRModelObject);
        if (this.isProcessed(objectIdentifier)) {
            return objectIdentifier;
        }
        ObjectIdentifier objectIdentifier2 = null;
        MIRObject mIRObject = mIRModelObject.getParent();
        if (mIRObject instanceof MIRElement && mIRObject.getName().equals("Fake Root") && ((MIRElement)mIRObject).getNativeType().equals("Fake Root")) {
            mIRObject = mIRObject.getParent();
        }
        if (mIRObject.isInstanceOf((short)216)) {
            objectIdentifier2 = this.getPackageLineageNode((MIRStoreConnection)mIRObject);
        } else if (mIRObject.isInstanceOf((short)141)) {
            objectIdentifier2 = this.getPackageLineageNode((MIRDataPackage)mIRObject);
        } else if (mIRObject.isInstanceOf((short)9) && this.isTableauDataSource(mIRObject)) {
            objectIdentifier2 = this.getPackageLineageNode((MIRDesignPackage)mIRObject);
        }
        if (objectIdentifier2 == null) {
            objectIdentifier2 = this.getObjectIdentifier(mIRModelObject.getRootModel());
        }
        this.addLink(objectIdentifier2, objectIdentifier, objectIdentifier, 7);
        if (mIRModelObject instanceof MIRDataPackage && mIRObject instanceof MIRDataPackage) {
            this.addLink(objectIdentifier2, objectIdentifier, objectIdentifier, 14);
        }
        return objectIdentifier;
    }

    private ObjectIdentifier getTransformationLineageNode(MIRTransformation mIRTransformation) {
        ObjectIdentifier objectIdentifier = this.getObjectIdentifier(mIRTransformation);
        if (this.isProcessed(objectIdentifier)) {
            return objectIdentifier;
        }
        if (mIRTransformation instanceof MIRSqlQuery) {
            return this.getSqlQueryNode((MIRSqlQuery)mIRTransformation);
        }
        ObjectIdentifier objectIdentifier2 = null;
        if (mIRTransformation.getDiModel() != null) {
            objectIdentifier2 = this.getObjectIdentifier(mIRTransformation.getDiModel());
        } else {
            MIREmbeddedCallTransformation mIREmbeddedCallTransformation = mIRTransformation.getEmbeddedCallTransformation();
            objectIdentifier2 = this.getTransformationLineageNode(mIREmbeddedCallTransformation);
        }
        this.addLink(objectIdentifier2, objectIdentifier, objectIdentifier, 7);
        return objectIdentifier;
    }

    private ObjectIdentifier getSqlQueryNode(MIRSqlQuery mIRSqlQuery) {
        ObjectIdentifier objectIdentifier = this.getObjectIdentifier(mIRSqlQuery);
        if (this.isProcessed(objectIdentifier)) {
            return objectIdentifier;
        }
        ObjectIdentifier objectIdentifier2 = null;
        if (mIRSqlQuery.getDiModel() != null) {
            MIRDiModel mIRDiModel = mIRSqlQuery.getDiModel();
            if (mIRDiModel.getTransformationCount() == 1) {
                return this.getObjectIdentifier(mIRDiModel);
            }
            objectIdentifier2 = this.getObjectIdentifier(mIRDiModel);
        } else if (mIRSqlQuery.getSubOfSqlQuery() != null) {
            MIRSqlQuery mIRSqlQuery2 = mIRSqlQuery.getSubOfSqlQuery();
            int n = 0;
            MIRMetaClass mIRMetaClass = mIRSqlQuery2.getMetaClass();
            for (MIRMetaLink mIRMetaLink : mIRMetaClass.getLinks()) {
                if (mIRMetaLink.getType() == 3 && (n += mIRMetaLink.getCount(mIRSqlQuery2)) > 1) break;
            }
            if (n == 1) {
                return this.getSqlQueryNode(mIRSqlQuery.getSubOfSqlQuery());
            }
            objectIdentifier2 = this.getSqlQueryNode(mIRSqlQuery.getSubOfSqlQuery());
        } else if (mIRSqlQuery.getEmbeddedCallTransformation() != null) {
            objectIdentifier2 = this.getTransformationLineageNode(mIRSqlQuery.getEmbeddedCallTransformation());
        }
        if (objectIdentifier2 != null) {
            this.addLink(objectIdentifier2, objectIdentifier, objectIdentifier, 7);
        }
        return objectIdentifier;
    }

    private boolean isWritableSqlViewAttribute(MIRFeature mIRFeature, Set<MIRSQLViewEntity> set) {
        if (mIRFeature instanceof MIRSQLViewAttribute) {
            MIRClassifier mIRClassifier = mIRFeature.getClassifier();
            return set.contains(mIRClassifier);
        }
        return false;
    }

    private void createFeatureMap(MIRFeatureMap mIRFeatureMap, Set<MIRSQLViewEntity> set) {
        MIRFeature mIRFeature = mIRFeatureMap.getDestinationFeature();
        if (mIRFeature == null) {
            return;
        }
        ObjectIdentifier objectIdentifier = this.getObjectIdentifier(mIRFeatureMap);
        if (objectIdentifier == null) {
            return;
        }
        ObjectIdentifier objectIdentifier2 = this.getFeatureLineageNode(mIRFeature);
        for (MIRFeature mIRFeature2 : mIRFeatureMap.getSourceFeatures()) {
            ObjectIdentifier objectIdentifier3 = this.getFeatureLineageNode(mIRFeature2);
            int n = this.getLinkType(mIRFeatureMap, mIRFeature);
            this.addLink(objectIdentifier3, objectIdentifier2, objectIdentifier, n);
            if (!this.isWritableSqlViewAttribute(mIRFeature, set)) continue;
            this.addLink(objectIdentifier2, objectIdentifier3, objectIdentifier, n);
        }
        for (MIRFeature mIRFeature2 : mIRFeatureMap.getControlFeatures()) {
            this.addLink(this.getObjectIdentifier(mIRFeature2), objectIdentifier2, objectIdentifier, 16);
        }
        if (mIRFeatureMap.getSourceFeatureCount() + mIRFeatureMap.getControlFeatureCount() == 0) {
            this.addLink(objectIdentifier2, objectIdentifier2, objectIdentifier, 14);
        }
    }

    private int getLinkType(MIRFeatureMap mIRFeatureMap, MIRFeature mIRFeature) {
        MIRMeasure mIRMeasure;
        int n;
        int n2 = n = mIRFeature instanceof MIRCondition ? 2 : 0;
        if (mIRFeatureMap.getBulk()) {
            n = 24;
        } else if (mIRFeatureMap.getExpression() == null) {
            if (mIRFeatureMap.getOperation() != null && mIRFeatureMap.getOperation().length() > 0) {
                n = 14;
            }
        } else {
            this.passThroughDetector.convertExpression(mIRFeatureMap);
            if (!this.passThroughDetector.isPassTrhough()) {
                n = 14;
            }
        }
        if (n == 0 && mIRFeature.isInstanceOf((short)97) && ((mIRMeasure = (MIRMeasure)mIRFeature).getAggregationRuleCount() > 0 || mIRMeasure.getDefaultAggregation() != 7)) {
            n = 14;
        }
        return n;
    }

    private void createClassifierMap(MIRClassifierMap mIRClassifierMap) {
        Comparable<MIR_Object> comparable;
        ObjectIdentifier objectIdentifier = this.getObjectIdentifier(mIRClassifierMap);
        MIRClassifier mIRClassifier = mIRClassifierMap.getDestinationClassifier();
        MIRObject mIRObject = mIRClassifier.getParent();
        MIRDataPackage mIRDataPackage = this.getParentDataPackage(mIRClassifier);
        for (MIRClassifier mIRModelObject : mIRClassifierMap.getSourceClassifiers()) {
            Iterator iterator;
            if (mIRClassifier != mIRModelObject && !this.isHierarchicalPart(mIRModelObject) && !this.isHierarchicalPart(mIRClassifier)) {
                this.addLink(this.getObjectIdentifier(mIRModelObject), this.getObjectIdentifier(mIRClassifier), this.getObjectIdentifier(mIRClassifierMap), 14);
            }
            if ((comparable = mIRModelObject.getParent()) instanceof MIRTransformation && mIRObject instanceof MIRTransformation) {
                if (mIRModelObject.getDataPackage() != null || mIRModelObject.getConnectionDataPackage() != null) {
                    iterator = mIRClassifierMap.getFeatureMaps().iterator();
                    while (iterator.hasNext()) {
                        MIRFeatureMap mIRFeatureMap = (MIRFeatureMap)iterator.next();
                        for (MIRFeature mIRFeature2 : mIRFeatureMap.getSourceFeatures()) {
                            if (mIRFeature2.getParent() != mIRModelObject) continue;
                            this.addLink(this.getObjectIdentifier(mIRFeature2), this.getObjectIdentifier(mIRObject), this.getObjectIdentifier(mIRFeatureMap), 23);
                        }
                    }
                } else if (mIRClassifier.getDataPackage() != null || mIRClassifier.getConnectionDataPackage() != null) {
                    iterator = mIRClassifierMap.getFeatureMaps().iterator();
                    while (iterator.hasNext()) {
                        MIRFeatureMap mIRFeatureMap = (MIRFeatureMap)iterator.next();
                        this.addLink(this.getObjectIdentifier((MIRObject)comparable), this.getObjectIdentifier(mIRFeatureMap.getDestinationFeature()), this.getObjectIdentifier(mIRFeatureMap), 23);
                    }
                } else if (comparable != mIRObject) {
                    this.addLink(this.getObjectIdentifier((MIRObject)comparable), this.getObjectIdentifier(mIRObject), objectIdentifier, 23);
                }
            }
            if (mIRDataPackage == null || (iterator = this.getParentDataPackage(mIRModelObject)) == null || iterator == mIRDataPackage) continue;
            this.addLink(this.getObjectIdentifier((MIRObject)((Object)iterator)), this.getObjectIdentifier(mIRDataPackage), this.getObjectIdentifier(mIRDataPackage), 14);
        }
        for (MIRClassifier mIRClassifier2 : mIRClassifierMap.getControlClassifiers()) {
            if (mIRClassifier == mIRClassifier2 || this.isHierarchicalPart(mIRClassifier2) || this.isHierarchicalPart(mIRClassifier)) continue;
            this.addLink(this.getObjectIdentifier(mIRClassifier2), this.getObjectIdentifier(mIRClassifier), this.getObjectIdentifier(mIRClassifierMap), 2);
        }
        if (mIRClassifierMap.getFeatureMapCount() == 0 && !LineageUtil.isHierarchialModel(mIRClassifierMap.getRootModel())) {
            for (MIRFeature mIRFeature : mIRClassifierMap.getDestinationClassifier().getFeatures()) {
                comparable = this.getObjectIdentifier(mIRFeature);
                for (MIRClassifier mIRClassifier3 : mIRClassifierMap.getSourceClassifiers()) {
                    for (MIRFeature mIRFeature2 : mIRClassifier3.getFeatures()) {
                        this.addLink(this.getObjectIdentifier(mIRFeature2), (ObjectIdentifier)comparable, objectIdentifier, 14);
                    }
                }
                for (MIRClassifier mIRClassifier4 : mIRClassifierMap.getControlClassifiers()) {
                    for (MIRFeature mIRFeature2 : mIRClassifier4.getFeatures()) {
                        this.addLink(this.getObjectIdentifier(mIRFeature2), (ObjectIdentifier)comparable, objectIdentifier, 2);
                    }
                }
            }
        }
    }

    private void createElementMap(MIRElementMap mIRElementMap) {
        ObjectIdentifier objectIdentifier = this.getObjectIdentifier(mIRElementMap);
        MIRElement mIRElement = mIRElementMap.getClientElement();
        ObjectIdentifier objectIdentifier2 = this.getObjectIdentifier(mIRElement);
        for (MIRElement mIRElement2 : mIRElementMap.getSupplierElements()) {
            this.addLink(this.getObjectIdentifier(mIRElement2), objectIdentifier2, objectIdentifier, 1);
        }
    }

    private void createSummaryMap(MIRSummaryMap mIRSummaryMap) {
        ObjectIdentifier objectIdentifier = this.getObjectIdentifier(mIRSummaryMap);
        MIRFeature mIRFeature = mIRSummaryMap.getDestinationFeature();
        ObjectIdentifier objectIdentifier2 = this.getObjectIdentifier(mIRFeature);
        MIRClassifier mIRClassifier = mIRFeature.getClassifier();
        MIRDataPackage mIRDataPackage = this.getParentDataPackage(mIRClassifier);
        if (!(mIRSummaryMap.getSourceFeatureCount() != 0 || mIRSummaryMap.getDataControlFeatureCount() != 0 || "*".equals(mIRFeature.getName()) && mIRFeature.isInstanceOf((short)261))) {
            this.addLink(objectIdentifier2, objectIdentifier2, objectIdentifier, 15);
        } else {
            int n = 15;
            if (mIRSummaryMap.getBulk()) {
                n = 25;
            } else if (mIRSummaryMap.getOperation().isEmpty()) {
                n = 12;
            }
            for (MIRFeature mIRFeature2 : mIRSummaryMap.getSourceFeatures()) {
                MIRDataPackage mIRDataPackage2;
                this.addLink(this.getObjectIdentifier(mIRFeature2), objectIdentifier2, objectIdentifier, n);
                if (mIRClassifier != mIRFeature2.getClassifier()) {
                    this.addLink(this.getObjectIdentifier(mIRFeature2.getClassifier()), this.getObjectIdentifier(mIRClassifier), this.getObjectIdentifier(mIRClassifier), 15);
                }
                if (mIRDataPackage == null || (mIRDataPackage2 = this.getParentDataPackage(mIRFeature2.getClassifier())) == null || mIRDataPackage2 == mIRDataPackage) continue;
                this.addLink(this.getObjectIdentifier(mIRDataPackage2), this.getObjectIdentifier(mIRDataPackage), this.getObjectIdentifier(mIRDataPackage), 15);
            }
            for (MIRFeature mIRFeature2 : mIRSummaryMap.getDataControlFeatures()) {
                this.addLink(this.getObjectIdentifier(mIRFeature2), objectIdentifier2, objectIdentifier, 17);
                if (mIRClassifier == mIRFeature2.getClassifier()) continue;
                this.addLink(this.getObjectIdentifier(mIRFeature2.getClassifier()), this.getObjectIdentifier(mIRClassifier), this.getObjectIdentifier(mIRClassifier), 17);
            }
        }
        for (MIRFeature mIRFeature3 : mIRSummaryMap.getControlFeatures()) {
            this.addLink(this.getObjectIdentifier(mIRFeature3), objectIdentifier2, objectIdentifier, 13);
            if (mIRClassifier == mIRFeature3.getClassifier()) continue;
            this.addLink(this.getObjectIdentifier(mIRFeature3.getClassifier()), this.getObjectIdentifier(mIRClassifier), this.getObjectIdentifier(mIRClassifier), 13);
        }
    }

    private void createStepReference(MIRStepReference mIRStepReference) {
        ObjectIdentifier objectIdentifier = this.getObjectIdentifier(mIRStepReference);
        MIRStepElement mIRStepElement = mIRStepReference.getPredecessorStepElement();
        MIRStepElement mIRStepElement2 = mIRStepReference.getSuccessorStepElement();
        this.addLink(this.getObjectIdentifier(mIRStepElement), this.getObjectIdentifier(mIRStepElement2), objectIdentifier, 3);
    }

    private void createConnection(MIRConnection mIRConnection) {
        ObjectIdentifier objectIdentifier = this.getObjectIdentifier(mIRConnection);
        MIRStoreContent mIRStoreContent = mIRConnection.getSupplierStoreContent();
        if (mIRStoreContent == null) {
            return;
        }
        MIRContent mIRContent = mIRConnection.getClientContent();
        if (mIRConnection.getUsage() == 0 || mIRConnection.getUsage() == 2) {
            this.addLink(this.getObjectIdentifier(mIRStoreContent), this.getObjectIdentifier(mIRContent), objectIdentifier, 4);
        }
        if (mIRConnection.getUsage() == 1 || mIRConnection.getUsage() == 2) {
            this.addLink(this.getObjectIdentifier(mIRContent), this.getObjectIdentifier(mIRStoreContent), objectIdentifier, 4);
        }
    }

    @Override
    protected void addControlLink(MIRFeature mIRFeature, MIRFeature mIRFeature2) {
        this.addLink(this.getObjectIdentifier(mIRFeature2), this.getObjectIdentifier(mIRFeature), this.getObjectIdentifier(mIRFeature), 2);
    }

    @Override
    protected void addDataLink(MIRFeature mIRFeature, MIRFeature mIRFeature2, boolean bl) {
        int n = bl ? 0 : 14;
        this.addLink(this.getObjectIdentifier(mIRFeature2), this.getObjectIdentifier(mIRFeature), this.getObjectIdentifier(mIRFeature), n);
    }

    private final void addLink(ObjectIdentifier objectIdentifier, ObjectIdentifier objectIdentifier2, ObjectIdentifier objectIdentifier3, int n) {
        if (objectIdentifier3 == null) {
            objectIdentifier3 = objectIdentifier2;
        }
        this.list.add(new Link(objectIdentifier, objectIdentifier2, objectIdentifier3, n));
        if (n == 7) {
            this.parentIds.put(objectIdentifier2, objectIdentifier);
        } else if (n == 21) {
            this.list.add(new Link(objectIdentifier, objectIdentifier2, objectIdentifier3, 1));
        }
    }
}

