/*
 * Decompiled with CFR 0.152.
 */
package MITI.lineage.links;

import MITI.lineage.links.LineageUtil;
import MITI.lineage.links.PassThroughDetector;
import MITI.sdk.MIRClassType;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRConnectionDataAttribute;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRFeatureMap;
import MITI.sdk.MIRFolder;
import MITI.sdk.MIRMeasure;
import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRPropertyValue;
import MITI.sdk.MIRQueryColumn;
import MITI.sdk.MIRStoreConnection;
import MITI.sdk.MIRStoreContent;
import MITI.sdk.MIRStoreModel;
import MITI.sdk.MIRSummaryMap;

public class LineageNodeFlags {
    public static final int STARTING_POINT = 0x100000;
    public static final int ENDING_POINT = 0x200000;
    public static final int INTERNAL = 0x400000;
    public static final int EXTERNAL = 0x800000;
    public static final int ULTIMATE_DATA_SOURCE = 0x1000000;
    public static final int ULTIMATE_DATA_DESTINATION = 0x2000000;
    public static final int PUBLIC = 0x4000000;
    public static final int CMP_NEW = 0x8000000;
    public static final int PARTIAL = 0x10000000;
    public static final int COLLAPSE_BY_DEFAULT = 0x20000000;
    public static final int IMMEDIATE = 0x40000000;

    public static int computeFlags(MIRObject mIRObject) {
        MIRPropertyValue mIRPropertyValue;
        int n = 0;
        if (mIRObject instanceof MIRModelObject && "ambiguous".equals(((MIRModelObject)mIRObject).getStereotype())) {
            n |= 1;
        }
        if (mIRObject instanceof MIRClassifier) {
            byte by;
            n |= ((MIRClassifier)mIRObject).getLineageOptions();
            byte by2 = LineageNodeFlags.getStoreType(mIRObject.getRootModel());
            if (!(by2 != 2 && by2 != 0 || (by = LineageNodeFlags.getStoreType(mIRObject)) == by2 || by != 2 && by != 0)) {
                n |= 0x10000;
            }
        } else if (mIRObject instanceof MIRFeature) {
            MIRFeature mIRFeature = (MIRFeature)mIRObject;
            n |= mIRFeature.getLineageOptions();
            if (mIRFeature.isInstanceOf((short)242)) {
                MIRQueryColumn mIRQueryColumn = (MIRQueryColumn)mIRFeature;
                if (mIRFeature.getDestinationOfFeatureMap() != null) {
                    if (mIRQueryColumn.isAggregated()) {
                        n |= 2;
                    }
                    if (mIRQueryColumn.getQuerySortItemCount() != 0) {
                        n |= 4;
                    }
                }
            }
            if (mIRFeature.getElementType() == 84) {
                n |= 0x80;
            } else if (mIRFeature.getElementType() == 333) {
                n |= 0x40;
            } else if (mIRFeature.getElementType() == 334) {
                n |= 0x20;
            } else if (mIRFeature.getElementType() == 335) {
                n |= 8;
            } else if (mIRFeature.getElementType() == 337) {
                n |= 0x10;
            }
            if (LineageNodeFlags.isAggregatedColumn(mIRFeature)) {
                n |= 2;
            }
            if (LineageUtil.isHierarchicalFeature(mIRFeature) && mIRFeature.getType() instanceof MIRClassType) {
                n |= 0x8000;
            }
        } else if (mIRObject instanceof MIRStoreContent) {
            MIRPropertyValue mIRPropertyValue2 = ((MIRElement)mIRObject).getPropertyValue("Partition");
            if (mIRPropertyValue2 != null && "true".equals(mIRPropertyValue2.getValue())) {
                n |= 0x4000;
            }
        } else if (mIRObject instanceof MIRFolder && (mIRPropertyValue = ((MIRElement)mIRObject).getPropertyValue("Partition Column Directory")) != null && "true".equals(mIRPropertyValue.getValue())) {
            n |= 0x4000;
        }
        return n;
    }

    private static byte getStoreType(MIRObject mIRObject) {
        while (mIRObject != null) {
            if (mIRObject instanceof MIRClassifier) {
                MIRClassifier mIRClassifier = (MIRClassifier)mIRObject;
                if (mIRClassifier.getConnectionDataPackage() != null) {
                    mIRObject = mIRClassifier.getConnectionDataPackage();
                    continue;
                }
                if (mIRClassifier.getDataPackage() != null) {
                    mIRObject = mIRClassifier.getDataPackage();
                    continue;
                }
                mIRObject = mIRObject.getParent();
                continue;
            }
            if (mIRObject instanceof MIRStoreModel) {
                return ((MIRStoreModel)mIRObject).getStoreType();
            }
            if (mIRObject instanceof MIRStoreConnection) {
                return ((MIRStoreConnection)mIRObject).getStoreType();
            }
            mIRObject = mIRObject.getParent();
        }
        return -1;
    }

    private static boolean isAggregatedColumn(MIRFeature mIRFeature) {
        if (mIRFeature.isInstanceOf((short)97)) {
            MIRMeasure mIRMeasure = (MIRMeasure)mIRFeature;
            if (mIRMeasure.getAggregationRuleCount() > 0 || mIRMeasure.getDefaultAggregation() != 7) {
                return true;
            }
        } else {
            MIRFeatureMap mIRFeatureMap = mIRFeature.getDestinationOfFeatureMap();
            if (mIRFeatureMap != null && mIRFeatureMap.getExpression() != null) {
                PassThroughDetector passThroughDetector = new PassThroughDetector(0, 0);
                passThroughDetector.convertExpression(mIRFeatureMap);
                return passThroughDetector.isAggregation();
            }
            if (mIRFeature.isInstanceOf((short)261)) {
                MIRConnectionDataAttribute mIRConnectionDataAttribute = (MIRConnectionDataAttribute)mIRFeature;
                for (MIRSummaryMap mIRSummaryMap : mIRConnectionDataAttribute.getDestinationOfSummaryMaps()) {
                    if (!mIRSummaryMap.getAggregated()) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

