/*
 * Decompiled with CFR 0.152.
 */
package MITI.util.thread;

import MITI.util.log.MIRLogger;
import MITI.util.thread.SimpleTask;
import MITI.util.thread.SimpleThreadFactory;
import MITI.util.thread.SimpleThreadLogger;
import MITI.util.thread.ThreadVariable;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class SimpleTimer
extends ScheduledThreadPoolExecutor {
    private ThreadVariable.ThreadState state = ThreadVariable.getState();

    public SimpleTimer(String string) {
        super(1, new SimpleThreadFactory(string, false));
        this.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
    }

    public void scheduleOnce(SimpleTask simpleTask) {
        this.schedule(simpleTask, 0L, TimeUnit.SECONDS);
    }

    public void schedule(SimpleTask simpleTask, int n) {
        this.schedule(simpleTask, 0, n);
    }

    public void schedule(final SimpleTask simpleTask, int n, int n2) {
        this.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                simpleTask.call();
            }
        }, n, n2, TimeUnit.SECONDS);
    }

    @Override
    public void close() {
        if (!this.isShutdown()) {
            this.shutdown();
        }
        if (!this.isTerminated()) {
            try {
                while (!this.awaitTermination(10L, TimeUnit.SECONDS)) {
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void beforeExecute(Thread thread, Runnable runnable) {
        ThreadVariable.setState(this.state);
        MIRLogger.setLogger(new SimpleThreadLogger(MIRLogger.getLogger()));
        super.beforeExecute(thread, runnable);
    }

    @Override
    protected void afterExecute(Runnable runnable, Throwable throwable) {
        ThreadVariable.clear();
        super.afterExecute(runnable, throwable);
    }
}

