/*
 * Decompiled with CFR 0.152.
 */
package MITI.util.thread;

import MITI.util.log.MIRLogger;
import MITI.util.thread.SimpleThreadFactory;
import MITI.util.thread.SimpleThreadLogger;
import MITI.util.thread.ThreadVariable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class SimpleThreadPool
extends ThreadPoolExecutor {
    private ThreadVariable.ThreadState state = ThreadVariable.getState();

    public SimpleThreadPool(String string, int n) {
        this(string, n, false);
    }

    public SimpleThreadPool(String string, int n, boolean bl) {
        super(n, n, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new SimpleThreadFactory(string, bl));
    }

    @Override
    public void close() {
        if (!this.isShutdown()) {
            this.shutdown();
        }
        if (!this.isTerminated()) {
            try {
                while (!this.awaitTermination(10L, TimeUnit.SECONDS)) {
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected SimpleThreadLogger newLogger(MIRLogger mIRLogger) {
        return new SimpleThreadLogger(mIRLogger);
    }

    @Override
    protected void beforeExecute(Thread thread, Runnable runnable) {
        ThreadVariable.setState(this.state);
        MIRLogger.setLogger(this.newLogger(MIRLogger.getLogger()));
        super.beforeExecute(thread, runnable);
    }

    @Override
    protected void afterExecute(Runnable runnable, Throwable throwable) {
        ThreadVariable.clear();
        super.afterExecute(runnable, throwable);
    }
}

