/*
 * Decompiled with CFR 0.152.
 */
package MITI.util.text;

import MITI.util.log.LogEvent;
import MITI.util.log.MIRLogger;
import MITI.util.text.TextLiteralCollection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MessageLiteral {
    public static final int NONE = 0;
    public static final int FATAL = 1;
    public static final int ERROR = 2;
    public static final int WARNING = 3;
    public static final int STATUS = 4;
    public static final int INFO = 5;
    public static final int DEBUG = 6;
    private String id;
    private TextLiteralCollection.TextLiteral text;
    private MessageLevel level;
    private static final Pattern PARAMETER = Pattern.compile("\\{([0-9]+)(?:\\:[^\\}]*)?\\}");

    public MessageLiteral(String string, TextLiteralCollection.TextLiteral textLiteral, MessageLevel messageLevel) {
        this.id = string;
        this.text = textLiteral;
        this.level = messageLevel;
    }

    public String getId() {
        return this.id;
    }

    public String getText() {
        return this.text.getText();
    }

    protected String createParameterizedText(Object ... objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = PARAMETER.matcher(this.getText());
        if (objectArray != null && objectArray.length > 0) {
            while (matcher.find()) {
                int n = -1;
                try {
                    n = Integer.parseInt(matcher.group(1));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                matcher.appendReplacement(stringBuffer, "");
                if (n < 0 || n >= objectArray.length || objectArray[n] == null) continue;
                stringBuffer.append(objectArray[n].toString());
            }
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public static int parseLevel(String string) {
        return MessageLevel.getId(string);
    }

    public static String convertLevelToText(int n) {
        return MessageLevel.getText(n);
    }

    public String getType() {
        return this.level.text;
    }

    public int getLevel() {
        return this.level.id;
    }

    public final String getMessage(Object ... objectArray) {
        return this.createParameterizedText(objectArray);
    }

    public final LogEvent generateLogEvent(Throwable throwable, Object ... objectArray) {
        String string = this.createParameterizedText(objectArray);
        LogEvent logEvent = new LogEvent(string, this.getLevel(), this.id);
        if (throwable != null) {
            logEvent.setStackTrace(throwable);
        }
        return logEvent;
    }

    public final void log(MIRLogger mIRLogger, Throwable throwable, Object ... objectArray) {
        LogEvent logEvent = this.generateLogEvent(throwable, objectArray);
        mIRLogger.log(logEvent);
    }

    public final void log(Object ... objectArray) {
        this.log(MIRLogger.getLogger(), null, objectArray);
    }

    public final void log(MIRLogger mIRLogger, Object ... objectArray) {
        this.log(mIRLogger, null, objectArray);
    }

    public final void log(Throwable throwable, Object ... objectArray) {
        this.log(MIRLogger.getLogger(), throwable, objectArray);
    }

    public static enum MessageLevel {
        NONE(0, "NONE"),
        FATAL(1, "FATAL"),
        ERROR(2, "ERROR"),
        WARNING(3, "WARNING"),
        STATUS(4, "STATUS"),
        INFO(5, "INFO"),
        DEBUG(6, "DEBUG");

        private int id;
        private String text;

        private MessageLevel(int n2, String string2) {
            this.id = n2;
            this.text = string2;
        }

        public static MessageLevel getById(int n) {
            return n >= 0 && n < MessageLevel.values().length ? MessageLevel.values()[n] : null;
        }

        public static String getText(int n) {
            for (MessageLevel messageLevel : MessageLevel.values()) {
                if (messageLevel.id != n) continue;
                return messageLevel.text;
            }
            return MessageLevel.NONE.text;
        }

        public static int getId(String string) {
            for (MessageLevel messageLevel : MessageLevel.values()) {
                if (!messageLevel.text.equals(string)) continue;
                return messageLevel.id;
            }
            return MessageLevel.NONE.id;
        }
    }
}

