/*
 * Decompiled with CFR 0.152.
 */
package MITI.util.ssl;

import MITI.util.ssl.TrustType;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;

public class RelaxedTrustManager
implements X509TrustManager {
    private final X509TrustManager tm;
    private TrustType type;
    private X509Certificate[] issuers;

    RelaxedTrustManager(X509TrustManager x509TrustManager, TrustType trustType) {
        this.tm = x509TrustManager;
        this.type = trustType;
        this.issuers = new X509Certificate[0];
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.issuers;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        try {
            this.tm.checkClientTrusted(x509CertificateArray, string);
        }
        catch (CertificateException certificateException) {
            switch (this.type) {
                case VALID: {
                    throw certificateException;
                }
                case SELF_SIGNED: {
                    for (X509Certificate x509Certificate : x509CertificateArray) {
                        x509Certificate.checkValidity();
                    }
                    break;
                }
            }
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        try {
            this.tm.checkServerTrusted(x509CertificateArray, string);
        }
        catch (CertificateException certificateException) {
            switch (this.type) {
                case VALID: {
                    throw certificateException;
                }
                case SELF_SIGNED: {
                    for (X509Certificate x509Certificate : x509CertificateArray) {
                        x509Certificate.checkValidity();
                    }
                    break;
                }
            }
        }
    }
}

