/*
 * Decompiled with CFR 0.152.
 */
package MITI.util.rest;

import MITI.util.file.FileUtil;
import MITI.util.ssl.SSLUtil;
import MITI.util.ssl.TrustLocalhostVerifier;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Proxy;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.rmi.RemoteException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class RestUtil {
    private static final int BUF_SIZE = 0xA00000;
    public static final String CONTENT_TYPE_MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String CONTENT_TYPE_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
    public static final String CONTENT_TYPE_JSON = "application/json";
    private static final int DEFAULT_BUFFER_SIZE = 10240;
    public static final String XML_REQUEST = "XmlRequest";
    public static final String FILE = "File";
    private static final Pattern UNSAFE_CHAR = Pattern.compile("(\\W+)");

    public static String readStream(InputStream inputStream, String string) {
        if (inputStream != null) {
            char[] cArray = new char[10240];
            StringBuilder stringBuilder = new StringBuilder();
            try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string);){
                int n;
                while ((n = ((Reader)inputStreamReader).read(cArray, 0, cArray.length)) >= 0) {
                    stringBuilder.append(cArray, 0, n);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return stringBuilder.toString();
        }
        return null;
    }

    public static final Document callRestXmlApi(URL uRL, Parameter parameter) throws RemoteException {
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        arrayList.add(parameter);
        return RestUtil.callRestXmlApi(uRL, arrayList);
    }

    public static final Document callRestXmlApi(URL uRL, List<Parameter> list) throws RemoteException {
        HttpURLConnection httpURLConnection = null;
        Document document = null;
        try {
            DocumentBuilder documentBuilder;
            httpURLConnection = RestUtil.openConnection(uRL);
            InputStream inputStream = RestUtil.callRestApi(httpURLConnection, CONTENT_TYPE_MULTIPART_FORM_DATA, list);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            try {
                documentBuilder = documentBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new RemoteException(parserConfigurationException.getMessage(), parserConfigurationException);
            }
            try {
                document = documentBuilder.parse(inputStream);
            }
            catch (SAXException sAXException) {
                throw new RemoteException(sAXException.getMessage(), sAXException);
            }
            catch (IOException iOException) {
                throw new RemoteException(iOException.getMessage(), iOException);
            }
        }
        catch (IOException | GeneralSecurityException exception) {
            throw new RemoteException(exception.getMessage(), exception);
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        return document;
    }

    public static final Document callRestXmlApi(HttpURLConnection httpURLConnection, List<Parameter> list) throws RemoteException {
        Document document = null;
        try {
            DocumentBuilder documentBuilder;
            InputStream inputStream = RestUtil.callRestApi(httpURLConnection, CONTENT_TYPE_MULTIPART_FORM_DATA, list);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            try {
                documentBuilder = documentBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new RemoteException(parserConfigurationException.getMessage(), parserConfigurationException);
            }
            try {
                document = documentBuilder.parse(inputStream);
            }
            catch (SAXException sAXException) {
                throw new RemoteException(sAXException.getMessage(), sAXException);
            }
            catch (IOException iOException) {
                throw new RemoteException(iOException.getMessage(), iOException);
            }
        }
        catch (IOException iOException) {
            throw new RemoteException(iOException.getMessage(), iOException);
        }
        return document;
    }

    public static final InputStream callRestApi(HttpURLConnection httpURLConnection, List<Parameter> list) throws IOException, RemoteException {
        return RestUtil.callRestApi(httpURLConnection, CONTENT_TYPE_MULTIPART_FORM_DATA, list);
    }

    public static final String callRestJsonApi(HttpURLConnection httpURLConnection, String string, String string2, List<Parameter> list) throws IOException, RemoteException {
        InputStream inputStream = RestUtil.callRestApi(httpURLConnection, string, CONTENT_TYPE_JSON, string2, list);
        return RestUtil.readStream(inputStream, StandardCharsets.UTF_8.name());
    }

    public static final InputStream callRestApi(HttpURLConnection httpURLConnection, String string, List<Parameter> list) throws IOException, RemoteException {
        return RestUtil.callRestApi(httpURLConnection, "POST", string, null, list);
    }

    public static final InputStream callRestApi(HttpURLConnection httpURLConnection, String string, String string2, String string3, List<Parameter> list) throws IOException, RemoteException {
        RestUtil.execRestApi(httpURLConnection, string, string2, string3, list);
        int n = httpURLConnection.getResponseCode();
        if (n != 200 && n != 201 && n != 202 && n != 204) {
            String string4 = httpURLConnection.getResponseMessage();
            String string5 = "";
            try (Object object = httpURLConnection.getErrorStream();){
                if (object != null) {
                    string5 = RestUtil.readStream((InputStream)object, FileUtil.UTF8.name());
                }
            }
            object = String.join((CharSequence)" ", String.valueOf(n), string4 != null ? string4 : "", string5);
            throw new RemoteException((String)object);
        }
        return httpURLConnection.getInputStream();
    }

    public static final void execRestApi(HttpURLConnection httpURLConnection, String string, List<Parameter> list) throws IOException, RemoteException {
        RestUtil.execRestApi(httpURLConnection, "POST", string, null, list);
    }

    public static final void execRestApi(HttpURLConnection httpURLConnection, String string, String string2, String string3, List<Parameter> list) throws IOException, RemoteException {
        String string4 = Long.toHexString(System.currentTimeMillis());
        String string5 = StandardCharsets.UTF_8.name();
        OutputStream outputStream = null;
        httpURLConnection.setRequestProperty("Accept-Charset", string5);
        httpURLConnection.setRequestMethod(string);
        if (list != null && !list.isEmpty() || string3 != null && !string3.isEmpty()) {
            if (string.equals("POST") || string.equals("PUT")) {
                httpURLConnection.setDoOutput(true);
            }
            if (string2.equalsIgnoreCase(CONTENT_TYPE_WWW_FORM_URLENCODED) || string2.equalsIgnoreCase(CONTENT_TYPE_JSON)) {
                httpURLConnection.setRequestProperty("Content-Type", string2.equalsIgnoreCase(CONTENT_TYPE_WWW_FORM_URLENCODED) ? CONTENT_TYPE_WWW_FORM_URLENCODED : CONTENT_TYPE_JSON);
                String string6 = null;
                if (string3 != null && !string3.isEmpty()) {
                    string6 = string3;
                } else if (list != null && !list.isEmpty()) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (Parameter parameter : list) {
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append("&");
                        }
                        stringBuffer.append(parameter.name).append("=").append(parameter.value);
                    }
                    string6 = stringBuffer.toString();
                }
                if (string6 != null && !string6.isEmpty()) {
                    httpURLConnection.setRequestProperty("Content-Length", "" + string6.length());
                    outputStream = httpURLConnection.getOutputStream();
                    RestUtil.print(outputStream, string6);
                    outputStream.flush();
                }
            } else if (string2.equalsIgnoreCase(CONTENT_TYPE_MULTIPART_FORM_DATA) && list != null && !list.isEmpty()) {
                httpURLConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + string4);
                outputStream = httpURLConnection.getOutputStream();
                for (Parameter parameter : list) {
                    if (parameter instanceof FileParameter) {
                        FileParameter fileParameter = (FileParameter)parameter;
                        RestUtil.printFileFormData(outputStream, string4, fileParameter);
                        continue;
                    }
                    if (parameter instanceof LargeTextParameter) {
                        RestUtil.printLargeTextFormData(outputStream, string4, string5, "text/plain", (LargeTextParameter)parameter);
                        continue;
                    }
                    RestUtil.printTextFormData(outputStream, string4, string5, parameter);
                }
                RestUtil.printFormDataEnd(outputStream, string4);
            }
        }
    }

    private static void println(OutputStream outputStream, String string) throws IOException {
        outputStream.write((string + "\r\n").getBytes(FileUtil.UTF8));
    }

    private static void print(OutputStream outputStream, String string) throws IOException {
        outputStream.write(string.getBytes(FileUtil.UTF8));
    }

    public static void printTextFormData(OutputStream outputStream, String string, String string2, Parameter parameter) throws IOException {
        RestUtil.println(outputStream, "--" + string);
        RestUtil.println(outputStream, "Content-Disposition: form-data; name=\"" + parameter.name + "\"");
        RestUtil.println(outputStream, "Content-Type: text/plain; charset=" + string2);
        RestUtil.println(outputStream, "");
        RestUtil.println(outputStream, parameter.value);
        outputStream.flush();
    }

    public static void printFileFormData(OutputStream outputStream, String string, FileParameter fileParameter) throws IOException {
        RestUtil.println(outputStream, "--" + string);
        RestUtil.println(outputStream, "Content-Disposition: form-data; name=\"" + fileParameter.name + "\"; filename=\"" + fileParameter.file.getName() + "\"");
        if (fileParameter.contentType.equalsIgnoreCase("text/plain")) {
            RestUtil.println(outputStream, "Content-Type: text/plain; charset=" + fileParameter.charSet);
        } else {
            RestUtil.println(outputStream, "Content-Type: " + fileParameter.contentType + (fileParameter.charSet != null ? "; Content-Transfer-Encoding=" + fileParameter.charSet : ""));
        }
        RestUtil.println(outputStream, "");
        Files.copy(fileParameter.file.toPath(), outputStream);
        RestUtil.println(outputStream, "");
        outputStream.flush();
    }

    public static void printLargeTextFormData(OutputStream outputStream, String string, String string2, String string3, LargeTextParameter largeTextParameter) throws IOException {
        RestUtil.println(outputStream, "--" + string);
        RestUtil.println(outputStream, "Content-Disposition: form-data; name=\"" + largeTextParameter.name + "\"; filename=\"" + largeTextParameter.name + "\"");
        if (string3.equalsIgnoreCase("text/plain")) {
            RestUtil.println(outputStream, "Content-Type: text/plain; charset=" + string2);
        } else {
            RestUtil.println(outputStream, "Content-Type: " + string3 + "; Content-Transfer-Encoding: " + string2);
        }
        RestUtil.println(outputStream, "");
        RestUtil.println(outputStream, largeTextParameter.value);
        RestUtil.println(outputStream, "");
        outputStream.flush();
    }

    public static void printFormDataEnd(OutputStream outputStream, String string) throws IOException {
        RestUtil.println(outputStream, "--" + string + "--");
        outputStream.flush();
    }

    public static void downloadFile(InputStream inputStream, File file) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            int n = -1;
            byte[] byArray = new byte[0xA00000];
            while ((n = inputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
        }
    }

    public static boolean isLocal(InetAddress inetAddress) {
        if (inetAddress.isAnyLocalAddress() || inetAddress.isLoopbackAddress()) {
            return true;
        }
        try {
            return NetworkInterface.getByInetAddress(inetAddress) != null;
        }
        catch (SocketException socketException) {
            return false;
        }
    }

    public static boolean isLocal(URL uRL) {
        String string = uRL.getHost();
        if (string == null || string.isEmpty()) {
            return true;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            return RestUtil.isLocal(inetAddress);
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }

    public static HttpURLConnection openConnection(URL uRL) throws IOException, GeneralSecurityException {
        return RestUtil.openConnection(uRL, null);
    }

    public static HttpURLConnection openConnection(URL uRL, Proxy proxy) throws IOException, GeneralSecurityException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)(proxy != null ? uRL.openConnection(proxy) : uRL.openConnection());
        if (httpURLConnection instanceof HttpsURLConnection) {
            SSLContext sSLContext = SSLUtil.getSslContext(uRL, proxy, true, false);
            ((HttpsURLConnection)httpURLConnection).setSSLSocketFactory(sSLContext.getSocketFactory());
            if ("localhost".equalsIgnoreCase(uRL.getHost())) {
                ((HttpsURLConnection)httpURLConnection).setHostnameVerifier(new TrustLocalhostVerifier());
            }
        }
        return httpURLConnection;
    }

    public static String appendURLPath(String string, String string2) {
        if (string == null || string.isEmpty()) {
            string = "/";
        }
        if (string.endsWith("/") && string2.startsWith("/")) {
            return string + string2.substring(1);
        }
        if (!string.endsWith("/") && !string2.startsWith("/")) {
            return string + "/" + string2;
        }
        return string + string2;
    }

    public static String encodeUrlParameter(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = UNSAFE_CHAR.matcher(string);
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, "");
            for (byte by : matcher.group().getBytes(StandardCharsets.UTF_8)) {
                stringBuffer.append("%").append(String.format("%02X", by));
            }
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public static class LargeTextParameter
    extends Parameter {
        public LargeTextParameter(String string, String string2) {
            super(string, string2);
        }
    }

    public static class FileParameter
    extends Parameter {
        public File file;
        public String charSet;
        public String contentType;

        public FileParameter(String string, File file, String string2, String string3) {
            super(string, "");
            this.file = file;
            this.charSet = string2;
            this.contentType = string3;
        }
    }

    public static class Parameter {
        public String name;
        public String value;

        public Parameter() {
        }

        public Parameter(String string, String string2) {
            this.name = string;
            this.value = string2;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

