/*
 * Decompiled with CFR 0.152.
 */
package MITI.util.reflect;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import sun.net.www.protocol.file.FileURLConnection;

public class ReflectUtil {
    public static URLConnection getUrlConnection(Class<?> clazz, String string) {
        block10: {
            try {
                URLConnection uRLConnection;
                URL uRL = clazz.getResource(string);
                if (uRL == null) break block10;
                if (uRL.toString().startsWith("wsjar:")) {
                    uRL = new URL(uRL.toString().substring(2));
                } else if (uRL.toString().startsWith("war:")) {
                    uRL = new URL(uRL.toString().replace("war:", "jar:").replace("*", "!"));
                } else if (uRL.toString().startsWith("bundleresource:")) {
                    uRLConnection = uRL.openConnection();
                    try {
                        Method method = uRLConnection.getClass().getMethod("getLocalURL", new Class[0]);
                        uRL = (URL)method.invoke((Object)uRLConnection, new Object[0]);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                        // empty catch block
                    }
                }
                uRLConnection = uRL.openConnection();
                if ("org.apache.catalina.webresources.CachedResource$CachedResourceURLConnection".equals(uRLConnection.getClass().getName())) {
                    uRLConnection = uRLConnection.getURL().openConnection();
                }
                return uRLConnection;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static <T> Collection<Class<? extends T>> listSubclasses(Class<T> clazz) {
        Collection<Class<Object>> collection = new ArrayList<Class<? extends T>>();
        try {
            String string = clazz.getPackage().getName().replace('.', '/');
            URLConnection uRLConnection = ReflectUtil.getUrlConnection(clazz, "/" + string);
            if (uRLConnection instanceof JarURLConnection) {
                collection = ReflectUtil.listSubclasses(clazz, string, ((JarURLConnection)uRLConnection).getJarFile());
            } else if (uRLConnection instanceof FileURLConnection) {
                collection = ReflectUtil.listSubclasses(clazz, string, new File(uRLConnection.getURL().getFile().replace("%20", " ")));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return collection;
    }

    private static <T> Collection<Class<? extends T>> listSubclasses(Class<T> clazz, String string, JarFile jarFile) {
        boolean bl = jarFile.getName().endsWith(".war");
        ArrayList<Class<T>> arrayList = new ArrayList<Class<T>>();
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            Class<T> clazz2;
            String string2 = enumeration.nextElement().getName();
            if (bl) {
                string2 = string2.replace("WEB-INF/classes/", "");
            }
            if (!string2.startsWith(string) || !string2.endsWith(".class") || (clazz2 = ReflectUtil.asSubclass(string2, clazz)) == null) continue;
            arrayList.add(clazz2);
        }
        try {
            jarFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return arrayList;
    }

    private static <T> Collection<Class<? extends T>> listSubclasses(Class<T> clazz, String string, File file) {
        ArrayList<Class<T>> arrayList = new ArrayList<Class<T>>();
        for (File file2 : file.listFiles()) {
            Class<T> clazz2;
            if (file2.isDirectory()) {
                arrayList.addAll(ReflectUtil.listSubclasses(clazz, string + "/" + file2.getName(), file2));
                continue;
            }
            if (!file2.isFile() || !file2.getName().endsWith(".class") || (clazz2 = ReflectUtil.asSubclass(string + "/" + file2.getName(), clazz)) == null) continue;
            arrayList.add(clazz2);
        }
        return arrayList;
    }

    private static <T> Class<? extends T> asSubclass(String string, Class<T> clazz) {
        try {
            Class<T> clazz2 = Class.forName(string.substring(0, string.length() - 6).replace('/', '.'), true, clazz.getClassLoader()).asSubclass(clazz);
            if (clazz2 != clazz) {
                return clazz2;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }
}

