/*
 * Decompiled with CFR 0.152.
 */
package MITI.util.os;

import java.util.Locale;

public class OsInfo {
    private String name;
    private String version;
    private String arch;
    private OSType type;

    protected OsInfo(String string, String string2, String string3) {
        this.name = string;
        this.version = string2;
        this.arch = string3;
        this.type = OSType.get(string);
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getArch() {
        return this.arch;
    }

    public OSType getType() {
        return this.type;
    }

    public String toString() {
        return this.name + " " + this.version + " " + this.arch;
    }

    public static enum OSType {
        Windows,
        MacOS,
        Linux,
        Solaris,
        Other;


        private static OSType get(String string) {
            String string2 = string.toLowerCase(Locale.ENGLISH);
            if (string2.indexOf("mac") >= 0 || string2.indexOf("darwin") >= 0) {
                return MacOS;
            }
            if (string2.indexOf("win") >= 0) {
                return Windows;
            }
            if (string2.indexOf("nux") >= 0) {
                return Linux;
            }
            if (string2.indexOf("solaris") >= 0 || string2.indexOf("sunos") >= 0) {
                return Solaris;
            }
            return Other;
        }
    }
}

