/*
 * Decompiled with CFR 0.152.
 */
package MITI.util.net;

import MITI.util.net.QueryParameters;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UrlUtil {
    private static final char DELIM = '/';
    private static final Pattern UNSAFE_CHAR = Pattern.compile("(\\W+)");

    public static String append(String string, String string2) {
        return UrlUtil.append(string, string2, null);
    }

    public static String append(String string, QueryParameters queryParameters) {
        return UrlUtil.append(string, null, queryParameters);
    }

    public static String append(String string, String string2, QueryParameters queryParameters) {
        char c;
        StringBuilder stringBuilder = new StringBuilder();
        if (string == null || string.isEmpty()) {
            stringBuilder.append('/');
        } else {
            stringBuilder.append(string);
        }
        if (string2 != null && !string2.isEmpty()) {
            if ('/' != stringBuilder.charAt(stringBuilder.length() - 1)) {
                stringBuilder.append('/');
            }
            c = '/' == string2.charAt(0) ? (char)'\u0001' : '\u0000';
            stringBuilder.append(string2.substring(c));
        }
        if (queryParameters != null && !queryParameters.isEmpty()) {
            if (string2 != null) {
                if (!string2.contains("?") && !string2.contains("#")) {
                    stringBuilder.append("?");
                }
            } else if (string != null && !string.contains("?") && !string.contains("#")) {
                stringBuilder.append("?");
            }
            boolean bl = (c = stringBuilder.charAt(stringBuilder.length() - 1)) == '?' || c == '#';
            for (Map.Entry<String, String> entry : queryParameters.entrySet()) {
                if (!bl) {
                    stringBuilder.append("&");
                }
                stringBuilder.append(entry.getKey());
                stringBuilder.append("=");
                stringBuilder.append(entry.getValue());
                bl = false;
            }
        }
        return stringBuilder.toString();
    }

    public static String encode(String string) {
        return UrlUtil.encode(new StringBuffer(), string).toString();
    }

    private static StringBuffer encode(StringBuffer stringBuffer, String string) {
        Matcher matcher = UNSAFE_CHAR.matcher(string);
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, "");
            for (byte by : matcher.group().getBytes(StandardCharsets.UTF_8)) {
                stringBuffer.append("%").append(String.format("%02X", by));
            }
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer;
    }
}

