/*
 * Decompiled with CFR 0.152.
 */
package MITI.util.net;

import MITI.util.net.UrlUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;

public class HttpMessage {
    private ContentType contentType;
    private Charset charset;
    private String body;
    private Map<String, String> parameters;
    private Map<String, File> files;
    private byte[] payload;
    private String boundary;

    public HttpMessage(ContentType contentType, String string) {
        this(contentType, string, null, null);
    }

    public HttpMessage(ContentType contentType, Map<String, String> map) {
        this(contentType, "", map, null);
    }

    public HttpMessage(ContentType contentType, Map<String, String> map, Map<String, File> map2) {
        this(contentType, "", map, map2);
    }

    private HttpMessage(ContentType contentType, String string, Map<String, String> map, Map<String, File> map2) {
        this.contentType = contentType;
        this.charset = StandardCharsets.UTF_8;
        this.body = string != null ? string : "";
        this.parameters = new LinkedHashMap<String, String>();
        if (map != null) {
            this.parameters.putAll(map);
        }
        this.files = new LinkedHashMap<String, File>();
        if (map2 != null) {
            this.files.putAll(map2);
        }
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getBody() {
        return this.body;
    }

    public boolean isEmpty() {
        return this.body.isEmpty() && this.parameters.isEmpty() && this.files.isEmpty();
    }

    public byte[] getPayload() {
        if (this.payload == null) {
            StringBuilder stringBuilder = new StringBuilder();
            if (!this.body.isEmpty()) {
                stringBuilder.append(this.body);
            } else {
                boolean bl = this.contentType == ContentType.WWW_FORM_URLENCODED;
                for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append("&");
                    }
                    stringBuilder.append(bl ? UrlUtil.encode(entry.getKey()) : entry.getKey());
                    stringBuilder.append("=");
                    stringBuilder.append(bl ? UrlUtil.encode(entry.getValue()) : entry.getValue());
                }
            }
            this.payload = stringBuilder.toString().getBytes(this.charset);
        }
        return this.payload;
    }

    public String getBoundary() {
        if (this.boundary == null) {
            this.boundary = String.format("%016x+%016x", ThreadLocalRandom.current().nextLong(), System.currentTimeMillis());
        }
        return this.boundary;
    }

    public void print(OutputStream outputStream) throws IOException {
        if (this.contentType == ContentType.WWW_FORM_URLENCODED || this.contentType == ContentType.JSON) {
            outputStream.write(this.getPayload());
        } else if (this.contentType == ContentType.MULTIPART_FORM_DATA) {
            for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
                this.printTextFormData(outputStream, entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Object> entry : this.files.entrySet()) {
                this.printFileFormData(outputStream, entry.getKey(), (File)entry.getValue());
            }
            this.println(outputStream, "--" + this.getBoundary() + "--");
        }
        outputStream.flush();
    }

    private void println(OutputStream outputStream, String string) throws IOException {
        outputStream.write((string + "\r\n").getBytes(this.charset));
    }

    private void printTextFormData(OutputStream outputStream, String string, String string2) throws IOException {
        this.println(outputStream, "--" + this.getBoundary());
        this.println(outputStream, "Content-Disposition: form-data; name=\"" + string + "\"");
        this.println(outputStream, "Content-Type: text/plain; charset=" + this.charset.name());
        this.println(outputStream, "");
        this.println(outputStream, string2);
        outputStream.flush();
    }

    private void printFileFormData(OutputStream outputStream, String string, File file) throws IOException {
        this.println(outputStream, "--" + this.getBoundary());
        this.println(outputStream, "Content-Disposition: form-data; name=\"" + string + "\"; filename=\"" + file.getName() + "\"");
        this.println(outputStream, "Content-Type: application/octet-stream");
        this.println(outputStream, "");
        Files.copy(file.toPath(), outputStream);
        this.println(outputStream, "");
        outputStream.flush();
    }

    public static enum ContentType {
        MULTIPART_FORM_DATA("multipart/form-data"),
        WWW_FORM_URLENCODED("application/x-www-form-urlencoded"),
        JSON("application/json");

        private String type;

        private ContentType(String string2) {
            this.type = string2;
        }

        public String getType() {
            return this.type;
        }
    }
}

