/*
 * Decompiled with CFR 0.152.
 */
package MITI.util.memory;

public enum MemoryUnit {
    TERA("T", 4),
    GIGA("G", 3),
    MEGA("m", 2),
    KILO("k", 1),
    BYTE("", 0);

    private String unit;
    private int power;

    private MemoryUnit(String string2, int n2) {
        this.unit = string2;
        this.power = n2;
    }

    public String getBinaryValue(long l) {
        return MemoryUnit.getString(l, 1024L, 0);
    }

    public static String getJvmString(long l) {
        return MemoryUnit.getString(l, 1000L, 1);
    }

    private static String getString(long l, long l2, int n) {
        for (MemoryUnit memoryUnit : MemoryUnit.values()) {
            long l3 = (long)Math.pow(l2, memoryUnit.power);
            if (l + l2 <= l3) continue;
            long l4 = l / l3;
            if (l > l3 && memoryUnit.power > 2 && n > 0) {
                long l5 = (l - l3) * (long)Math.pow(10.0, n) / l3;
                return String.valueOf(l4) + "." + String.valueOf(l5 + 1L) + memoryUnit.unit;
            }
            return String.valueOf(l4 + 1L) + memoryUnit.unit;
        }
        return String.valueOf(l);
    }
}

