/*
 * Decompiled with CFR 0.152.
 */
package MITI.util.memory;

import com.sun.management.GarbageCollectionNotificationInfo;
import com.sun.management.HotSpotDiagnosticMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.Map;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;

public class MemMonitor
implements NotificationListener {
    private static double minFreeRatio = 40.0;
    private static double maxFreeRatio = 70.0;
    private long maxCommittedBefore;
    private long maxCommittedAfter;
    private long maxUsedBefore;
    private long maxUsedAfter;
    private ArrayList<NotificationEmitter> emitters = new ArrayList();

    public static MemMonitor start() {
        MemMonitor memMonitor = new MemMonitor();
        for (GarbageCollectorMXBean garbageCollectorMXBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            if (!(garbageCollectorMXBean instanceof NotificationEmitter)) continue;
            memMonitor.add((NotificationEmitter)((Object)garbageCollectorMXBean));
        }
        return memMonitor;
    }

    private MemMonitor() {
    }

    public long getMaxUsedMemory() {
        return Math.max(this.maxUsedBefore, this.maxUsedAfter);
    }

    public long getMaxCommittedMemory() {
        return Math.max(this.maxCommittedBefore, this.maxCommittedAfter);
    }

    public long getRecommendedMemory() {
        return (long)((double)this.getMaxCommittedMemory() * (maxFreeRatio / 100.0) + (double)this.getMaxUsedMemory() * ((minFreeRatio + 100.0) / 100.0)) / 2L + 1L;
    }

    public boolean hasData() {
        return this.maxCommittedBefore > 1024L && this.maxCommittedAfter > 1024L && this.maxUsedBefore > 1024L && this.maxUsedAfter > 1024L;
    }

    private void add(NotificationEmitter notificationEmitter) {
        this.emitters.add(notificationEmitter);
        notificationEmitter.addNotificationListener(this, null, null);
    }

    public void stop() {
        for (NotificationEmitter notificationEmitter : this.emitters) {
            try {
                notificationEmitter.removeNotificationListener(this);
            }
            catch (ListenerNotFoundException listenerNotFoundException) {}
        }
        this.emitters.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleNotification(Notification notification, Object object) {
        block5: {
            try {
                if (!notification.getType().equals("com.sun.management.gc.notification")) break block5;
                GarbageCollectionNotificationInfo garbageCollectionNotificationInfo = GarbageCollectionNotificationInfo.from((CompositeData)notification.getUserData());
                MemMonitor memMonitor = this;
                synchronized (memMonitor) {
                    this.maxCommittedBefore = Math.max(this.maxCommittedBefore, this.getCommittedMem(garbageCollectionNotificationInfo.getGcInfo().getMemoryUsageBeforeGc()));
                    this.maxCommittedAfter = Math.max(this.maxCommittedAfter, this.getCommittedMem(garbageCollectionNotificationInfo.getGcInfo().getMemoryUsageAfterGc()));
                    this.maxUsedBefore = Math.max(this.maxUsedBefore, this.getUsedMem(garbageCollectionNotificationInfo.getGcInfo().getMemoryUsageBeforeGc()));
                    this.maxUsedAfter = Math.max(this.maxUsedAfter, this.getUsedMem(garbageCollectionNotificationInfo.getGcInfo().getMemoryUsageAfterGc()));
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
    }

    private long getCommittedMem(Map<String, MemoryUsage> map) {
        long l = 0L;
        for (MemoryUsage memoryUsage : map.values()) {
            l += memoryUsage.getCommitted();
        }
        return l;
    }

    private long getUsedMem(Map<String, MemoryUsage> map) {
        long l = 0L;
        for (MemoryUsage memoryUsage : map.values()) {
            l += memoryUsage.getUsed();
        }
        return l;
    }

    static {
        try {
            HotSpotDiagnosticMXBean hotSpotDiagnosticMXBean = ManagementFactory.getPlatformMXBean(HotSpotDiagnosticMXBean.class);
            try {
                minFreeRatio = Double.parseDouble(hotSpotDiagnosticMXBean.getVMOption("MinHeapFreeRatio").getValue());
            }
            catch (NullPointerException | NumberFormatException runtimeException) {
                // empty catch block
            }
            try {
                maxFreeRatio = Double.parseDouble(hotSpotDiagnosticMXBean.getVMOption("MaxHeapFreeRatio").getValue());
            }
            catch (NullPointerException | NumberFormatException runtimeException) {}
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }
}

