/*
 * Decompiled with CFR 0.152.
 */
package MITI.util.log;

import MITI.util.log.BufferedLogEventHandler;
import MITI.util.log.LogEvent;
import MITI.util.log.LogEventHandler;
import MITI.util.log.PrintStreamLogEventHandler;
import MITI.util.text.MessageLiteral;
import MITI.util.thread.ThreadVariable;
import java.util.ArrayList;
import java.util.Collection;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class MIRLogger {
    private static MIRLogger STD_OUT = new MIRLogger(PrintStreamLogEventHandler.STD_OUT);
    private static MIRLogger DEFAULT_LOGGER = null;
    private static ThreadVariable<MIRLogger> loggers = new ThreadVariable<MIRLogger>(){

        @Override
        protected synchronized MIRLogger initialValue() {
            return DEFAULT_LOGGER != null ? DEFAULT_LOGGER : STD_OUT;
        }
    };
    public static final String ENV_MIR_LOG_LEVEL = "MIR_LOG_LEVEL";
    private static MessageLiteral.MessageLevel globalLevel = MIRLogger.getEnvGlobalLogLevel();
    private ArrayList<LogEventHandler> handlers = new ArrayList();
    private MessageLiteral.MessageLevel localLevel;

    public static void setLogger(MIRLogger mIRLogger) {
        loggers.set(mIRLogger);
    }

    public static MIRLogger getLogger() {
        return (MIRLogger)loggers.get();
    }

    public static void clear() {
        loggers.remove();
    }

    private static MessageLiteral.MessageLevel getEnvGlobalLogLevel() {
        String string = null;
        try {
            string = (String)new InitialContext().lookup("java:comp/env/miti.log.level");
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        if (string == null || string.isEmpty()) {
            string = System.getenv(ENV_MIR_LOG_LEVEL);
        }
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = MessageLiteral.MessageLevel.getId(string);
        }
        MessageLiteral.MessageLevel messageLevel = MessageLiteral.MessageLevel.getById(n);
        if (messageLevel == null || messageLevel == MessageLiteral.MessageLevel.NONE) {
            messageLevel = MessageLiteral.MessageLevel.INFO;
        }
        return messageLevel;
    }

    public static MIRLogger getNullLogger() {
        return new MIRLogger(new LogEventHandler[0]);
    }

    public static MIRLogger init(LogEventHandler ... logEventHandlerArray) {
        MIRLogger mIRLogger = new MIRLogger(logEventHandlerArray);
        if (DEFAULT_LOGGER == null) {
            DEFAULT_LOGGER = mIRLogger;
        }
        MIRLogger.setLogger(mIRLogger);
        return mIRLogger;
    }

    protected MIRLogger(LogEventHandler ... logEventHandlerArray) {
        if (logEventHandlerArray != null) {
            for (LogEventHandler logEventHandler : logEventHandlerArray) {
                if (logEventHandler == null) continue;
                this.handlers.add(logEventHandler);
            }
        }
    }

    public synchronized void log(LogEvent logEvent) {
        for (LogEventHandler logEventHandler : this.handlers) {
            logEventHandler.log(logEvent, this.getLevel());
        }
    }

    public synchronized Collection<LogEvent> getEvents() {
        for (LogEventHandler logEventHandler : this.handlers) {
            if (!(logEventHandler instanceof BufferedLogEventHandler)) continue;
            return ((BufferedLogEventHandler)logEventHandler).getEvents();
        }
        return null;
    }

    public static boolean isDebug() {
        return MIRLogger.getLogger().getLevel() >= 6;
    }

    public static int getGlobalLevel() {
        return globalLevel.ordinal();
    }

    public static void setGlobalLevel(int n) {
        MessageLiteral.MessageLevel messageLevel = MessageLiteral.MessageLevel.getById(n);
        if (messageLevel != null) {
            globalLevel = messageLevel;
        }
    }

    public int getLocalLevel() {
        return this.localLevel != null ? this.localLevel.ordinal() : -1;
    }

    public void setLocalLevel(int n) {
        this.localLevel = MessageLiteral.MessageLevel.getById(n);
    }

    public int getLevel() {
        return this.localLevel != null ? this.localLevel.ordinal() : globalLevel.ordinal();
    }
}

