/*
 * Decompiled with CFR 0.152.
 */
package MITI.util.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Collections;
import java.util.Map;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class YamlFile {
    public static final String YAML_LIB = "Yaml/snakeyaml-2.0.jar";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> load(File file) {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            Map<String, String> map = YamlFile.load(fileInputStream);
            return map;
        }
        catch (IOException iOException) {
            return Collections.emptyMap();
        }
    }

    public static Map<String, String> load(InputStream inputStream) {
        Yaml yaml = YamlFile.getSafeYaml(1);
        Object t = yaml.load(inputStream);
        if (t instanceof Map) {
            return (Map)t;
        }
        return Collections.emptyMap();
    }

    public static Map<String, String> load(String string) {
        Yaml yaml = YamlFile.getSafeYaml(1);
        Object t = yaml.load(new StringReader(string));
        if (t instanceof Map) {
            return (Map)t;
        }
        return Collections.emptyMap();
    }

    public static String toYaml(Map<String, String> map) {
        Yaml yaml = YamlFile.getSafeYaml(1);
        return yaml.dumpAsMap(map);
    }

    private static Yaml getSafeYaml(int n) {
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setAllowDuplicateKeys(false);
        loaderOptions.setAllowRecursiveKeys(false);
        loaderOptions.setMaxAliasesForCollections(0);
        loaderOptions.setNestingDepthLimit(n);
        return new Yaml(new SafeConstructor(loaderOptions));
    }
}

