/*
 * Decompiled with CFR 0.152.
 */
package MITI.util.file;

import MITI.util.file.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertyFile {
    private static final Pattern PROPERTY = Pattern.compile("^\\s*([^\\r\\n#=][^\\r\\n=]*)=([^\\r\\n]*).*$", 8);
    private boolean modified;
    private File file;
    private Map<String, String> properties = new LinkedHashMap<String, String>();

    public PropertyFile(File file) {
        this.file = file;
        if (this.file.isFile()) {
            String string = FileUtil.readContent(this.file, FileUtil.UTF8);
            Matcher matcher = PROPERTY.matcher(string);
            while (matcher.find()) {
                String string2 = matcher.group(1).trim();
                String string3 = matcher.group(2).trim();
                this.properties.put(string2, string3);
            }
        }
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean getBooleanProperty(String string) {
        String string2 = this.properties.get(string);
        if (string2 != null && !string2.isEmpty()) {
            return Boolean.parseBoolean(string2);
        }
        return false;
    }

    public int getIntProperty(String string) {
        String string2 = this.properties.get(string);
        if (string2 != null && !string2.isEmpty()) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public String getStringProperty(String string) {
        String string2 = this.properties.get(string);
        if (string2 != null) {
            return string2;
        }
        return "";
    }

    public void setProperty(String string, String string2) {
        String string3;
        if (string2 == null) {
            string2 = "";
        }
        this.modified |= !string2.equals(string3 = this.properties.put(string, string2));
    }

    public void save() {
        if (this.modified) {
            if (!this.file.isFile()) {
                try {
                    this.file.createNewFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            linkedHashSet.addAll(this.properties.keySet());
            StringBuffer stringBuffer = new StringBuffer();
            String string = FileUtil.readContent(this.file, FileUtil.UTF8);
            if (string != null && !string.isEmpty()) {
                Matcher matcher = PROPERTY.matcher(string);
                while (matcher.find()) {
                    String string2 = matcher.group(1).trim();
                    matcher.appendReplacement(stringBuffer, "");
                    stringBuffer.append(string2).append("=").append(this.properties.get(string2));
                    linkedHashSet.remove(string2);
                }
                matcher.appendTail(stringBuffer);
            }
            for (String string2 : linkedHashSet) {
                stringBuffer.append("\n").append(string2).append("=").append(this.properties.get(string2));
            }
            FileUtil.writeContent(this.file, stringBuffer.toString(), FileUtil.UTF8);
        }
        this.modified = false;
    }
}

