/*
 * Decompiled with CFR 0.152.
 */
package MITI.util.file;

import MITI.util.StringDigest;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class FileChecksum {
    public static String getMd5(File file) {
        return FileChecksum.getDigest(file, StringDigest.getMd5());
    }

    public static String getSha1(File file) {
        return FileChecksum.getDigest(file, StringDigest.getSha1());
    }

    public static String getSha256(File file) {
        return FileChecksum.getDigest(file, StringDigest.getSha256());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getDigest(File file, StringDigest stringDigest) {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            FileChannel fileChannel = fileInputStream.getChannel();
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(0x100000);
            while (true) {
                int n;
                if ((n = fileChannel.read(byteBuffer)) < 0) {
                    String string = stringDigest.toString();
                    return string;
                }
                byteBuffer.flip();
                stringDigest.update(byteBuffer);
                byteBuffer.clear();
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

