/*
 * Decompiled with CFR 0.152.
 */
package MITI.util.cmd;

import MITI.util.cmd.CommandLineOption;
import java.io.File;

public abstract class TypedOption
extends CommandLineOption {
    protected Type type;

    public TypedOption(String[] stringArray, String string, Type type) {
        super(stringArray, string);
        this.type = type;
    }

    protected void checkValue(String string) {
        if (this.type == Type.INT) {
            Integer.valueOf(string);
        } else if (this.type == Type.BOOL) {
            if (!"true".equalsIgnoreCase(string) && !"false".equalsIgnoreCase(string)) {
                throw new IllegalArgumentException("Boolean value should be true or false");
            }
        } else if (this.type == Type.PATH || this.type == Type.FILE || this.type == Type.DIRECTORY) {
            File file = new File(string);
            if (!file.exists()) {
                throw new IllegalArgumentException("Path does not exist");
            }
            if (this.type == Type.FILE && !file.isFile()) {
                throw new IllegalArgumentException("Path does not denote a file");
            }
            if (this.type == Type.DIRECTORY && !file.isDirectory()) {
                throw new IllegalArgumentException("Path does not denote a directory");
            }
        }
    }

    public static enum Type {
        INT("int"),
        BOOL("true|false"),
        STRING("string"),
        PATH("path"),
        FILE("file"),
        DIRECTORY("directory");

        private String value;

        private Type(String string2) {
            this.value = string2;
        }

        public String toString() {
            return this.value;
        }
    }
}

