/*
 * Decompiled with CFR 0.152.
 */
package MITI.util;

import MITI.util.XmlVersion;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class XmlUtil {
    public static final NsName NS_XMLNS_XSI = new NsName("xsi", "http://www.w3.org/2001/XMLSchema-instance");
    public static final NsName NS_XMI = new NsName("xmi", "http://www.omg.org/XMI");
    public static final NsName NS_MIR = new NsName("mir", "http://www.metaintegration.com/MIR_XMI_61");
    private static final String EOL = "\n";

    public static final String escapeXml(String string) {
        return XmlUtil.escapeXml(string, XmlVersion.XML_10);
    }

    public static final String escapeXml11(String string) {
        return XmlUtil.escapeXml(string, XmlVersion.XML_11);
    }

    public static final boolean containsUnprintableXmlCharacters(String string) {
        if (string != null) {
            XmlVersion xmlVersion = XmlVersion.get();
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c != '\u0000' && (xmlVersion != XmlVersion.XML_10 || c >= ' ')) continue;
                return true;
            }
        }
        return false;
    }

    public static final String escapeXml(String string, XmlVersion xmlVersion) {
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer(string.length() + 32);
            int n = 0;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (xmlVersion.getEscape(c) == null) continue;
                stringBuffer.append(string, n, i).append(xmlVersion.getEscape(c));
                n = i + 1;
            }
            if (n > 0) {
                return stringBuffer.append(string, n, string.length()).toString();
            }
        }
        return string;
    }

    public static void printXml(Element element, StringBuffer stringBuffer) {
        XmlUtil.printXml(element, stringBuffer, "", true);
    }

    public static void printXml(Element element, StringBuffer stringBuffer, String string, boolean bl) {
        String string2;
        String string3;
        int n;
        String string4 = null;
        if (bl) {
            string4 = element.getNodeName();
        } else {
            string4 = element.getLocalName();
            if (string4 == null) {
                string4 = element.getNodeName();
            }
        }
        String string5 = string;
        String string6 = EOL;
        if (string == null) {
            string5 = "";
            string6 = "";
        }
        stringBuffer.append(string5).append('<').append(string4);
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (n = 0; n < namedNodeMap.getLength(); ++n) {
            Node node = namedNodeMap.item(n);
            string3 = null;
            if (bl) {
                string3 = node.getNodeName();
            } else {
                string3 = node.getLocalName();
                if (string3 == null) {
                    string3 = node.getNodeName();
                }
            }
            if (!bl && string3.indexOf("xmlns:") >= 0) continue;
            String string7 = node.getNodeValue();
            string7 = XmlUtil.escapeXml(string7);
            stringBuffer.append(string6).append(string5).append(' ').append(string3).append("=\"").append(string7).append('\"');
        }
        n = 1;
        boolean bl2 = false;
        string3 = null;
        boolean bl3 = false;
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            if (!bl3) {
                bl3 = true;
                if (!bl2) {
                    stringBuffer.append(">").append(EOL);
                    bl2 = true;
                } else {
                    stringBuffer.append(EOL);
                }
                if (string != null) {
                    string3 = string5 + string5;
                }
                n = 1;
            }
            XmlUtil.printXml((Element)node, stringBuffer, string3, bl);
        }
        if (!bl3 && (string2 = XmlUtil.getElementValue(element)) != null && string2.length() > 0) {
            string2 = XmlUtil.escapeXml(string2);
            stringBuffer.append('>').append(string2);
            bl2 = true;
            n = 0;
        }
        if (bl2) {
            if (n != 0) {
                stringBuffer.append(string5);
            }
            stringBuffer.append("</").append(string4).append(">").append(EOL);
        } else {
            stringBuffer.append("/>").append(EOL);
        }
    }

    public static String getString(Element element) {
        StringBuffer stringBuffer = new StringBuffer();
        XmlUtil.printXml(element, stringBuffer, null, false);
        return stringBuffer.toString();
    }

    public static void setElementValue(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 3) continue;
            node.setNodeValue(string);
            return;
        }
        Document document = element.getOwnerDocument();
        element.appendChild(document.createTextNode(string));
    }

    public static String getNodeName(Node node) {
        return node.getLocalName() != null ? node.getLocalName() : node.getNodeName();
    }

    public static String getElementValue(Node node) {
        if (node != null) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 3 && node2.getNodeType() != 4) continue;
                return node2.getNodeValue();
            }
        }
        return null;
    }

    public static String getNonNullElementValue(Element element) {
        String string = XmlUtil.getElementValue(element);
        if (string == null) {
            string = "";
        }
        return string;
    }

    public static Element getFirstElement(Element element, NsName nsName, String string) {
        if (element != null) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!XmlUtil.isElementNode(node, nsName, string)) continue;
                return (Element)node;
            }
        }
        return null;
    }

    public static Element getFirstElement(Element element, String string) {
        return XmlUtil.getFirstElement(element, null, string);
    }

    public static Element getFirstElement(Element element) {
        return XmlUtil.getFirstElement(element, null, null);
    }

    public static int getIntAttribute(Element element, String string) {
        String string2;
        int n = 0;
        if (element != null && !(string2 = element.getAttribute(string)).isEmpty()) {
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public static DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = XmlUtil.getDocumentBuilderFactory();
        documentBuilderFactory.setNamespaceAware(true);
        return documentBuilderFactory.newDocumentBuilder();
    }

    public static DocumentBuilderFactory getDocumentBuilderFactory() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        try {
            documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        try {
            documentBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        try {
            documentBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        try {
            documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        documentBuilderFactory.setXIncludeAware(false);
        documentBuilderFactory.setExpandEntityReferences(false);
        return documentBuilderFactory;
    }

    public static SAXParserFactory getSAXParserFactory() {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        try {
            sAXParserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException exception) {
            // empty catch block
        }
        try {
            sAXParserFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException exception) {
            // empty catch block
        }
        try {
            sAXParserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException exception) {
            // empty catch block
        }
        try {
            sAXParserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException exception) {
            // empty catch block
        }
        try {
            sAXParserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException exception) {
            // empty catch block
        }
        sAXParserFactory.setXIncludeAware(false);
        return sAXParserFactory;
    }

    public static XMLInputFactory getXMLInputFactory() {
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        try {
            xMLInputFactory.setProperty("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            xMLInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            xMLInputFactory.setProperty("javax.xml.stream.supportDTD", false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return xMLInputFactory;
    }

    public static Element parseFile(File file) {
        if (file != null && file.isFile()) {
            try {
                return XmlUtil.parse(new InputSource(new FileInputStream(file)));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Element parseStream(InputStream inputStream) {
        if (inputStream != null) {
            return XmlUtil.parse(new InputSource(inputStream));
        }
        return null;
    }

    public static Element parseString(String string) {
        if (string != null && !string.isEmpty()) {
            return XmlUtil.parse(new InputSource(new StringReader(string)));
        }
        return null;
    }

    private static Element parse(InputSource inputSource) {
        try {
            DocumentBuilder documentBuilder = XmlUtil.getDocumentBuilderFactory().newDocumentBuilder();
            Document document = documentBuilder.parse(inputSource);
            return document.getDocumentElement();
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static ArrayList<Element> getChildElements(Element element) {
        return XmlUtil.getChildElements(element, null, null);
    }

    public static ArrayList<Element> getChildElements(Element element, String string) {
        return XmlUtil.getChildElements(element, null, string);
    }

    public static ArrayList<Element> getChildElements(Element element, NsName nsName, String string) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        if (element != null) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!XmlUtil.isElementNode(node, nsName, string)) continue;
                arrayList.add((Element)node);
            }
        }
        return arrayList;
    }

    public static boolean isElementNode(Node node, NsName nsName, String string) {
        if (node != null && node.getNodeType() == 1) {
            return !(nsName != null && !nsName.getUri().equals(node.getNamespaceURI()) || string != null && !string.equals(XmlUtil.getNodeName(node)));
        }
        return false;
    }

    public static Element appendNewElement(Node node, NsName nsName, String string) {
        Document document = node instanceof Document ? (Document)node : node.getOwnerDocument();
        Element element = nsName != null ? document.createElementNS(nsName.getUri(), nsName.getPrefix().isEmpty() ? string : nsName.getPrefix() + ":" + string) : document.createElement(string);
        node.appendChild(element);
        return element;
    }

    public static Element appendNewElement(Node node, String string) {
        return XmlUtil.appendNewElement(node, null, string);
    }

    public static void addNamespaceAttribute(Element element, NsName nsName) {
        String string = "xmlns:" + nsName.getPrefix();
        element.setAttribute(string, nsName.getUri());
    }

    public static class NsName {
        private String prefix;
        private String uri;

        public NsName(String string, String string2) {
            this.prefix = string;
            this.uri = string2;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getUri() {
            return this.uri;
        }
    }
}

