/*
 * Decompiled with CFR 0.152.
 */
package MITI.util;

import MITI.util.DateUtil;
import MITI.util.VersionNumber;
import MITI.util.file.FileUtil;
import MITI.util.reflect.ReflectUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.net.www.protocol.file.FileURLConnection;

public class VersionInfo {
    public static final String MANIFEST = "/META-INF/MANIFEST.MF";
    private String component = null;
    private VersionNumber version = null;
    private String date = null;
    private static final Pattern PATCH_DATE = Pattern.compile("\\-CumulativePatch\\-[0-9]+\\-([0-9]{4})([0-9]{2})([0-9]{2})\\-[0-9]+\\.zip");
    private static final Pattern PATCH_VERSION = Pattern.compile("Version ([0-9]+\\.[0-9]+\\.[0-9]+)");

    private VersionInfo(String string, String string2, String string3) {
        this.component = string;
        this.version = VersionNumber.parse(string2 != null ? string2 : "");
        this.date = string3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VersionInfo loadMitiJar(Class<?> clazz) {
        try {
            Manifest manifest = null;
            String string = "/" + clazz.getName().replace('.', '/') + ".class";
            URLConnection uRLConnection = ReflectUtil.getUrlConnection(clazz, string);
            if (uRLConnection instanceof JarURLConnection) {
                uRLConnection.setUseCaches(false);
                JarFile jarFile = ((JarURLConnection)uRLConnection).getJarFile();
                manifest = jarFile.getManifest();
                jarFile.close();
                return VersionInfo.loadManifest(manifest);
            } else if (uRLConnection instanceof FileURLConnection) {
                File file;
                String string2 = URLDecoder.decode(uRLConnection.getURL().getPath(), "UTF-8");
                File file2 = new File(string2, clazz.getName().replace('.', '/').replaceAll("[^/]+", ".."));
                if (string2.endsWith("/WEB-INF/classes" + string)) {
                    file2 = new File(file2, "../..");
                }
                if (!(file = new File(file2, MANIFEST)).exists()) return new VersionInfo(clazz.getSimpleName(), "0.0.0", DateUtil.formatSimpleDate(System.currentTimeMillis(), false));
                FileInputStream fileInputStream = new FileInputStream(file);
                manifest = new Manifest(fileInputStream);
                fileInputStream.close();
                return VersionInfo.loadManifest(manifest);
            } else {
                InputStream inputStream = clazz.getClassLoader().getResourceAsStream(MANIFEST);
                if (inputStream == null) return VersionInfo.loadManifest(manifest);
                manifest = new Manifest(inputStream);
                inputStream.close();
            }
            return VersionInfo.loadManifest(manifest);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static VersionInfo loadManifest(Manifest manifest) {
        if (manifest != null) {
            Attributes attributes = manifest.getMainAttributes();
            String string = attributes.getValue("Miti-Component");
            String string2 = attributes.getValue("Miti-Version");
            String string3 = attributes.getValue("Miti-BuildDate");
            if (string2 != null && string3 != null && string != null) {
                return new VersionInfo(string, string2, string3);
            }
        }
        return null;
    }

    public static VersionInfo loadPatch(File file, String string) {
        File file2 = new File(file, string + "-ReadMe.txt");
        if (file2.isFile()) {
            String string2 = FileUtil.readContent(file2, FileUtil.UTF8);
            String string3 = "";
            Matcher matcher = PATCH_DATE.matcher(string2);
            if (matcher.find()) {
                string3 = matcher.group(1) + "-" + matcher.group(2) + "-" + matcher.group(3);
            }
            String string4 = "0.0.0";
            Matcher matcher2 = PATCH_VERSION.matcher(string2);
            if (matcher2.find()) {
                string4 = matcher2.group(1);
            }
            return new VersionInfo(string, string4, string3);
        }
        return null;
    }

    public String getComponent() {
        return this.component;
    }

    public VersionNumber getVersionNumber() {
        return this.version;
    }

    public String getVersionString() {
        return this.version.toString();
    }

    public String getDate() {
        return this.date;
    }

    public String toString() {
        return this.component + ": " + this.version.toString() + " - " + this.date;
    }
}

