/*
 * Decompiled with CFR 0.152.
 */
package MITI.util;

import java.util.Collection;

public class StringUtil {
    public static final String SEPARATOR = "\u2028";

    public static <T> String join(T[] TArray) {
        return StringUtil.join(TArray, ",");
    }

    public static <T> String join(T[] TArray, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (TArray != null) {
            for (T t : TArray) {
                stringBuilder.append(t.toString()).append(string);
            }
            if (stringBuilder.length() > 0 && string.length() > 0) {
                stringBuilder.setLength(stringBuilder.length() - string.length());
            }
        }
        return stringBuilder.toString();
    }

    public static <T> String join(Collection<T> collection) {
        return StringUtil.join(collection, ",");
    }

    public static <T> String join(Collection<T> collection, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (collection != null) {
            for (T t : collection) {
                stringBuilder.append(t.toString()).append(string);
            }
            if (stringBuilder.length() > 0 && string.length() > 0) {
                stringBuilder.setLength(stringBuilder.length() - string.length());
            }
        }
        return stringBuilder.toString();
    }

    public static String toCamelCase(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : string.split("[ _]+")) {
            if (string2.isEmpty()) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(string2.substring(0, 1).toUpperCase()).append(string2.substring(1).toLowerCase());
        }
        return stringBuilder.toString();
    }

    public static boolean isNumber(String string) {
        if (string != null && !string.isEmpty()) {
            boolean bl = false;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (i == 0 && c == '-' || c >= '0' && c <= '9') continue;
                if (!bl && c == '.') {
                    bl = true;
                    continue;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public static String trimChar(String string, char c) {
        return StringUtil.unquote(string, c, c, false);
    }

    public static String unquote(String string, char c) {
        return StringUtil.unquote(string, c, c, true);
    }

    public static String unquote(String string, char c, char c2) {
        return StringUtil.unquote(string, c, c2, true);
    }

    private static String unquote(String string, char c, char c2, boolean bl) {
        if (string != null && !string.isEmpty()) {
            int n;
            int n2 = string.length();
            int n3 = string.charAt(0) == c ? 1 : 0;
            int n4 = n = string.charAt(n2 - 1) == c2 ? 1 : 0;
            if (!(n3 == 0 && n == 0 || bl && n3 != n)) {
                return string.substring(n3, Math.max(n3, n2 - n));
            }
        }
        return string;
    }
}

