/*
 * Decompiled with CFR 0.152.
 */
package MITI.util;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MiscParams {
    public static final String ENV_VARIABLE = "-environment.variable";
    public static final String JAVA_EXE = "-java.executable";
    public static final String JAVA_MEMORY = "-java.memory";
    public static final String JAVA_PARAMS = "-java.parameters";
    private Map<String, LinkedList<MiscParam>> params = new LinkedHashMap<String, LinkedList<MiscParam>>();
    private static final String KEY = "-[^\\s]+";
    private static final String SIMPLE_VALUE = "([^-=\\s\"][^=\\s\"]*)";
    private static final String QUOTED_VALUE = "\"((?:\\\\\"|[^\"])*)\"";
    private static final String VALUE = "(?:([^-=\\s\"][^=\\s\"]*)|\"((?:\\\\\"|[^\"])*)\")";
    private static final Pattern ARGUMENTS = Pattern.compile("(-[^\\s]+)\\s*(((?:([^-=\\s\"][^=\\s\"]*)|\"((?:\\\\\"|[^\"])*)\"))(?:\\s*=\\s*((?:([^-=\\s\"][^=\\s\"]*)|\"((?:\\\\\"|[^\"])*)\")))?)?");

    private MiscParams() {
    }

    public Collection<String> getKeys() {
        return this.params.keySet();
    }

    public boolean contains(String string) {
        return this.params.containsKey(string);
    }

    public void addValue(String string, String string2) {
        this.add(string, string2, string2, null);
    }

    public String getValue(String string) {
        LinkedList<MiscParam> linkedList = this.params.get(string);
        return linkedList != null ? linkedList.getLast().value : null;
    }

    public void removeValue(String string) {
        this.params.remove(string);
    }

    public Map<String, String> getMappedValues(String string) {
        LinkedHashMap<String, String> linkedHashMap = null;
        List list = this.params.get(string);
        if (list != null) {
            linkedHashMap = new LinkedHashMap<String, String>();
            for (MiscParam miscParam : list) {
                if (miscParam.originalValue == null) continue;
                linkedHashMap.put(miscParam.value, miscParam.mappedValue != null ? miscParam.mappedValue : "");
            }
        }
        return linkedHashMap;
    }

    private void add(String string, String string2) {
        this.add(string, string2, string2, null);
    }

    private void add(String string, String string2, String string3, String string4) {
        LinkedList<MiscParam> linkedList = this.params.get(string);
        if (linkedList == null) {
            linkedList = new LinkedList();
            this.params.put(string, linkedList);
        }
        linkedList.add(new MiscParam(string2, string3, string4));
    }

    public static MiscParams parse(String string) {
        return MiscParams.parse(string, false);
    }

    public static Map<String, Collection<String>> validate(String string) {
        LinkedHashMap<String, Collection<String>> linkedHashMap = new LinkedHashMap<String, Collection<String>>();
        MiscParams miscParams = MiscParams.parse(string, true);
        for (Map.Entry<String, LinkedList<MiscParam>> entry : miscParams.params.entrySet()) {
            LinkedList<String> linkedList = new LinkedList<String>();
            for (MiscParam miscParam : entry.getValue()) {
                linkedList.add(miscParam.originalValue);
            }
            linkedHashMap.put(entry.getKey(), linkedList);
        }
        return linkedHashMap;
    }

    private static MiscParams parse(String string, boolean bl) {
        MiscParams miscParams = new MiscParams();
        if (string != null && !string.isEmpty()) {
            String string2;
            int n = 0;
            Matcher matcher = ARGUMENTS.matcher(string);
            while (matcher.find()) {
                String string3;
                if (bl) {
                    if (matcher.start() > n && !(string2 = string.substring(n, matcher.start()).trim()).isEmpty()) {
                        miscParams.add("#", string2, "", "");
                    }
                    n = matcher.end();
                }
                if ("-j".equals(string2 = matcher.group(1))) {
                    string2 = JAVA_PARAMS;
                } else if ("-jre".equals(string2)) {
                    string2 = JAVA_EXE;
                } else if ("-m".equals(string2)) {
                    string2 = JAVA_MEMORY;
                } else if ("-v".equals(string2)) {
                    string2 = ENV_VARIABLE;
                }
                if (JAVA_PARAMS.equals(string2)) {
                    string3 = string.substring(matcher.start() + matcher.group(1).length() + 1);
                    miscParams.add(string2, string3);
                    break;
                }
                string3 = matcher.group(2);
                String string4 = null;
                String string5 = null;
                if (string3 != null && matcher.group(3) != null) {
                    string4 = matcher.group(4);
                    if (string4 == null) {
                        string4 = matcher.group(5).replace("\\\"", "\"");
                    }
                    if (matcher.group(6) != null && (string5 = matcher.group(7)) == null) {
                        string5 = matcher.group(8).replace("\\\"", "\"");
                    }
                }
                miscParams.add(string2, string3, string4, string5);
            }
            if (bl && !(string2 = string.substring(n).trim()).isEmpty()) {
                miscParams.add("#", string2, "", "");
            }
        }
        return miscParams;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        MiscParam miscParam = null;
        for (Map.Entry<String, LinkedList<MiscParam>> entry : this.params.entrySet()) {
            if (JAVA_PARAMS.equals(entry.getKey())) {
                miscParam = entry.getValue().getFirst();
                continue;
            }
            for (MiscParam miscParam2 : entry.getValue()) {
                stringBuilder.append(entry.getKey());
                if (miscParam2.value != null) {
                    stringBuilder.append(" \"").append(miscParam2.value.replace("\"", "\\\"")).append("\"");
                    if (miscParam2.mappedValue != null) {
                        stringBuilder.append("=\"").append(miscParam2.mappedValue.replace("\"", "\\\"")).append("\"");
                    }
                }
                stringBuilder.append(" ");
            }
        }
        if (miscParam != null) {
            stringBuilder.append(JAVA_PARAMS).append(" ").append(miscParam.value);
        }
        return stringBuilder.toString();
    }

    private static class MiscParam {
        public String originalValue;
        public String value;
        public String mappedValue;

        private MiscParam(String string, String string2, String string3) {
            this.originalValue = string;
            this.value = string2;
            this.mappedValue = string3;
        }
    }
}

