/*
 * Decompiled with CFR 0.152.
 */
package MITI.util;

import MITI.util.file.FileUtil;
import java.util.Base64;

public class Encryption {
    private static final String MASK = "(c) 2006, MetaIntegration Technology Inc.";
    private static final byte[] BYTE_MASK = "(c) 2006, MetaIntegration Technology Inc.".getBytes();

    public static void convertLongToBytes(long l, byte[] byArray, int n) {
        int n2 = 0;
        byArray[n + n2] = (byte)((l & 255L << n2 * 8) >> n2 * 8);
        byArray[n + ++n2] = (byte)((l & 255L << n2 * 8) >> n2 * 8);
        byArray[n + ++n2] = (byte)((l & 255L << n2 * 8) >> n2 * 8);
        byArray[n + ++n2] = (byte)((l & 255L << n2 * 8) >> n2 * 8);
        byArray[n + ++n2] = (byte)((l & 255L << n2 * 8) >> n2 * 8);
        byArray[n + ++n2] = (byte)((l & 255L << n2 * 8) >> n2 * 8);
        byArray[n + ++n2] = (byte)((l & 255L << n2 * 8) >> n2 * 8);
        byArray[n + ++n2] = (byte)((l & 255L << n2 * 8) >> n2 * 8);
        ++n2;
    }

    public static long convertBytesToLong(byte[] byArray, int n) {
        long l = 0L;
        int n2 = 0;
        l += ((long)byArray[n + n2] & 0xFFL) << n2 * 8;
        l += ((long)byArray[n + ++n2] & 0xFFL) << n2 * 8;
        l += ((long)byArray[n + ++n2] & 0xFFL) << n2 * 8;
        l += ((long)byArray[n + ++n2] & 0xFFL) << n2 * 8;
        l += ((long)byArray[n + ++n2] & 0xFFL) << n2 * 8;
        l += ((long)byArray[n + ++n2] & 0xFFL) << n2 * 8;
        l += ((long)byArray[n + ++n2] & 0xFFL) << n2 * 8;
        l += ((long)byArray[n + ++n2] & 0xFFL) << n2 * 8;
        ++n2;
        return l;
    }

    public static byte[] encrypt(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        int n = 0;
        for (int i = 1; i < byArray.length; ++i) {
            byte by = byArray[i - 1];
            byte by2 = byArray[i];
            int n2 = by ^ by2;
            byte by3 = BYTE_MASK[n++];
            byArray2[i - 1] = (byte)((n2 ^= by3) & 0xFF);
            if (n < BYTE_MASK.length) continue;
            n = 0;
        }
        byArray2[byArray.length - 1] = (byte)((byArray[byArray.length - 1] ^ BYTE_MASK[n]) & 0xFF);
        return byArray2;
    }

    public static byte[] decrypt(byte[] byArray) {
        int n;
        byte[] byArray2 = new byte[byArray.length];
        int n2 = n = BYTE_MASK.length > byArray.length ? byArray.length - 1 : byArray.length % BYTE_MASK.length - 1;
        if (n < 0) {
            n = BYTE_MASK.length - 1;
        }
        if (byArray.length > 0) {
            byArray2[byArray.length - 1] = (byte)((byArray[byArray.length - 1] ^ BYTE_MASK[n--]) & 0xFF);
            for (int i = byArray.length - 2; i >= 0; --i) {
                if (n < 0) {
                    n = BYTE_MASK.length - 1;
                }
                byte by = byArray[i];
                byte by2 = byArray2[i + 1];
                byte by3 = BYTE_MASK[n--];
                int n3 = by ^ by3;
                byArray2[i] = (byte)((n3 ^= by2) & 0xFF);
            }
        }
        return byArray2;
    }

    public static String encrypt(String string) {
        return Encryption.encrypt(string, false);
    }

    public static String encrypt(String string, boolean bl) {
        string = (bl ? MASK : "") + (string != null ? string : "");
        if (string.isEmpty()) {
            return string;
        }
        byte[] byArray = Encryption.encrypt(string.getBytes(FileUtil.UTF8));
        return Base64.getEncoder().encodeToString(byArray);
    }

    public static String decrypt(String string) {
        return Encryption.decrypt(string, false);
    }

    public static String decrypt(String string, boolean bl) {
        byte[] byArray = null;
        try {
            if (string != null && !string.isEmpty()) {
                byArray = Base64.getDecoder().decode(string);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (byArray == null) {
            return string;
        }
        String string2 = new String(Encryption.decrypt(byArray), FileUtil.UTF8);
        if (bl) {
            if (string2.startsWith(MASK)) {
                return string2.substring(MASK.length());
            }
            return string;
        }
        return string2;
    }

    public static String bytesToHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            String string = Integer.toHexString(n);
            if (string.length() < 2) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static byte[] hexToBytes(String string) {
        if (string.length() % 2 != 0) {
            throw new IllegalArgumentException("Odd count of characters.");
        }
        int n = string.length() / 2;
        byte[] byArray = new byte[n];
        for (int i = 0; i < byArray.length; ++i) {
            String string2 = string.substring(i * 2, (i + 1) * 2);
            int n2 = Integer.parseInt(string2, 16);
            byArray[i] = (byte)n2;
        }
        return byArray;
    }
}

