/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.muu;

import com.sas.metadata.muu.MUUException;
import com.sas.metadata.muu.MUU_Client;
import com.sas.metadata.muu.MessageBundle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;

public class SMUProperties {
    private static SMUProperties instance0;
    private static String productCode;
    private Map propertyCache = new HashMap();
    private File tempFolder;
    private static final String SERVER_FQID = "server.fqid";

    private SMUProperties(String tempPath) throws MUUException {
        this.tempFolder = new File(tempPath);
        if (!this.tempFolder.exists()) {
            throw new MUUException(MessageBundle.getString("SMUProperties.tmpdir.nt.found.log") + this.tempFolder.getPath());
        }
    }

    public static SMUProperties getSMUProperties(String productCode, String tempPath) throws MUUException {
        if (productCode == null || tempPath == null) {
            throw new MUUException(MessageBundle.getString("SMUProperties.invalid.input.log"));
        }
        if (SMUProperties.productCode == null || !SMUProperties.productCode.equals(productCode)) {
            SMUProperties.productCode = productCode.toLowerCase();
            instance0 = new SMUProperties(tempPath);
        }
        return instance0;
    }

    private void readProperties(String serverId) throws MUUException {
        File[] propertiesFiles = null;
        Properties properties = null;
        String serverNameProperty = SERVER_FQID;
        String propServerName = null;
        if (!this.propertyCache.containsKey(serverId) && (propertiesFiles = this.listProductPropertyFiles()) != null) {
            for (int index = 0; index < propertiesFiles.length; ++index) {
                properties = this.loadProperties(propertiesFiles[index]);
                if (properties == null || (propServerName = properties.getProperty(serverNameProperty)) == null) continue;
                this.propertyCache.put(propServerName, properties);
                if (propServerName.equals(serverId)) break;
            }
        }
    }

    private void readProductProperties() throws MUUException {
        File propertiesFiles;
        Properties properties = null;
        if (!this.propertyCache.containsKey(productCode) && (propertiesFiles = this.getProductConfigurationPropertyFile()) != null && (properties = this.loadProperties(propertiesFiles)) != null) {
            this.propertyCache.put(productCode, properties);
        }
    }

    private Properties loadProperties(File propertyFile) throws MUUException {
        Properties properties = null;
        FileInputStream fis = null;
        try {
            if (!propertyFile.canRead()) {
                MUU_Client.m_logger.info("Can not read file: " + propertyFile.getCanonicalPath());
            }
            fis = new FileInputStream(propertyFile);
            properties = new Properties();
            properties.load(fis);
        }
        catch (FileNotFoundException exception) {
            MUU_Client.m_logger.error("exception message: " + exception.getMessage());
            throw new MUUException(MessageBundle.getString("SMUProperties.file.nt.found.log"));
        }
        catch (IOException exception) {
            throw new MUUException(MessageBundle.getString("SMUProperties.cannot.readfile.log"));
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return properties;
    }

    private File[] listProductPropertyFiles() {
        File[] productProperties = this.tempFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File parent, String fileName) {
                return Pattern.matches(productCode + "([0-9]+?)_Configuration.properties", fileName);
            }
        });
        System.out.println(productProperties.length);
        return productProperties;
    }

    private File getProductConfigurationPropertyFile() {
        File propertyFile = new File(this.tempFolder, productCode + ".configuration.properties");
        return propertyFile;
    }

    public Properties getServerPropertiesById(String serverId) throws MUUException {
        Properties serverProperties = null;
        this.readProperties(serverId);
        if (this.propertyCache.containsKey(serverId)) {
            serverProperties = (Properties)this.propertyCache.get(serverId);
        }
        return serverProperties;
    }

    public Properties getServerPropertiesByProduct() throws MUUException {
        Properties serverProperties = null;
        this.readProductProperties();
        if (this.propertyCache.containsKey(productCode)) {
            serverProperties = (Properties)this.propertyCache.get(productCode);
        }
        return serverProperties;
    }

    public String getServerProperty(String serverId, String property) throws MUUException {
        String propertyName;
        Properties properties = this.getServerPropertiesById(serverId);
        String serverProperty = null;
        if (properties != null && properties.containsKey(propertyName = SMUProperties.getPropertyName(properties, property))) {
            serverProperty = properties.getProperty(propertyName);
        }
        return serverProperty;
    }

    public String getProductProperty(String property) throws MUUException {
        Properties properties = this.getServerPropertiesByProduct();
        String serverProperty = null;
        if (properties != null && properties.containsKey(property)) {
            serverProperty = properties.getProperty(property);
        }
        return serverProperty;
    }

    public static String getPropertyName(Map properties, String property) {
        String propertyName2 = null;
        boolean isFound = false;
        if (properties != null && property != null) {
            for (String propertyName2 : properties.keySet()) {
                if (!propertyName2.endsWith(property)) continue;
                isFound = true;
                break;
            }
        }
        return isFound ? propertyName2 : "";
    }

    public boolean isPrimaryServer(String serverId) throws MUUException {
        Properties properties = this.getServerPropertiesById(serverId);
        String isPrimary = null;
        if (properties != null) {
            isPrimary = properties.getProperty("server.primary.directory");
        }
        return isPrimary != null;
    }

    public boolean isMigratedOnThisMachine(String serverId) throws MUUException {
        return this.getServerPropertiesById(serverId) != null;
    }
}

