/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.muu;

import com.sas.metadata.muu.MUUException;
import com.sas.metadata.muu.MUU_Client;
import com.sas.metadata.muu.MessageBundle;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.Machine;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.metadata.remote.TextStore;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class MetaDataHelper {
    public static final String CONNECTION_TCPIP = "TCPIPConnection";
    public static final String CONNECTION_SASCLIENT = "SASClientConnection";
    public static final String PROTOCOL_OPERATOR = "Operator";
    public static final String PROTOCOL_BRIDGE = "Bridge";
    public static final String PROTOCOL_SASCLIENT = "SASClientConnection";
    private static final String CONFIG_FILE_EXT_BAT = ".bat";
    private static final String CONFIG_FILE_EXT_SH = ".sh";
    private static final String CONFIG_FILE_EXT_JCL = ".jcl";

    public static LogicalServer getLogicalServer(ServerComponent server) throws MUUException {
        LogicalServer logicalServer = null;
        ServerComponent component = null;
        try {
            MUU_Client.m_logger.info(" Getting logical server for : " + server.getName());
            AssociationList logicalServers = server.getUsedByComponents();
            if (logicalServers != null && logicalServers.size() > 0) {
                for (int index = 0; index < logicalServers.size(); ++index) {
                    component = (ServerComponent)logicalServers.get(index);
                    if (!(component instanceof LogicalServer)) continue;
                    logicalServer = (LogicalServer)component;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        return logicalServer;
    }

    public static boolean addProperties(ServerComponent server, Property property) throws MUUException {
        AssociationList properties = null;
        boolean isAdded = true;
        try {
            MUU_Client.m_logger.info(" Adding property for server : " + server.getName() + " : " + property.getName());
            properties = server.getProperties();
            if (properties != null) {
                properties.add((Object)property);
                server.updateMetadataAll();
            } else {
                isAdded = false;
            }
        }
        catch (Exception e) {
            throw new MUUException(e);
        }
        return isAdded;
    }

    public static boolean addProperties(ServerComponent server, List props) throws MUUException {
        AssociationList properties = null;
        boolean isAdded = true;
        try {
            MUU_Client.m_logger.info(" Adding properties for server : " + server.getName() + " Properties No.: " + props.size());
            properties = server.getProperties();
            if (properties != null) {
                isAdded = properties.addAll((Collection)props);
                server.updateMetadataAll();
            } else {
                isAdded = false;
            }
        }
        catch (Exception e) {
            throw new MUUException(e);
        }
        return isAdded;
    }

    public static Machine getSpecificMachineFromList(String machineName, List listOfMachines) throws MUUException {
        if (listOfMachines != null && machineName != null) {
            for (int i = 0; i < listOfMachines.size(); ++i) {
                Object obj = listOfMachines.get(i);
                if (!(obj instanceof Machine)) continue;
                Machine machine = (Machine)obj;
                try {
                    if (!MetaDataHelper.isHostsEqual(machineName, machine.getName())) continue;
                    return machine;
                }
                catch (RemoteException e) {
                    e.printStackTrace(System.err);
                    throw new MUUException(e);
                }
            }
        }
        return null;
    }

    public static Property getProperty(ServerComponent server, String property) throws MUUException {
        boolean isFound;
        Property prop;
        block4: {
            AssociationList properties = null;
            prop = null;
            isFound = false;
            try {
                if (server == null || property == null || (properties = server.getProperties()) == null) break block4;
                for (int index = 0; index < properties.size(); ++index) {
                    prop = (Property)properties.get(index);
                    if (!prop.getPropertyName().equals(property)) continue;
                    isFound = true;
                    break;
                }
            }
            catch (MdException e) {
                throw new MUUException(e);
            }
            catch (RemoteException e) {
                throw new MUUException(e);
            }
        }
        return isFound ? prop : null;
    }

    public static boolean deleteProperty(ServerComponent server, String property) throws MUUException {
        Property prop = MetaDataHelper.getProperty(server, property);
        boolean isDeleted = false;
        try {
            MUU_Client.m_logger.info(" Deleting property for server : " + server.getName() + " : " + property);
            if (prop != null) {
                isDeleted = prop.delete();
            }
        }
        catch (RemoteException e) {
            throw new MUUException(e);
        }
        return isDeleted;
    }

    public static String getQualifiedName(String strSource) {
        String[] arrInvalidChars = new String[]{"*", "/", "\\"};
        StringBuffer sbNewName = new StringBuffer(strSource);
        for (int i = 0; i < arrInvalidChars.length; ++i) {
            int index = sbNewName.indexOf(arrInvalidChars[i]);
            if (index == -1) continue;
            sbNewName.setCharAt(index, ' ');
            --i;
        }
        if (sbNewName != null) {
            return sbNewName.toString();
        }
        return strSource;
    }

    public static Connection getConnectionByType(ServerComponent server, String connectionType) {
        Connection serverConnection = null;
        try {
            AssociationList connectionList = server.getSourceConnections();
            if (connectionList != null && connectionList.size() > 0) {
                for (int index = 0; index < connectionList.size(); ++index) {
                    serverConnection = (Connection)connectionList.get(index);
                    if (!serverConnection.getApplicationProtocol().equalsIgnoreCase(connectionType) || !MetaDataHelper.isSpecifiedServer(serverConnection, CONNECTION_TCPIP)) continue;
                    return serverConnection;
                }
            }
        }
        catch (MdException mdException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return null;
    }

    private static List getConnectionsByType(ServerComponent server, String connectionType) {
        Connection serverConnection = null;
        ArrayList<Connection> connections = new ArrayList<Connection>();
        boolean isFound = false;
        try {
            AssociationList connectionList = server.getSourceConnections();
            if (connectionList != null && connectionList.size() > 0) {
                for (int index = 0; index < connectionList.size(); ++index) {
                    serverConnection = (Connection)connectionList.get(index);
                    System.out.println(" APP PROTOCOL : " + serverConnection.getApplicationProtocol());
                    if (!MetaDataHelper.isSpecifiedServer(serverConnection, connectionType)) continue;
                    connections.add(serverConnection);
                    System.out.println(" FOUND SAS CLIENT CONNECTION ");
                    isFound = true;
                }
            }
        }
        catch (MdException mdException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return isFound ? connections : null;
    }

    private static boolean isSpecifiedServer(Connection serverConnection, String type) {
        Class<?> serverClass = serverConnection.getClass();
        Class<?>[] interfaces = serverClass.getInterfaces();
        String interfaceName = null;
        boolean isSpecified = false;
        for (int index = 0; index < interfaces.length && !(isSpecified = (interfaceName = interfaces[index].getName()).endsWith(type)); ++index) {
        }
        return isSpecified;
    }

    public static TCPIPConnection getOperatorConnection(ServerComponent server) {
        return (TCPIPConnection)MetaDataHelper.getConnectionByType(server, PROTOCOL_OPERATOR);
    }

    public static TCPIPConnection getBridgeConnection(ServerComponent server) {
        return (TCPIPConnection)MetaDataHelper.getConnectionByType(server, PROTOCOL_BRIDGE);
    }

    public static List getSASClientConnections(ServerComponent server) {
        return MetaDataHelper.getConnectionsByType(server, "SASClientConnection");
    }

    public static ServerComponent getConfigurableObject(ServerComponent server) throws MUUException {
        LogicalServer configurableObject = null;
        configurableObject = MetaDataHelper.getLogicalServer(server);
        if (configurableObject == null) {
            configurableObject = server;
        }
        return configurableObject;
    }

    public static InetAddress convertToInetAddress(String host) {
        InetAddress address = null;
        try {
            if (host != null) {
                address = InetAddress.getByName(host);
            }
        }
        catch (UnknownHostException unknownHost) {
            MUU_Client.m_logger.warn(MessageBundle.getString("MetaDataHelper.unknown.host.fmt.log", new Object[]{host}));
        }
        return address;
    }

    public static boolean isHostsEqual(String host1, String host2) {
        MUU_Client.m_logger.debug("host1 :" + host1 + "host2 :" + host2);
        InetAddress hostAddress1 = MetaDataHelper.convertToInetAddress(host1);
        MUU_Client.m_logger.debug("hostAddress1 : " + hostAddress1);
        InetAddress hostAddress2 = MetaDataHelper.convertToInetAddress(host2);
        MUU_Client.m_logger.debug("hostAddress2 : " + hostAddress2);
        if (hostAddress1 == null || hostAddress2 == null) {
            return host1 != null && host1.equalsIgnoreCase(host2);
        }
        if (hostAddress1 != null && hostAddress1.equals(hostAddress2) && host1 != null && !host1.equalsIgnoreCase(host2)) {
            MUU_Client.m_logger.debug("Check for host alias");
            return false;
        }
        return hostAddress1 != null && hostAddress1.equals(hostAddress2);
    }

    public static Map splitPropertyValue(String value, String propertySuffix) {
        String[] values = null;
        String[] singleValue = null;
        String propertyName = null;
        String propertyValue = null;
        HashMap<String, String> properties = null;
        if (value != null) {
            String[] stringArray;
            properties = new HashMap<String, String>();
            if (value.indexOf("|") != -1) {
                stringArray = value.split("\\|");
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = value;
            }
            values = stringArray;
            if (values != null) {
                for (int index = 0; index < values.length; ++index) {
                    singleValue = values[index].split("=");
                    if (singleValue == null || singleValue.length <= 1) continue;
                    propertyName = singleValue[0] + propertySuffix;
                    propertyValue = singleValue[1];
                    properties.put(propertyName, propertyValue);
                }
            }
        }
        return properties;
    }

    public static String getConfigFileName(String configDirectory, final String fileName1) {
        File configDir = new File(configDirectory);
        String configFileName = null;
        File[] configFile = configDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File parent, String fileName) {
                String winCommand = fileName1 + MetaDataHelper.CONFIG_FILE_EXT_BAT;
                String unixCommand = fileName1 + MetaDataHelper.CONFIG_FILE_EXT_SH;
                String jclCommand = fileName1 + MetaDataHelper.CONFIG_FILE_EXT_JCL;
                return fileName.equalsIgnoreCase(winCommand) || fileName.equalsIgnoreCase(unixCommand) || fileName.equalsIgnoreCase(jclCommand);
            }
        });
        if (configFile != null && configFile.length > 0) {
            configFileName = configFile[0].getAbsolutePath();
        }
        return configFileName;
    }

    public static Properties loadPropertiesFromStoredText(TextStore ts) {
        Properties props = null;
        if (ts != null) {
            try {
                String storedText = ts.getStoredText();
                if (storedText != null) {
                    StringReader reader = new StringReader(storedText);
                    PropertyMap propMap = new PropertyMap();
                    propMap.load((Reader)reader);
                    Iterator iterator = propMap.getPropertyIterator();
                    while (iterator.hasNext()) {
                        String propName = (String)iterator.next();
                        String propValue = propMap.getProperty(propName);
                        if (props == null) {
                            props = new Properties();
                        }
                        props.put(propName, propValue);
                    }
                }
            }
            catch (RemoteException e) {
                e.printStackTrace(System.err);
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
        return props;
    }

    public static String getStringFromProperties(Properties props) {
        String multiValuedProps = null;
        PropertyList myPropertyList = null;
        String[] keys = props.keySet().toArray(new String[0]);
        if (keys != null && keys.length > 0) {
            myPropertyList = new PropertyList();
            for (int i = 0; i < keys.length; ++i) {
                myPropertyList.addProperty(keys[i], (String)props.get(keys[i]));
            }
            StringWriter strWriter = new StringWriter();
            try {
                myPropertyList.save((Writer)strWriter);
                multiValuedProps = strWriter.toString();
                multiValuedProps = multiValuedProps.replaceAll("\\r", "");
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
        return multiValuedProps;
    }
}

