/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.muu;

import com.sas.metadata.muu.MUUException;
import com.sas.metadata.muu.MUU_Client;
import com.sas.metadata.muu.MUU_Object;
import com.sas.metadata.muu.MessageBundle;
import com.sas.metadata.muu.MetaDataHelper;
import com.sas.metadata.muu.SMUProperties;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.metadata.remote.ServerComponent;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class MUU_ShareSrv
extends MUU_Object {
    public static final String m_strProductCode = "SHARESRV";
    public static final String m_strPublicName = "Share server";
    public static final String m_strMetadataType = "ServerComponent";
    public static final String m_strTemplate = "<Templates><ServerComponent><AssociatedMachine/><InitProcesses/><Properties/><ServiceTypes/><SoftwareTrees/><SourceConnections><SASClientConnection Id=\"\" RemoteAddress=\"\" ApplicationProtocol=\"\" /></SourceConnections><UsedByComponents/><UsingComponents/><UsingPrototype/></ServerComponent><Tree><Members/></Tree><LogicalServer><InitProcesses/><Properties/><ServiceTypes/><UsedByComponents/><UsingPrototype/></LogicalServer><Transformation><Properties/></Transformation><Property Id=\"\" Name=\"\" PropertyName=\"\"><OwningType/></Property></Templates>";
    public static final String m_strXMLSelect = "<XMLSelect Search=\"@ProductName='REMOTE'\"/>";
    public static final String PROPERTY_PROP_NAME = "property";

    @Override
    public String getPublicName() {
        return m_strPublicName;
    }

    public void UpdateAttributes() throws MUUException {
        ServerComponent cmSrv = (ServerComponent)this.m_objMetadata;
        String strTempDir = MUU_Object.getProperty("tempdir");
        String productCode = m_strProductCode;
        try {
            SMUProperties smuProperties = SMUProperties.getSMUProperties(productCode, strTempDir);
            Properties properties = smuProperties.getServerPropertiesById(cmSrv.getId());
            if (properties != null) {
                String strSrvName = properties.getProperty("server.sharesrv.priorname");
                String strSrvNewName = properties.getProperty("server.sharesrv.name");
                if (strSrvName != null && strSrvNewName != null) {
                    if (strSrvName.equalsIgnoreCase(cmSrv.getName())) {
                        cmSrv.setName(strSrvNewName);
                    } else {
                        MUU_Client.m_logger.warn(MessageBundle.getString("MUU_ShareSrv.srvname.missmatch.log") + cmSrv.getName());
                    }
                } else {
                    MUU_Client.m_logger.warn(MessageBundle.getString("MUU_ShareSrv.srvname.nt.found.log") + cmSrv.getName());
                }
            } else {
                MUU_Client.m_logger.warn(MessageBundle.getString("MUU_ShareSrv.props.nt.found.log") + cmSrv.getName());
            }
        }
        catch (RemoteException exception) {
            throw new MUUException(exception);
        }
        try {
            Connection con;
            int i;
            AssociationList connections = cmSrv.getSourceConnections();
            Iterator iterator = connections.iterator();
            for (i = 0; i < connections.size(); ++i) {
                con = (Connection)iterator.next();
                MUU_Client.m_logger.debug("DEBUG: MUU_ShareSrv : con.getName() = " + con.getName());
                con.setName(MetaDataHelper.getQualifiedName(con.getName()));
                MUU_Client.m_logger.debug("DEBUG: MUU_ShareSrv : con.getName() = " + con.getName());
            }
            connections = cmSrv.getSourceConnections();
            iterator = connections.iterator();
            for (i = 0; i < connections.size(); ++i) {
                con = (Connection)iterator.next();
                MUU_Client.m_logger.debug("DEBUG: MUU_ShareSrv : con.getName() = " + con.getName());
            }
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (MdException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
    }

    @Override
    public boolean IsUpgraded() throws MUUException {
        ServerComponent sc = (ServerComponent)this.m_objMetadata;
        return this.isSCUpgradedToLatestVersion(sc);
    }

    @Override
    public boolean doLocationChange(String changedHost) throws MUUException {
        List clientConnections = MetaDataHelper.getSASClientConnections((ServerComponent)this.m_objMetadata);
        SASClientConnection connection = null;
        try {
            if (clientConnections != null) {
                String strTempDir = MUU_Object.getProperty("tempdir");
                String strPort = null;
                for (int index = 0; index < clientConnections.size(); ++index) {
                    connection = (SASClientConnection)clientConnections.get(index);
                    strPort = this.getChangedPort((Connection)connection);
                    if (strPort != null && !"".equals(strPort)) {
                        this.doLocalHostPortChange(connection, strPort, changedHost);
                        continue;
                    }
                    Object[] arrObjects = new Object[]{connection.getName()};
                    MUU_Client.m_logger.warn(MessageBundle.getString("MUU_Object.changed.port.not.found.fmt.log", arrObjects));
                }
            }
        }
        catch (RemoteException exception) {
            throw new MUUException(exception);
        }
        return false;
    }

    private void doLocalHostPortChange(SASClientConnection connection, String newport, String newhost) throws MUUException {
        if (connection != null && newport != null && newhost != null) {
            String strHost = "\"" + newhost + "\"";
            try {
                String serverShortName;
                String shortHost;
                String oldHost;
                AssociationList properties = connection.getProperties();
                if (properties != null) {
                    for (int iProp = 0; iProp < properties.size(); ++iProp) {
                        Property prop = (Property)properties.get(iProp);
                        if (prop.getPropertyName().equals("Server")) {
                            String newSrvID = this.createNewServerID(prop.getDefaultValue(), newport, newhost);
                            if (newSrvID == null) continue;
                            prop.setDefaultValue(newSrvID);
                            continue;
                        }
                        if (!prop.getPropertyName().equals("HOSTNAME")) continue;
                        prop.setDefaultValue(strHost);
                    }
                }
                if ((oldHost = connection.getRemoteAddress()) != null && (shortHost = this.getShortHostName(oldHost)).equalsIgnoreCase(serverShortName = connection.getServerShortName())) {
                    connection.setServerShortName(this.getShortHostName(newhost));
                }
                connection.setRemoteAddress(newhost);
            }
            catch (RemoteException e) {
                e.printStackTrace(System.err);
                throw new MUUException(e);
            }
            catch (MdException e) {
                e.printStackTrace(System.err);
                throw new MUUException(e);
            }
        }
    }

    private String createNewServerID(String oldSrvID, String port, String host) {
        String newSrvID = null;
        if (oldSrvID != null && port != null && !"0".equals(port) && host != null) {
            newSrvID = "__" + port;
            int index = (oldSrvID = oldSrvID.trim()).indexOf(".");
            if (index > 0) {
                String hostNode = null;
                index = host.indexOf(".");
                hostNode = index != -1 ? (oldSrvID.startsWith("localhost") ? "localhost" : host.substring(0, index)) : host;
                newSrvID = hostNode + "." + newSrvID;
            }
        }
        return newSrvID;
    }

    @Override
    public boolean performSubstituations() throws MUUException {
        try {
            ServerComponent cmSrv = (ServerComponent)this.m_objMetadata;
            this.UpdateAttributes();
            this.doLocationChange();
            this.updateServerName(cmSrv, MUU_ShareSrv.getProperty("productcode").toLowerCase());
            this.changeConnectionName(cmSrv);
            cmSrv.updateMetadataAll();
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (MdException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        return true;
    }

    protected boolean upgradeMetadataModelTo92() throws MUUException {
        return true;
    }
}

