/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.muu;

import com.sas.metadata.muu.MUUException;
import com.sas.metadata.muu.MUU_Client;
import com.sas.metadata.muu.MUU_Object;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Machine;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.metadata.remote.Tree;
import java.rmi.RemoteException;

public abstract class MUU_Server
extends MUU_Object {
    protected void UpdateAttributes() throws MUUException {
        try {
            ServerComponent cmSrv = (ServerComponent)this.m_objMetadata;
            cmSrv.setMinor("2");
            cmSrv.setSoftwareVersion("9.2");
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
    }

    protected void AddAssociations(String strReposId) throws MUUException {
        try {
            ServerComponent cmSrv = (ServerComponent)this.m_objMetadata;
            Machine objMachine = cmSrv.getAssociatedMachine();
            if (objMachine == null) {
                return;
            }
            String strMachineName = objMachine.getName();
            AssociationList alSoftTree = cmSrv.getSoftwareTrees();
            Tree objTree = null;
            if (alSoftTree.size() == 0) {
                objTree = this.CreateTree(strReposId, "MachineGroup", "MachineGroup");
                alSoftTree.addElement((Object)objTree);
                cmSrv.setSoftwareTrees(alSoftTree);
            }
            AssociationList alMembers = null;
            for (int iTree = 0; iTree < alSoftTree.size(); ++iTree) {
                objTree = (Tree)alSoftTree.get(iTree);
                alMembers = objTree.getMembers();
                if (alMembers.size() <= 0) continue;
                for (int iMac = 0; iMac < alMembers.size(); ++iMac) {
                    String strName;
                    CMetadata mac = (CMetadata)alMembers.get(iMac);
                    if (!"Machine".equalsIgnoreCase(mac.getCMetadataType()) || !(strName = mac.getName()).equalsIgnoreCase(strMachineName)) continue;
                    return;
                }
            }
            objTree = (Tree)alSoftTree.get(0);
            alMembers = objTree.getMembers();
            alMembers.addElement((Object)objMachine);
            objTree.setMembers(alMembers);
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (MdException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
    }

    void SubstituteValues(ServerComponent cmSrv) throws MUUException {
        try {
            AssociationList alConn = cmSrv.getSourceConnections();
            for (int iSrv = 0; iSrv < alConn.size(); ++iSrv) {
                CMetadata cm = (CMetadata)alConn.get(iSrv);
                if (!"TCPIPConnection".equalsIgnoreCase(cm.getCMetadataType())) continue;
                TCPIPConnection con = (TCPIPConnection)cm;
                con.setHostName(MUU_Client.m_strHost);
            }
        }
        catch (MdException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
    }

    protected void DeleteAssociations() throws MUUException {
        try {
            ServerComponent cmSrv = (ServerComponent)this.m_objMetadata;
            AssociationList alProps = cmSrv.getProperties();
            for (int iProp = 0; iProp < alProps.size(); ++iProp) {
                Property objProp = (Property)alProps.get(iProp);
                PropertyType pType = objProp.getOwningType();
                if (objProp == null || pType == null) continue;
                objProp.setSQLType(pType.getSQLType());
            }
            AssociationList alSrcConn = cmSrv.getSourceConnections();
            for (int iCon = alSrcConn.size() - 1; iCon >= 0; --iCon) {
                CMetadata objConn = (CMetadata)alSrcConn.get(iCon);
                if (!"COMConnection".equalsIgnoreCase(objConn.getCMetadataType())) continue;
                objConn.delete();
            }
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        catch (MdException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
    }

    @Override
    public boolean IsUpgraded() throws MUUException {
        try {
            ServerComponent cmSrv = (ServerComponent)this.m_objMetadata;
            int nMinor = cmSrv.getMinor();
            String strSoftwareVer = cmSrv.getSoftwareVersion();
            if (strSoftwareVer.equalsIgnoreCase("9.2") && nMinor == 2) {
                return true;
            }
        }
        catch (RemoteException e) {
            e.printStackTrace(System.err);
            throw new MUUException(e);
        }
        return false;
    }
}

